        PAGE    60,132
NAME    COMSWAP
        TITLE   COMSWAP.com version 1.3
COMMENT 

Precis:

COMSWAP  swaps COM1: and COM2:

Copyrighted, but may be freely copied for non-military use only.

Usage:

COMSWAP.Com

To put the com ports back the way there were, just run COMSWAP again.

Limitations
***********

Some programs (such as Telix) bypass looking at the BIOS tables,
so they will be unaffected by COMSWAP.

COMSWAP works only on COM1: and COM2:.  You could roll your own
variant based on the this code to swap COM3: and COM4: in some
other combination.

Inside DESQview, com ports are invisible unless you declare them
accessible in the PIF file.


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1 1993 June 9
- display new address and phone number


stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment byte            ; provide a separate DATA segment
                                ; actually comes after the code

;==============================================================


;  C O N S T A N T S

NoPorts         DB      13,10,'No COM ports to swap.',13,10,'$'
OnePort         DB      13,10,'Only COM1: Cannot swap.',13,10,'$'
TwoPorts        DB      13,10,'COM1: and COM2: now swapped.',13,10,'$'

CopyrightMsg    label byte


        DB      ' COMSWAP 1.3 ۲'
        db      10,13
        DB      'Swaps COM1: and COM2: serial ports.'
        db      10,13
        DB      'Copyright (c) 1991-1999 Roedy Green Canadian Mind Products'
        db      10,13
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        db      10,13,"$"

;========================

data            ends
;======================================

SAY     MACRO   Msg
;       display message on screen
        LEA     DX,&Msg         ; use LEA rather than
                                ; MOV Offset for more generality
        MOV     AH,09h
        INT     21h
        ENDM

;======================================

BIOSDATA    segment AT 40h      ; dummy segment in low RAM
        org     0h
BIOSComAddrs    dw      ?       ; 4 words of COM1: .. COM4:
                dw      ?       ; device addresses
                dw      ?
                dw      ?
BIOSDATA        ends

com     group   code,data       ; force data segment to go at the end

        ASSUME  CS:com,DS:com,ES:com,SS:com
                                ; seg regs cover everything
        ORG     100H            ; in Code segment

;==========================

Main    proc    far

;       M A I N L I N E   R O U T I N E

Start:
        say     CopyRightMsg
        push    DS
        mov     ax,BIOSDATA
        mov     DS,ax
        assume  DS:BIOSDATA
        lea     si,BIOSCOMAddrs ; 4 words of device address

        lodsw                   ; COM1:
        mov     cx,ax           ; save COM1: in CX
        test    ax,ax           ; is there an COM1:?
        jnz     GotCOM1

        pop     DS              ; oops, no printers at all
        Say     NoPorts
        mov     ax,4c01h        ; DIE
        INT     21H

GotCOM1:
        lodsw                   ; COM2:
        test    ax,ax           ; is there an COM2:?
        jnz     GotCOM2

        pop     DS              ; oops, only one port
        Say     OnePort
        mov     ax,4c01h        ; DIE
        INT     21H

GotCOM2:
                                ; have both COM1: and COM2:
        lea     di,BIOSCOMAddrs ; 4 words of device address
                                ; cx=COM1: ax=COM2:
        mov     DS:[di],ax      ; save COM2: in COM1: slot
        mov     DS:[di+2],cx    ; save COM1: in COM2: slot
        pop     DS
        Say     TwoPorts
        mov     ax,4c00h        ; exit BACK TO dos normally
        INT     21H

Main    EndP

;=======================================

Code    EndS

        End     Start
