@ECHO OFF
::REM CHKCMOS.BAT -- ensures CMOS not damaged, repairs if it is.

::REM last updated by Roedy Green of Canadian Mind Products 2001/01/08
::REM Insert to this in AUTOEXEC.BAT to check CMOS.

REM Configure this line to point to where you installed the CMP utilities.

SET CMPDIR=C:\CMP

REM Switch to the C:\CMP drive and directory
C:
CD %CMPDIR%

if not exist  CMOSCHK.COM  GOTO Missing
if not exist  CMOSSAVE.COM GOTO Missing
if not exist  CMOSREST.COM GOTO Missing
if not exist  REBOOT.COM   GOTO Missing
if not exist  CONFIRM.COM  GOTO Missing
GoTo KeepGoing

:Missing

Echo. Error ۲
Echo The following files must be installed in %CMPDIR%:
Echo REBOOT.com CONFIRM.com CMOSCHK.com CMOSSAVE.com and CMOSREST.com.
Echo They are available from http://mindprod.com/downloads.html
Echo or when you register CMOSSAVE.
Echo.
pause
GoTo Done

:KeepGoing


IF NOT EXIST CMOS.SAV GoTo MakeIt

CMOSCHK.com CMOS.SAV /Q
IF NOT Errorlevel 1 GOTO DONE

::REM CMOS check failed:
::REM could be 2 reasons:

::REM 1. CMOS has been illegitimately tampered with

::REM 2. CMOS has been deliberately changed,
::REM    Clever user will have to abort, and delete %CMPDIR%\CMOS.SAV
::REM    or delete before before making changes.
::REM    A new CMOS.SAV will be automatically
::REM    generated.  It should be copied to the rescue diskette.

Echo.
Echo.To deliberately change CMOS, run ChgCMOS.BAT,
Echo.preferably B E F O R E you make your CMOS changes.
Echo.
Echo.Do you wish to restore damaged CMOS?
Echo.Normally you should answer Y for Yes to repair CMOS and put it
Echo.back the way it used to be.
Echo.If you made deliberate changes, answer N for No and run ChgCMOS.
Echo.
confirm
if errorlevel 1 goto Done

::REM save "corrupted" current contents of CMOS just in case
CMOSSAVE.COM CMOS.OLD /Q

::REM try restoring
CMOSREST.COM CMOS.SAV /Q
IF NOT Errorlevel 1 GOTO Reboot
Echo CMOS is still corrupted
Echo.
Pause

:Reboot
pause about to reboot
Reboot.Com

:MakeIt

::REM Build a NEW CMOS.SAV file
Echo Recreating %CMPDIR%\CMOS.SAV file.
CMOSSAVE.COM CMOS.SAV /Q
Echo You might also want to create a new A: Rescue floppy boot disk soon
Echo Use CMOSSAVE A:\CMOS.SAV
Echo.
Pause

:DONE
::REM -30-
