        PAGE    60,132
NAME    BBL
        TITLE   BSTOP.COM version 1.3 1998 November 8
COMMENT |

BSTOP.COM

It has the same effect as BUTIL -STOP
It causes Novell/Softcraft Btrieve to remove itself from RAM.

It sets the ERRORLEVEL like this:
 0 = all went ok
 1 = Btrieve was not loaded, so no need no remove it.
 2 = Btrieve refused to remove itself because of subsequently
     loaded TSRs.

The advantages of this routine over Novell's BUTIL are:
 1.  It sets the ERRORLEVEL
 2.  You can distribute it freely.
 3.  You have the source code to modify as you see fit.
 4.  It is quicker.

Warning.  Btrieve will usually remove itself even when there are
subsequently loaded TSRs.  You will not recover the RAM until
the subsequent TSRs are also unloaded.  If you have removed
Btrieve, with subsequent TSRs still in place, you may sometimes
find Btrieve will refuse to reload giving a "Btrieve already
loaded" message.


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

version 1.3 1998 Novemeber 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1 1993 June 7
- embed new address and phone #

|
; M A C R O S

CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

;======

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM

;======

;================================================

BtrInt  EQU     07Bh    ; Btrieve interrupt
bdos    EQU     21h     ; DOS function interrupt

;================================================

code    segment para

        assume  cs:code,ds:code
        org     100h

;================================================

BSTOP   proc    far             ; mainline routine

start:
        Call    InitBtrCb       ; intialize the control block

;       Is Btrieve Loaded?
        Call    Loaded
        JE      BtrieveLoaded

BtrieveAlreadyRemoved:
        lea     DX,AlreadyMsg
        call    Say
                                ; AL = 01 = return code
        MOV     AX,4C01h        ; AH = 4C = terminate process
                                ; and close files
        INT     bdos            ; DOS function call
                                ; That's all folks

BtrieveLoaded:
                                ; Send a STOP command to Btrieve
        MOV     OpCode,25d      ; 25 = STOP opcode
        MOV     DX, offset BtrCB; address of control block
        INT     BtrInt          ; call Btrieve

; We do not trust Btrieve's status.
; Instead test to see if Btrieve it still loaded.

;       Is Btrieve still Loaded?
        Call    Loaded
        JE      Stuck

Stopped:
        LEA     DX,StoppedMsg
        Call    Say             ; all's well, Btrieve stopped
                                ; AL = 00 = return code
        MOV     AX,4C00h        ; AH = 4C = terminate process
                                ; and close files
        INT     bdos            ; DOS function call
                                ; That's all folks

Stuck:
        LEA     DX,StuckMsg
        Call    Say             ; would not die
                                ; AL = 02 = return code
        MOV     AX,4C02h        ; AH = 4C = terminate process
                                ; and close files
        INT     bdos            ; DOS function call
                                ; That's all folks
BStop   endp

;================================================

InitBtrCB PROC NEAR
;       Prepare the Btrieve control block for use
        MOV     BufAdS,DS
        MOV     PosAdS,DS
        MOV     FCBAdS,DS
        MOV     KEYAdS,DS
        MOV     STAAdS,DS
        MOV     STAAdO, offset Status
;       for STOP function we do not need to set up the data buffer, POS FCB or
;       KEY buffers
        RET
InitBtrCB ENDP

;================================================

;       Is Btrieve Loaded?  Check vector for 033H offset signature
;       Returns with condition code set to indicate whether
;       Btrieve is loaded.  JE = loaded, JNE = not loaded

Loaded  PROC    NEAR
        PUSH    DS
        XOR     BX,BX
        MOV     DS,BX
        CMP     WORD PTR (BtrInt*4)[BX],033h
        POP     DS
        RET
Loaded  ENDP

;================================================

Say     Proc    Near
;       On entry DX points to a $ delimited string to display.
        MOV     AH,9h
        INT     bdos
        RET
Say     EndP

;================================================

BtrCB   LABEL   BYTE            ; Btrieve Control Block
BufAdO  DW      0               ; offset of buffer
BufAdS  DW      0               ; segment of buffer
BufLen  DW      0               ; buffer length
PosAdO  DW      0               ; offset of 90-byte positioning buffer
PosAdS  DW      0               ; segment of 90-byte positioning buffer
FCBAdO  DW      0               ; offset of 38-byte FCB buffer
FCBAdS  DW      0               ; segment of 38-byte FCB buffer
OPCode  DW      0               ; Btrieve opcode (command)
KEYAdO  DW      0               ; offset of KEY buffer
KEYAdS  DW      0               ; segment of KEY buffer
KEYLen  DB      0               ; key length
KEYNum  DB      0               ; key number
STAAdO  DW      0               ; offset of status word
STAAdS  DW      0               ; segment of status word
IFID    DW      06176h          ; signature byte

Status  DW      0               ; where Btrieve returns the status
                                ; of the last operation
;================================================

AlreadyMsg LABEL BYTE
        DB      "Warning: Btrieve already removed.",13,10,"$"

StoppedMsg LABEL BYTE
        DB      "Btrieve removed from memory.",13,10,"$"

StuckMsg LABEL BYTE
        DB      "Error: Btrieve is stuck in memory, pinned by other TRSs.",13,10,"$"

;================================================

CopyrightMsg    label byte      ; does not display
        CR
        DB      ' BSTOP 1.3 ۲'
        CR
        DB      'Freeware to remove Novell Btrieve from memory.'
        CR
        DB      'usage:  BSTOP'
        CR
        DB      'Copyright (c) 1989-1999 Roedy Green Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        EOS


code    ends
        end     start
