        PAGE    60,132
NAME    BBL
        TITLE   BExist.COM version 1.3 1998 November 8
COMMENT |

BExist.COM

By Roedy Green
Determines if the Novell/Softcraft Btrieve btree TSR is already
loaded in RAM.

It sets the ERRORLEVEL like this:
 0 = Btrieve already loaded
 1 = Btrieve not yet loaded

Examples of use:
C:\FastSys\BExist.Com
IF ERRORLEVEL 1 C:\FastSys\Btrieve /M:32/P:1024/C/I:E

The advantages of this routine are:
 1.  It sets the ERRORLEVEL
 2.  You can distribute it freely.
 3.  You have the source code to modify as you see fit.
 4.  It is quicker that loading Btrieve twice.



Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1 1993 June 7
- embed new address and phone

Version 1.0 1989 Oct 10
- initial version


|


; M A C R O S

CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

;======

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM

;======

;================================================

BtrInt  EQU     07Bh    ; Btrieve interrupt
bdos    EQU     21h     ; DOS function interrupt

;================================================

code    segment para

        assume  cs:code,ds:code
        org     100h

;================================================

BExist  proc    far             ; mainline routine

start:

;       Is Btrieve Loaded?
        Call    Loaded
        JE      Present

Absent:
        LEA     DX,AbsentMsg    ; not loaded
        Call    Say
                                ; AL = 01 = return code
        MOV     AX,4C01h        ; AH = 4C = terminate process
                                ; and close files
        INT     bdos            ; DOS function call
                                ; That's all folks
Present:
        LEA     DX,PresentMsg
        Call    Say             ;
                                ; AL = 00 = return code
        MOV     AX,4C00h        ; AH = 4C = terminate process
                                ; and close files
        INT     bdos            ; DOS function call
                                ; That's all folks
                                ; That's all folks
BExist  endp

;================================================

;       Is Btrieve Loaded?  Check vector for 033H offset signature
;       Returns with condition code set to indicate whether
;       Btrieve is loaded.  JE = loaded, JNE = not loaded

Loaded  PROC    NEAR
        PUSH    DS
        XOR     BX,BX
        MOV     DS,BX
        CMP     WORD PTR (BtrInt*4)[BX],033h
        POP     DS
        RET
Loaded  ENDP

;================================================

Say     Proc    Near
;       On entry DX points to a $ delimited string to display.
        MOV     AH,9h
        INT     bdos
        RET
Say     EndP

;================================================

PresentMsg LABEL BYTE
        DB      "Btrieve loaded in memory.",13,10,"$"

AbsentMsg LABEL BYTE
        DB      "Btrieve not present in memory.",13,10,"$"

;================================================

CopyrightMsg    label byte      ; does not display
        CR
        DB      ' BEXIST 1.3 ۲'
        CR
        DB      'Freeware to test if Novell Btrieve TSR is loaded in RAM.'
        CR
        DB      'usage:  BEXIST'
        CR
        DB      '        IF ERRORLEVEL 1 GOTO NotLoaded'
        CR
        DB      'Copyright (c) 1989-1999 Roedy Green Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        EOS

code    ends
        end     start
