@echo off
::
:: Lines beginning with "::" are inactive.
::
::-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-<
::
:: Purpose:
:: ~~~~~~~~
:: This batch program is a menu-driven frontend for SCANREG (Microsoft
:: Registry Checker).
::
::-------------------------------------------------------------------------<
::
:: Requirements:
:: ~~~~~~~~~~~~~
:: * MS-DOS [ ] Protected-mode ... (with Win9x ... running)
::          [*] Real-mode ........ (with Win9x NOT running)
:: * MS-DOS External Command Program(s):
::   -   CHOICE.COM
::   -       FC.EXE
::   -     FIND.EXE
::   -      MEM.EXE
::   -     MODE.COM
::   -  SCANREG.EXE (Microsoft Registry Checker; Win32 sister: SCANREGW.EXE)
::                  Windows 98 already has SCANREG; Windows 95 does not.
::                  It can, however, be installed and used on Windows 95.
::                  http://www.95isalive.com/dloads/scanregsetup.exe
::                  http://www.95isalive.com/registry.htm
::                  http://support.microsoft.com/kb/322754/
::   - BATCHMAN.COM (v1.1) (by Michael J Mefford)
::                  (MD5:  753c4c21960b59f5f59ad7e147ff081d  BATCHMAN.COM)
::                  ftp://ftp.elf.stuba.sk/pub/pc/utiltask/batchman.zip
::   -     NSET.COM (v2.1) (by Horst Schaeffer)
::                  (MD5:  2d09602c021592df1659c78b3df8ec6c  NSET.COM)
::                  ftp://ftp.elf.stuba.sk/pub/pc/utiltask/horst31.zip
:: * OTHER:
::   -      RFN.BAT (v1.3) (Blaware)
::                  (MD5:  a63883b359464e913d1704fa246ccadf  RFN.BAT)
::                  Requires:  MD5SUM.EXE / NSET.COM (v2.1)
::   - YYYYMMDD.BAT (v1.3) (Blaware)
::                  (MD5:  ba007a166ae2e3ab025b0c3fe6908290  YYYYMMDD.BAT)
::                  Requires:  RFN.BAT (v1.3) (Blaware)
::
::-------------------------------------------------------------------------<
::
:: Overview:
:: ~~~~~~~~~
:: 9x Registry Checker is a menu-driven frontend for SCANREG (Microsoft
:: Registry Checker).  It runs under real-mode DOS (with Windows NOT
:: running) and offers the following SCANREG commands/options:
::
::      SCANREG
::      SCANREG /BACKUP
::      SCANREG /BACKUP /COMMENT="<comment>"
::      SCANREG /FIX
::      SCANREG /RESTORE
::
:: If you are unfamiliar with SCANREG, it's purpose is to backup and restore
:: the Windows Registry (and any additional files the user defines).
::
::-------------------------------------------------------------------------<
::
:: Notes:
:: ~~~~~~
:: * This batch code must be run in a real-mode DOS environment (with
::   Windows NOT running).
::
:: * SCANREG stores it's backups as CAB archives, and the default location
::   for their storage is the "sysbckup" folder which is in the "Windows"
::   directory (%windir%\sysbckup\).
::
:: * SCANREG's default preferences can be set within it's INI file,
::   (SCANREG.INI), which is generally found in the "Windows" directory.
::   Open it in a text editor (such as Notepad) to view and/or edit it's
::   contents.  A typical (SCANREG.INI) file's contents might be:
::
::   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
::   ; Lines beginning with ";" are inactive.
::   ; Scanreg.ini for making system backups.
::
::   ; Registry backup is skipped altogether if this is set to 0.
::   ;
::   Backup=1
::
::   ; Registry automatic optimization is skipped if this is set to 0.
::   ;
::   Optimize=1
::
::   ; Version.
::   ;
::   ScanregVersion=0.0001
::
::   ; Max is 99, Recommended is 5.
::   ;
::   MaxBackupCopies=5
::
::   ; Backup directory where CABs are stored: <windir>\sysbckup by default.
::   ; Value below overrides it.  Must be a full path. (ex. c:\tmp\backup).
::   ;
::   BackupDirectory=C:\Windows\Backups\Cabs
::
::   ; Additional system files to backup into CAB as follows:
::   ; Filenames are separated by ','
::   ; dir code can be:
::   ;      10 : windir        (ex. c:\windows)
::   ;      11 : system dir    (ex. c:\windows\system)
::   ;      30 : boot dir      (ex. c:\)
::   ;      31 : boot host dir (ex. c:\)
::   ;
::   ;Files=[dir code,]file1,file2,file3
::   ;Files=[dir code,]file1,file2,file3
::   ;
::   ; Note: Files that are backed-up automatically are:
::   ;       System.dat,User.dat,System.ini,Win.ini
::   ;
::   Files=10,Control.ini,Dosstart.bat,Hosts,Protocol.ini,Scanreg.ini
::   Files=30,Autoexec.bat,Config.sys
::   Files=31,Io.sys,Msdos.sys
::
::   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
::
:: * If the "SCANREG /RESTORE" option is selected and the user later chooses
::   to "Cancel" (rather than restore a backup CAB), Microsoft Registry
::   Checker (SCANREG) returns the error message:  "System restore operation
::   failed."  Of course, there is no cause for alarm.  Nothing has really
::   failed here...the user just canceled out.
::
:: * If problems are encountered running (9xRegChk.bat), it may be that a
::   larger environment space is needed for it to operate in.  Evidence of
::   this could be "Bad command or file name" errors or menus not displaying
::   properly.  Try running (9xRegChk.bat) with a command such as:
::        [COMMAND C:\PATH\TO /E:nnnnn /C Q:\PATH\TO\9XREGCHK.BAT]
::   ("nnnnn" must be between 256 and 32768).  Bla recommends 32768 for
::   nnnnn, as this would provide the maximum space of 32,768 bytes.
::   Alternately, add a line to the system's (CONFIG.SYS) file, such as:
::        [SHELL=C:\PATH\TO\COMMAND.COM /E:32768 /P]
::   This would apply the maximum environment space of 32,768 bytes
::   globally, so that all DOS batch programs would have access to the large
::   environment space automatically.  BTW, the default environment size is
::   just 256 bytes!
::
:: * (9xRegChk.bat) was partially adapted from code found here:
::        http://www.ericphelps.com/
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
:: SCANREG Help {screen output (Bla-edit) of the command [SCANREG /?]}:
:: --------------------------------------------------------------------
:: Windows Registry Checker
::
:: Usage: SCANREG [/<option>]
::
::   <option>
::                     ? : Displays usage.
::                BACKUP : Backup the registry and related system
::                         configuration files.
::   COMMENT="<comment>" : Adds the specified comment to the CAB file while
::                         backing up.
::                   FIX : Repair the registry.
::               RESTORE : Choose a backup to restore.
::
::-------------------------------------------------------------------------<
::
:: About:                                               (06-13-2009)
:: ~~~~~~
:: 9XREGCHK.BAT (v1.3) is Blaware, and Blaware is freeware!
::
::      Bla
::      P.O. Box NUL
::      Valley View, Ohio 44125 USA
::
::      E-Mail:   Blaware@FastMail.fm
::      Webpage:  http://www.NUL.nul/index.html
::
:: Feed the birds.  (Why?)  Well, they haven't pecked your eyes out!
::
::-#######################################################################-<
::
ctty nul
echo z | find "z" > NUL
batchman month
if not errorlevel 1 goto 0X
batchman cls 00h
for %%A in (Z9 Z8 Z6 Z4 RFN) do set %%A=
mode | find "Status for device CON:" > NUL
if errorlevel 1 goto 0K
mode | find "Columns=80" > NUL
if errorlevel 1 goto 0G
set Z9=80
goto 0H
:0G
mode | find "Columns=40" > NUL
if errorlevel 1 goto 0H
set Z9=40
:0H
mode | find "Lines=25" > NUL
if errorlevel 1 goto 0I
set Z8=25
goto 0K
:0I
mode | find "Lines=50" > NUL
if errorlevel 1 goto 0J
set Z8=50
goto 0K
:0J
mode | find "Lines=43" > NUL
if errorlevel 1 goto 0K
set Z8=43
:0K
mem /module:win | find "K)  " > NUL
if errorlevel 1 goto 0L
mem /module:vmm32 | find "K)  " > NUL
if errorlevel 1 goto 0L
goto 0Y
:0L
ver | find "Windows 95" > NUL
if not errorlevel 1 goto 0M
ver | find "Windows 98" > NUL
if not errorlevel 1 goto 0N
goto 0Z
:0M
set Z7=95
goto 0O
:0N
set Z7=98
:0O
md5sum -b nuL | find "d41d8cd98f00b204e9800998ecf8427e *nuL" > NUL
if errorlevel 1 set Z6=MD5SUM.EXE
if not .%Z6%.==.. set Z5=.                
if not .%Z6%.==.. goto 0P
nset /? | find "NSET 2.1 (c) 1997 Horst Schaeffer" > NUL
if errorlevel 1 set Z6=NSET.COM (v2.1)
if not .%Z6%.==.. set Z5=.           
if not .%Z6%.==.. goto 0P
CALL YYYYMMDD.BAT 0 1 0 0 0 1 0 0 1
for %%B in (.%YYYY%. .%MM%. .%DD%.) do if .%%B.==.... set Z6=YYYYMMDD.BAT (v1.3)
if not .%Z6%.==.. set Z5=.       
:0P
ctty con
if not .%Z6%.==.. goto 1G
if .%Z9%%Z8%.==.8025. goto 0Q
mode con: cols=80 lines=25
:0Q
batchman numlock on
cls
echo  Ŀ
echo                                                                          
echo                           
echo                       
echo                        
echo                                                                             
echo                                                                              
echo    PRE MENU                                                                  
echo                                                                      
echo                                                                              
batchman cecho c 07h,   Press [
batchman cecho c 0Fh,0
batchman cecho c 07h,] (
batchman cecho c 0Fh,number ZERO
batchman cecho 07h,) to access 9x Registry Checker.                    
echo                                                                              
echo    Auto-ABORT in 5 seconds.                                                  
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo  
batchman cecho c 07h,    Type your choice ... [
batchman cecho c 0Fh,0
batchman cecho 07h,]
batchman setcursor 26,01
choice /c:0.123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ!#$&'()-@^_,=+;[]`{}~"*:?\ /n /t:.,7 > NUL
if errorlevel 2 goto 1I
:0R
set Z4=
ctty con
batchman cls 0Fh
echo  Ŀ
echo                                                                           
echo                           
echo                        
echo                          
echo                                                                             
batchman cecho c 0Fh, 
batchman cecho c 0Bh,                                          
batchman cecho 0Fh,                                 
batchman cecho c 0Fh,   MAIN MENU
batchman cecho c 0Bh,                               
batchman cecho c 0Fh, Operating System : Windows %Z7%
batchman cecho 0Fh,   
batchman cecho c 0Fh, 
batchman cecho c 0Eh,  
batchman cecho c 0Bh,                               Ŀ
batchman cecho c 0Fh, Today's Date : %MM%-%DD%-%YYYY%
batchman cecho 0Fh,   
batchman cecho c 0Fh, 
batchman cecho c 0Bh,                                              
batchman cecho 0Fh, 
echo    9x Registry Checker is simply a frontend                                  
echo    for SCANREG (Microsoft Registry Checker).                                 
echo                                                                              
echo       Options:                                                               
batchman cecho c 0Fh, 
batchman cecho c 0Ah,     
batchman cecho 0Fh,                                                               
echo       [-] ... ABORT!                                                         
> NUL batchman cecho c 0Fh,      [4] ... SCANREG /BACKUP /COMMENT
> NUL batchman cecho c 0Ch, 
> NUL batchman cecho 0Fh, Create CAB (adding a comment)     
> NUL batchman cecho c 0Fh,      [3] ... SCANREG /BACKUP
> NUL batchman cecho c 0Ch, 
> NUL batchman cecho 0Fh, Create CAB                        
> NUL batchman cecho c 0Fh,      [2] ... SCANREG
> NUL batchman cecho c 0Ch, 
> NUL batchman cecho 0Fh, Create/View/Restore CABs          
> NUL batchman cecho c 0Fh,      [1] ... SCANREG /RESTORE
> NUL batchman cecho c 0Ch, 
> NUL batchman cecho 0Fh, View/Restore CABs                 
> NUL batchman cecho c 0Fh,      [0] ... SCANREG /FIX
> NUL batchman cecho c 0Ch, 
> NUL batchman cecho 0Fh, Repair Registry (takes awhile)    
echo                                                                              
echo  
echo     Type your choice ... [0-4] [-]
batchman setcursor 26,01
choice /c:01234- /n > NUL
if errorlevel 6 goto 1I
if errorlevel 5 goto 0S
if errorlevel 4 goto 0T
if errorlevel 3 goto 0U
if errorlevel 2 goto 0V
if errorlevel 1 goto 0W
:0S
call RFN.BAT 8 i w
md %RFN%
cd %RFN%
batchman cls 0Fh
echo  Ŀ
echo                                                                           
echo                           
echo                        
echo                          
echo                                                                             
echo                                                                        Ŀ  
batchman cecho c 0Fh,   ADD COMMENT         Maximum Number Of Characters (including spaces):
batchman cecho c 0Bh,29
batchman cecho 0Fh,. 
batchman cecho c 0Fh, 
batchman cecho c 0Eh,  
batchman cecho c 0Bh,         
batchman cecho 0Fh,   
echo                                                                              
echo                       Ŀ      
batchman cecho c 0Fh,     Legal Characters:
batchman cecho c 0Ah,` ~ ! @ # $ ^ & * ( ) - _ + \ [ ] { } : ' . / ?
batchman cecho 0Fh,,     
batchman cecho c 0Fh, 
batchman cecho c 0Ah,    
batchman cecho 0Fh,       
echo                                Ŀ          Ŀ      Ŀ             
batchman cecho c 0Fh,                       numbers 
batchman cecho c 0Ah,0-9
batchman cecho c 0Fh,, letters 
batchman cecho c 0Ah,A-Z
batchman cecho c 0Fh,, and 
batchman cecho c 0Ah,Space
batchman cecho 0Fh,.            
echo                                                             
echo                       Ŀ                          Ŀ  Ŀ  
batchman cecho c 0Fh,   Illegal Characters:
batchman cecho c 0Ch,= ; " ,
batchman cecho c 0Fh,, leading and/or trailing 
batchman cecho c 0Ch,Space
batchman cecho c 0Fh,, 
batchman cecho c 0Ch,Percent
batchman cecho 0Fh,, 
batchman cecho c 0Fh, 
batchman cecho c 0Ch,  
batchman cecho 0Fh,                               
echo                       Ŀ  Ŀ      Ŀ        
batchman cecho c 0Fh,                      
batchman cecho c 0Ch,Vertical Bar
batchman cecho c 0Fh,, 
batchman cecho c 0Ch,Less Than
batchman cecho c 0Fh,, and 
batchman cecho c 0Ch,Greater Than
batchman cecho 0Fh,.       
echo                                       
echo  
batchman cecho c 0Fh,Type comment up to here
batchman cecho 0bh, ... 
fc /LB1 /N CON NUL | date | find "1:" > $A.BAT
>  ENTER.BAT echo :LOOP
>> ENTER.BAT echo if not .%%Z4%%.==.. set Z4=%%Z4%% %%5
>> ENTER.BAT echo if .%%Z4%%.==.. set Z4=%%5
>> ENTER.BAT echo shift
>> ENTER.BAT echo if not .%%5.==.. goto LOOP
call $A.BAT
echo  /COMMENT="%Z4%"| nset Z4=$0
del *.BAT
cd ..
rd %RFN%
:0T
batchman cls 0Fh
echo  Ŀ
echo                                                                           
echo                           
echo                        
echo                          
echo                                                                             
echo                                                                              
echo                                                                              
batchman cecho c 0Fh, 
batchman cecho c 0Eh,    
batchman cecho 0Fh,                                                                
batchman cecho c 0Fh, 
batchman cecho c 0Eh,                     
batchman cecho 0Fh,            
batchman cecho c 0Fh, 
batchman cecho c 0Eh,                 
batchman cecho 0Fh,            
batchman cecho c 0Fh, 
batchman cecho c 0Eh,                
batchman cecho 0Fh,           
batchman cecho c 0Fh, 
batchman cecho c 0Eh,          
batchman cecho 0Fh,           
batchman cecho c 0Fh, 
batchman cecho c 0Eh,           
batchman cecho 0Fh,           
batchman cecho c 0Fh, 
batchman cecho c 0Eh,           
batchman cecho 0Fh,           
batchman cecho c 0Fh, 
batchman cecho c 0Eh,           
batchman cecho 0Fh,           
batchman cecho c 0Fh, 
batchman cecho c 0Eh,        
batchman cecho 0Fh,           
batchman cecho c 0Fh, 
batchman cecho c 0Eh,           
batchman cecho 0Fh,  
batchman cecho c 0Fh, 
batchman cecho c 0Eh,             
batchman cecho 0Fh,  
batchman cecho c 0Fh, 
batchman cecho c 0Eh,                       
batchman cecho 0Fh,  
echo                                                                              
echo                                                                              
echo  
batchman setcursor 26,01
ctty nul
SCANREG /BACKUP%Z4%
goto 0R
:0U
SCANREG
goto 0R
:0V
SCANREG /RESTORE
goto 0R
:0W
SCANREG /FIX
goto 0R
:0X
ctty con
cls
echo  Ŀ
echo                                                                           
echo                           
echo                        
echo                          
echo                                                                             
echo                                                                           
echo                                                           
echo                                                            
echo                                                              
echo                                                                              
echo                                                                              
echo    There is a problem with the required program:  BATCHMAN.COM (v1.1).       
echo                                                                              
echo    Check that the proper version is installed in one of the system's PATH    
echo                                                                              
echo    directories.                                                              
echo                                                                              
echo                                                                              
echo    THIS program (9xRegChk.bat) must now abort!                               
echo                                                                          :(  
echo                                                                              
echo  
echo     Press any key to continue...
pause > NUL
goto 1K
:0Y
set Z3=echo    This batch program is running in "PROTECTED-MODE" MS-DOS, under Windows.  
set Z2=::
set Z1=::
set Z0=echo    It can only be run in "REAL-MODE" MS-DOS (with Windows NOT running).      
set Y9=::
set Y8=::
set Y7=echo                                                                              
set Y6=::
set Y5=::
goto 1H
:0Z
set Z3=echo    The operating system, as far as can be determined, is not a version of    
set Z2=::
set Z1=::
set Z0=echo    either Windows 95 or Windows 98.  A version of one of these operating     
set Y9=::
set Y8=::
set Y7=echo    systems is required.                                                      
set Y6=::
set Y5=::
goto 1H
:1G
set Z3=batchman cecho c 0Fh,   There is a problem with the required program:
set Z2=batchman cecho c 0Bh,  %Z6%
set Z1=batchman cecho 0Fh,%Z5%
set Z0=echo    Check that the proper version is installed in one of the system's PATH    
set Y9=::
set Y8=::
set Y7=echo    directories.                                                              
set Y6=::
set Y5=::
:1H
ctty con
batchman cls 0Fh
echo  Ŀ
echo                                                                           
echo                           
echo                        
echo                          
echo                                                                             
batchman cecho c 0Fh, 
batchman cecho c 0Ch,                              
batchman cecho 0Fh,                                           
batchman cecho c 0Fh, 
batchman cecho c 0Ch,              
batchman cecho 0Fh,                                           
batchman cecho c 0Fh, 
batchman cecho c 0Ch,              
batchman cecho 0Fh,                                            
batchman cecho c 0Fh, 
batchman cecho c 0Ch,              
batchman cecho 0Fh,                                             
echo                                                                              
echo                                                                              
%Z3%
%Z2%
%Z1%
echo                                                                              
%Z0%
%Y9%
%Y8%
echo                                                                              
%Y7%
%Y6%
%Y5%
echo                                                                              
echo                                                                              
batchman cecho c 0Fh,   THIS program (
batchman cecho c 0Bh,9xRegChk.bat
batchman cecho 0Fh,) must now abort!                               
echo                                                                          :(  
echo                                                                              
echo  
echo     Press any key to continue...
batchman setcursor 26,01
pause > NUL
:1I
ctty nul
if .%Z9%%Z8%.==.8025. goto 1J
mode con: cols=%Z9% lines=%Z8%
:1J
for %%C in (Z9 Z8 Z7 Z6 Z5 Z3 Z2 Z1 Z0 Y9 Y8 Y7 Y6 Y5 RFN YYYY MM DD) do set %%C=
ctty con
:1K
cls
:END