@echo off
::
:: Lines beginning with "::" are inactive.
::
::-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-<
::
:: Purpose:
:: ~~~~~~~~
:: This batch code will SET environment variables for the current date
:: (%DD%), day (%DAY% and %DY%), month (%MONTH%, %MON%, and %MM%), and year
:: (%YYYYMMDD%, %YYYY%, and %YY%).
::
::-------------------------------------------------------------------------<
::
:: Requirements:
:: ~~~~~~~~~~~~~
:: * MS-DOS [*] Protected-mode ... (with Win9x ... running)
::          [*] Real-mode ........ (with Win9x NOT running)
:: * MS-DOS External Command Program(s):
::   -   CHOICE.COM
::   -     FIND.EXE
::   -     MODE.COM
:: * OTHER:
::   -      RFN.BAT (v1.3) (Blaware)
::                  (MD5:  a63883b359464e913d1704fa246ccadf  RFN.BAT)
::                  Requires:  MD5SUM.EXE / NSET.COM (v2.1)
::
::-------------------------------------------------------------------------<
::
:: Notes:
:: ~~~~~~
:: * For usage, type "YYYYMMDD /?".
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
:: Usage: YYYYMMDD [0/1] [0/1] [0/1] [0/1] [0/1] [0/1] [0/1] [0/1] [0/1]
::                 --1-- --2-- --3-- --4-- --5-- --6-- --7-- --8-- --9--
::   / - Choose one or the other, not both
::   0 - Don't SET this EV
::   1 - SET this EV                 /
::  /-----------------------------\  | Example: YYYYMMDD 0 1 0 1 0 0 1 0 1
::  | Param | Variable |  Value   |  \-------------------------------------/
::  | ----- | -------- | -------- |
::  |  1st  | YYYYMMDD | 19991231 |   The above example SETs EVs for only
::  |  2nd  | YYYY     | 1999     |   YYYY, MONTH, DAY, and DD, which are
::  |  3rd  | YY       | 99       |   represented by the 2nd, 4th, 7th, and
::  |  4th  | MONTH    | December |   9th parameters, respectively.
::  |  5th  | MON      | Dec      |
::  |  6th  | MM       | 12       |   Note: A 1st parameter (at least) must
::  |  7th  | DAY      | Friday   |         be specified.  Parameters not
::  |  8th  | DY       | Fri      |         specified will not be SET.
::  |  9th  | DD       | 31       |
::  \-----------------------------/
:: Requirements: RFN.BAT (v1.3) (Blaware)
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
:: * For this batch program to SET environment variables it must be CALLed
::   with at least one parameter.
::
:: * To select which environment variables are to receive values, CALL this
::   batch program with up to 9 parameters.  A parameter value of of "1" is
::   used to SET it's respective variable.  A parameter value of "0" is used
::   to clear (not SET) it's respective variable.
::
:: * This batch code was partially adapted from code found here:
::   http://www.ericphelps.com/
::
::-------------------------------------------------------------------------<
::
:: About:                                               (06-06-2009)
:: ~~~~~~
:: YYYYMMDD.BAT (v1.3)
::
::      Bla
::      P.O. Box NUL
::      Valley View, Ohio 44125 USA
::
::      E-Mail:   Blaware@FastMail.fm
::      Webpage:  http://www.NUL.nul/index.html
::
:: Feed the birds.  (Why?)  Well, they haven't pecked your eyes out!
::
::-#######################################################################-<
::
if .%1.==.. goto MESSAGE
echo -h/H?-?/?--HELP | find /i "%1" > NUL
if not errorlevel 1 goto HELP
if not .%1.==.0. if not .%1.==.1. goto HELP
if not .%2.==.. if not .%2.==.0. if not .%2.==.1. goto HELP
if not .%3.==.. if not .%3.==.0. if not .%3.==.1. goto HELP
if not .%4.==.. if not .%4.==.0. if not .%4.==.1. goto HELP
if not .%5.==.. if not .%5.==.0. if not .%5.==.1. goto HELP
if not .%6.==.. if not .%6.==.0. if not .%6.==.1. goto HELP
if not .%7.==.. if not .%7.==.0. if not .%7.==.1. goto HELP
if not .%8.==.. if not .%8.==.0. if not .%8.==.1. goto HELP
if not .%9.==.. if not .%9.==.0. if not .%9.==.1. goto HELP
goto 0G
::
:MESSAGE
echo.
echo  YYYYMMDD.BAT -- SETs environment variables for the current date (DD), day
echo                  (DAY,DY), month (MONTH,MON,MM), and year (YYYYMMDD,YYYY,YY).
echo                  Type "YYYYMMDD /?" for usage.
echo.
goto END
::
:HELP
echo.
echo  YYYYMMDD.BAT -- SETs environment variables for the current date (DD), day
echo  ************    (DAY,DY), month (MONTH,MON,MM), and year (YYYYMMDD,YYYY,YY).
echo.
echo  Usage: YYYYMMDD [0/1] [0/1] [0/1] [0/1] [0/1] [0/1] [0/1] [0/1] [0/1]
echo                  1 2 3 4 5 6 7 8 9
echo     / - Choose one or the other, not both
echo     0 - Don't SET this EV
echo     1 - SET this EV                   
echo    Ŀ     Example: YYYYMMDD 0 1 0 1 0 0 1 0 1
echo     Param  Variable   Value       
echo     -----  --------  -------- 
echo      1st   YYYYMMDD  19991231      The above example SETs EVs for only
echo      2nd   YYYY      1999          YYYY, MONTH, DAY, and DD, which are
echo      3rd   YY        99            represented by the 2nd, 4th, 7th, and
echo      4th   MONTH     December      9th parameters, respectively.
echo      5th   MON       Dec      
echo      6th   MM        12            Note: A 1st parameter (at least) must
echo      7th   DAY       Friday              be specified.  Parameters not
echo      8th   DY        Fri                 specified will not be SET.
echo      9th   DD        31       
echo    
echo  Requirements: RFN.BAT (v1.3) (Blaware)
echo.
goto END
::
:0G
CALL RFN.BAT 8 i w
if .%RFN%.==.. goto END
for %%A in (YZ9 YZ8 YZ7 YZ6 YZ5 DAY DD DY MM MON MONTH YY YYYY YYYYMMDD) do set %%A=
md %RFN%
cd %RFN%
:0H
if .%YZ6%.==.##########. goto 0T
if not .%YZ9%.==.###. set YZ9=%YZ9%#
mode => #nv#l#d.bat
if .%YZ9%.==.###. goto 0I
echo.|date|find "Current">> #nv#l#d.bat
if .%YZ9%.==.#. echo set YZ8=%%6>> Invalid.bat
if .%YZ9%.==.##. echo set YZ8=%%7>> Invalid.bat
goto 0S
:0I
type NUL> Invalid.bat
set YZ7=Invalid.bat echo shift
set YZ6=%YZ6%#
if .%YZ6%.==.#. goto 0R
if .%YZ6%.==.##. goto 0Q
if .%YZ6%.==.###. goto 0P
if .%YZ6%.==.####. goto 0O
if .%YZ6%.==.#####. goto 0N
if .%YZ6%.==.######. goto 0M
if .%YZ6%.==.#######. goto 0L
if .%YZ6%.==.########. goto 0K
if .%YZ6%.==.#########. goto 0J
>> %YZ7%
:0J
>> %YZ7%
:0K
>> %YZ7%
:0L
>> %YZ7%
:0M
>> %YZ7%
:0N
>> %YZ7%
:0O
>> %YZ7%
:0P
>> %YZ7%
:0Q
>> %YZ7%
:0R
echo set YZ5=%%4>> Invalid.bat
echo =|choice /c=%YZ8%=>> #nv#l#d.bat
:0S
call #nv#l#d.bat
if .%YZ9%.==.#. set DY=%YZ8%
if .%YZ9%.==.#. goto 0H
if .%YZ9%.==.##. goto 0H
if .%YZ6%.==.#. set MM=%MM%%YZ5%
if .%YZ6%.==.##. set MM=%MM%%YZ5%
if .%YZ6%.==.###. goto 0H
if .%YZ6%.==.####. set DD=%DD%%YZ5%
if .%YZ6%.==.#####. set DD=%DD%%YZ5%
if .%YZ6%.==.######. goto 0H
if .%YZ6%.==.#######. set YYYY=%YYYY%%YZ5%
if .%YZ6%.==.########. set YYYY=%YYYY%%YZ5%
if .%YZ6%.==.#########. set YY=%YY%%YZ5%
if .%YZ6%.==.#########. set YYYY=%YYYY%%YZ5%
if .%YZ6%.==.##########. set YY=%YY%%YZ5%
if .%YZ6%.==.##########. set YYYY=%YYYY%%YZ5%
goto 0H
:0T
for %%B in (YZ9 YZ8 YZ7 YZ6 YZ5) do set %%B=
del ?nv?l?d.bat
set YYYYMMDD=%YYYY%%MM%%DD%
if .%MM%.==.01. set MONTH=January
if .%MM%.==.01. set MON=Jan
if .%MM%.==.02. set MONTH=February
if .%MM%.==.02. set MON=Feb
if .%MM%.==.03. set MONTH=March
if .%MM%.==.03. set MON=Mar
if .%MM%.==.04. set MONTH=April
if .%MM%.==.04. set MON=Apr
if .%MM%.==.05. set MONTH=May
if .%MM%.==.05. set MON=May
if .%MM%.==.06. set MONTH=June
if .%MM%.==.06. set MON=Jun
if .%MM%.==.07. set MONTH=July
if .%MM%.==.07. set MON=Jul
if .%MM%.==.08. set MONTH=August
if .%MM%.==.08. set MON=Aug
if .%MM%.==.09. set MONTH=September
if .%MM%.==.09. set MON=Sep
if .%MM%.==.10. set MONTH=October
if .%MM%.==.10. set MON=Oct
if .%MM%.==.11. set MONTH=November
if .%MM%.==.11. set MON=Nov
if .%MM%.==.12. set MONTH=December
if .%MM%.==.12. set MON=Dec
if .%DY%.==.Sun. set DAY=Sunday
if .%DY%.==.Mon. set DAY=Monday
if .%DY%.==.Tue. set DAY=Tuesday
if .%DY%.==.Wed. set DAY=Wednesday
if .%DY%.==.Thu. set DAY=Thursday
if .%DY%.==.Fri. set DAY=Friday
if .%DY%.==.Sat. set DAY=Saturday
set YZ4=%DAY%
set DAY=
if .%7.==.1. set DAY=%YZ4%
set YZ4=%DY%
set DY=
if .%8.==.1. set DY=%YZ4%
set YZ4=%MONTH%
set MONTH=
if .%4.==.1. set MONTH=%YZ4%
set YZ4=%MON%
set MON=
if .%5.==.1. set MON=%YZ4%
set YZ4=%YYYYMMDD%
set YYYYMMDD=
if .%1.==.1. set YYYYMMDD=%YZ4%
set YZ4=%YYYY%
set YYYY=
if .%2.==.1. set YYYY=%YZ4%
set YZ4=%YY%
set YY=
if .%3.==.1. set YY=%YZ4%
set YZ4=%MM%
set MM=
if .%6.==.1. set MM=%YZ4%
set YZ4=%DD%
set DD=
if .%9.==.1. set DD=%YZ4%
cd ..
rd %RFN%
for %%C in (YZ4 RFN) do set %%C=
:END