@echo off
::
:: Lines beginning with "::" are inactive.
::
::-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-<
::
:: Purpose:
:: ~~~~~~~~
:: This batch code will change the console display mode (number of columns
:: and lines).
::
::-------------------------------------------------------------------------<
::
:: Requirements:
:: ~~~~~~~~~~~~~
:: * MS-DOS [*] Protected-mode ... (with Win9x ... running)
::          [*] Real-mode ........ (with Win9x NOT running)
:: * MS-DOS External Command Program(s):
::   -     FIND.EXE
::   -     MODE.COM
::
::-------------------------------------------------------------------------<
::
:: Notes:
:: ~~~~~~
:: * For usage, type "MODECON /?".
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
::                                      /
::                                      | Examples: MODECON 80 50
:: Usage: MODECON [C] [L]               |           MODECON 25
::                                      \-------------------------/
::    C - Number of Columns [80/40]
::    L - Number of Lines   [50/43/25]
::
::- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -<
::
:: * The parameters "C" and/or "L" can be given in any order.
::
:: * Of course, "C" cannot equal "L".                                     ;)
::
:: * The DOS defaults are (80 columns, 25 lines).
::
::   Columns = Fixed-width text characters per line of text.
::             Valid values are 40 and 80.  Default is 80.
::
::     Lines = Lines of text displayed on screen.
::             Valid values are 25, 43, and 50.  Default is 25.
::
::-------------------------------------------------------------------------<
::
:: About:                                               (06-06-2009)
:: ~~~~~~
:: MODECON.BAT (v1.3)
::
::      Bla
::      P.O. Box NUL
::      Valley View, Ohio 44125 USA
::
::      E-Mail:   Blaware@FastMail.fm
::      Webpage:  http://www.NUL.nul/index.html
::
:: Feed the birds.  (Why?)  Well, they haven't pecked your eyes out!
::
::-#######################################################################-<
::
if .%1.==.. goto MESSAGE
if not .%3.==.. goto HELP
echo -h/H?-?/?--HELP | find /i "%1" > NUL
if not errorlevel 1 goto HELP
if .%2.==.. goto 0G
if .%1.==.%2. goto HELP
for %%A in (50 25 43 80 40) do if .%2.==.%%A. goto 0G
goto HELP
:0G
for %%B in (50 25 43 80 40) do if .%1.==.%%B. goto 0H
goto HELP
::
:MESSAGE
echo.
echo  MODECON.BAT -- Changes the console display mode (number of columns and lines).
echo                 Type "MODECON /?" for usage.
echo.
goto END
::
:HELP
echo.
echo  MODECON.BAT -- Changes the console display mode (number of columns and lines).
echo  ***********                          
echo                                        Examples: MODECON 80 50
echo  Usage: MODECON [C] [L]                          MODECON 25
echo                                       
echo     C - Number of Columns [80/40]
echo     L - Number of Lines   [50/43/25]
echo.
goto END
::
:0H
for %%C in (MZ9 MZ8) do set %%C=
mode | find /i "Columns=80" > NUL
if not errorlevel 1 set MZ9=80
mode | find /i "Columns=40" > NUL
if not errorlevel 1 set MZ9=40
mode | find /i "Lines=50" > NUL
if not errorlevel 1 set MZ8=50
mode | find /i "Lines=25" > NUL
if not errorlevel 1 set MZ8=25
mode | find /i "Lines=43" > NUL
if not errorlevel 1 set MZ8=43
if .%2.==.. goto 0I
if .%2.==.40. set MZ9=40
if .%2.==.80. set MZ9=80
if .%2.==.50. set MZ8=50
if .%2.==.25. set MZ8=25
if .%2.==.43. set MZ8=43
:0I
if .%1.==.40. set MZ9=40
if .%1.==.80. set MZ9=80
if .%1.==.50. set MZ8=50
if .%1.==.25. set MZ8=25
if .%1.==.43. set MZ8=43
mode con: cols=%MZ9% lines=%MZ8%
for %%D in (MZ9 MZ8) do set %%D=
:END