@echo off
::
:: Lines beginning with "::" are inactive.
::
::-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-<
::
:: Purpose:
:: ~~~~~~~~
:: This batch program will create and manage (on a Windows 9x machine) 100
:: backup sets of the following 14 system files:
::
::      in (C:\) directory:
::      -------------------
::           AUTOEXEC.BAT
::            BOOTLOG.TXT
::             CONFIG.SYS
::                 IO.SYS
::              MSDOS.SYS
::
::      in (C:\Windows\) directory:
::      ---------------------------
::            CONTROL.INI
::           DOSSTART.BAT
::              HOSTS
::           PROTOCOL.INI
::            SCANREG.INI
::             SYSTEM.DAT (Windows Registry)
::             SYSTEM.INI
::               USER.DAT (Windows Registry)
::                WIN.INI
::
::-------------------------------------------------------------------------<
::
:: Requirements:
:: ~~~~~~~~~~~~~
:: * MS-DOS [*] Protected-mode ... (with Win9x ... running)
::          [*] Real-mode ........ (with Win9x NOT running)
:: * MS-DOS External Command Program(s):
::   -   ATTRIB.EXE
::   -   CHOICE.COM
::   -     FIND.EXE
::   -      MEM.EXE
::   -     MODE.COM
::   -     MORE.COM
::   -    XCOPY.EXE
::   - BATCHMAN.COM (v1.1) (by Michael J Mefford)
::                  (MD5:  753c4c21960b59f5f59ad7e147ff081d  BATCHMAN.COM)
::                  ftp://ftp.elf.stuba.sk/pub/pc/utiltask/batchman.zip
::   -    TYPEA.EXE (v1.1a) (by Erik Jon Oredson)
::                  (MD5:  430113e9277267cce331ff4a95a55913  TYPEA.EXE)
::                  ftp://ftp.elf.stuba.sk/pub/pc/utiltask/morutl57.zip
::                  (optional)
:: * Microsoft Windows 9x installation directory:  (C:\Windows\)
:: * File(s) on the system (as per "Purpose")
::
::-------------------------------------------------------------------------<
::
:: Notes:
:: ~~~~~~
:: * To perform backup operations, this batch program must be CALLed under
::   protected-mode DOS (with Windows running).
::
:: * To perform restoration operations, this batch program must be CALLed
::   under real-mode DOS (with Windows NOT running).
::
:: * Backup sets are saved for the last 100 computer restarts (can be more
::   than one per day).  For example, the (C:\Config.sys) file is backed-up
::   to the (C:\Bat\9xBak100\!Backups\config\) directory, with the most
::   recent file named (config.s00) and the oldest (config.s99).
::
:: * If Windows is not installed to the default location of (C:\Windows\),
::   then (9xBak100.bat) must be edited to reflect the true installation
::   location.  As an example, if Windows is installed to (C:\Doors\), the
::   following lines (at label :0G)...
::
::        --------------------------------------------------
::        echo C:\WINDOWS | find /i "%winbootdir%" > NUL
::        if errorlevel 1 goto 0U
::        set Z2=C:\Windows
::        --------------------------------------------------
::
::   ...should be edited to look like this...
::
::        ------------------------------------------------
::        echo C:\DOORS | find /i "%winbootdir%" > NUL
::        if errorlevel 1 goto 0U
::        set Z2=C:\Doors
::        ------------------------------------------------
::
::   Also, if the number of characters in the installation path is different
::   (for example, "C:\Windows" vs. "C:\Doors") from the default, then
::   section (:0V) would require a bit of editing as well.
::
:: * (TYPEA.EXE) is an optional (not required) app for this batch program.
::   If TYPEA is found, it will be used to view files if the user requests.
::   If TYPEA is not found, the MS-DOS internal "TYPE" command will be used
::   instead.  TYPEA will display the full contents of (that is, without
::   truncating) binary files [eg. (System.dat) or (User.dat)], whereas
::   "TYPE" will not.  TYPEA, however, must first process the whole file
::   that is sent to it before that data can be sent along to the MS-DOS
::   external app (MORE.COM) for display to screen (one screenful at a
::   time).  So, depending on the size of the file to be displayed, there
::   may be a substantial time delay before it's text actually appears on
::   screen.
::
::   BTW, "The Set Of More DOS Utilities v57.0a" (morutl57.zip) is a fine
::   collection of DOS apps created by Erik Jon Oredson and a highly
::   recommended download.  Since it is in the public domain, (TYPEA.EXE)
::   was able to be provided within (9xBak100.zip) separate from the full
::   archive (whew, caught a break there...that baby's almost 5MB!).      ;)
::
:: * Just to make this quite clear, viewing either (System.dat) or
::   (User.dat) (together making up the Windows Registry) from the menu
::   option may [depending on processor speed and providing (TYPEA.EXE)
::   exists to fully display them to screen] require a substantial time
::   investment.  (Of course, why would one even want to do such a thing?!)
::
::                                                                        ;)
::
:: * The date and time of (for example) Backup Set 00's creation is stored
::   in the (C:\Bat\9xBak100\!Backups\datetime\datetime.t00) file.
::
:: * There is no integrity check made on the files in a backup set.  This
::   program (9xBak100.bat) has no way of knowing if file(s) destined for
::   restoration have been altered in some way.
::
:: * There is no self-integrity check of/by (9xBak100.bat).  It has no way
::   of knowing if it has been altered in some way.
::
::-------------------------------------------------------------------------<
::
:: About:                                               (06-13-2009)
:: ~~~~~~
:: 9XBAK100.BAT (v1.3) is Blaware, and Blaware is freeware!
::
::      Bla
::      P.O. Box NUL
::      Valley View, Ohio 44125 USA
::
::      E-Mail:   Blaware@FastMail.fm
::      Webpage:  http://www.NUL.nul/index.html
::
:: Feed the birds.  (Why?)  Well, they haven't pecked your eyes out!
::
::-#######################################################################-<
::
ctty nul
set Y1=
echo z | find "z" > NUL
batchman month
if not errorlevel 1 goto 0W
set Z9=batchman setcursor 26,01
for %%A in (Z8 Z7 Z6 Z5 Z4 Z3) do set %%A=                                                                             
ver | find "Windows 95" > NUL
if not errorlevel 1 goto 0G
ver | find "Windows 98" > NUL
if not errorlevel 1 goto 0G
goto 0T
:0G
echo C:\WINDOWS | find /i "%winbootdir%" > NUL
if errorlevel 1 goto 0U
set Z2=C:\Windows
for %%B in (Autoexec.bat Bootlog.txt Config.sys Io.sys Msdos.sys) do if not exist C:\%%B goto 0V
for %%C in (Control.ini Dosstart.bat Hosts Protocol.ini) do if not exist %Z2%\%%C goto 0V
for %%D in (Scanreg.ini System.dat System.ini User.dat Win.ini) do if not exist %Z2%\%%D goto 0V
if not exist C:\Bat\nul if not exist C:\Bat md C:\Bat
if not exist C:\Bat\nul goto 1L
if not exist C:\Bat\9xBak100\nul if not exist C:\Bat\9xBak100 md C:\Bat\9xBak100
if not exist C:\Bat\9xBak100\nul goto 1L
set Z1=C:\Bat\9xBak100\!Backups
mem /module:win | find "K)  " > NUL
if errorlevel 1 goto 0I
mem /module:vmm32 | find "K)  " > NUL
if errorlevel 1 goto 0I
echo %Z2% | find /i "%windir%" > NUL
if errorlevel 1 goto 0U
if not exist %Z1%\nul md %Z1%
if not exist %Z1%\nul goto 1L
>  %Z1%\9xBak100.txt echo Created by (9xBak100.bat), the folders in this directory contain the last
>> %Z1%\9xBak100.txt echo 100 backup copies (one at each computer restart) of the following files:
>> %Z1%\9xBak100.txt echo.
>> %Z1%\9xBak100.txt echo      C:\Autoexec.bat     %Z2%\Control.ini      %Z2%\System.dat
>> %Z1%\9xBak100.txt echo      C:\Bootlog.txt      %Z2%\Dosstart.bat     %Z2%\System.ini
>> %Z1%\9xBak100.txt echo      C:\Config.sys       %Z2%\Hosts            %Z2%\User.dat
>> %Z1%\9xBak100.txt echo      C:\Io.sys           %Z2%\Protocol.ini     %Z2%\Win.ini
>> %Z1%\9xBak100.txt echo      C:\Msdos.sys        %Z2%\Scanreg.ini
set Z0=
:0H
if .%Z0%.==.win. goto 1J
if .%Z0%.==.user. set Z0=win
if .%Z0%.==.system. set Z0=user
if .%Z0%.==.user. if .%Y9%.==.d. set Z0=system
if .%Z0%.==.scanreg. set Z0=system
if .%Z0%.==.protocol. set Z0=scanreg
if .%Z0%.==.msdos. set Z0=protocol
if .%Z0%.==.io. set Z0=msdos
if .%Z0%.==.hosts. set Z0=io
if .%Z0%.==.dosstart. set Z0=hosts
if .%Z0%.==.control. set Z0=dosstart
if .%Z0%.==.config. set Z0=control
if .%Z0%.==.bootlog. set Z0=config
if .%Z0%.==.autoexec. set Z0=bootlog
if .%Z0%.==.datetime. set Z0=autoexec
if .%Z0%.==.. set Z0=datetime
if not exist %Z1%\%Z0%\nul md %Z1%\%Z0%
if not exist %Z1%\%Z0%\nul goto 1L
if .%Z0%.==.win. set Y9=i
if .%Z0%.==.win. set Y8=%Z2%\Win.ini
if .%Z0%.==.user. set Y9=d
if .%Z0%.==.user. set Y8=%Z2%\User.dat
if .%Z0%.==.system. if .%Y9%.==.d. set Y9=i
if .%Z0%.==.system. if .%Y8%.==.%Z2%\System.dat. set Y8=%Z2%\System.ini
if .%Z0%.==.system. if .%Y8%.==.%Z2%\Scanreg.ini. set Y9=d
if .%Z0%.==.system. if .%Y9%.==.d. set Y8=%Z2%\System.dat
if .%Z0%.==.scanreg. set Y9=i
if .%Z0%.==.scanreg. set Y8=%Z2%\Scanreg.ini
if .%Z0%.==.protocol. set Y9=i
if .%Z0%.==.protocol. set Y8=%Z2%\Protocol.ini
if .%Z0%.==.msdos. set Y9=s
if .%Z0%.==.msdos. set Y8=C:\Msdos.sys
if .%Z0%.==.io. set Y9=s
if .%Z0%.==.io. set Y8=C:\Io.sys
if .%Z0%.==.hosts. set Y9=_
if .%Z0%.==.hosts. set Y8=%Z2%\Hosts
if .%Z0%.==.dosstart. set Y9=b
if .%Z0%.==.dosstart. set Y8=%Z2%\Dosstart.bat
if .%Z0%.==.control. set Y9=i
if .%Z0%.==.control. set Y8=%Z2%\Control.ini
if .%Z0%.==.config. set Y9=s
if .%Z0%.==.config. set Y8=C:\Config.sys
if .%Z0%.==.bootlog. set Y9=t
if .%Z0%.==.bootlog. set Y8=C:\Bootlog.txt
if .%Z0%.==.autoexec. set Y9=b
if .%Z0%.==.autoexec. set Y8=C:\Autoexec.bat
if .%Z0%.==.datetime. set Y9=t
del %Z1%\%Z0%\%Z0%.%Y9%99
ren %Z1%\%Z0%\%Z0%.%Y9%98 %Z0%.%Y9%99
ren %Z1%\%Z0%\%Z0%.%Y9%97 %Z0%.%Y9%98
ren %Z1%\%Z0%\%Z0%.%Y9%96 %Z0%.%Y9%97
ren %Z1%\%Z0%\%Z0%.%Y9%95 %Z0%.%Y9%96
ren %Z1%\%Z0%\%Z0%.%Y9%94 %Z0%.%Y9%95
ren %Z1%\%Z0%\%Z0%.%Y9%93 %Z0%.%Y9%94
ren %Z1%\%Z0%\%Z0%.%Y9%92 %Z0%.%Y9%93
ren %Z1%\%Z0%\%Z0%.%Y9%91 %Z0%.%Y9%92
ren %Z1%\%Z0%\%Z0%.%Y9%90 %Z0%.%Y9%91
ren %Z1%\%Z0%\%Z0%.%Y9%89 %Z0%.%Y9%90
ren %Z1%\%Z0%\%Z0%.%Y9%88 %Z0%.%Y9%89
ren %Z1%\%Z0%\%Z0%.%Y9%87 %Z0%.%Y9%88
ren %Z1%\%Z0%\%Z0%.%Y9%86 %Z0%.%Y9%87
ren %Z1%\%Z0%\%Z0%.%Y9%85 %Z0%.%Y9%86
ren %Z1%\%Z0%\%Z0%.%Y9%84 %Z0%.%Y9%85
ren %Z1%\%Z0%\%Z0%.%Y9%83 %Z0%.%Y9%84
ren %Z1%\%Z0%\%Z0%.%Y9%82 %Z0%.%Y9%83
ren %Z1%\%Z0%\%Z0%.%Y9%81 %Z0%.%Y9%82
ren %Z1%\%Z0%\%Z0%.%Y9%80 %Z0%.%Y9%81
ren %Z1%\%Z0%\%Z0%.%Y9%79 %Z0%.%Y9%80
ren %Z1%\%Z0%\%Z0%.%Y9%78 %Z0%.%Y9%79
ren %Z1%\%Z0%\%Z0%.%Y9%77 %Z0%.%Y9%78
ren %Z1%\%Z0%\%Z0%.%Y9%76 %Z0%.%Y9%77
ren %Z1%\%Z0%\%Z0%.%Y9%75 %Z0%.%Y9%76
ren %Z1%\%Z0%\%Z0%.%Y9%74 %Z0%.%Y9%75
ren %Z1%\%Z0%\%Z0%.%Y9%73 %Z0%.%Y9%74
ren %Z1%\%Z0%\%Z0%.%Y9%72 %Z0%.%Y9%73
ren %Z1%\%Z0%\%Z0%.%Y9%71 %Z0%.%Y9%72
ren %Z1%\%Z0%\%Z0%.%Y9%70 %Z0%.%Y9%71
ren %Z1%\%Z0%\%Z0%.%Y9%69 %Z0%.%Y9%70
ren %Z1%\%Z0%\%Z0%.%Y9%68 %Z0%.%Y9%69
ren %Z1%\%Z0%\%Z0%.%Y9%67 %Z0%.%Y9%68
ren %Z1%\%Z0%\%Z0%.%Y9%66 %Z0%.%Y9%67
ren %Z1%\%Z0%\%Z0%.%Y9%65 %Z0%.%Y9%66
ren %Z1%\%Z0%\%Z0%.%Y9%64 %Z0%.%Y9%65
ren %Z1%\%Z0%\%Z0%.%Y9%63 %Z0%.%Y9%64
ren %Z1%\%Z0%\%Z0%.%Y9%62 %Z0%.%Y9%63
ren %Z1%\%Z0%\%Z0%.%Y9%61 %Z0%.%Y9%62
ren %Z1%\%Z0%\%Z0%.%Y9%60 %Z0%.%Y9%61
ren %Z1%\%Z0%\%Z0%.%Y9%59 %Z0%.%Y9%60
ren %Z1%\%Z0%\%Z0%.%Y9%58 %Z0%.%Y9%59
ren %Z1%\%Z0%\%Z0%.%Y9%57 %Z0%.%Y9%58
ren %Z1%\%Z0%\%Z0%.%Y9%56 %Z0%.%Y9%57
ren %Z1%\%Z0%\%Z0%.%Y9%55 %Z0%.%Y9%56
ren %Z1%\%Z0%\%Z0%.%Y9%54 %Z0%.%Y9%55
ren %Z1%\%Z0%\%Z0%.%Y9%53 %Z0%.%Y9%54
ren %Z1%\%Z0%\%Z0%.%Y9%52 %Z0%.%Y9%53
ren %Z1%\%Z0%\%Z0%.%Y9%51 %Z0%.%Y9%52
ren %Z1%\%Z0%\%Z0%.%Y9%50 %Z0%.%Y9%51
ren %Z1%\%Z0%\%Z0%.%Y9%49 %Z0%.%Y9%50
ren %Z1%\%Z0%\%Z0%.%Y9%48 %Z0%.%Y9%49
ren %Z1%\%Z0%\%Z0%.%Y9%47 %Z0%.%Y9%48
ren %Z1%\%Z0%\%Z0%.%Y9%46 %Z0%.%Y9%47
ren %Z1%\%Z0%\%Z0%.%Y9%45 %Z0%.%Y9%46
ren %Z1%\%Z0%\%Z0%.%Y9%44 %Z0%.%Y9%45
ren %Z1%\%Z0%\%Z0%.%Y9%43 %Z0%.%Y9%44
ren %Z1%\%Z0%\%Z0%.%Y9%42 %Z0%.%Y9%43
ren %Z1%\%Z0%\%Z0%.%Y9%41 %Z0%.%Y9%42
ren %Z1%\%Z0%\%Z0%.%Y9%40 %Z0%.%Y9%41
ren %Z1%\%Z0%\%Z0%.%Y9%39 %Z0%.%Y9%40
ren %Z1%\%Z0%\%Z0%.%Y9%38 %Z0%.%Y9%39
ren %Z1%\%Z0%\%Z0%.%Y9%37 %Z0%.%Y9%38
ren %Z1%\%Z0%\%Z0%.%Y9%36 %Z0%.%Y9%37
ren %Z1%\%Z0%\%Z0%.%Y9%35 %Z0%.%Y9%36
ren %Z1%\%Z0%\%Z0%.%Y9%34 %Z0%.%Y9%35
ren %Z1%\%Z0%\%Z0%.%Y9%33 %Z0%.%Y9%34
ren %Z1%\%Z0%\%Z0%.%Y9%32 %Z0%.%Y9%33
ren %Z1%\%Z0%\%Z0%.%Y9%31 %Z0%.%Y9%32
ren %Z1%\%Z0%\%Z0%.%Y9%30 %Z0%.%Y9%31
ren %Z1%\%Z0%\%Z0%.%Y9%29 %Z0%.%Y9%30
ren %Z1%\%Z0%\%Z0%.%Y9%28 %Z0%.%Y9%29
ren %Z1%\%Z0%\%Z0%.%Y9%27 %Z0%.%Y9%28
ren %Z1%\%Z0%\%Z0%.%Y9%26 %Z0%.%Y9%27
ren %Z1%\%Z0%\%Z0%.%Y9%25 %Z0%.%Y9%26
ren %Z1%\%Z0%\%Z0%.%Y9%24 %Z0%.%Y9%25
ren %Z1%\%Z0%\%Z0%.%Y9%23 %Z0%.%Y9%24
ren %Z1%\%Z0%\%Z0%.%Y9%22 %Z0%.%Y9%23
ren %Z1%\%Z0%\%Z0%.%Y9%21 %Z0%.%Y9%22
ren %Z1%\%Z0%\%Z0%.%Y9%20 %Z0%.%Y9%21
ren %Z1%\%Z0%\%Z0%.%Y9%19 %Z0%.%Y9%20
ren %Z1%\%Z0%\%Z0%.%Y9%18 %Z0%.%Y9%19
ren %Z1%\%Z0%\%Z0%.%Y9%17 %Z0%.%Y9%18
ren %Z1%\%Z0%\%Z0%.%Y9%16 %Z0%.%Y9%17
ren %Z1%\%Z0%\%Z0%.%Y9%15 %Z0%.%Y9%16
ren %Z1%\%Z0%\%Z0%.%Y9%14 %Z0%.%Y9%15
ren %Z1%\%Z0%\%Z0%.%Y9%13 %Z0%.%Y9%14
ren %Z1%\%Z0%\%Z0%.%Y9%12 %Z0%.%Y9%13
ren %Z1%\%Z0%\%Z0%.%Y9%11 %Z0%.%Y9%12
ren %Z1%\%Z0%\%Z0%.%Y9%10 %Z0%.%Y9%11
ren %Z1%\%Z0%\%Z0%.%Y9%09 %Z0%.%Y9%10
ren %Z1%\%Z0%\%Z0%.%Y9%08 %Z0%.%Y9%09
ren %Z1%\%Z0%\%Z0%.%Y9%07 %Z0%.%Y9%08
ren %Z1%\%Z0%\%Z0%.%Y9%06 %Z0%.%Y9%07
ren %Z1%\%Z0%\%Z0%.%Y9%05 %Z0%.%Y9%06
ren %Z1%\%Z0%\%Z0%.%Y9%04 %Z0%.%Y9%05
ren %Z1%\%Z0%\%Z0%.%Y9%03 %Z0%.%Y9%04
ren %Z1%\%Z0%\%Z0%.%Y9%02 %Z0%.%Y9%03
ren %Z1%\%Z0%\%Z0%.%Y9%01 %Z0%.%Y9%02
ren %Z1%\%Z0%\%Z0%.%Y9%00 %Z0%.%Y9%01
if .%Z0%.==.datetime. goto 0H
echo f| xcopy %Y8% %Z1%\%Z0%\%Z0%.%Y9%00 /h /q /y > NUL
attrib -h -r -s %Z1%\%Z0%\%Z0%.%Y9%00
if .%Y8%.==.%Z2%\System.ini. goto 0H
>  %Z1%\%Z0%\%Z0%.txt echo This folder contains the last 100 backup copies (one per computer boot) of:
>> %Z1%\%Z0%\%Z0%.txt echo.
>> %Z1%\%Z0%\%Z0%.txt echo      %Y8%
>> %Z1%\%Z0%\%Z0%.txt if .%Y8%.==.%Z2%\System.dat. echo      %Z2%\System.ini
goto 0H
:0I
set Y7=
typea /? | find "Command line error. Type Typea /? for help." > NUL
if not errorlevel 1 set Y7=typea
if not .%Y7%.==.typea. set Y7=type
ctty con
mode con: cols=80 lines=25
batchman numlock on
cls
echo  Ŀ
echo                                                                          
echo                                         
echo                                          
echo                                         
echo                                                                             
echo                                                                              
echo    PRE MENU                                                                  
echo                                                                      
echo                                                                              
batchman cecho c 07h,   Press [
batchman cecho c 0Fh,0
batchman cecho c 07h,] (
batchman cecho c 0Fh,number ZERO
batchman cecho 07h,) to access 9x Backup 100.                          
echo                                                                              
echo    Auto-ABORT in 5 seconds.                                                  
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo                                                                              
echo  
batchman cecho c 07h,    Type your choice ... [
batchman cecho c 0Fh,0
batchman cecho 07h,]
%Z9%
choice /c:0.123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ!#$&'()-@^_,=+;[]`{}~"*:?\ /n /t:.,7 > NUL
if errorlevel 2 goto 1K
:0J
batchman cls 1Dh
echo  Ŀ
echo                                                                           
echo                                         
echo                                          
echo                                           
echo                                                                             
echo                                                                              
echo    OVERVIEW                                                                  
echo                                                                      
echo                                                                              
echo    This program can restore a backup set of the following system files...    
echo                                                                              
echo                                                                              
echo            In C:\:     In C:\Windows\:                                       
echo                                                        
echo       Autoexec.bat      Control.ini     System.dat (Windows Registry)        
echo        Bootlog.txt     Dosstart.bat     System.ini                           
echo         Config.sys        Hosts           User.dat (Windows Registry)        
echo             Io.sys     Protocol.ini        Win.ini                           
echo          Msdos.sys      Scanreg.ini                                          
echo                                                                              
echo                                                                              
echo  
echo     Press any key to continue...
%Z9%
pause > NUL
:0K
for %%E in (Z8 Z7) do set %%E=                                                                             
batchman cls 3Ah
echo  Ŀ
echo                                                                           
echo                                         
echo                                          
echo                                           
echo                                                                             
echo                                                                              
echo    SELECT SET GROUP                                                          
echo                                                              
echo                                                                              
echo    The most recent set of system files is "Set 00".  The oldest is           
echo    "Set 99".  Please select an initial grouping of 10 sets.                  
echo                                                                              
echo       Options:                                                               
echo                                                                      
echo       [-] ... ABORT!           [.] ... Go Back                               
echo       [0] ... Sets (00-09)     [5] ... Sets (50-59)                          
echo       [1] ... Sets (10-19)     [6] ... Sets (60-69)                          
echo       [2] ... Sets (20-29)     [7] ... Sets (70-79)                          
echo       [3] ... Sets (30-39)     [8] ... Sets (80-89)                          
echo       [4] ... Sets (40-49)     [9] ... Sets (90-99)                          
echo                                                                              
echo  
echo     Type your choice ... [-] [.] [0-9]
%Z9%
choice /c:-0123456789. /n > NUL
if errorlevel 12 goto 0J
if errorlevel 11 goto 0L9
if errorlevel 10 goto 0L8
if errorlevel 9 goto 0L7
if errorlevel 8 goto 0L6
if errorlevel 7 goto 0L5
if errorlevel 6 goto 0L4
if errorlevel 5 goto 0L3
if errorlevel 4 goto 0L2
if errorlevel 3 goto 0L1
if errorlevel 2 goto 0L0
if errorlevel 1 goto 1K
:0L9
set Y6=9
goto 0M
:0L8
set Y6=8
goto 0M
:0L7
set Y6=7
goto 0M
:0L6
set Y6=6
goto 0M
:0L5
set Y6=5
goto 0M
:0L4
set Y6=4
goto 0M
:0L3
set Y6=3
goto 0M
:0L2
set Y6=2
goto 0M
:0L1
set Y6=1
goto 0M
:0L0
set Y6=0
:0M
batchman cls 5Eh
echo  Ŀ
echo                                                                           
echo                                         
echo                                          
echo                                           
echo                                                                             
echo                                                                              
echo    SELECT SET                                                                
echo                                                                    
echo                                                                              
echo    The most recent set of system files in this grouping is "Set %Y6%0".  The    
echo    oldest is "Set %Y6%9".  Please select a set.                                 
echo                                                                              
echo       Options:                                                               
echo                                                                      
echo       [-] ... ABORT!     [.] ... Go Back                                     
echo       [0] ... Set %Y6%0     [5] ... Set %Y6%5                                      
echo       [1] ... Set %Y6%1     [6] ... Set %Y6%6                                      
echo       [2] ... Set %Y6%2     [7] ... Set %Y6%7                                      
echo       [3] ... Set %Y6%3     [8] ... Set %Y6%8                                      
echo       [4] ... Set %Y6%4     [9] ... Set %Y6%9                                      
echo                                                                              
echo  
echo     Type your choice ... [-] [.] [0-9]
%Z9%
choice /c:-0123456789. /n > NUL
if errorlevel 12 goto 0K
if errorlevel 11 goto 0N9
if errorlevel 10 goto 0N8
if errorlevel 9 goto 0N7
if errorlevel 8 goto 0N6
if errorlevel 7 goto 0N5
if errorlevel 6 goto 0N4
if errorlevel 5 goto 0N3
if errorlevel 4 goto 0N2
if errorlevel 3 goto 0N1
if errorlevel 2 goto 0N0
if errorlevel 1 goto 1K
:0N9
set Y5=9
goto 0O
:0N8
set Y5=8
goto 0O
:0N7
set Y5=7
goto 0O
:0N6
set Y5=6
goto 0O
:0N5
set Y5=5
goto 0O
:0N4
set Y5=4
goto 0O
:0N3
set Y5=3
goto 0O
:0N2
set Y5=2
goto 0O
:0N1
set Y5=1
goto 0O
:0N0
set Y5=0
:0O
for %%F in (Y4 Y3 Y1) do set %%F=
for %%G in (Z8 Z7) do set %%G=                                                                             
batchman cls 1Bh
echo  Ŀ
echo                                                                           
echo                                         
echo                                          
echo                                           
echo                                                                             
echo                                                                              
echo    SET %Y6%%Y5% OPTIONS                                                            
echo                                                                
echo                                                                              
echo    See set creation time [0], or view file in set [A-N] (patience w/[K,M]).  
echo    If [*] is chosen, restoration begins immediately, without confirmation!   
echo                                                                              
echo       Options:                                                               
echo                                                                      
echo       [-] ... ABORT!         [.] ... Go Back        [0] ... DateTime.txt     
echo       [A] ... Autoexec.bat   [F] ... Control.ini    [*] ... Restore Set %Y6%%Y5%   
echo       [B] ... Bootlog.txt    [G] ... Dosstart.bat   [K] ... System.dat       
echo       [C] ... Config.sys     [H] ... Hosts          [L] ... System.ini       
echo       [D] ... Io.sys         [I] ... Protocol.ini   [M] ... User.dat         
echo       [E] ... Msdos.sys      [J] ... Scanreg.ini    [N] ... Win.ini          
echo                                                                              
echo  
echo     Type your choice ... [-] [.] [0] [*] [A-N]
%Z9%
choice /c:-ABCDEFGHIJKLMN0.* /n > NUL
if errorlevel 18 goto 0R
if errorlevel 17 goto 0M
if errorlevel 16 goto 0P0
if errorlevel 15 goto 0PN
if errorlevel 14 goto 0PM
if errorlevel 13 goto 0PL
if errorlevel 12 goto 0PK
if errorlevel 11 goto 0PJ
if errorlevel 10 goto 0PI
if errorlevel 9 goto 0PH
if errorlevel 8 goto 0PG
if errorlevel 7 goto 0PF
if errorlevel 6 goto 0PE
if errorlevel 5 goto 0PD
if errorlevel 4 goto 0PC
if errorlevel 3 goto 0PB
if errorlevel 2 goto 0PA
if errorlevel 1 goto 1K
:0P0
set Y4=datetime
set Y3=DateTime.t%Y6%%Y5%
goto 0Q
:0PN
set Y4=win
set Y3=Win.i%Y6%%Y5%
goto 0Q
:0PM
set Y4=user
set Y3=User.d%Y6%%Y5%
goto 0Q
:0PL
set Y4=system
set Y3=System.i%Y6%%Y5%
goto 0Q
:0PK
set Y4=system
set Y3=System.d%Y6%%Y5%
goto 0Q
:0PJ
set Y4=scanreg
set Y3=Scanreg.i%Y6%%Y5%
goto 0Q
:0PI
set Y4=protocol
set Y3=Protocol.i%Y6%%Y5%
goto 0Q
:0PH
set Y4=hosts
set Y3=Hosts._%Y6%%Y5%
goto 0Q
:0PG
set Y4=dosstart
set Y3=Dosstart.b%Y6%%Y5%
goto 0Q
:0PF
set Y4=control
set Y3=Control.i%Y6%%Y5%
goto 0Q
:0PE
set Y4=msdos
set Y3=Msdos.s%Y6%%Y5%
goto 0Q
:0PD
set Y4=io
set Y3=Io.s%Y6%%Y5%
goto 0Q
:0PC
set Y4=config
set Y3=Config.s%Y6%%Y5%
goto 0Q
:0PB
set Y4=bootlog
set Y3=Bootlog.t%Y6%%Y5%
goto 0Q
:0PA
set Y4=autoexec
set Y3=Autoexec.b%Y6%%Y5%
:0Q
batchman cls 3Bh
echo.
echo [9XBAK100.BAT - (%Y3%)]:  Loading....  Please be patient.
if exist %Z1%\%Y4%\%Y3% %Y7% %Z1%\%Y4%\%Y3% | more
echo.
choice /c:+ /n "[9XBAK100.BAT - (%Y3%)]:  End of file.  Please type [+] to continue..."
goto 0O
:0R
batchman cls 2Eh
echo  Ŀ
echo                                                                           
echo                                         
echo                                          
echo                                           
echo                                                                             
echo                                                                              
echo                                                                              
echo                                                                      
echo                                   
echo                               
echo                             
echo                       
echo                        
echo                        
echo                        
echo                     
echo               
echo                 
echo                           
echo                                                                              
echo                                                                              
echo  
%Z9%
ctty nul
set Y2=
if not exist %Z1%\autoexec\autoexec.b%Y6%%Y5% set Y2=#
if not exist %Z1%\bootlog\bootlog.t%Y6%%Y5% set Y2=#
if not exist %Z1%\config\config.s%Y6%%Y5% set Y2=#
if not exist %Z1%\control\control.i%Y6%%Y5% set Y2=#
if not exist %Z1%\dosstart\dosstart.b%Y6%%Y5% set Y2=#
if not exist %Z1%\hosts\hosts._%Y6%%Y5% set Y2=#
if not exist %Z1%\io\io.s%Y6%%Y5% set Y2=#
if not exist %Z1%\msdos\msdos.s%Y6%%Y5% set Y2=#
if not exist %Z1%\protocol\protocol.i%Y6%%Y5% set Y2=#
if not exist %Z1%\scanreg\scanreg.i%Y6%%Y5% set Y2=#
if not exist %Z1%\system\system.d%Y6%%Y5% set Y2=#
if not exist %Z1%\system\system.i%Y6%%Y5% set Y2=#
if not exist %Z1%\user\user.d%Y6%%Y5% set Y2=#
if not exist %Z1%\win\win.i%Y6%%Y5% set Y2=#
if .%Y2%.==.#. goto 0S
for %%H in (AUTOEXEC.BAT MSDOS.SYS IO.SYS CONFIG.SYS BOOTLOG.TXT) do attrib -h -r -s C:\%%H
for %%I in (HOSTS DOSSTART.BAT PROTOCOL.INI CONTROL.INI) do attrib -h -r -s %Z2%\%%I
for %%J in (USER.DAT SYSTEM.DAT WIN.INI SYSTEM.INI SCANREG.INI) do attrib -h -r -s %Z2%\%%J
copy %Z1%\autoexec\autoexec.b%Y6%%Y5% C:\Autoexec.bat /y > NUL
copy %Z1%\bootlog\bootlog.t%Y6%%Y5% C:\Bootlog.txt /y > NUL
copy %Z1%\config\config.s%Y6%%Y5% C:\Config.sys /y > NUL
copy %Z1%\io\io.s%Y6%%Y5% C:\Io.sys /y > NUL
copy %Z1%\msdos\msdos.s%Y6%%Y5% C:\Msdos.sys /y > NUL
copy %Z1%\control\control.i%Y6%%Y5% %Z2%\Control.ini /y > NUL
copy %Z1%\dosstart\dosstart.b%Y6%%Y5% %Z2%\Dosstart.bat /y > NUL
copy %Z1%\hosts\hosts._%Y6%%Y5% %Z2%\Hosts /y > NUL
copy %Z1%\protocol\protocol.i%Y6%%Y5% %Z2%\Protocol.ini /y > NUL
copy %Z1%\scanreg\scanreg.i%Y6%%Y5% %Z2%\Scanreg.ini /y > NUL
copy %Z1%\system\system.d%Y6%%Y5% %Z2%\System.dat /y > NUL
copy %Z1%\system\system.i%Y6%%Y5% %Z2%\System.ini /y > NUL
copy %Z1%\user\user.d%Y6%%Y5% %Z2%\User.dat /y > NUL
copy %Z1%\win\win.i%Y6%%Y5% %Z2%\Win.ini /y > NUL
for %%K in (MSDOS.SYS IO.SYS) do attrib +h +r +s C:\%%K
for %%L in (USER.DAT SYSTEM.DAT) do attrib +h +r +s %Z2%\%%L
set Y1=0O
set Z8=   Congratulations, Set %Y6%%Y5% has successfully been restored!                   
set Z7=   Now back to the "Set %Y6%%Y5% Options" menu where "ABORT!" may be the choice.   
goto 0X
:0S
set Y1=0K
set Z8=   Set %Y6%%Y5% is incomplete or nonexistent and therefore cannot be restored.     
goto 0X
:0T
set Z8=   The operating system, as far as can be determined, is not a version of    
set Z7=   either Windows 95 or Windows 98.  A version of one of these operating     
set Z5=   systems is required.                                                      
goto 0X
:0U
set Z8=   The operating system does not appear to be installed in the expected,     
set Z7=   default location.  This program requires that Windows is installed to     
set Z5=   (C:\Windows\).                                                            
goto 0X
:0V
set Z8=   This program requires that the following files exist on the system:       
set Z7=      C:\Autoexec.bat     %Z2%\Control.ini      %Z2%\System.dat  
set Z6=      C:\Bootlog.txt      %Z2%\Dosstart.bat     %Z2%\System.ini  
set Z5=      C:\Config.sys       %Z2%\Hosts            %Z2%\User.dat    
set Z4=      C:\Io.sys           %Z2%\Protocol.ini     %Z2%\Win.ini     
set Z3=      C:\Msdos.sys        %Z2%\Scanreg.ini                             
goto 0X
:0W
set Z9=
set Y0=cls
set Z8=   There is a problem with the required program:  BATCHMAN.COM (v1.1).       
set Z7=   Check that the proper version is installed in one of the system's PATH    
set Z5=   directories.                                                              
goto 0Y
:0X
set Y0=batchman cls 0Ch
if .%Y1%.==.0O. set Y0=batchman cls 2Ah
:0Y
ctty con
%Y0%
echo  Ŀ
echo                                                                           
echo                                         
echo                                          
echo                                           
echo                                                                             
if .%Y1%.==.0O. goto 0Z
echo                                                                           
echo                                                           
echo                                                            
echo                                                              
goto 1G
:0Z
echo                                                                           
echo                                                     
echo                                                      
echo                                                        
:1G
echo                                                                              
echo                                                                              
echo %Z8%
echo                                                                              
echo %Z7%
echo %Z6%
echo %Z5%
echo %Z4%
echo %Z3%
echo                                                                              
if not .%Y1%.==.. goto 1H
echo    THIS program (9xBak100.bat) must now abort!                           :(  
goto 1I
:1H
echo                                                                              
:1I
echo                                                                              
echo  
echo     Press any key to continue...
%Z9%
pause > NUL
if not .%Y1%.==.. goto %Y1%
goto 1K
:1J
>  %Z1%\datetime\datetime.txt echo This folder contains files logging the date and time of
>> %Z1%\datetime\datetime.txt echo creation of each the last 100 "9xBak100" backup sets.
>  %Z1%\datetime\datetime.t00 echo This backup set was created...
>> %Z1%\datetime\datetime.t00 echo.
>> %Z1%\datetime\datetime.t00 echo.|date|find "date is"
>> %Z1%\datetime\datetime.t00 echo.|time|find "time is"
goto 1L
:1K
cls
:1L
for %%M in (Z9 Z8 Z7 Z6 Z5 Z4 Z3 Z2 Z1 Z0 Y9 Y8 Y7 Y6 Y5 Y4 Y3 Y2 Y1 Y0) do set %%M=
ctty con
:END