; 80x30 text video mode setup for all VGAs (not just Trident :)
;
; Extracted by Luchezar Georgiev <lucho@mbox.digsys.bg> from Linux
; kernel file linux/arch/i386/boot/video.S version 2.13 (14-May-99)
; which is Copyright  1995-1999 Martin Mares <mj@ucw.cz>
;
; Freeware distributed under the terms of the GNU Plublic License (GPL)
; (in short, this source code must always be included with the package)
;
; COMPILE: ml 80x30.asm | tasm 80x30; tlink /t 80x30
;
; WARNING: Not all software works in 80x30 text mode. Please see its
; documentation if it's possible to set it up for this mode and how!
;
; NOTE: Use of an eye-saving ISO 9241 Part 3 compliant 8x16 font is
; highly recommended. Please take care of your eyes, you'll need'em!
;
; CAUTION: Neither Luchezar Georgiev nor Martin Mares may be held
; responsible for your eventual addiction to the 80x30 text mode or
; ISO fonts!
;___________________________________________________________________

;
; Force 400 scan lines for standard modes (hack to fix bad behaviour
; of certain broken BIOSes -- don't use unless needed)
;
;CONFIG_VIDEO_400_HACK equ 1

	.model	tiny
	.code
	.startup

	push	es		; We use different segment
	xor	ax,ax
	mov	es,ax		; ES is zero
;
; Set the 80x30 mode (all VGA's). 480 scanlines, 16-pixel font.
;
	call	use_80x25	; Start with real 80x25
	mov	dx,3ccH		; Get CRTC port
	in	al,dx
	mov	dl,0d4H
	ror	al,1		; Mono or color?
	jc	set48a
	mov	dl,0b4H
set48a: mov	ax,0c11H	; Vertical sync end (also unlocks CR0-7)
	call	outidx
	mov	ax,0b06H	; Vertical total
	call	outidx
	mov	ax,3e07H	; (Vertical) overflow
	call	outidx
	mov	ax,0ea10H	; Vertical sync start
	call	outidx
	mov	ax,0df12H	; Vertical display end
	call	outidx
	mov	ax,0e715H	; Vertical blank start
	call	outidx
	mov	ax,0416H	; Vertical blank end
	call	outidx
	push	dx
	mov	dl,0ccH		; Misc output register (read)
	in	al,dx
	mov	dl,0c2H		; (write)
	and	al,0dH		; Preserve clock select bits and color bit
	or	al,0e2H		; Set correct sync polarity
	out	dx,al
	pop	dx
	mov	al,29
	mov	es:[484h],al	; Tell BIOS the real "Number of Lines - 1"
	pop	es		; That's all.
	ret
;
; Write to indexed VGA register (AL=index, AH=data, DX=index reg. port)
;
outidx: out	dx,al
	push	ax
	mov	al,ah
	inc	dx
	out	dx,al
	dec	dx
	pop	ax
	ret
;
; Set the 80x25 mode. If already set, do nothing.
;
use_80x25:
ifdef CONFIG_VIDEO_400_HACK
	mov	ax,1202H	; Force 400 scan lines
	mov	bl,30H
	int	10H
else
	mov	ah,0fH		; Get current mode ID
	int	10H
	cmp	ax,5007H	; Mode 7 (80x25 mono) is the only one available
	jz	st80		; on CGA/MDA/HGA and is also available on EGAM
	cmp	ax,5003H	; Unknown mode => force 80x25 color
	jnz	force3
st80:	mov	al,es:[484H]	; This is EGA+ -- beware of 80x50 etc.
	or	al,al		; Some buggy BIOSes set 0 rows
	jz	set80
	cmp	al,24		; Let's hope this is correct
	jz	set80
endif ; CONFIG_VIDEO_400_HACK
force3: mov	ax,3		; Forced set
	int	10H
set80:	ret

	end
