;       ZAP.ASM version 1.3
comment 
by Roedy Green
This program is copyrighted but may be used freely
for any purpose except military.

ZAP C:\MySub\MyFile.Blk

Fills the file with nulls chr$(0).  The length of the file
is unchanged.

You might do this preparatory to erasing a file to ensure
it can never be unerased.  You might use it in debugging a
defragger my converting a problem diskette into and
equivalent one easily compressed for modem transfer.

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

;

SAY     MACRO   Msg
;       display message on screen
        lea     dx,&Msg         ; use LEA rather than
                                ; MOV Offset for more generality
        mov     ah,09h
        int     21h
        ENDM

;======================================


code    segment para

        assume  cs:code,ds:code
        org     100h

zap      proc    far

start:
;=============================
;   PARSE THE FILENAME          ; counted string at HEX 80
                                ; contains command line.
                                ; Name of file we want is
                                ; preceeded by unwanted spaces.
                                ; It is missing a trailing null.
        xor     ch,ch
        mov     cl,DS:80h
        mov     bx,cx
        mov     byte ptr [bx+81H],0     ; append the null
        mov     al,20h
        mov     di,81h
        repe    scasb           ; scan for first non blank
        dec     di              ; DI points one past it.

;=============================
;  OPEN THE FILE
        mov     dx,di           ; DS:DX point to file
        mov     ax,03d02h       ; DOS open file
        INT     21h
        jc      bad
        mov     bx,ax           ; save handle

;==============================
; SEEK TO END OF FILE TO FIND OUT HOW LONG IT IS
;
        mov     ax,4202h        ; LSEEK function to eof
                                ; bx is handle
        sub     cx,cx           ; cx:dx = 0 = offset
        mov     dx,cx
        int     21h
                                ; dx:ax is size of file
        mov     fileSize,ax
        mov     FileSize+2,dx

;==============================
; SEEK TO START OF FILE PREPARATORY FOR WRITE
;
        mov     ax,4200h        ; LSEEK function to start of file
                                ; bx is handle
        sub     cx,cx           ; cx:dx = 0 = offset
        mov     dx,cx
        int     21h

;=============================
;  CLEAR THE BUFFER
        lea     di,Buffer
        mov     cx,48*1024/2    ; 48K in words
        sub     ax,ax
        rep     stosw           ; clear whole buffer to 0

;=============================
;  WRITE THE FULL BLOCKS
MainLoop:
        mov     ax,fileSize
        mov     dx,FileSize+2
        sub     ax,48*1024d     ; figure out what would be remaining
        sbb     dx,0            ; if we did another 48K block
        jl      BulkDone        ; if would go negative, the
                                ; bulk is done
        mov     fileSize,ax     ; save the subtracted size
        mov     FileSize+2,dx

        mov     cx,48*1024d     ; 48K bytes to write
        mov     dx,offset buffer
        mov     ah,40h          ; DOS write
        int     21h
        jc      close
        jmp     MainLoop
BulkDone:

;=============================
;  WRITE THE LAST PARTIAL BLOCK
        mov     cx,FileSize     ; 48K bytes or less to write
        Jcxz    Close
        mov     dx,offset buffer
        mov     ah,40h          ; DOS write
        int     21h

;=============================
;  CLOSE THE FILE
CLOSE:
        mov     ah,3eh          ; DOS close
        int     21h

QUIT:
        mov     ax,4c00h        ; EXIT
        int     21h

;=============================
BAD:
;  COMPLAIN ABOUT THE FILE
        SAY     BadMsg          ; if died before file opened
        jmp     quit
;=============================

CopyrightMsg    label byte

;               This message is not displayed, just embedded in the file.
        db      13,10
        DB      ' ZAP 1.3 ۲'
        db      13,10
        DB      'Wipes a file to nulls without changing its length.'
        db      13,10
        DB      'Copyright (c) 1991,1998 Roedy Green Canadian Mind Products'
        db      13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        db      13,10,"$"


BadMsg  label byte
        db 07h
        db "Cannot find this file.  Perhaps it is read-only.$"


        even

FileSize        DW      0,0     ; 32 bit filesize in bytes

buffer  label   word            ; will actually be 48K bytes long
                                ; hangs out past the end

zap     endp
code    ends

        end start
