;                                                                           ;
;                       TOUCH.S   v1.08d  2003-10-05                        ;
;                       Copyright 1996-2003,  C. Dye                        ;
;                       email:  raster@highfiber.com                        ;
;                                                                           ;
;       This is source for NASM, the Netwide Assembler.  Type               ;
;       NASM TOUCH.S -O TOUCH.COM  to re-assemble.  NASM is                 ;
;       freeware, available from  http://www.cryogen.com/Nasm               ;
;                                                                           ;
;       This program is copyrighted, but may be freely distributed          ;
;       under the terms of the Free Software Foundation's GNU General       ;
;       Public License v2 (or later.)  See the file COPYING for the         ;
;       legalities.  If you did not receive a copy of COPYING, you          ;
;       may request one from the Free Software Foundation, Inc.,            ;
;       59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           ;
;       ABSOLUTELY NO WARRANTY -- use it at your own risk!                  ;
;                                                                           ;


%macro doscall 1                       ; call to dos int 21 with a one-byte
%if %1 >= 0100h                        ; value in .ah, or a two-byte value
mov ax,%1                              ; in .ax :
%else
mov ah,%1
%endif
int 21h
%endmacro

%macro dosprint 1                      ; a simple wrapper for the dos 21/09
mov dx,%1                              ; print-a-string function
mov ah,09h
int 21h
%endmacro

%macro zprint 1                        ; a wrapper for a call to my asciiz-
mov di,%1                              ; print routine
call zprint1
%endmacro

%macro zero 1                          ; cheap way to zero a two-byte
xor %1,%1                              ; register
%endmacro

%macro testzero 1                      ; cheap way to test for zero
or %1,%1
%endmacro

%macro bomb 2                          ; jump to handler for fatal errors
call bombs_away                        ; ... does not return!
dw %1                                  ; inline:  address of error message
db %2                                  ; inline:  exit code (errorlevel)
%endmacro


%define hilo(a,b) (a * 100h + b)       ; easy way to code two-byte quantities


org 0100h


country  equ  005ch                    ; put country data in the psp
country_date equ country + 00h         ; local date format, usa-eur-japan
country_thou equ country + 07h         ; local thousands char (',' in usa)
country_dsep equ country + 0bh         ; local date separator ('-' in usa)
country_tsep equ country + 0dh         ; local time separator (':' in usa)
country_time equ country + 11h         ; local time format (0 12hr, 1 24hr)


newdate   equ  0056h                   ; new date stamp for files
newtime   equ  0058h                   ; new time stamp for files

temp      equ  006eh                   ; local temp variable (byte or word)

dp_t1     equ  0070h                   ; low  word for decimal print routine
dp_t2     equ  0072h                   ; high word for decimal print routine
dp_t4     equ  0074h                   ; character count for decimal print
today     equ  0076h                   ; date when program is started
now       equ  0078h                   ; time when program is started
handle    equ  007ah                   ; handle for touch operation
dos_ver   equ  007ch                   ; dos version, major in high byte

fn_max    equ  0104h                   ; max number of characters in filename

attr_r    equ  01h                     ; value of read-only attribute
attr_h    equ  02h                     ; value of hidden attribute
attr_s    equ  04h                     ; value of system attribute
attr_d    equ  10h                     ; value of directory attribute
attr_a    equ  20h                     ; value of archive attribute
attr_c    equ  40h                     ; attribute bit for character devices

SPC       equ  20h                     ; ascii space
BS        equ  08h                     ; ascii backspace
TAB       equ  09h                     ; ascii tab
CR        equ  0dh                     ; ascii carriage return
LF        equ  0ah                     ; ascii line feed


; -------------------------------------- START OF CODE:

doscall 3000h                          ; check ms-dos version:
cmp al,02h
ja dos_okay                            ; dos prior to version 3 :
bomb msg_err_dos_bad,17h               ; complain and exit with errorlevel 23
dos_okay:
mov [dos_ver+0],ah                     ; save major version number
mov [dos_ver+1],al                     ; save minor version number
mov ax,sp                              ; examine stack pointer:
cmp ax,stack_end                       ; plenty of room?
jae enough_memory
trs_80:                                ; not enough memory:
bomb msg_trs_80,11h                    ; complain and exit with errorlevel 17
enough_memory:
mov sp,stack_end                       ; reduce stack size
zero ax
push ax
push cs
pop es
mov bx,(stack_end / 10h) + 2h
doscall 4ah                            ; and shrink program's memory block
jc trs_80

call get_country_info                  ; get current country info
mov dx,dta
doscall 1ah                            ; set up disk transfer area
call get_current_time                  ; used for default time / date stamps
call get_vga_lines                     ; figure default scroll length
mov byte [last_dir_shown],00h          ; empty the last_dir_shown buffer

mov si,0080h                           ; read from command line
mov di,fnbuf                           ; into filespec buffer

parse_main:                            ; PRIMARY PARSER LOOP:
inc si
switch_done:
mov al,[si]                            ; examine next character
call force_uc                          ; in uppercase:
call test_eol                          ; end of line?
je parse_done                          ; if so, terminate primary parser
call test_space                        ; is it a space?
je parse_main                          ; if so, ignore it
call test_switch                       ; is it a switch character?
je found_switch                        ; if so, interpret it
mov bx,[pointer_pointer]               ; otherwise, this is the start of a
mov [filespec_pointers+bx],si          ; filespec; remember it
add bx,byte 02h
mov [pointer_pointer],bx
cmp bx,byte 40h
jb .l2                                 ; too many filespecs?  if so,
bomb msg_err_specs_galore,10h          ; complain and exit with errorlevel 16
.l2:
call parse_fn                          ; parse through the filespec
mov al,[si]
call test_eol                          ; if the end of the line was found,
je parse_done                          ; terminate primary parser
jmp short parse_main                   ; otherwise, keep on truckin'

found_switch:                          ; FOUND A SWITCH CHARACTER:
inc si
lodsb                                  ; examine next character
call force_uc                          ; in uppercase:
mov bx,0ffffh                          ; start at beginning of switch table
.l0:
inc bx
cmp byte [switches+bx],00h             ; run out of legal switches to try?
je syntax                              ; if so, syntax error
cmp [switches+bx],al                   ; found this letter in table?
jne .l0                                ; if not, keep looking
shl bx,01h                             ; multiply .bx by two
mov ax,[switch_routines+bx]            ; and get address of switch routine
zero bx
call ax                                ; to call
mov al,[si]
call test_eol
je parse_done
call test_space
je switch_done
call test_switch
je switch_done

syntax:                                ; SYNTAX ERROR IN COMMAND LINE:
call error_out
switch_query:
dosprint msg_syntax                    ; print error message
call show_date_format                  ; and report the current date format
dosprint msg_gpl                       ; mention the license
doscall 4c10h                          ; and exit with errorlevel 16

parse_done:                            ; DONE WITH PRIMARY PARSER:
mov bx,[pointer_pointer]
testzero bx                            ; found any filespecs at all?
jne .l1
mov ax,star_dot_star
mov [filespec_pointers],ax             ; if not, slip in a star-dot-star-cr
add bx,byte 02h
.l1:
zero cx
mov [filespec_pointers+bx],cx          ; add a null to end of list
mov [pointer_pointer],cx               ; and point to the start of the list
mov al,[flags]
and al,0f0h                            ; supposed to change the date or time
or al,[chgattr]                        ; or any attributes?
je .l2
or byte [more_flags],04h               ; if so, note it
.l2:
call alloc_tree_buffer                 ; create buffer for /s tree if needed
call alloc_list_buffer                 ; get buffer for file list
call use_template_stamps               ; use /c stamps, if present
call eval_user_stamps                  ; evaluate user time and date
call prompt_fix                        ; check usage of /p
call fix_paging                        ; disable paging if output redirected
call hook_int_24                       ; intercept critical-error handling

big_loop:                              ; LOOP THROUGH COMMAND-LINE FILESPECS:
mov bx,[pointer_pointer]
mov ax,[filespec_pointers+bx]          ; get offset of command-line filespec
testzero ax                            ; have we run out yet?
je big_loop_done                       ; if so, exit
add word [pointer_pointer],byte 02h    ; otherwise, point to next filespec
mov si,ax
call parse_fn                          ; and parse this one
call clean_up_filespec                 ; canonicalize it

filespec_loop:
call get_fn_from_list                  ; read filespec from list, if needed
jc big_loop                            ; if eof, back for next user filespec
subdir_loop:
call touch_multiple_files              ; touch files matching this filespec
call find_any_subdirs                  ; add any subdirectories to tree buff.
call use_next_subdir                   ; is there a subdirectory in buffer?
jnc subdir_loop                        ; if so, touch any files in it
test byte [flags],04h                  ; using a file list?
jne filespec_loop                      ; if so, get next filespec from it
jmp short big_loop

big_loop_done:                         ; done with all user filespecs:
call show_file_count
call show_total_counts                 ; display num. of files found, changed
doscall 4c00h                          ; exit with errorlevel 0


parse_tfn:                             ; READ TEMPLATE FILENAME:
mov word [tfn_attr],0016h              ; directories are okay, hidden, etc.
and byte [flags],0feh                  ; turn off quote mode
or byte [flags],04h                    ; turn on at-mode
mov di,tfbuf                           ; point to template filename buffer
jmp short parse_fn_0

parse_fn:                              ; READ FILESPEC FROM COMMAND LINE:
and byte [flags],0fah                  ; turn off quote-mode and at-mode
mov di,fnbuf                           ; point to filespec buffer
parse_fn_0:
zero cx                                ; no characters yet
mov [di],cl                            ; empty the buffer

parse_fn_1:                            ; parse filename loop:
lodsb                                  ; get a character from command line
call force_uc                          ; and force it to uppercase
cmp al,'?'
je .l0                                 ; found a wildcard in the filespec?
cmp al,'*'
jne .l1                                ; if not, never mind
.l0:
and byte [tfn_attr],0efh               ; if so, disallow subdirectories
.l1:
call test_eol                          ; end of line?
je parse_fn_eol                        ; if so, handle it
call test_space                        ; space or tab?
je parse_fn_space                      ; if so, handle it
cmp al,'"'                             ; quote mark?
je parse_fn_quote                      ; if so, handle it
cmp al,'/'                             ; forward slash?
jne .l2
mov al,'\'                             ; if so, convert to backslash
.l2:
cmp al,'@'                             ; at sign?
jne parse_fn_char                      ; no, treat like a normal character
testzero cx                            ; yes:  got any characters yet?
jne parse_fn_char                      ; yes:  at sign is part of filename
test byte [flags],05h                  ; quote-mode or at-mode?  if either,
jne parse_fn_char                      ; at sign is part of filename
or byte [flags],04h                    ; note:  file list
jmp short parse_fn_1                   ; continue parsing

parse_fn_char:                         ; NORMAL CHARACTER IN FILENAME:
mov [di],al                            ; stash it
inc di
mov byte [di],00h                      ; null terminate the buffer
inc cx                                 ; increment count of characters
cmp cx,fn_max                          ; buffer overflow?
jb parse_fn_1                          ; if not, continue parsing
bomb msg_err_fn_ovf,10h                ; complain and exit with errorlevel 16

parse_fn_eol:                          ; FOUND THE END OF COMMAND LINE:
testzero cx                            ; found a filename yet?
jne .l0                                ; if not,
bomb msg_err_in_filespec,10h           ; complain and exit with errorlevel 16
.l0:
dec si                                 ; let the primary parser see it
ret                                    ; and we're done parsing the filespec

parse_fn_space:                        ; FOUND A SPACE IN THE FILESPEC:
test byte [flags],01h                  ; parsing between quotes?
jne parse_fn_char                      ; if so, treat like any other char
testzero cx                            ; any characters in filespec yet?
jne .l1                                ; if not,
bomb msg_err_in_filespec,10h           ; complain and exit with errorlevel 16
.l1:
dec si                                 ; if so, we're done parsing filespec
ret

parse_fn_quote:                        ; found a quote mark:
test byte [flags],01h                  ; has an opening quote been found?
jne parse_close_quote                  ; if so, this is a close quote
testzero cx                            ; is the filename empty?
jne parse_fn_char                      ; if not, quote is part of filename
or byte [flags],01h                    ; note that open quote was found
jmp parse_fn_1                         ; and continue parsing
parse_close_quote:
testzero cx                            ; empty filename?
jne .l2                                ; if so,
bomb msg_err_in_filespec,10h           ; complain and exit with errorlevel 16
.l2:
ret                                    ; if not, done parsing filespec


touch_multiple_files:                  ; TOUCH FILES MATCHING CURRENT SPEC:
call append_short_filespec             ; add user's filespec
mov dx,fnbuf                           ; point to working filespec
mov cx,0006h                           ; include hidden and system files
doscall 4eh                            ; find first matching file
touch_multi_1:
jc touch_multi_exit                    ; any error, exit loop
test byte [dta_attr],attr_c            ; character device?
jne .l10                               ; if so, don't futz with it
call show_cur_dir_maybe                ; display current directory if need be
call show_cur_filename                 ; display current filename
call show_file_info                    ; and its date, time, attributes
add word [found_lo],byte 01h           ; add one to count of files found
adc word [found_hi],byte 00h
call touch_file                        ; do it to it!
.l10:
doscall 4fh                            ; find next matching file
jmp short touch_multi_1                ; till the cows come home
touch_multi_exit:
ret

touch_file:                            ; CHANGE FILE DATE, TIME, ATTRIBUTES:
test byte [more_flags],04h             ; supposed to change anything at all?
jne .l1                                ; if so, proceed
mov al,[dta_attr]                      ; if not, user may just want info
call show_attribs                      ; so display file attributes
mov ax,[dta_size+0]
mov dx,[dta_size+2]                    ; display file size
call show_file_size
jmp crlf                               ; terminate the print line and exit
.l1:
call prompt_user                       ; prompt user, if necessary
je .l18
jmp touch_file_no                      ; if answer is 'no', do nothing, exit
.l18:
call append_found_filespec             ; use the filename that was found

zero cx                                ; CLRMOD :
mov dx,fnbuf                           ; set file's attributes to 'none'
doscall 4301h
jnc .l2
mov dx,msg_clrmod                      ; error!  point to 'clrmod' string
jmp touch_problem                      ; and print error message
.l2:
test byte [flags],0c0h                 ; changing either the time or date?
je .l7                                 ; if not, just fix the attributes
mov dx,fnbuf                           ; OPEN :
doscall 3d22h                          ; open file for read/write
jnc .l3
mov dx,msg_open                        ; error!  point to 'open' string
jmp touch_problem                      ; and print error message
.l3:                                   ; file open succeeded:
mov [handle],ax                        ; save handle
test byte [flags],80h                  ; switch d specified?
je .l4
mov ax,[newdate]                       ; if so, use new date
mov [dta_date],ax
.l4:
test byte [flags],40h                  ; switch t specified?
je .l5
mov ax,[newtime]                       ; if so, use new time
mov [dta_time],ax
.l5:                                   ; TOUCH :
mov bx,[handle]
mov cx,[dta_time]                      ; use the correct time
mov dx,[dta_date]                      ; and date values
doscall 5701h                          ; to touch the file
jnc .l6
mov dx,msg_touch                       ; error!  point to 'touch' string
jmp short touch_problem                ; and print error message
.l6:                                   ; CLOSE :
mov bx,[handle]                        ; get file handle
doscall 3eh                            ; and close file
jnc .l7
mov dx,msg_close                       ; error!  point to 'close' string
jmp short touch_problem                ; and print error message
.l7:                                   ; FIXMOD :
mov ch,[chgattr]
xor ch,0ffh                            ; bits to _not_ change
and ch,[dta_attr]                      ; value of those bits
mov cl,[chgattr]                       ; bits to change
and cl,[newattr]                       ; value of those bits
or cl,ch                               ; combine old and new attribute bytes
mov [dta_attr],cl                      ; and save the resulting value
mov ch,00h
mov dx,fnbuf                           ; set file's attributes correctly
doscall 4301h
jnc .l8
mov dx,msg_fixmod                      ; error!  point to 'fixmod' string
jmp short touch_problem                ; and print error message
.l8:
add word [touch_lo],byte 01h           ; add one to count of files changed
adc word [touch_hi],byte 00h
file_touch_done:                       ; file was modified:
dosprint msg_arrow                     ; display the 'changed to' arrow
call show_file_info                    ; and new date, time, attributes
touch_file_no:                         ; nothing was done to the file:
jmp crlf                               ; terminate print line and exit
touch_problem:                         ; error trying to touch file:
push dx                                ; save error message
push ax                                ; and error number
call error_out
dosprint msg_touch_problem             ; print error message
pop ax
call decout                            ; and error number
dosprint msg_touch_prob_2
pop dx
doscall 09h                            ; and where it happened
jmp crlf                               ; terminate print line and exit

show_file_info:                        ; DISPLAY FILE'S DATE, TIME, ATTRIBS :
mov ax,[dta_date]
call show_dow                          ; compute and display day of week
mov ax,[dta_date]
call show_date                         ; display file's date stamp
dosprint msg_info_space                ; and two spaces
mov ax,[dta_time]
jmp show_time                          ; display file's time stamp and exit

find_any_subdirs:                      ; FIND SUBDIRECTORIES, ADD TO TREE BUF
test byte [flags],08h                  ; was /s specified?
jne .l1
ret                                    ; if not, don't bother finding subdirs
.l1:
mov si,star_dot_star                   ; copy star-dot-star filespec
mov di,[last_bs]                       ; just after the final backslash
inc di
call copy_string
cmp di,fnbuf + fn_max                  ; did the copy overflow the buffer?
jna .l2                                ; no, continue
jmp error_fnbuf_over                   ; yes, crash and burn
.l2:
mov dx,fnbuf
mov cx,0016h                           ; look for subdir, hidden, system ...
doscall 4eh
dir_loop:
jc dir_loop_exit                       ; any error, stop subdir search
test byte [dta_attr],attr_d            ; is the item found a subdir?
je dir_loop_next                       ; if not, keep looking
cmp byte [dta_name],'.'                ; stupid dos . or .. entries?
je dir_loop_next                       ; if so, keep looking
call append_found_filespec             ; add subdir name to current dir name
mov es,[tree_seg]
call find_es_zz                        ; find the end of the tree buffer
mov dx,si                              ; and remember where it was
mov di,si
mov si,fnbuf                           ; copy full pathname of found subdir
call copy_string_far                   ; into the tree buffer
mov cx,di
stosb                                  ; and add a second null
push ds
pop es
cmp cx,dx                              ; did we overflow the tree buffer?
jb tree_buffer_over                    ; if so, bomb out
dir_loop_next:                         ; look for next subdirectory:
doscall 4fh                            ; dos find-next-handle function
jmp short dir_loop
dir_loop_exit:                         ; done looking for subdirectories:
ret

tree_buffer_over:                      ; TREE BUFFER HAS OVERFLOWED:
bomb msg_tree_buffer_over,16h          ; complain and exit with errorlevel 22

use_next_subdir:                       ; IS A DIRECTORY NAME BUFFERED?
test byte [flags],08h                  ; was /s specified?
jne .l1
.l0:
stc                                    ; if not, exit with no new subdir
ret
.l1:                                   ; /s was specified:
mov es,[tree_seg]
zero bx
cmp [es:bx],bl                         ; is there anything in the buffer?
je .l0                                 ; if not, don't use it.  duh.
push ds
pop es
mov di,fnbuf                           ; es:di points to fnbuf
mov ds,[tree_seg]
zero si                                ; ds:si points to start of tree buffer
call copy_string_far                   ; get directory name from buffer
cmp byte [si],00h                      ; was it the last name in the buffer?
jne .l4
; zero bx
mov [bx],bx                            ; if so, empty the tree buffer
jmp short .l6
.l4:                                   ; if not,
zero di                                ; copy to the start of the tree buffer
mov es,[cs:tree_seg]
.l5:
lodsb                                  ; copy one byte from tree buffer
stosb                                  ; down into its new location
cmp al,00h                             ; null marking end of one subdir name?
jne .l5
cmp byte [si],00h                      ; if so, look for second (final) null
jne .l5                                ; and keep copying until you find it
stosb                                  ; store final null to new location
.l6:
push cs                                ; restore
push cs
pop ds                                 ; data segment
pop es                                 ; and extra segment
call find_null_fnbuf                   ; find the end of fnbuf
mov [last_bs],di
mov word [di],hilo (00h,'\')           ; add a backslash and terminal null
clc                                    ; and exit with carry clear
.quit:
ret                                    ; to indicate new dir. name present

show_total_counts:                     ; FINAL DISPLAY OF ALL FOUND, CHANGED:
call crlf                              ; print a blank line
dosprint msg_total_found               ; print 'Total found'
mov ax,[total_found_lo]
mov dx,[total_found_hi]
call dec_print_big                     ; and number found.
dosprint msg_num_touched               ; print ', changed'
mov ax,[total_touch_lo]
mov dx,[total_touch_hi]
call dec_print_big                     ; and number changed.
test byte [more_flags],04h             ; supposed to change anything at all?
jne .l10
dosprint msg_syntax_reminder           ; if not, display reminder message
.l10:
jmp crlf                               ; terminate print line and exit


switch_d_null:                         ; /D:N -- SET NULL DATE STAMP
mov [newdate],bx                       ; put zero value in newdate
.l1:
mov al,[si]
call force_uc
cmp al,'A'
jb use_next_subdir.quit
cmp al,'Z'
ja use_next_subdir.quit
inc si
jmp short .l1

switch_d_err:                          ; PROBLEM WITH /D SYNTAX
call error_out
switch_d_query:
dosprint msg_err_sw_d                  ; display help message
call show_date_format                  ; and current date style
doscall 4c10h                          ; and exit with errorlevel 16

switch_d_dupe:                         ; MORE THAN ONE /D ON COMMAND LINE:
mov al,'D'
jmp confused

switch_d:                              ; /D -- CHANGE DATE STAMPS
test byte [flags],80h                  ; was there a previous /d ?
jne switch_d_dupe                      ; if so, complain
or byte [flags],80h                    ; note it
and byte [more_flags],0d7h             ; no user-specified date (yet)
mov al,[si]                            ; examine next character
cmp al,'?'                             ; question mark?
je switch_d_query                      ; if so, show help for /d switch
call test_colon                        ; colon or equals sign?
jne .l0
inc si                                 ; if so, skip over it
mov al,[si]                            ; and expect the next character
call force_uc
cmp al,'N'                             ; to be the letter 'n'
je switch_d_null
call test_digit                        ; or else a digit
jne switch_d_err                       ; colon but no digit = syntax error!
.l0:                                   ; no colon:
call test_digit                        ; is the next character a digit?
je .l1                                 ; if so, skip ahead, get user's date
mov ax,[today]                         ; switch d with no date specified:
mov [newdate],ax                       ; use default of today's date
ret                                    ; and return to main parse loop
.l1:                                   ; switch d with a specific date:
or byte [more_flags],20h               ; note user-specified date
call get_num                           ; get first number (month)
jc switch_d_err
mov [date1],ax                         ; and save it
mov al,[si]                            ; examine the next character
call test_dsep                         ; is it a date separator?
jne switch_d_err
inc si                                 ; if so, continue
call get_num                           ; get second number (day)
jc switch_d_err
mov [date2],ax                         ; and save it
mov ax,[today]
mov cl,09h
shr ax,cl
add ax,1980
mov [date3],ax                         ; year defaults to this year
mov al,[si]                            ; examine the next character
call test_dsep                         ; is it a date separator?
jne .quit                              ; if not, year not specified
inc si                                 ; if so, skip over it
or byte [more_flags],08h               ; note user-specified year
call get_num                           ; get third number (year)
jnc .l2
jmp switch_d_err
.l2:
mov [date3],ax                         ; and save it
.quit:
ret

switch_t_dupe:                         ; MORE THAN ONE /T ON COMMAND LINE:
mov al,'T'
confused:                              ; used for duplicate switches :
mov [msg_err_dupe1],al                 ; insert offending letter into message
bomb msg_err_dupe,10h                  ; complain and exit with errorlevel 16

switch_t_err:                          ; PROBLEM WITH /T SYNTAX
call error_out
switch_t_query:
dosprint msg_err_sw_t                  ; show help message
doscall 4c10h                          ; and exit with errorlevel 16

switch_t:                              ; /T -- CHANGE TIME STAMPS
test byte [flags],40h                  ; was there a previous /t ?
jne switch_t_dupe                      ; if so, complain
or byte [flags],40h                    ; note it
and byte [more_flags],0efh             ; no user time (yet)
mov al,[si]                            ; examine next character
cmp al,'?'                             ; question mark?
je switch_t_query                      ; if so, show /t help
call test_colon                        ; colon or equals sign?
jne .l0
inc si                                 ; if so, skip over it
mov al,[si]                            ; and expect the next character
call test_digit                        ; to be a digit
jne switch_t_err                       ; colon but no digit = syntax error!
.l0:                                   ; no colon:
call test_digit                        ; is the character a digit?
je .l1                                 ; if so, skip ahead, get user's time
mov ax,[now]                           ; switch t with no time specified:
mov [newtime],ax                       ; use default of current time
ret                                    ; and return to main parse loop
.l1:                                   ; switch t with a specific time :
or byte [more_flags],10h               ; note user-specified time
call get_num                           ; get first number (hour)
jc switch_t_err
mov [user_hour],ax                     ; and save it
zero ax
mov [user_minute],ax                   ; minutes default to zero
mov [user_second],ax                   ; seconds default to zero
mov al,[si]                            ; examine the next character
call test_tsep                         ; is it a time separator?
jne .l3                                ; if not, minutes not specified
inc si                                 ; if so, continue
call get_num                           ; get second number (minute)
jc switch_t_err
mov [user_minute],ax                   ; and save it
mov al,[si]                            ; examine the next character
call test_tsep                         ; is it a time separator?
jne .l3                                ; if not, seconds not specified
inc si                                 ; if so, skip over it
call get_num                           ; get third number (seconds)
jc switch_t_err
mov [user_second],ax                   ; and save it
.l3:
mov ax,[user_hour]                     ; check user hours:
testzero ax                            ; zero hours?
je got_user_time                       ; if so, don't look for am or pm
cmp ax,12                              ; thirteen hours or more?
ja got_user_time                       ; if so, don't look for am or pm
mov al,[si]                            ; examine the next character
call force_uc
cmp al,'A'                             ; is it an 'a' ?
je time_is_am                          ; if so, adjust ante meridian
cmp al,'P'                             ; is it a 'p' ?
je time_is_pm                          ; if so, adjust post meridian
got_user_time:
ret

time_is_am:                            ; A.M. HOUR:
cmp word [user_hour],byte 12           ; am hours unchanged except for 12 am,
jne skip_am_pm
mov word [user_hour],0000h             ; which is zero hours
jmp skip_am_pm
time_is_pm:                            ; P.M. HOUR:
cmp word [user_hour],byte 12           ; 12 pm unchanged (12 pm is 12 hours)
je skip_am_pm
add word [user_hour],byte 12           ; other pm hours, add 12 hours
skip_am_pm:
inc si                                 ; skip over 'a' or 'p'
mov al,[si]                            ; and examine following character
call force_uc
cmp al,'M'                             ; is it an 'm' ?
jne .l0
inc si                                 ; if so, skip over that as well
.l0:
jmp short got_user_time

switch_s:                              ; /S -- RECURSE INTO SUBDIRECTORIES
or byte [flags],08h
ret

switch_p:                              ; /P /Q -- PROMPT USER, YES OR NO
or byte [more_flags],40h
ret

switch_w:                              ; /W -- PERMIT WEIRD STAMP VALUES
or byte [more_flags],02h
ret

switch_e:                              ; /E -- SUPPRESS AUTOMATIC .* EXT
or byte [more_flags],80h
switch_r:                              ; /R -- do-nothing switch, ignored
ret

switch_h:                              ; /H -- DO NOT HOOK INT 24
or byte [blue_flags],80h
ret

switch_f_dupe:                         ; MORE THAN ONE /F ON COMMAND LINE:
mov al,'F'
jmp confused

switch_f:                              ; /F -- DATE FORMAT
test byte [more_flags],01h             ; has there already been a /f ?
jne switch_f_dupe                      ; if so, problem
or byte [more_flags],01h               ; note it
mov al,[si]                            ; examine the next character
cmp al,'?'
je switch_f_query
call test_colon                        ; colon or equals sign?
jne switch_f_err                       ; if not, automatic syntax error
inc si                                 ; skip over colon
mov al,[si]                            ; examine the next character
call force_uc                          ; in uppercase:
cmp al,'U'                             ; /f:u ?
je switch_f_u                          ; if so, force united states format
cmp al,'E'                             ; /f:e ?
je switch_f_e                          ; if so, force european date format
cmp al,'J'                             ; /f:j ?
je switch_f_j                          ; if so, force japanese date format
cmp al,'I'                             ; /f:i ?
je switch_f_i                          ; if so, force iso date/time format
switch_f_err:                          ; PROBLEM WITH /F SYNTAX
call error_out
switch_f_query:
dosprint msg_err_sw_f                  ; complain
doscall 4c10h                          ; and exit with errorlevel 16
switch_f_u:
mov byte [country_date],00h            ; united states: use date format 0
inc si                                 ; skip over the u
ret                                    ; and exit
switch_f_e:
mov byte [country_date],01h            ; european: use date format 1
inc si                                 ; skip over the e
ret                                    ; and exit
switch_f_i:                            ; iso date and time format:
mov byte [country_dsep],'-'            ; date separator is a dash
mov byte [country_time],01h            ; 24-hour time format, fall through...
switch_f_j:
mov byte [country_date],02h            ; japanese: use date format 2
inc si                                 ; skip over the j
ret                                    ; and exit

switch_12:                             ; /12 -- 12-HOUR TIME DISPLAY FORMAT
mov al,[si]                            ; examine the next character
cmp al,'2'
je .l1                                 ; is it a 2 ?
jmp syntax                             ; if not, syntax error
.l1:
mov byte [country_time],00h            ; force 12-hour display format
inc si                                 ; skip over the 2
ret                                    ; and exit

switch_24:                             ; /24 -- 24-HOUR TIME DISPLAY FORMAT
mov al,[si]                            ; examine the next character
cmp al,'4'
je .l1                                 ; is it a 4 ?
jmp syntax                             ; if not, syntax error
.l1:
mov byte [country_time],01h            ; force 24-hour display format
inc si                                 ; skip over the 4
ret                                    ; and exit

switch_c_err:                          ; PROBLEM WITH /C SYNTAX
call error_out
switch_c_query:
dosprint msg_err_sw_c                  ; complain
doscall 4c10h                          ; and exit with errorlevel 16

switch_cd_cd:                          ; MORE THAN ONE TEMPLATE DATE:
bomb msg_err_cd_cd,10h                 ; complain and exit with errorlevel 16

switch_ct_ct:                          ; MORE THAN ONE TEMPLATE TIME :
bomb msg_err_ct_ct,10h                 ; complain and exit with errorlevel 16

switch_c:                              ; /C -- TEMPLATE FILE
mov cl,30h                             ; assume /c (both date and time)
mov al,[si]                            ; examine next character after /c:
call force_uc
cmp al,'?'
je switch_c_query
cmp al,'A'                             ; /ca?
jne .l0
jmp switch_ca                          ; if so, deal with it separately
.l0:
cmp al,'D'                             ; /cd?
jne .l1
inc si                                 ; if so, skip over the d
mov cl,20h                             ; copy only the date stamp
jmp short .l2                          ; and continue
.l1:
cmp al,'T'                             ; /ct?
jne .l2
inc si                                 ; if so, skip over the t
mov cl,10h                             ; copy only the time stamp
.l2:
mov [temp],cl                          ; save flags for a moment
mov al,[si]                            ; examine the next character
call test_template_separator           ; colon or equals sign?
jne switch_c_err                       ; if not, automatic syntax error
and cl,[flags]                         ; check for conflicts with earlier /c
test cl,20h                            ; more than one template date?
jne switch_cd_cd                       ; if so, complain
test cl,10h                            ; more than one template time?
jne switch_ct_ct                       ; if so, complain
mov cl,[temp]
or [flags],cl                          ; set appropriate flags
inc si                                 ; skip over colon and
call parse_tfn                         ; parse the template filename
mov dx,tfbuf                           ; use template filespec
mov cx,[tfn_attr]                      ; and template attributes
doscall 4eh                            ; attempt to locate matching file
jc switch_c_oops                       ; if any error, jump to handler
mov cx,[dta_time]                      ; get file's time stamp in .cx
mov dx,[dta_date]                      ; get file's date stamp in .dx
test byte [temp],20h                   ; supposed to use template date?
je .l10
mov [newdate],dx                       ; if so, stash template date
.l10:
test byte [temp],10h                   ; supposed to use template time?
je .l20
mov [newtime],cx                       ; if so, stash template time
.l20:
ret                                    ; done getting template stamp(s)

switch_c_oops:                         ; problem with template filespec :
call error_out
dosprint msg_err_begin
dosprint msg_err_temp_open             ; problem -- print error message
zprint tfbuf                           ; and template filespec
doscall 4c12h                          ; and exit with errorlevel 18

switch_ca:                             ; /CA -- COPY ATTRIBUTES FROM FILE
inc si
mov al,[si]                            ; examine the next character
call test_template_separator           ; colon or equals sign?
je .l1
jmp switch_c_err                       ; if not, automatic syntax error
.l1:
cmp byte [chgattr],00h                 ; was there a previous /a or /ca ?
jne switch_a_dupe                      ; if there was, bomb out
inc si                                 ; skip over the colon
call parse_tfn                         ; parse the template filename
mov dx,tfbuf                           ; use template filespec
mov cx,[tfn_attr]                      ; and template attributes
doscall 4eh                            ; attempt to locate matching file
jc switch_c_oops                       ; if any error, jump to handler
mov cl,[dta_attr]                      ; get attributes of found file
and cl,27h                             ; mask off unwanted bits
mov [newattr],cl                       ; save new attributes
mov byte [chgattr],27h                 ; note:  all attributes to be changed
ret                                    ; done getting template attributes

switch_a_dupe:                         ; MORE THAN ONE /A ON COMMAND LINE:
mov al,'A'
jmp confused

switch_a_query:
jmp switch_a_q1

switch_a:                              ; /A -- CHANGE ATTRIBUTES
cmp [chgattr],bl
jne switch_a_dupe
mov al,[si]                            ; examine next character
cmp al,'?'
je switch_a_query
call test_colon                        ; colon or equals sign?
jne .l0
inc si                                 ; if so, skip over it
.l0:
mov ch,00h                             ; no attributes found yet
mov al,[si]                            ; examine next character
cmp al,'+'
je sw_a_loop                           ; plus sign is legal, continue
cmp al,'-'
je sw_a_loop                           ; minus sign is legal, continue
jmp switch_a_err                       ; anything else is a boo-boo
sw_a_loop:                             ; main loop
mov al,[si]                            ; examine next character
cmp al,'+'
je sw_a_plus                           ; if a plus, set following attribs
cmp al,'-'
je sw_a_minus                          ; if a minus, clear following attribs
call force_uc
cmp al,'A'                             ; is it an 'a' ?
je sw_a_a                              ; if so, change archive bit
cmp al,'S'                             ; is it an 's' ?
je sw_a_s                              ; if so, change system bit
cmp al,'H'                             ; is it an 'h' ?
je sw_a_h                              ; if so, change hidden bit
cmp al,'R'                             ; is it an 'r' ?
je sw_a_r                              ; if so, change read-only bit
jmp sw_a_set_clr                       ; anything else, clean up and exit
sw_a_plus:                             ; found a plus sign:
call sw_a_set_clr                      ; resolve any pending attributes
mov ch,00h                             ; set following attributes
inc si                                 ; and the following character
jmp sw_a_get_letter                    ; must be an attribute letter
sw_a_minus:                            ; found a minus sign:
call sw_a_set_clr                      ; resolve any pending attributes
mov ch,80h                             ; clear following attributes
inc si                                 ; and the following character
sw_a_get_letter:                       ; must be an attribute letter:
mov al,[si]                            ; examine next character:
call force_uc
cmp al,'A'                             ; a for archive is legal
je sw_a_loop
cmp al,'S'                             ; s for system is legal
je sw_a_loop
cmp al,'H'                             ; h for hidden is legal
je sw_a_loop
cmp al,'R'                             ; r for read-only is legal
je sw_a_loop
jmp switch_a_err                       ; anything else is illegal!
sw_a_a:                                ; change archive bit:
or ch,attr_a
inc si
jmp short sw_a_loop
sw_a_s:                                ; change system bit:
or ch,attr_s
inc si
jmp short sw_a_loop
sw_a_h:                                ; change hidden bit:
or ch,attr_h
inc si
jmp short sw_a_loop
sw_a_r:                                ; change read-only bit:
or ch,attr_r
inc si
jmp short sw_a_loop
sw_a_set_clr:                          ; any attributes found yet?
cmp ch,00h
je .l3                                 ; if not, exit
test ch,80h                            ; setting or clearing attribs?
jne .l2
or [chgattr],ch                        ; setting - note bits to change
or [newattr],ch                        ; and their new value
jmp short .l3
.l2:                                   ; clearing:
and ch,7fh                             ; strip off the set/clear bit
or [chgattr],ch                        ; note bits to change
xor ch,0ffh
and [newattr],ch                       ; and their new value
.l3:
mov ch,00h                             ; reset temp attribs
ret

switch_a_err:                          ; PROBLEM WITH /A SYNTAX
call error_out
switch_a_q1:
dosprint msg_err_sw_a                  ; cry about it
doscall 4c10h                          ; and exit with errorlevel 16

switch_m_err:                          ; PROBLEM WITH /M SYNTAX
call error_out
switch_m_query:
dosprint msg_err_sw_m                  ; display error message
doscall 4c10h                          ; and exit with errorlevel 16

switch_m:                              ; /M -- CONTROL PAGING
mov al,[si]                            ; examine the next character:
cmp al,'?'                             ; is it a question mark?
je switch_m_query                      ; if so, display syntax help
call test_colon                        ; is the next character a colon?
jne .l1
inc si                                 ; if so, skip over it
mov al,[si]                            ; and expect the next character
call test_digit                        ; to be a digit
jne switch_m_err                       ; colon but no digit = syntax error!
.l1:                                   ; no colon:
call test_digit                        ; is the character a digit?
je .l3                                 ; if so, skip ahead, get user value
mov al,[vga_lines]
mov [screen_lines],al                  ; otherwise, default to 23 lines
ret                                    ; and return to main parse loop
.l3:                                   ; user-specified paging value:
call get_num                           ; read it in
cmp ah,00h                             ; more than 255?
jne switch_m_err                       ; if so, problem
mov [screen_lines],al                  ; otherwise, save it
ret                                    ; and exit

show_cur_dir_maybe:                    ; DISPLAY DIRECTORY NAME IF NEEDED:
cmp word [last_bs],byte 00h            ; is there a backslash in fnbuf?
je show_cur_dir.l9                     ; if not, exit in disgust
mov si,fnbuf
mov di,last_dir_shown
.l2:
lodsb
cmp al,[di]
jne .l8
inc di
cmp si,[last_bs]
jbe .l2
cmp byte [di],00h
je show_cur_dir.l9
.l8:
call show_file_count
call crlf                              ; display a blank line

show_cur_dir:
mov si,fnbuf                           ; point to start of filespec buffer
mov di,last_dir_shown
mov ah,02h                             ; dos print-a-character function
.l0:
cmp si,[last_bs]                       ; passed the final backslash yet?
ja .l8                                 ; if so, exit
mov dl,[si]                            ; get a character from directory name
inc si
mov [di],dl
inc di
int 21h                                ; and print it out
jmp short .l0                          ; and loop back for more
.l8:                                   ; done printing current directory name
mov byte [di],00h
call crlf                              ; terminate the current print line
.l9:
ret                                    ; get outta here

show_cur_filename:                     ; DISPLAY FILENAME OF FOUND FILE:
dosprint msg_info_space                ; tab in
mov di,dta_name                        ; point to start of found filename
mov ah,02h                             ; dos print-a-character function
mov cx,000eh                           ; must print 14 characters
.l0:
mov dl,[di]                            ; get a character from filename
cmp dl,'A'
jb .l4                                 ; is it an uppercase letter?
cmp dl,'Z'                             ; if not, don't lowercase it
ja .l4
or dl,20h                              ; if it is, force it to lowercase
.l4:
inc di
cmp dl,00h                             ; found the terminal null yet?
je .l1
int 21h                                ; if not, print the character
dec cx                                 ; decrement the characters index
jmp short .l0                          ; and loop back
.l1:                                   ; done printing filename:
mov dl,SPC
.l2:
int 21h                                ; print spaces
loop .l2                               ; until 13 characters have been shown
ret                                    ; then quit

show_date:                             ; display file's date stamp:
testzero ax
jne .l10
dosprint msg_date_none
ret
.l10:
push ax                                ; stash date stamp
mov al,[country_date]                  ; check country's date format
cmp al,01h
je show_datee                          ; 01, european date format
cmp al,02h
je show_datej                          ; 02, japanese date format
pop ax
push ax                                ; file's date stamp:
and ah,01h
mov cl,05h
shr ax,cl                              ; get month value in al
mov ah,80h                             ; suppress leading zeroes
call time_print                        ; print month
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ax,001fh                           ; get day value in ax
call time_print                        ; print day
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax                                 ; file's date stamp:
show_year:
mov cl,09h
shr ax,cl                              ; get year value in al
add ax,1980                            ; and normalize
jmp decout                             ; print the year and exit

show_datee:                            ; show date, european:
pop ax
push ax                                ; file's date stamp:
and ax,001fh                           ; get day value in al
or ah,80h
call time_print                        ; print day without leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ah,01h
mov cl,05h
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax                                 ; file's date stamp:
jmp show_year                          ; print the year

show_datej:                            ; show date, japanese:
pop ax
push ax                                ; file's date stamp:
call show_year                         ; print the year
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax
push ax                                ; file's date stamp:
and ah,01h
mov cl,05h
shr ax,cl                              ; get month value in al
call time_print                        ; print month, with leading zeroes
mov dl,[country_dsep]
doscall 02h                            ; and the date separator
pop ax                                 ; file's date stamp:
and ax,001fh                           ; get day value in al
call time_print                        ; print day with leading zeroes
ret

show_time:                             ; display file's time stamp:
push ax                                ; save time stamp for future reference
mov cl,0bh
shr ax,cl                              ; get hour in al
cmp byte [country_time],00h            ; do the locals use a 24-hour clock?
jne show_time_25                       ; if so, skip all am / pm fiddling
mov byte [msg_info_ampm+1],'a'         ; assume a.m.
cmp al,00h                             ; is it midnight?
jne show_time_15                       ; no, continue ....
mov al,12                              ; display midnight as '12 am'
jmp show_time_20
show_time_15:                          ; not midnight:
cmp al,12                              ; is it before noon?
jb show_time_20                        ; if so, don't need to manipulate it
mov byte [msg_info_ampm+1],'p'         ; noon or later:  display as 'pm'
cmp al,12                              ; is it noon?
je show_time_20                        ; if so, display as '12 pm'
sub al,12                              ; otherwise, normalize hours
show_time_20:                          ; done fiddling with hours:
mov ah,80h                             ; suppress leading zeroes
show_time_25:
call time_print                        ; and print hours
mov dl,[country_tsep]
doscall 02h                            ; followed by the time separator char
pop ax
push ax                                ; file's time stamp:
and ah,07h
mov cl,05h
shr ax,cl                              ; get minutes in al
call time_print                        ; print minutes with leading zeroes
mov dl,[country_tsep]
doscall 02h                            ; followed by the time separator char
pop ax                                 ; file's time stamp:
and ax,001fh
shl ax,01h
call time_print                        ; print seconds with leading zeroes
cmp byte [country_time],00h            ; do the locals use a 24-hour clock?
jne .l30
dosprint msg_info_ampm                 ; if not, display a.m. or p.m.
.l30:
ret

time_print:                            ; STUPID TWO-DIGIT DECIMAL PRINT:
mov dh,ah
aam                                    ; unpack decimal digits
add ax,hilo ('0','0')                  ; and convert to ascii digits
push ax                                ; save the remainder
mov dl,ah
test dh,80h                            ; supposed to suppress leading zero?
je .l10                                ; if not, skip ahead
cmp dl,'0'                             ; is the tens digit zero?
jne .l10                               ; if not, skip ahead
mov dl,SPC                             ; if so, print a space instead
.l10:
doscall 02h                            ; print the tens digit
pop dx                                 ; get the ones digit
int 21h                                ; print the ones digit
ret

show_dow_err:                          ; error computing day of week:
mov dx,0007h                           ; return 7 (no day-of-week)
jmp show_dow_x

show_dow:                              ; compute and display day of week:
mov [temp],ax                          ; save date in directory format
mov cl,09h
shr ax,cl
mov [date3],ax                         ; save year
mov ax,[temp]
mov cl,05h
shr ax,cl
and ax,000fh                           ; extract month value
cmp al,1                               ; month less than 1?
jb show_dow_err                        ; if so, no day-of-week
cmp al,12                              ; month greater than 12?
ja show_dow_err                        ; if so, no day-of-week
mov [date1],ax                         ; save month
mov ax,[temp]
and ax,001fh                           ; extract day value
cmp al,1                               ; day less than 1?
jb show_dow_err                        ; if so, no day-of-week
mov [date2],ax                         ; save day
call test_leap_year                    ; set correct length for february
mov bx,[date1]
mov cl,[months_table-1+bx]             ; get length of month in .cl
cmp cl,[date2]                         ; date greater than maximum?
jb show_dow_err                        ; if so, no day-of-week
zero bx
.l3:
mov al,[months_table+bx]               ; get length of month
cbw                                    ; as a word
inc bx
cmp bx,[date1]                         ; hit the user's month yet?
je .l4                                 ; yes, exit this loop
add [date2],ax                         ; no, add month length into julian
jmp short .l3                          ; and loop back for next month
.l4:                                   ; added in lengths of previous months:
mov bx,[date3]                         ; get dos year in .bx
testzero bx                            ; dos year zero?
je .l8                                 ; if so, skip following calculations
inc word [date2]                       ; add one for leap day 1980
mov ax,bx
mov dx,365
mul dx                                 ; multiply year number by 365
add [date2],ax                         ; and add into the julian number
mov ax,bx
dec ax                                 ; decrement year number
shr ax,01h
shr ax,01h                             ; and divide by four
add [date2],ax                         ; add leap days into julian number
cmp bx,byte 120                        ; year greater than 2100?
jbe .l8
dec word [date2]                       ; if so, subtract one leap day
.l8:                                   ; done computing julian number:
zero dx
mov ax,[date2]                         ; get julian date as 32-bit number
inc ax                                 ; add one (1-1-1980 was a tuesday)
mov cx,0007h                           ; divide julian number by seven
div cx                                 ; remainder in .dx is the day of week
show_dow_x:
shl dx,01h
shl dx,01h                             ; multiply dow number by four
add dx,dow_names                       ; to get offset within dow names table
doscall 09h                            ; print dow name
mov dl,SPC                             ; and a space
doscall 02h
ret                                    ; exit

show_attribs:                          ; display file's attributes:
mov dl,al                              ; save attributes byte
zero si                                ; pointer to bit-name letters
mov cl,attr_a                          ; highest bit is #5 (archive)
attr_loop:
mov al,'.'                             ; assume a space
test dl,cl                             ; is this bit set?
je attr_go                             ; clear, use the space
mov al,[attr1+si]                      ; set, get the bit-name letter instead
attr_go:
mov [msg_attrib+5+si],al               ; poke space or letter into string
inc si                                 ; and point to the next letter
attr_skip:
shr cl,1h                              ; and shift right to next bit
test cl,18h                            ; bit 3 (volume label) we
jne attr_skip                          ; don't care about, so skip it
cmp cl,00h                             ; run out of bits?
jne attr_loop                          ; no, loop back for next
dosprint msg_attrib                    ; yes, print the attribute string
ret

show_file_size:
mov byte [dp_min],0ch
call dec_print_big
dosprint msg_bytes
ret

show_file_count:                       ; SHOW NUMBER OF FILES FOUND, CHANGED:
mov ax,[found_lo]
or ax,[found_hi]                       ; found any at all?
or ax,ax
je .l0                                 ; if not, do nothing and exit
call crlf                              ; found some; print a blank line
dosprint msg_num_found                 ; and 'files found' message
mov ax,[found_lo]
mov dx,[found_hi]
call dec_print_big                     ; print number of files found
dosprint msg_num_touched               ; print 'files changed' message
mov ax,[touch_lo]
mov dx,[touch_hi]
call dec_print_big                     ; and number of files changed
dosprint msg_in_dir
zprint last_dir_shown
mov ax,[found_lo]
add [total_found_lo],ax                ; add number found
mov ax,[found_hi]
adc [total_found_hi],ax                ; to total number found
mov ax,[touch_lo]
add [total_touch_lo],ax                ; add number changed
mov ax,[touch_hi]
adc [total_touch_hi],ax                ; to total number changed
zero ax
mov [found_lo],ax
mov [found_hi],ax                      ; then zero out files-found count
mov [touch_lo],ax
mov [touch_hi],ax                      ; and files-changed count
.l0:
ret

dec_print_big:                         ; DISPLAY DOUBLEWORD IN DX:AX
mov [dp_t1],ax                         ; save the doubleword value
mov [dp_t2],dx                         ; for later use
mov byte [dp_t4],00h
mov bx,000ah                           ; ten decimal is our divisor
push bx                                ; also our end-of-stack marker
mov cl,00h                             ; init digits-between-commas count
dec_print_1:                           ; main decimal division loop
zero dx
mov ax,[dp_t2]                         ; dx:ax contains the high word as quad
div bx                                 ; divide by ten
mov [dp_t2],ax                         ; save new high-order word
mov ax,[dp_t1]                         ; get the old low word
div bx                                 ; and divide by ten
mov [dp_t1],ax                         ; save new low word
add dx,byte '0'                        ; convert remainder to ascii digit
push dx                                ; and save it on the stack
inc byte [dp_t4]
testzero ax                            ; anything left?
jne dec_print_12                       ; if so, continue with divisions
cmp word [dp_t2],byte 00h
je dec_print_15                        ; if not, print out digits
dec_print_12:
inc cl
cmp cl,03h                             ; three digits yet?
jne dec_print_1                        ; if not, loop back for next digit
mov cl,00h                             ; yes, zero counter
mov dl,[country_thou]
mov dh,dl                              ; and push a comma on the stack
push dx
inc byte [dp_t4]
jmp short dec_print_1                  ; and loop back for next digit
dec_print_15:                          ; done with divisions:
mov ah,02h                             ; dos print-character function:
cmp byte [dp_min],00h                  ; right justified?
je dec_print_2                         ; if not, print digits now
mov cl,[dp_min]                        ; get the decimal field width
sub cl,[dp_t4]                         ; subtract number of characters pushed
jbe dec_print_2                        ; if width already exceeded, forget it
mov ch,00h                             ; convert number of spaces to word
mov dl,SPC                             ; space character
dec_print_17:
int 21h                                ; print correct number of spaces
loop dec_print_17
dec_print_2:                           ; decimal printout loop
pop dx                                 ; get a digit from the stack
cmp dx,byte 0ah                        ; hit the end of stack yet?
je dec_print_3                         ; if so, exit decimal print routine
int 21h                                ; otherwise, print the digit
jmp short dec_print_2                  ; and loop back for next digit
dec_print_3:
mov byte [dp_min],00h                  ; default to no justification
ret

dp_min:                                ; minimum number of chars to print
db 00h

decout:                                ; DECIMAL PRINT, ONE WORD, NO COMMAS:
zero dx
push dx                                ; save zero as end-of-stack marker
mov cx,000ah                           ; use ten as decimal divisor
decout1:                               ; decimal division loop:
div cx                                 ; divide to get next lowest digit
add dx,byte '0'                        ; convert to ascii
push dx                                ; and save on the stack
zero dx                                ; recover high word for division
cmp ax,dx                              ; and check whether done dividing yet
jne decout1                            ; if not, loop back for more
mov ah,02h                             ; dos print-a-character function
decout2:                               ; decimal print loop:
pop dx                                 ; get a word from the stack
testzero dx                            ; run out of decimal digits yet?
je decout3                             ; if so, we're done
int 21h                                ; otherwise, print this digit
jmp short decout2                      ; and loop back for more
decout3:
ret

get_num:                               ; READ DEC. NUMBER FROM COMMAND LINE:
mov al,[si]                            ; examine first digit
call test_digit                        ; it is a digit, right?
jne get_num_err                        ; if not, exit with carry set
zero bx                                ; start with zero
get_num_loop:
lodsb                                  ; get digit from command line
sub al,'0'                             ; and convert to a value
mov cl,al                              ; save it in .cl
mov ch,00h                             ; as a word value
mov ax,bx                              ; get interim value
mov bx,000ah
mul bx                                 ; and multiply by ten
testzero dx                            ; if overflow on multiply,
jne get_num_err                        ; abort
add ax,cx                              ; add in value of most recent digit
jc get_num_err
mov bx,ax                              ; and save
mov al,[si]                            ; examine next character
call test_digit                        ; is it a decimal digit?
je get_num_loop                        ; if so, use it as well
mov ax,bx                              ; if not, done -- return value in .ax
clc                                    ; with carry clear
ret
get_num_err:                           ; overflow, or no number at all:
stc                                    ; exit with carry set
ret

force_uc:                              ; FORCE CHARACTER IN .AL TO UPPERCASE:
cmp al,'a'
jb .l1                                 ; lowercase letter?
cmp al,'z'                             ; if not, make no changes
ja .l1
and al,0dfh                            ; if so, force to uppercase
.l1:
ret

test_eol:                              ; IS CHARACTER IN .AL AN EOL OR NULL?
cmp al,00h
je .l1
cmp al,CR
.l1:
ret

test_switch:                           ; IS CHAR IN .AL A SWITCH CHARACTER?
cmp al,'/'                             ; exit with zero-flag set if it is
je .l1
cmp al,'-'
.l1:
ret

test_space:                            ; IS CHARACTER IN .AL A SPACE OR TAB?
cmp al,SPC                             ; exit with zero-flag set if it is
je .l1
cmp al,TAB
.l1:
ret

test_template_separator:               ; IS CHAR. IN .AL A : = or , SYMBOL?
cmp al,','
je test_colon.l1

test_colon:                            ; IS CHAR. IN .AL A COLON OR EQUALS?
cmp al,':'                             ; exit with zero-flag set if it is
je .l1
cmp al,'='
.l1:
ret

test_tsep:                             ; IS CHAR. IN .AL A TIME SEPARATOR?
cmp al,':'                             ; exit with zero-flag set if it is
je .l1
cmp al,'.'
je .l1
cmp al,','
.l1:
ret

test_dsep:                             ; IS CHAR. IN .AL A DATE SEPARATOR?
cmp al,'/'                             ; exit with zero-flag set if it is
je .l1
cmp al,'-'
je .l1
cmp al,'.'
.l1:
ret

test_digit:                            ; IS CHARACTER IN .AL A DECIMAL DIGIT?
cmp al,'0'                             ; exit with zero-flag set if it is
jb .l1
cmp al,'9'
ja .l1
cmp al,al
.l1:
ret

get_current_time:                      ; AND CONVERT TO DIRECTORY FORMAT
doscall 2ah                            ; get date
sub cx,1980                            ; normalize year to 1980-based
mov ch,cl
shl ch,01h                             ; and multiply by 512
and dl,1fh                             ; mask off day (shouln't need this)
mov cl,dl                              ; add in day
shr dx,01h
shr dx,01h
shr dx,01h                             ; multiply month by 32
and dx,01e0h                           ; mask off month value
or cx,dx                               ; and add it in
mov [today],cx                         ; stash date in directory format
doscall 2ch                            ; get time
mov al,00h
shl ch,01h
shl ch,01h
shl ch,01h                             ; multiply hours by 2048
mov ah,ch                              ; save hours
shl cx,01h
shl cx,01h
shl cx,01h
shl cx,01h
shl cx,01h                             ; multiply minutes by 32
and cx,07e0h                           ; mask off minutes
or ax,cx                               ; and add them in
shr dh,01h                             ; drop least significant bit of
and dh,1fh                             ; seconds and mask 'em off
or al,dh                               ; add in seconds
mov [now],ax                           ; stash time in directory format
ret

get_vga_lines:                         ; FIGURE DEFAULT SCROLL LENGTH
push cs
pop es                                 ; point es:di
mov di,dta                             ; to temporary buffer
mov ax,1b00h                           ; vga call:
zero bx
int 10h                                ; get state information
cmp al,1bh                             ; was call successful?
jne .l2                                ; if not, done with paging setup
mov al,[dta+22h]                       ; get number of lines
sub al,02h                             ; and subtract 2
mov [vga_lines],al                     ; save as number of lines to scroll
.l2:
ret

show_date_format:                      ; DISPLAY LOCAL DATE FORMAT:
call get_country_info                  ; get local format (override any /f:x)
dosprint msg_date_format               ; display introductory message
mov bx,msg_date_fmt_0                  ; point to u.s. format string
cmp byte [country_date],00h            ; using u.s. date format?
je show_date_format_1                  ; if so, okay, use u.s. string
mov bx,msg_date_fmt_1                  ; point to european format string
cmp byte [country_date],01h            ; using european date format?
je show_date_format_1                  ; if so, okay, use european string
mov bx,msg_date_fmt_2                  ; otherwise, use japanese string
show_date_format_1:
mov ah,02h                             ; dos print-a-character function
show_date_format_2:
mov dl,[bx]                            ; get a byte from format string
inc bx
cmp dl,00h                             ; end of string yet?
je show_date_format_4                  ; if so, exit
cmp dl,'-'                             ; minus sign?
jne show_date_format_3                 ; if so, convert
mov dl,[country_dsep]                  ; to local date separator character
show_date_format_3:
int 21h                                ; print the character
jmp short show_date_format_2           ; and loop back for more
show_date_format_4:                    ; done printing format string:
dosprint msg_date_fmt_done             ; print closing message
ret                                    ; and exit

clean_up_filespec:                     ; CANONICALIZE FILESPEC:
call fix_last_bs                       ; find final backslash
call must_have_drive                   ; supply drive letter if needed
call must_have_path                    ; supply pathname if needed
call never_ends_in_bs                  ; make sure filespec doesn't end in \
call doesnt_name_dir                   ; make sure it isn't a directory name
call no_double_bs                      ; eliminate any duplicate backslashes
call dots_fix                          ; eliminate any . or .. entries
call add_star_maybe                    ; add .* if permitted in this context
call get_short_filespec                ; extract short filespec from long
ret

must_have_drive:                       ; MAKE SURE FILESPEC HAS A DRIVE:
mov ax,[fnbuf]                         ; examine the first two characters :
cmp ax,hilo ('\','\')                  ; is this a unc filespec?
je .quit                               ; if so, don't muck about with it
cmp ah,':'                             ; is the second a colon?
jne .l0                                ; if not, add drive letter
cmp al,'A'
jb .l0                                 ; is the first a letter?
cmp al,'Z'                             ; if not, add drive letter
ja .l0                                 ; a drive letter was specified:
cmp byte [fnbuf+2],00h                 ; was there anything after it?
je .l5                                 ; if not, add star-dot-star
.quit:
ret                                    ; otherwise, exit with no change
.l0:
call find_null_fnbuf                   ; find the end of the filespec
cmp di,fnbuf + fn_max - 2              ; will this overflow fnbuf?
jae .l7                                ; if so, problem
.l1:
mov al,[di]                            ; copy a byte from source
mov [di+2],al                          ; to destination
dec di
cmp di,fnbuf                           ; done yet?
jae .l1                                ; no, continue
doscall 19h                            ; get current drive number
add al,'A'                             ; and convert to a letter
mov ah,':'                             ; stash letter and a colon
mov [fnbuf],ax                         ; into the filename buffer
cmp word [last_bs],byte 00h            ; if a backslash was found,
je .l2
add word [last_bs],byte 02h            ; add 2 to its location
.l2:
ret                                    ; and we're done
.l5:                                   ; only a drive letter found:
mov si,star_dot_star
mov di,fnbuf+2                         ; supply a star-dot-star
jmp copy_string                        ; and exit
.l7:                                   ; adding a drive would overflow fnbuf:
jmp error_fnbuf_over                   ; handle error

must_have_path:                        ; SUPPLY PATHNAME IF NEEDED:
cmp word [fnbuf],hilo ('\','\')        ; is this a unc filespec?
je .l4                                 ; if so, don't muck about with it
cmp byte [fnbuf+2],'\'                 ; did the user supply an abs. path?
je .l4                                 ; if so, exit without further ado
mov si,fnbuf+2                         ; starting immediately after colon,
mov di,dta                             ; copy everything to temp buffer
call copy_string
mov word [fnbuf+2],hilo (00h,'\')      ; poke in initial backslash
mov dl,[fnbuf]                         ; get drive letter
sub dl,40h                             ; and convert to a number
mov si,fnbuf + 3
doscall 47h                            ; get current directory name
call find_null_fnbuf                   ; find the end of the pathname
dec di
cmp byte [di],'\'                      ; does path already end in backslash?
je .l3
inc di
.l3:
mov byte [di],'\'                      ; terminate pathname
inc di
mov si,dta
call copy_string                       ; and copy remainder of filespec back
call fix_last_bs                       ; repair last_bs variable
.l4:
ret

never_ends_in_bs:                      ; FIX PATHNAMES ENDING IN BACKSLASH:
mov di,word [last_bs]                  ; get address of final backslash
inc di                                 ; and examine the following char.
cmp byte [di],00h                      ; is it a null?
jne must_have_path.l4                  ; if not, do nothing and exit
mov si,star_dot_star                   ; if so, tack on a star-dot-star
call copy_string                       ; after the backslash
cmp di,fnbuf + fn_max                  ; didn't overflow the buffer, did we?
jbe must_have_path.l4
jmp error_fnbuf_over                   ; oops

doesnt_name_dir:                       ; MAKE SURE IT'S NOT A DIRECTORY NAME:
mov si,[last_bs]
.l10:
lodsb                                  ; scan through filespec
cmp al,00h                             ; found a null?
je .l20                                ; if so, skip ahead
cmp al,'?'                             ; found a wildcard?
je .quit                               ; if so, not a directory name so exit
cmp al,'*'                             ; if not, keep scanning
jne .l10
.quit:
ret
.l20:
mov di,[last_bs]
inc di
cmp byte [di],'.'
je .l25
mov cx,0016h
mov dx,fnbuf
doscall 4eh                            ; search for items matching spec
jc .quit                               ; if not found, okay so exit
test byte [dta_attr],attr_d            ; is item a subdirectory?
je .quit                               ; if not, just exit
.l25:
dec si                                 ; point to terminal null
cmp si,fnbuf + fn_max - 5
ja .l30
mov [last_bs],si                       ; fix last-backslash pointer
mov word [si],hilo ('*','\')
mov word [si+2],hilo ('*','.')         ; add a backslash-star-dot-star
mov byte [si+4],00h                    ; and null-terminate the filespec
ret
.l30:
jmp error_fnbuf_over

no_double_bs:                          ; remove any duplicated backslashes :
mov di,fnbuf                           ; start at beginning of filename
.l10:
inc di
mov ax,[di]                            ; examine two characters at a time
cmp al,00h                             ; found the end of the filespec yet?
je doesnt_name_dir.quit                ; if so, exit
cmp ax,hilo ('\','\')                  ; duplicate backslashes?
jne .l10                               ; if not, loop back, keep searching
.l20:
mov si,di                              ; copy down
inc si                                 ; from the second backslash
call copy_string                       ; onto the first
dec word [last_bs]                     ; adjust last-backslash pointer
jmp short no_double_bs                 ; and loop back for more abuse

dots_fix:                              ; LOOK FOR . OR .. ENTRIES:
mov si,fnbuf                           ; start at beginning of filespec
.l0:
mov ax,[si]                            ; look at two bytes at a time
inc si
cmp al,00h                             ; found the end of the filespec yet?
jne .l1
.l9:
jmp fix_last_bs                        ; if so, fix last_bs variable and exit
.l1:
cmp ax,hilo ('.','\')                  ; found a . entry?
jne .l0                                ; if not, keep looking
mov cx,0001h                           ; one dot found so far
.l2:
inc si                                 ; skip past that first dot
mov al,[si]                            ; examine the next character
cmp al,00h                             ; end of filespec?
je .l9                                 ; if so, exit
cmp al,'.'                             ; another dot?
jne .l3
inc cx                                 ; if so, count it
jmp short .l2                          ; and keep parsing
.l3:
cmp al,'\'                             ; another backslash?
jne .l0                                ; if not, ignore this (weird) entry
mov di,si                              ; point .di to backslash after dots
.l4:
dec di                                 ; and scan backwards through fnbuf
cmp di,fnbuf                           ; fell off the beginning of fnbuf?
jbe .l8                                ; if so error
cmp byte [di],'\'                      ; found a backslash?
jne .l4                                ; if not, keep searching backwards
loop .l4                               ; decrement dots count, continue
call copy_string                       ; copy string after dots down
jmp short dots_fix                     ; and loop back for more .\ entries
.l8:                                   ; too many dot entries:
bomb msg_err_dots_fix,15h              ; complain and exit with errorlevel 21

add_star_maybe:                        ; ADD .* IF PERMITTED IN THIS CONTEXT:
test byte [more_flags],80h             ; allowed to add .* ?
jne .l8                                ; if so, exit without effect
test byte [flags],04h                  ; list file name?  name from list?
jne .l8                                ; either case, exit without effect
mov cl,00h                             ; have not found dot yet
mov si,fnbuf                           ; start at beginning of filespec
.l1:
lodsb                                  ; get a character from filespec
cmp al,'\'                             ; backslash?
jne .l3
mov cl,00h                             ; if so, note dot not found yet
.l3:
cmp al,'.'                             ; dot?
jne .l4
mov cl,01h                             ; if so, note dot has been found
.l4:
cmp al,00h                             ; found end of filespec?
jne .l1                                ; if not, keep parsing
cmp cl,00h                             ; found a dot in the filespec?
jne .l8                                ; if so, exit with no effect
cmp si,fnbuf + fn_max - 2              ; have room to add the .* ?
ja .l9                                 ; if not, bomb out
dec si                                 ; point to the terminal null
mov word [si],hilo ('*','.')           ; add the .*
inc si
inc si
mov byte [si],00h                      ; and the terminal null
.l8:                                   ; normal exit
ret
.l9:                                   ; filespec buffer overflow:
jmp error_fnbuf_over                   ; bomb out

get_short_filespec:                    ; EXTRACT SHORT FILESPEC FROM LONG:
mov si,fnbuf + 2                       ; copy entire filespec
cmp word [last_bs],byte 00h            ; or, if directory was specified,
je .l0
mov si,[last_bs]                       ; the filespec immediately following
inc si                                 ; the last backslash
.l0:
mov di,nambuf                          ; into the name buffer
call copy_string
cmp di,nambuf + 0eh                    ; overflowed the short name buffer?
jb alloc_tree_buffer.quit              ; no, bliss
bomb msg_err_nambuf_over,10h           ; complain and exit with errorlevel 16


alloc_tree_buffer:                     ; CREATE BUFFER FOR /S TREE IF NEEDED:
test byte [flags],08h                  ; /s specified?
je .quit                               ; no, don't bother with tree buffer
mov bx,1000h                           ; yes, allocate 64k
doscall 48h                            ; for tree buffer
jnc .l0
jmp trs_80                             ; any problem, complain and abort
.l0:
mov [tree_seg],ax                      ; no problem, remember segment
mov es,ax
zero bx
mov [es:bx],bx                         ; and empty the tree buffer
.quit:
ret

alloc_list_buffer:                     ; CREATE BUFFER FOR FILE LIST:
mov bx,0100h                           ; allocate four kilobytes
doscall 48h                            ; for list buffer
jnc .l0
jmp trs_80                             ; any problem, complain and abort
.l0:
mov [list_seg],ax                      ; no problem, remember segment
mov word [list_pnt],2000h              ; and note that the buffer is empty
ret

use_template_stamps:                   ; USE /C DATE AND TIME, IF PRESENT:
mov al,[flags]
and al,0a0h                            ; check for conflict between
cmp al,0a0h                            ; /d and /cd:
jne .l1                                ; if both were specified,
bomb msg_err_d_cd,10h                  ; complain and exit with errorlevel 16
.l1:
mov al,[flags]
and al,50h                             ; check for conflict between
cmp al,50h                             ; /t and /ct:
jne .l2                                ; if both were specified,
bomb msg_err_t_ct,10h                  ; complain and exit with errorlevel 16
.l2:
mov al,[flags]
and al,30h                             ; get template date and/or time flags
shl al,01h
shl al,01h                             ; and copy them over
or [flags],al                          ; into the main date and/or time flags
ret

eval_user_stamps:                      ; EVALUATE USER DATE AND TIME VALUES:
test byte [flags],80h                  ; was there any /d at all?
je .l0                                 ; if not, don't evaluate date stamp
test byte [more_flags],20h             ; user-specified date stamp?
jne eval_user_date                     ; if not, don't evaluate date stamp
.l0:
jmp eval_time
eval_user_date:                        ; EVALUATE USER DATE VALUE:
test byte [more_flags],08h             ; long format -- user specified year?
je .l4                                 ; if not, don't do japanese adjustment
cmp word [date1],1980                  ; is the first number at least 1980?
jae .l2                                ; if so, assume iso date format....
cmp byte [country_date],02h            ; japanese (long) format date?
jne .l4                                ; if not, don't do japanese adjustment
.l2:                                   ; adjust japanese yyyy-mm-dd format :
mov ax,[date1]
mov bx,[date2]                         ; shuffle values around:
mov cx,[date3]
mov [date3],ax                         ; first number is really the year
mov [date1],bx                         ; second number is really the month
mov [date2],cx                         ; third number is relly the day
jmp short .l5
.l4:
cmp byte [country_date],01h            ; european (long or short) format?
jne .l5
mov ax,[date1]                         ; if so, shuffle values around:
mov bx,[date2]
mov [date2],ax                         ; first number is really the day
mov [date1],bx                         ; second number is really the month
.l5:
mov ax,[date1]                         ; check user month:
mov bx,0c01h                           ; normally 1 through 12
mov cx,0f00h                           ; but might be zero through 15
mov dx,msg_month_eq                    ; point to 'month =' message
call test_range                        ; and verify that month is reasonable
jnc .l54
jmp eval_date_err
.l54:
mov ax,[date2]                         ; check user day:
mov bx,1f01h                           ; normally 1 through 31
mov cx,1f00h                           ; but might be zero through 31
mov dx,msg_day_eq                      ; point to 'day =' message
call test_range                        ; and verify that day is reasonable
jnc .l58
jmp eval_date_err
.l58:
mov ax,[date3]                         ; check user year:
mov dx,msg_year_eq
cmp ax,0050h                           ; less than 80?
jae .l6                                ; if so, year is 2000 through 2079
add ax,0014h                           ; so add 20
mov [date3],ax                         ; to get dos year 20 through 99
jmp pack_date                          ; and convert date to directory form
.l6:
cmp ax,0063h                           ; 80 through 99?
ja .l7                                 ; if so, year is 1980 through 1999
sub ax,0050h                           ; so subtract 80
mov [date3],ax                         ; to get dos year 0 through 19
jmp pack_date                          ; and convert date to directory form
.l7:
cmp ax,1980                            ; anything else less than 1980
jb eval_date_err                       ; is an error
cmp ax,2107                            ; anything over 2107
ja eval_date_err                       ; is also an error
test byte [more_flags],02h             ; weird values allowed?
jne .l8
cmp ax,2099                            ; if not, any year over 2099
ja eval_date_err                       ; is also an error
.l8:
sub ax,1980                            ; year is 1980 - 2107, subtract 1980
mov [date3],ax                         ; to get dos year 0 through 127
pack_date:
mov ax,[date3]                         ; get user year
mov cl,09h
shl ax,cl                              ; and multiply by 512
mov bx,[date1]                         ; get user month
mov cl,05h
shl bx,cl                              ; and multiply by 32
or ax,bx                               ; add it in
or ax,[date2]                          ; add in user day
mov [newdate],ax                       ; and save it
test byte [more_flags],02h             ; weird dates allowed?
jne eval_time                          ; if so, skip remaining tests
call test_leap_year                    ; set correct length for february
mov bx,[date1]
mov al,[months_table-1+bx]             ; get max days in user's month
cmp al,[date2]                         ; compare against user's day
jae eval_time                          ; if okay, continue with user's time
call error_out                         ; problem!
dosprint msg_err_user_date             ; print error message
mov ax,[newdate]
call show_date                         ; and display the user's illegal date
call crlf                              ; blank line
doscall 4c10h                          ; exit with errorlevel 16

eval_time:                             ; skip over error code, evaluate time
jmp eval_user_time
eval_date_err:                         ; problem with user-specified date:
push ax                                ; save user value
push dx                                ; and pointer to string
call error_out                         ; force error output
dosprint msg_err_user_date             ; print error message 
pop dx
doscall 09h                            ; and value-name string
pop ax
call decout                            ; and the user's erroneous value
call crlf                              ; and a blank line
doscall 4c10h                          ; and exit with errorlevel 16

eval_user_time:                        ; EVALUATE USER TIME VALUE:
test byte [flags],40h                  ; was there any /t at all?
je .l0                                 ; if not, don't evaluate date stamp
test byte [more_flags],10h             ; user-specified time stamp?
jne .l1                                ; if not, don't evaluate time stamp
.l0:
ret
.l1:
mov ax,[user_hour]                     ; check user hours:
mov bx,1700h                           ; normally zero through 23
mov cx,1f00h                           ; but might be zero through 31
mov dx,msg_hour_eq                     ; point to 'hour =' message
call test_range                        ; and verify that hour is reasonable
jc eval_time_err
mov ax,[user_minute]                   ; check user minutes:
mov bx,3b00h                           ; normally zero through 59
mov cx,3f00h                           ; but might be zero through 63
mov dx,msg_minute_eq                   ; point to 'minute =' message
call test_range                        ; and verify that minute is reasonable
jc eval_time_err
mov ax,[user_second]                   ; check user seconds:
mov bx,3b00h                           ; normally zero through 59
mov cx,3f00h                           ; but might be zero through 63
mov dx,msg_second_eq                   ; point to 'second =' message
call test_range                        ; and verify that second is reasonable
jc eval_time_err
mov ax,[user_hour]                     ; get user hours
mov cl,0bh
shl ax,cl                              ; and multiply by 2048
mov bx,[user_minute]                   ; get user minutes
mov cl,05h
shl bx,cl                              ; and multiply by 32
or ax,bx                               ; add in minutes
mov bx,[user_second]                   ; get user seconds
shr bx,01h                             ; and divide by two
or ax,bx                               ; add in user seconds
testzero ax                            ; midnight exactly?
jne .l3                                ; no, don't worry about 12am blanking
cmp word [dos_ver],031fh               ; dos version 3.31 or later?
jae .l3                                ; yes, don't worry about 12am blanking
test byte [more_flags],02h             ; weird values permitted?
jne .l3                                ; yes, don't worry about 12am blanking
inc ax                                 ; else add two seconds to midnight
.l3:
mov [newtime],ax                       ; and save
ret
eval_time_err:                         ; problem with user-specified time:
push ax                                ; save the value
push dx                                ; and the pointer to the value's name
call error_out
dosprint msg_err_begin
dosprint msg_err_user_time             ; print an error message
pop dx
doscall 09h                            ; and the value's name
pop ax
call decout                            ; and the erroneous value
call crlf                              ; and a blank line
doscall 4c10h                          ; and exit with errorlevel 16

test_leap_year:                        ; SET CORRECT LENGTH FOR FEBRUARY:
mov al,28                              ; 28 days in february
cmp word [date3],byte 120              ; year 2100 (dos year 120) ?
je .l1                                 ; if so, not a leap year
test byte [date3],03h                  ; year divisible by 4 ?
jne .l1                                ; if not, not a leap year
inc al                                 ; leap year, 29 days in february
.l1:
mov [months_table+1],al                ; set number of days for february
ret                                    ; and exit

get_fn_from_list:                      ; READ FILESPEC FROM FILE LIST:
test byte [flags],04h                  ; are we using a file list?
jne .l1
clc
ret                                    ; if not, simply exit with carry clear
.l1:
cmp word [auxhandle],byte 00h          ; is it open yet?
jne .l3                                ; if so, continue
mov dx,fnbuf
doscall 3d20h                          ; open file list file
jnc .l2
dosprint msg_err_listfile              ; problem:  print error message
zprint fnbuf                           ; and filename
stc                                    ; and exit with carry
ret
.l2:
mov [auxhandle],ax                     ; save file handle
mov word [list_pnt],2000h              ; and note that the buffer is empty
.l3:
mov di,fnbuf
mov byte [di],00h                      ; empty the filespec buffer
and byte [flags],0feh                  ; not between quotes
read_fn_loop:
call read_from_list                    ; get a character from the file list
cmp al,1ah                             ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,SPC                             ; end of line?
jb read_fn_eol                         ; if so, deal with it
call test_space                        ; space?
je read_fn_sp                          ; if so, deal with it
cmp al,'"'                             ; quote mark?
je read_fn_qu                          ; if so, deal with it
cmp al,';'                             ; semicolon?
je read_fn_semi                        ; if so, deal with it
cmp al,':'                             ; colon?
je read_fn_semi                        ; if so, deal with it
call force_uc
cmp al,'/'                             ; slash?
jne read_fn_ch
mov al,'\'                             ; if so, convert to a backslash
read_fn_ch:                            ; got a legal character for filename:
mov ah,00h
mov [di],ax                            ; put it into the buffer, with a null
inc di
cmp di,fnbuf + fn_max                  ; blown past the end of the buffer?
jb read_fn_loop                        ; no, loop back for more
jmp read_fn_spam                       ; yes, deal with it
read_fn_eof:                           ; found end of list file:
mov bx,[auxhandle]
doscall 3eh                            ; close the list file
zero ax
mov [auxhandle],ax                     ; and mark it closed
and byte [flags],0fbh                  ; no more file list!
cmp [fnbuf],al                         ; was a filename retrieved before eof?
je .l1
clc                                    ; yes, exit with carry clear
ret
.l1:
stc                                    ; no, exit with carry set
ret
read_fn_sp:                            ; found a space:
test byte [flags],01h                  ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
read_fn_eol:                           ; found end of line:
cmp byte [fnbuf],00h                   ; anything in the buffer yet?
je read_fn_loop                        ; if not, keep looking
call clean_up_filespec                 ; clean it up
clc
ret                                    ; and exit
read_fn_qu:                            ; found a quote:
test byte [flags],01h                  ; was there an open quote?
jne read_fn_eol                        ; if so, it ends the filespec
cmp byte [fnbuf],00h                   ; anything in the buffer yet?
jne read_fn_ch                         ; if so, treat like any other char
or byte [flags],01h                    ; otherwise, this is an open quote
jmp short read_fn_loop                 ; keep reading
read_fn_semi:                          ; found a semicolon:
test byte [flags],01h                  ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
cmp byte [fnbuf],00h                   ; anything in the buffer yet?
jne read_fn_ch                         ; if so treat like any other char
cmp al,':'                             ; was comment character a colon?
je read_fn_notice                      ; if so, this is a printable 'notice'
read_fn_remark:                        ; NONPRINTABLE COMMENT IN FILE LIST:
call read_from_list                    ; get a character from the file list
cmp al,1ah                             ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,SPC                             ; found the end of the remark?
jae read_fn_remark                     ; if not, keep looking
jmp read_fn_loop                       ; otherwise, resume hunt for filespec
read_fn_notice:                        ; PRINTABLE NOTICE IN FILE LIST:
dosprint msg_notice                    ; introduce it
.l0:
call read_from_list                    ; get a character from the file list
cmp al,1ah                             ; end of file?
je .l2                                 ; if so, deal with it
cmp al,SPC                             ; found the end of the notice?
jae .l1
call crlf                              ; if so, terminate the output line
jmp read_fn_loop                       ; and go back to the filespec search
.l1:
mov dl,al                              ; otherwise, this is a printable char
doscall 02h                            ; print it
jmp short .l0                          ; and continue scanning through notice
.l2:                                   ; end-of-file within notice:
call crlf                              ; terminate the output line
jmp read_fn_eof                        ; and the input file

read_fn_spam:                          ; overflowed the working buffer:
mov byte [fnbuf],00h                   ; empty the working buffer
dosprint msg_err_list_spam             ; print an error message
jmp read_fn_eof                        ; and kill the current file list

read_from_list:                        ; GET CHARACTER FROM FILE LIST FILE:
mov ax,[list_pnt]
cmp ax,1000h                           ; need to refill the buffer?
jb read_list                           ; nope, skip ahead
mov cx,1000h                           ; read four kilobytes
mov bx,[auxhandle]                     ; from the file list
zero dx                                ; to the start
mov ds,[list_seg]                      ; of the list buffer
doscall 3fh
push cs
pop ds                                 ; restore data segment
jnc .l3                                ; if any error on read,
bomb msg_err_read_list,13h             ; complain and exit with errorlevel 19
.l3:
mov word [list_pnt],0000h              ; move pointer back to start of buffer
cmp ax,1000h                           ; got four kilobytes?
je read_list                           ; cool!
testzero ax                            ; got anything at all?
jne .l4
mov al,1ah                             ; if not, return end-of-file
ret
.l4:
mov si,ax                              ; got less than four kilobytes:
mov es,[list_seg]                      ; poke in an eof
mov byte [es:si],1ah                   ; just to be on the safe side
read_list:                             ; get buffered char from file list:
mov es,[list_seg]                      ; segment of file list buffer
mov si,[list_pnt]                      ; pointer into list buffer
mov al,[es:si]                         ; get character from buffer
inc si
mov [list_pnt],si                      ; and increment the pointer
push ds
pop es                                 ; fix data segment
.quit:
ret                                    ; and exit

find_null_fnbuf:                       ; FIND END OF FILESPEC:
mov di,fnbuf                           ; fall through to:

find_null:                             ; FIND END OF ASCIIZ STRING:
cmp byte [di],00h                      ; found null yet?
je read_list.quit                      ; yes, exit
inc di                                 ; no, keep searching
jmp short find_null

fix_last_bs:                           ; REPAIR LAST_BS VARIABLE:
zero ax
mov [last_bs],ax                       ; note no backslashes found yet
mov si,fnbuf                           ; point to start of filespec buffer
.l0:
mov al,[si]                            ; look at character
cmp al,00h                             ; terminal null?
je .l2                                 ; if so, exit
cmp al,'\'                             ; backslash?
jne .l1
mov [last_bs],si                       ; if so, save its address
.l1:
inc si                                 ; and keep on going
jmp short .l0
.l2:                                   ; found the terminal null
cmp si,fnbuf + fn_max                  ; have we wandered off the edge?
jae .l4                                ; if so, problem
ret
.l4:                                   ; spammed fnbuf:
jmp error_fnbuf_over                   ; abort

prompt_user:                           ; PROMPT USER, IF NEEDED:
test byte [more_flags],40h             ; was /p or /q specified?
je prompt_user_x                       ; if not, bug out
dosprint msg_query                     ; display prompt message
.l0:
call flush_key_buffer                  ; empty keyboard buffer
mov ah,00h
int 16h                                ; get a keystroke
call force_uc                          ; and convert it to uppercase
cmp al,'A'                             ; 'a' for 'all' ?
je prompt_user_all                     ; if so, deal with it
cmp al,'Q'                             ; 'q' for 'quit' ?
je prompt_user_quit                    ; if so, deal with it
cmp al,'N'                             ; 'n' for 'no' ?
je prompt_user_1                       ; if so, normal exit
cmp al,'Y'                             ; 'y' for 'yes' ?
jne .l0                                ; if not, ignore this keystroke
prompt_user_1:                         ; 'y' or 'n' pressed:
push ax                                ; save the keystroke
call unquery                           ; erase the prompt message
pop ax                                 ; and check the user's keystroke
cmp al,'Y'                             ; was it 'y' for 'yes' ?
prompt_user_x:                         ; exit
ret
prompt_user_all:                       ; 'a' for 'all' :
and byte [more_flags],0bfh             ; turn off prompting
mov al,'Y'                             ; pretend this was a 'y'
jmp short prompt_user_1                ; and exit normally
prompt_user_quit:                      ; 'q' for 'quit' :
call unquery                           ; erase the prompt message
call crlf                              ; terminate the current print line
call show_file_count                   ; show current files found/changed
jmp big_loop_done                      ; and break out of big_loop

unquery:
mov ah,02h
mov dl,BS
call .unq13
mov dl,SPC
call .unq13
mov dl,BS
.unq13:
mov cx,0013h
.l10:
int 21h
loop .l10
ret

flush_key_buffer:                      ; EMPTY KEYBOARD BUFFER:
mov ah,01h
int 16h                                ; check keyboard buffer
je get_country_info.quit               ; exit if empty
mov ah,00h                             ; otherwise,
int 16h                                ; get a keystroke from buffer
jmp short flush_key_buffer             ; and loop back

get_country_info:                      ; time and date formats, etcetera
mov dx,country
doscall 3800h                          ; get current country info
.quit:
ret                                    ; and exit

test_range:                            ; SANITY CHECK FOR TIME / DATE VALUES:
cmp ah,00h                             ; all of which are less than 256
jne test_range_bad                     ; so a nonzero high byte is a problem
test byte [more_flags],02h             ; are weird values permitted?
jne test_range_weird                   ; if so, do weird tests instead
cmp al,bl                              ; is it less than the minimum value?
jb test_range_bad                      ; if so, fail
cmp al,bh                              ; is it above the maximum value?
ja test_range_bad                      ; if so, fail
clc                                    ; all correct, exit with carry clear
ret
test_range_bad:                        ; any failure,
stc                                    ; exit with carry set
ret
test_range_weird:                      ; /w weird range check:
cmp al,cl                              ; is it less than the minimum value?
jb test_range_bad                      ; if so, fail
cmp al,ch                              ; is it above the maximum value?
ja test_range_bad                      ; if so, fail
clc                                    ; all correct, exit with carry clear
ret

append_found_filespec:                 ; ADD FOUND FILESPEC AFTER PATHNAME:
mov di,[last_bs]                       ; destination is
inc di                                 ; character following final backslash
mov si,dta_name                        ; source is filename in dta
call copy_string                       ; copy found filename into fnbuf
cmp di,fnbuf + fn_max                  ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

append_short_filespec:                 ; ADD USER FILESPEC AFTER PATHNAME:
mov di,[last_bs]                       ; destination is
inc di                                 ; character following final backslash
mov si,nambuf                          ; source is short filespec buffer
call copy_string                       ; copy found filename into fnbuf
cmp di,fnbuf + fn_max                  ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

error_fnbuf_over:                      ; fnbuf has overflowed:
bomb msg_err_fnbuf_over,14h            ; complain and exit with errorlevel 20

copy_string:                           ; COPY ASCIIZ STRING [SI] TO [DI]:
push ds                                ; make .es equal to .ds
pop es                                 ; and fall through ....

copy_string_far:                       ; COPY ASCIIZ STRING [SI] TO [ES:DI]:
lodsb                                  ; get a character from [ds:si]
stosb                                  ; put it in [es:di]
cmp al,00h                             ; until the final null is found
jne copy_string_far
ret                                    ; then quit

find_es_zz:                            ; FIND TERMINAL DOUBLE-NULL:
zero si                                ; start at beginning of tree buffer
cmp [es:si],si                         ; is the tree buffer empty?
je .l2                                 ; if so, return zero in .si
.l0:                                   ; scan forward through tree buffer:
cmp word [es:si],byte 00h              ; found the double null null yet?
je .l1
inc si                                 ; if not, increment pointer
jmp short .l0                          ; and keep looking
.l1:                                   ; found the double null:
inc si                                 ; return offset of _second_ null
.l2:
ret                                    ; exit

zprint1:                               ; PRINT ASCIIZ STRING VIA .DI:
mov ah,02h                             ; dos print-a-character function
.l0:
mov dl,[di]                            ; get a byte from string
inc di
cmp dl,00h                             ; found the final null?
je .l1                                 ; if so, deal with it
int 21h                                ; otherwise, print the character
jmp short .l0                          ; and loop back for more abuse
.l1:                                   ; found the final null:

crlf:                                  ; END OF PRINT LINE:
dosprint msg_crlf                      ; print a carriage return, line feed
test byte [flags],02h                  ; was stdout redirected?
jne .l25                               ; if so, skip control/alt-key handler
push es
mov ax,0040h
mov es,ax                              ; bios data segment :
test byte [es:0017h],04h               ; is control key down?
je .l20                                ; if not, never mind
.l10:                                  ; control pressed, so do brief delay :
test byte [es:006ch],01h               ; wait for an even jiffy
jne .l10
.l15:
test byte [es:006ch],01h               ; then wait for an odd jiffy
je .l15
.l20:
cmp byte [line],00h                    ; continuous scrolling?
jne .l22                               ; if not, skip alt-key check
test byte [es:0017h],08h               ; is alt key down?
je .l22                                ; if not, don't interrupt scroll
call flush_key_buffer                  ; pause request!  empty key buffer
mov byte [line],01h                    ; and note that this line should pause
cmp byte [screen_lines],00h
jne .l22                               ; if number of screen lines not set,
mov al,[vga_lines]
mov [screen_lines],al                  ; set screen lines to default
.l22:
pop es
.l25:
cmp byte [line],00h                    ; paging output?
je pause_maybe.quit                    ; if not, exit now

pause_maybe:                           ; CHECK WHETHER PAUSE NEEDED:
dec byte [line]                        ; decrement line count
; cmp byte [line],00h                  ; hit zero yet?
je .l0
.quit:
ret                                    ; if not, just exit
.l0:                                   ; time for a pause:
dosprint msg_pause                     ; announce it
call flush_key_buffer                  ; empty keyboard buffer
.l1:
mov ah,00h
int 16h                                ; get a keystroke
call force_uc                          ; and force it to uppercase
call unpause                           ; erase pause message
cmp al,CR                              ; enter?
je pause_cr                            ; if so, deal with it (scroll line)
cmp al,'/'                             ; slash?
je pause_slash                         ; if so, deal with it (scroll half)
cmp al,'C'                             ; C ?
je pause_c                             ; if so, deal with it (continuous)
cmp al,1bh                             ; escape ?
je pause_c                             ; if so, deal with it (continuous)
mov al,[screen_lines]                  ; otherwise, move scroll value
mov [line],al                          ; into line count
ret                                    ; and exit
pause_cr:                              ; scroll line:
inc byte [line]                        ; set line count to one
ret                                    ; and exit
pause_slash:                           ; scroll half:
mov al,[screen_lines]                  ; get normal scroll value
shr al,01h                             ; divide by two
inc al                                 ; and add one
mov [line],al                          ; save new line count
ret                                    ; and exit
pause_c:                               ; continuous:
mov byte [line],00h                    ; set for no paging
ret                                    ; and exit

unpause:                               ; ERASE PAUSE MESSAGE FROM SCREEN:
push ax                                ; save .ax
mov ah,02h                             ; dos print-a-character function
mov dl,CR                              ; carriage return
int 21h                                ; move cursor to start of line
mov dl,SPC                             ; ascii space
mov cx,004fh                           ; 79 repetitions:
.l0:
int 21h                                ; print a space
loop .l0                               ; over and over again
mov dl,CR                              ; then another carriage return
int 21h                                ; move cursor to start of line
pop ax                                 ; restore previous .ax value
ret                                    ; and exit

prompt_fix:                            ; CHECK USAGE OF /P :
mov al,[flags]
and al,0c0h                            ; supposed to change date or time
or al,[chgattr]                        ; or attributes?
cmp al,00h
jne .l1                                ; if so, accept /p
and byte [more_flags],0bfh             ; if not, ignore /p
ret
.l1:
test byte [more_flags],40h             ; was /p specified?
je error_out.quit                      ; if so, fall through to ....

error_out:                             ; FORCE STDOUT TO STDERR:
mov cx,0001h                           ; force stdout
mov bx,0002h                           ; to stderr
doscall 46h
mov byte [screen_lines],00h            ; and disable paging
and byte [flags],0fdh                  ; note that output is to the screen
.quit:
ret

fix_paging:                            ; CHECK FOR OUTPUT REDIRECTION :
mov bx,0001h                           ; standard output handle
doscall 4400h                          ; ioctl get handle info
and dl,82h
cmp dl,82h                             ; is this the console device?
je .l0
mov byte [screen_lines],00h            ; if not, disable paging
or byte [flags],02h                    ; and note stdout was redirected
.l0:
mov al,[screen_lines]                  ; use paging value
mov [line],al                          ; to initialize lines count
ret                                    ; and exit

bombs_away:                            ; HANDLE PARSE ERRORS:
call error_out                         ; reset output to console
dosprint msg_err_begin                 ; print start of error message
pop di
mov dx,[di]                            ; get pointer to error message
doscall 09h                            ; print error message
dosprint msg_crlf
mov al,[di+02]                         ; get errorlevel
doscall 4ch                            ; and exit program
int 20h

hook_int_24:                           ; INTERCEPT CRITICAL-ERROR HANDLING :
test byte [blue_flags],80h
jne .l1
mov dx,new_int_24
doscall 2524h
.l1:
ret

new_int_24:
mov al,03h
iret


msg_markver:                           ; for mark aitchison's version utility
db 'VeRsIoN=1.08d',00h
db 'CoPyRiGhT=Copyright 1996-2003, Charles Dye',00h

msg_syntax:
db CR,LF
db 'TOUCH.COM   v1.08d   2003-10-05   C. Dye   raster@highfiber.com',CR,LF
db 'GPL Freeware.  Copyright 1996-2003, Charles Dye.  No warranty!',CR,LF
db LF
db 'TOUCH [filespecs] [options]',CR,LF
db LF
db "   /D:date  set to specific date     /D  set to today's date",CR,LF
db '   /T:time  set to specific time     /T  set to current time',CR,LF
db '   /C=file  copy stamps from file',CR,LF
db '   /A:attr  change file attributes',CR,LF
db '   /P  offer yes/no prompt           /F:x  set date format',CR,LF
db '   /S  recurse into subdirectories   /M    page output',CR,LF
db LF
db 'Unless you use /D /T /C or /A, no changes will be made!',CR,LF
db 'Try /D? /T? /C? /A? /F? or /M? for more info.',CR,LF
db '$'

msg_gpl:
db CR,LF
db 'This program may be freely distributed under the terms of the Free',CR,LF
db "Software Foundation's GNU General Public License, version 2; or, at",CR,LF
db 'your option, any later version of that License.  See the file COPYING',CR,LF
db 'for details.'

msg_crlf:
db CR,LF,'$'

switches:
db 'DTCSPQAWFRMEH12?',00

switch_routines:
dw switch_d, switch_t, switch_c, switch_s, switch_p, switch_p, switch_a
dw switch_w, switch_f, switch_r, switch_m, switch_e, switch_h, switch_12
dw switch_24, switch_query


months_table:                          ; number of days in each month
db 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31

dow_names:
db 'Sun$Mon$Tue$Wed$Thu$Fri$Sat$---$'

msg_err_begin:
db CR,LF,'Error:  $'

msg_err_dos_bad:
db 'Requires DOS version 3 or better!$'

msg_trs_80:
db 'Not enough memory!$'

msg_err_fn_ovf:
db 'Filespec too long!$'

msg_err_in_filespec:
db 'In filespec!$'

msg_err_specs_galore:
db 'More than 31 filespecs on command line!$'

msg_err_user_date:
db CR,LF,'Error:  Illegal value in user date!  $'

msg_err_user_time:
db 'Illegal value in user time!  $'

msg_err_dots_fix:
db 'Resolving dots in directory name!$'

msg_err_d_cd:
db '/D conflicts with /C date!$'

msg_err_t_ct:
db '/T conflicts with /C time!$'

msg_err_cd_cd:
db 'More than one /C date file specified!$'

msg_err_ct_ct:
db 'More than one /C time file specified!$'

msg_err_temp_open:
db 'Unable to open template file $'

msg_err_listfile:
db 'Unable to open file list:  $'

msg_err_read_list:
db 'Problem reading from file list!$'

msg_err_fnbuf_over:
db 'Spammed working buffer!$'

msg_tree_buffer_over:
db 'Tree buffer overflow!  Too many subdirectories.$'

msg_err_list_spam:
db 'Filespec too long in file list!  Closing file list.',CR,LF,'$'

msg_err_nambuf_over:
db 'Filename longer than 12 characters!$'

msg_err_sw_d:
db CR,LF
db 'TOUCH /D  -- change date stamps',CR,LF
db LF
db "/D        set files to today's date",CR,LF
db '/D:date   set files to specific date',CR,LF
db '/D:N      set files to the null date stamp',CR,LF
db LF
db 'Date stamps will NOT be changed unless you use /D or /C.  You can force',CR,LF
db 'a specific date format by using /F.',CR,LF
db '$'

msg_err_sw_t:
db CR,LF
db 'TOUCH /T  -- change time stamps',CR,LF
db LF
db '/T        set files to the current time',CR,LF
db '/T:time   set files to a specific time',CR,LF
db LF
db 'You may use 12- or 24-hour format; minutes and seconds are optional, and',CR,LF
db 'you may use a colon, period, or comma as the time separator.  You may',CR,LF
db 'append an AM or PM suffix ONLY if the hour is between 1 and 12.  You may',CR,LF
db 'express midnight as 00:00 or 12:00 AM, but not as 24:00.',CR,LF
db LF
db 'Time stamps will NOT be changed unless you use /T or /C.',CR,LF
db '$'

msg_err_sw_c:
db CR,LF
db 'TOUCH  /C=filename  -- copy date and time from file',CR,LF
db 'TOUCH /CD=filename  -- copy date stamp from file',CR,LF
db 'TOUCH /CT=filename  -- copy time stamp from file',CR,LF
db 'TOUCH /CA=filename  -- copy attributes from file',CR,LF
db LF
db 'The template filename may be any legal DOS filename, possibly including',CR,LF
db 'a drive and path.  You may use slashes as path separators, and you can',CR,LF
db 'enclose the filespec in quotes to "trap" troublesome characters.  If you',CR,LF
db 'use wildcards, the first matching file will be used.',CR,LF
db LF
db '$'

msg_err_sw_a:
db CR,LF
db 'TOUCH /A:change  -- change file attributes',CR,LF
db LF
db 'Use a plus sign followed by attribute letters to set the attributes, or',CR,LF
db 'a minus sign followed by letters to clear attributes.  Valid letters are',CR,LF
db 'A for "Archive needed", S for "System file", H for "Hidden", and R for',CR,LF
db '"Read-only".  You may not use spaces in the change string.  Any attributes',CR,LF
db 'you do not specify in the change string will not be altered.',CR,LF
db LF
db 'Attributes will NOT be changed unless you use /A or /CA.',CR,LF
db '$'

msg_err_sw_f:
db CR,LF
db 'TOUCH /F:x  -- format for date entry and display',CR,LF
db LF
db '/F:U  United States format:  MM-DD-YYYY or MM-DD',CR,LF
db '/F:E  European date format:  DD-MM-YYYY or DD-MM',CR,LF
db '/F:J  Japanese date format:  YYYY-MM-DD or MM-DD',CR,LF
db '/F:I  ISO date format and 24-hour time',CR,LF
db LF
db 'If you do not specify /F=x, TOUCH will use the local date format',CR,LF
db 'set by the COUNTRY= directive in your CONFIG.SYS file.',CR,LF
db '$'

msg_err_sw_m:
db CR,LF
db 'TOUCH /M:x  -- select lines per page (More)',CR,LF
db LF
db 'Sets the number of lines to print to the screen before pausing.',CR,LF
db 'Use 0 to disable screen pausing.  The value (x) is optional.  Screen',CR,LF
db 'pausing will always be disabled if /P is specified, or if output',CR,LF
db 'is redirected.',CR,LF
db '$'

msg_syntax_reminder:
db '   (Type TOUCH /? if you need syntax info)$'

msg_err_dupe:
db 'More than one option /'
msg_err_dupe1:
db '# -- you must be trying to confuse me!$'

msg_month_eq:
db 'Month = $'
msg_day_eq:
db 'Day = $'
msg_year_eq:
db 'Year = $'

msg_hour_eq:
db 'Hour = $'
msg_minute_eq:
db 'Minute = $'
msg_second_eq:
db 'Second = $'

msg_notice:
db 'Notice:  $'

attributes:
db 'ASHR',00h

attrib_values:
db attr_a,attr_s,attr_h,attr_r

msg_date_format:
db CR,LF,'The local date format is $'

msg_date_fmt_0:
db 'MM-DD-YYYY',00h

msg_date_fmt_1:
db 'DD-MM-YYYY',00h

msg_date_fmt_2:
db 'YYYY-MM-DD',00h

msg_date_fmt_done:
db '; you may omit the year.',CR,LF,'$'

msg_info_ampm:
db ' am$'

msg_date_none:
db '  (none)'

msg_info_space:
db '  $'

attr1:
db 'ASHR'

msg_attrib:
db '    [----]  $'

msg_bytes:
db ' bytes$'

msg_num_found:
db 'Files found: $'

msg_num_touched:
db '; touched: $'

msg_in_dir:
db ' in $'

msg_total_found:
db 'Total found: $'

msg_arrow:
db '  -->  $'

msg_query:
db ' [Yes No All Quit] $'

msg_touch_problem:
db '  DOS error $'

msg_touch_prob_2:
db ' dec on $'

msg_clrmod:
db '"clear"$'

msg_open:
db '"open"$'

msg_touch:
db '"touch"$'

msg_close:
db '"close"$'

msg_fixmod:
db '"fix_attr"$'

msg_pause:
db ' -- MORE --  <space> page, <enter> line, </> half page, <C> continuous $'

star_dot_star:
db '*.*',00h


; -------------------------------------- BYTE LENGTH VARIABLES:

flags:                                 ; bit 7 = change date        /D
db 00h                                 ; bit 6 = change time        /T
                                       ; bit 5 = template date      /C /CD
                                       ; bit 4 = template time      /C /CT
                                       ; bit 3 = subdirectories     /S
                                       ; bit 2 = use file list      @filename
                                       ; bit 1 = stdout is redirected
                                       ; bit 0 = parsing between quotes

more_flags:                            ; bit 7 = never add .*       /E
db 00h                                 ; bit 6 = prompt user        /P /Q
                                       ; bit 5 = user-specified date stamp
                                       ; bit 4 = user-specified time stamp
                                       ; bit 3 = user's date includes year
                                       ; bit 2 = change anything at all?
                                       ; bit 1 = weird values       /W
                                       ; bit 0 = user date fmt      /F

blue_flags:                            ; bit 7 = don't hook int 24  /H
db 00h

chgattr:                               ; which attributes to change?
db 00h

newattr:                               ; new attributes
db 00h

vga_lines:                             ; default number of lines to scroll
db 17h

screen_lines:                          ; lines to print between pauses
db 00h

line:                                  ; lines remaining before next pause
db 00h

align 2 ; ------------------------------ WORD LENGTH VARIABLES:

auxhandle:                             ; handle for file list, template file
dw 0000h

tree_seg:                              ; segment address of tree buffer
dw 0000h

list_seg:                              ; segment address of list buffer
dw 0000h

last_bs:                               ; offset of final backslash in fnbuf
dw 0000h

list_pnt:                              ; pointer into file list buffer
dw 0000h

pointer_pointer:                       ; pointer into list of filespec
dw 0000h                               ; pointers

tfn_attr:                              ; legal attributes for template file
dw 0000h

date1:                                 ; first  number in user-specified date
dw 0000h                               ;    (month in u.s. format)
date2:                                 ; second number in user-specified date
dw 0000h                               ;    (day in u.s. format)
date3:                                 ; third  number in user-specified date
dw 0000h                               ;    (year in u.s. format)

;  Month, day, and year may be read into different variables depending on the
;  COUNTRY= setting in CONFIG.SYS.  If so, the eval_user_stamps routine will
;  rearrange these variables into United States order before converting to
;  DOS directory date-stamp format.

user_hour:                             ; user-specified  hour  for /t
dw 0000h
user_minute:                           ; user-specified minute for /t
dw 0000h
user_second:                           ; user-specified second for /t
dw 0000h

found_lo:                              ; number of files found in current
dw 0000h                               ; directory:
found_hi:                              ; low word / high word
dw 0000h

touch_lo:                              ; number of files changed in current
dw 0000h                               ; directory:
touch_hi:                              ; low word / high word
dw 0000h

total_found_lo:                        ; total number of files found so far:
dw 0000h                               ; low word / high word
total_found_hi:
dw 0000h

total_touch_lo:                        ; total number of files changed:
dw 0000h                               ; low word / high word
total_touch_hi:
dw 0000h


nambuf:                                          ; holds the short filename
                                                 ; (no path)

filespec_pointers  equ  nambuf + 000eh           ; room for 32 pointers
                                                 ; (31 valid plus final null)

fnbuf     equ  filespec_pointers + 0040h         ; filespec of files to touch
                                                 ; or of file list

tfbuf     equ  fnbuf + fn_max                    ; filespec of template file

last_dir_shown   equ  tfbuf + fn_max             ; last directory name shown

dta       equ  last_dir_shown + fn_max           ; disk transfer area:
dta_attr  equ  dta + 0015h                       ; attribute of found file
dta_time  equ  dta + 0016h                       ; time stamp of found file
dta_date  equ  dta + 0018h                       ; date stamp of found file
dta_size  equ  dta + 001ah                       ; size of found file
dta_name  equ  dta + 001eh                       ; name of found file

stack1       equ  dta - $$ + 0100h
stack_start  equ  (stack1 * 10h + 0fh) / 10h     ; stack starts on paragraph
stack_end    equ  stack_start + 0800h            ; stack is about 2k long

;
;   Errorlevels:
;   00   All's well
;   16   General syntax, buffer overflow
;   17   Not enough memory
;   18   Problem with template file
;   19   Problem with list file
;   20   Internal buffer overflow
;   21   Error resolving directory name
;   22   Tree buffer overflow
;   23   Bad DOS version
;
;
;   Version log:
;
;   1.00   1996-09-28
;          First public release.
;   1.00a  1996-10-16
;          Purely cosmetic update:  displays my new email address.  No
;          functional changes at all.
;   1.00b  1996-10-20
;          Makes TOUCH less inimical to UNC filespecs.
;   1.00c  1996-10-27
;          During a continuous scroll, you may now press a key to pause
;          the display.  ESC now works the same as C, to force continuous
;          scrolling (i.e., to disable pausing.)
;   1.00d  1996-11-11
;          Minor changes to syntax display.  If no switches /D /T /C or /A
;          are specified, a 'reminder' message is displayed.
;   1.00e  1996-12-31
;          Fix for a trivial bug:  commas will now appear in numbers greater
;          than 999.
;
;   1.01   1997-03-09
;          Changes to /C -- /CD copies only the date.  /CT copies only the
;          time.  /C still copies both date and time, but /C is now illegal
;   with either /D or /T.  /CA copies attributes.  /K provides a slightly
;   different display, with days of the week instead of attributes.
;   Date checking is more thorough now; February 30 is an invalid date, and
;   February 29 is only valid for leap years -- /W suppresses these checks.
;   Years above 2099 are now considered illegal (outside DOS's date range;
;   I guess Microsoft didn't want to deal with the intricacies of the
;   Gregorian calendar) -- again, /W disables this restriction.
;
;   1.01a  1997-04-24
;          Fixes bug in day-of-week code.  1980 was a leap year, darnit!
;   1.01b  1997-05-07
;          Only ESC key permitted to pause continuous scrolling.
;
;   1.02   1997-05-11
;          Makes the /K day-of-week display the default, unless /A or /CA
;          is specified.
;   1.02a  1997-06-14
;          When /M is used with no value, the default scroll length will now
;          be the number of screen lines minus 2 -- not always 23.
;
;   1.03   1997-08-25
;          Several cosmetic changes to make TOUCH's output more readable and
;          more like some of my other programs.  Filenames are now indented
;          two spaces.  The single and double bars are gone, and so are the
;   'using-filespec' messages.  Attributes are no longer displayed, and /K
;   now does nothing.  The same directory name will not be displayed twice
;   running, which makes multiple filespecs in the same directory look
;   neater.  Also, the test for output redirection is now done correctly
;   (using IOCTL instead of peeking the PSP.)
;
;   1.04   1997-10-31
;          The template filespec for /C /CD /CT or /CA may contain wildcards,
;          or may name a directory.  If wildcards are used, the first
;          matching file will be used.  Wildcard template filespecs will not
;   match subdirectory names.  Also, if none of the 'change' switches /D /T
;   /C or /A is used, TOUCH will use the empty space on the right of the
;   screen to display file attributes and sizes:  a simple DIR replacement.
;
;   1.05   1998-08-19   9,800 bytes
;          Miscellaneous tweaks for FreeDOS compatibility.  Null is now a
;          legal end-of-line character, along with CR.  Removes any duplicate
;   backslashes from filespec.  Now works on 8086 and 8088-based systems.
;   Fixed a possible problem when an empty subdir was specified under DOS-C.
;   Moved the filespec buffers out to the uninitialized data area.  Added
;   version strings for Mark Aitchison's VERSION.EXE utility.  I have also
;   stopped compressing the executable, as it makes the version string
;   unintelligible to VERSION.EXE.
;
;   1.06   1999-01-31   9,880 bytes
;          Minor changes to the handling of the null date stamp.  It is now
;          displayed as (none) instead of 0-00-1980.  It can now be set with
;   /D:N -- easier than /D:0-0-80 /W.  Also, two changes to scrolling.  The
;   key to pause a continuous scroll is now Alt instead of Esc.  This change
;   eliminates the annoying problem of TOUCH 'eating' characters in the
;   typeahead buffer.  Also, the Control key may now be used to slow a
;   scrolling display.
;
;   1.07   1999-03-05   9,800 bytes
;          Added an INT 25 handler to suppress "Abort, Retry, Fail" messages;
;          use new switch /H to disable it.  Bug fix:  On CD-ROM drives under
;   DR DOS, filenames would sometimes be treated as if they were directory
;   names.  (I know, why would you try to touch files on a CD-ROM anyhow?)
;   Bug fix:  Prompting (/P) did not properly disable paging (/M).  Added
;   errorlevel 23 for invalid DOS version.  General code bumming.
;
;   1.08   1999-10-04   9,450 bytes                           CA525965  5BDF
;          Changed license to GPL, and ported to NASM.  Added explicit
;          support for /? and /D? /T? /C? /A? /F? /M? -- these display syntax
;   help to stdout, which can be redirected to a file.  Added /F:I as a
;   synonym for /F:J (ISO date format.)  Added inline error handler and other
;   size optimizations.  Disallowed character device names.  Leading zeroes
;   no longer suppressed in 24-hour time display.  Tightened syntax.
;
;   1.08a  1999-12-30   9,444 bytes                           12B8B726  5EB8
;          Removed a minor undocumented feature.  A single space between the
;          user time and any AM or PM was legal.  This syntax caused problems
;   and is no longer supported.
;
;   1.08b  2000-04-14   9,438 bytes                           8509B910  78BC
;          Filespec buffers increased to 260 bytes to handle the super-long
;          pathnames permitted by Windows 95/98.
;
;   1.08c  2001-01-01   9,442 bytes                           6747B9C3  9F92
;          /C /CD /CT /CA all accept a comma in place of the equals sign
;          to allow for changes in filename completion in the latest 4DOS.
;
;   1.08d  2003-10-05   9,604 bytes                           3E440100  05A3
;          If the first number in a three-part, user-specified date is
;          1980 or greater, assume the date is in ISO format.  Also, /F:I
;          now sets the date separator to a dash and forces 24-hour time
;          format.  (/F:U /F:E /F:J do not affect the date separator or time
;          format.)  Tweaks to syntax screens.  Added undocumented /12 and
;          /24 to force times to be displayed in a particular format.


