%pagesize 72,132

; Title		: XD
; Version	: 3.0M
; Date		: Nov 29,1996
; Author	: J R Ferguson
; Language	: Intel 8086/8088 assembler
; O.S.		: MS-DOS v2.0 (.COM file)
; Assembler	: Borland Turbo Assembler, Ideal mode
;
; Description in file XD.DOC
;
; Uses FEXPAND.ASM
; To assemble and link the following files are no ded
;   TASM.ASM	Main program source
;   FEXPAND.ASM	File expand routine
;   TASM.EXE	Borland Turbo Assembler
;   TLINK.EXE	Borland Turbo Linker
; Use the following commands:
;   TASM XD
;   TASM FEXPAND
;   TLINK /T XD FEXPAND

	.sall
	ideal
	dosseg
	%trunc
	
model	tiny

false	=	0
true	=	not false

;---------------------------------------------------------------------------
; PROGRAM SETTINGS
;---------------------------------------------------------------------------

DEBUG	=	true	;debug version
ENDWAIT	=	false	;wait for keypress before exit (with /W option)

maxcol	=	4	;max number of display columns
maxlin	=	24	;max number of lines per page
maxprm	=	4	;max number of questions per line
stksiz	=	256	;stack size in byte

%subttl "Constants"
%newpage
;---------------------------------------------------------------------------
; CONSTANTS
;---------------------------------------------------------------------------

;DOS interrupt 21h functions
conout	=	02h	;console output character
lstout	=	05h	;listing device output character
conio	=	06h	;direct console i/o
constr	=	09h	;console string output
sfsfcb	=	11h	;search first fcb
curdsk	=	19h	;get current disk number
getdate	=	2ah	;get current date
gettime	=	2ch	;get current time
getver	=	30h	;get DOS version
getfre	=	36h	;get free disk space
setdir	=	3bh	;set current directory
delete	=	41h	;delete file
getatr	=	4300h	;get file attribute
setatr	=	4301h	;set file attribute
getdir	=	47h	;get current directory
alloc	=	4ah	;re-allocate memory
endprg	=	4c00h	;end program
sfirst	=	4eh	;search first
snext	=	4fh	;search next

;Extended FCB fields
Fatr	=	06	;attribute		1 byte
Fdrn	=	07	;drive code		1 byte
Ffnm	=	08	;file name		8 byte
Fext	=	16	;extension		3 byte

;File informatie record fields after search first/next
Satr	=	21	;attribute		1 byte
Stime	=	22	;time			2 byte
Sdate	=	24	;date			2 byte
Ssize	=	26	;file size		4 byte
Sfsp	=	30	;ASCIIZ filename.ext	13 byte
Srcsiz	=	43	;size of search record

;File information record table entry offsets
Tatr	=	0	;attribute		1 byte
Ttime	=	1	;time			2 byte
Tdate	=	3	;date			2 byte
Tsize	=	5	;file size		4 byte
Tfsp	=	9	;ASCIIZ filename.ext	13 byte
Tflg	=	Tfsp	;delete flag (00h)	1 byte

entsiz	=	22	;entry size
maxfnm	=	13	;max length 'filename.ext' + 0-byte
maxfsp	=	80	;max length fully expanded file specification


;file attribute masks
rdomsk	=	01h	;read only
hidmsk	=	02h	;hidden
sysmsk	=	04h	;system file
volmsk	=	08h	;volume label
dirmsk	=	10h	;directory
arcmsk	=	20h	;archive flag

;character codes
bel	=	07h
tab	=	09h
lf	=	0ah
ff	=	0ch
cr	=	0dh
can	=	18h	;cancel (^X)
optgen	equ	'/'	;option prefix : general
optset	equ	'+'	;option prefix : set
optres	equ	'-'	;option prefix : reset
rdochr	equ	':'	;filename separator: read only
rdwchr	equ	'.'	;filename separator: read/write
colchr	equ	'|'	;column separator

%subttl "-- Macros, declarations"
%newpage
;--------------------------------------------------------------------------
; MACROS
;--------------------------------------------------------------------------

macro	CalRet	address
IF DEBUG
	call	address
	ret
ELSE
	jmp	address
ENDIF
	endm


macro	AtrOff	AtrMask,EqChr,NeChr
	mov	al,EqChr
	mov	ah,NeChr
	test	[byte ptr bp+Tatr],AtrMask
	call	outattr
	endm

macro	DecOff	Digits,Leading
	mov	bh,Digits
	mov	bl,Leading
	call	outdec
	endm

%subttl "-- Messages"
%newpage

	dataseg

;--------------------------------------------------------------------------
; MESSAGES
;--------------------------------------------------------------------------

txhelp	db	'XD v3.0M',cr
	db	'Command:  XD [filespec] [option(s)]',cr
	db	'Display options:',cr
	db	'  /?      help',cr
	db	'  /*      show hidden files',cr
	db	'  /D      show subdirectory names',cr
	db	'  /P      printer echo',cr
	db	'  /F      same, with formfeed',cr
	db	'  /1      single column display',cr
	db	'  /2      two column display',cr
	db	'  /W      wait for CR when screen is full',cr
	db	'  /E      sort on file extension',cr
	db	'  /L      sort on file length',cr
	db	'  /T      sort on timestamp',cr
	db	'Command options:',cr
	db	'  +H  -H  set/reset hidden attribute',cr
	db	'  +R  -R  set/reset read-only attribute',cr
	db	'  +S  -S  ser/reset system attribute',cr
	db	'  +A  -A  set/reset archive attribute',cr 
	db	'  /Z      zap: delete file',cr
	db	'  /Y      yes: no confirmation',0
%newpage
txroot	db	' :\'
 txwild	db	'*.*'
 txdmy	db	0

;extended fcb to get disk volume label
volfcb	db	0ffh,5 dup(0),volmsk,0,'???????????',25 dup(0);

txver	db	'XD: Need DOS version 2.0 or higher',0
txmem	db	'XD: Out of memory',0
txildr	db	'XD: Drive error',0
txfnf	db	'XD: No file(s) ',0
txisrd	db	' is +R ',0
txzap	db	' delete',0
txis	db	' is ',0
txarrow	db	' -> ',0
txmis	db	' unable',bel,0
txprmp	db	'? ynax:',0
txempty	db	'         ',0
txstop	db	cr,'XD: Aborted',0
txdir	db	'<DIR>',0
txtot	db	'Total: ',0
txfile	db	' files, ',0
txfree	db	'  Free: ',0
txpct1	db	' (',0
txpct2	db	'%)',0
txwait	db	'CR:$'

%subttl "-- Initialized buffers"
%newpage
;--------------------------------------------------------------------------
; INITIALIZED BUFFERS
;--------------------------------------------------------------------------

	;weekdays
dagtbl	db	5	;length per entry
	db	'Sun ',0
	db	'Mon ',0
	db	'Tue ',0
	db	'Wed ',0
	db	'Thu ',0
	db	'Fri ',0
	db	'Sat ',0

	;months
mndtbl	db	5	;length per entry
	db	'Jan ',0
	db	'Feb ',0
	db	'Mar ',0
	db	'Apr ',0
	db	'May ',0
	db	'Jun ',0
	db	'Jul ',0
	db	'Aug ',0
	db	'Sep ',0
	db	'Oct ',0
	db	'Nov ',0
	db	'Dec ',0

	;Options in execution order
opttbl	db	'R'	;(re)set read-only attribute
	db	'Z'	;erase file
	db	'H'	;(re)set hidden attribute
	db	'S'	;(re)set system attribute
	db	'A'	;(re)set archive attribute
cmdcnt	= this byte  - opttbl
	db	'Y'	;skip confirmation
	db	'1'	;1 column
	db	'2'	;2 column
	db	'W'	;wait when screen is full
	db	'*'	;include hidden files
	db	'D'	;include subdirectory names
	db	'P'	;printer echo
	db	'F'	;formfeed
	db	'E'	;sort on file extent
	db	'L'	;sort on file length
	db	'T'	;sort on timestamp
	db	'?'	;help option (must be last in table!)
optcnt	= this byte - opttbl

ofsrdo	=	0
ofszap	=	1
ofshid	=	2
ofssys	=	3
ofsarc	=	4
ofsyes	=	5
ofskl1	=	6
ofskl2	=	7
ofswai	=	8
ofsall	=	9
ofsdir	=	10
ofslst	=	11
ofspff	=	12
ofsext	=	13
ofslen	=	14
ofstim	=	15
ofshlp	=	16

cmdtbl	dw	cmdrdo
	dw	cmdzap
	dw	cmdhid
	dw	cmdsys
	dw	cmdarc

;powers of 10 (in 32 bit unsigned integer precision)
tentbl	dd	1000000000
	dd	100000000
	dd	10000000
	dd	1000000
	dd	100000
	dd	10000
	dd	1000
	dd	100
	dd	10
	db	1				;end-of-table marker

%subttl "-- Uninitialized buffers"
%newpage
;--------------------------------------------------------------------------
; UNINITIALIZED BUFFERS
;--------------------------------------------------------------------------

olddir	db	69 dup(?)	;current directory (ASCIIZ 'd:path')
tmpfnm	db	maxfnm dup(?)	;temp storage for ASCIIZ filename.ext
fspstr	db	maxfsp dup(?)	;ASCIIZ filespec
fspdir	dw	?		;start address directory path in fspstr
fspfnm	dw	?		;start address filename.ext in fspstr
fspend	dw	?		;address end-of-string marker in fspstr
drcode	db	?		;drive code (A=0, B=1, etc.) 
digbuf	db	10 dup(?)	;digit buffer for decimal display
denom	dw	2  dup(?)	;denominator in devision routine outdec
optchr	db	?		;option prefix character
cmdflg	db	?		;command option flag
optstr	db	optcnt dup(?)	;options
yesopt	db	?		;process all files
atrmsk	db	?		;file attribute mask
fcount	dw	?		;aantal files
totbyt	dw	2 dup(?)	;total number of bytes
frebyt	dw	2 dup(?)	;free disk space in bytes
frepct	dw	?		;free disk space percentage
bufpt1	dw	?		;buffer pointer
bufpt2	dw	?		;sort pointer
endpnt	dw	?		;buffer end pointer
minpnt	dw	?		;minimum pointer
filcnt	dw	?		;file count
lintot	dw	?		;total number of lines
lincnt	dw	?		;number of lines left to process
curlin	db	?		;current display row
column	db	?		;column number
dirkol	db	?		;number of display columns
vrgkol	db	?		;number of prompt columns
label	firtbl	byte		;file information record table, up to stack

%subttl "-- Main program"
%newpage
;--------------------------------------------------------------------------
; MAIN PROGRAM
;--------------------------------------------------------------------------

	codeseg
	assume	cs:@code, ds:@code, es:@code, ss:@code

	extrn	FExpand:near

;
; program segment prefix
;

	org	0080h
label	argbuf	byte
label	dtabuf	byte

	org	0100h

;
; start of executable code
;

xd:	mov	ax,ds
	mov	es,ax

	call	init
	call	scan
	call	sort
	test	[byte ptr cmdflg],true		;command?
	jz	xd1
	call	execute				;  yes: do command
	jmp	short exit
xd1:	call	displ				;  no :	directory

exit:	mov	al,cr
	call	outchr
	test	[byte ptr optstr+ofspff],true
	jz	exit1
	mov	al,ff
	call	outlst
exit1:
IF ENDWAIT
	call	waitcr
ENDIF
	mov	ax,endprg
	int	21h

;
;error traps
;

errfnf:	mov	si,offset txfnf			;file not found
	call	outtxt
	mov	si,offset fspstr
	call	outtxt
	jmp	short exit

errhlp:	mov	si,offset txhelp		;help or command error
error:	call	outtxt				;other
	jmp	short exit

%subttl "-- Initialization"
%newpage
;--------------------------------------------------------------------------
; INITIALIZATION
;--------------------------------------------------------------------------

init:	cld					;string functions upward
	xor	ax,ax				;clear flags and counters
	mov	di,offset optstr
	mov	cx,optcnt
	rep	stosb
	mov	[cmdflg],al
	mov	[yesopt],al
	mov	[curlin],al
	mov	[fcount],ax
	mov	[totbyt+0],ax
	mov	[totbyt+2],ax
	mov	[frebyt+0],ax
	mov	[frebyt+2],ax
	mov	[byte ptr drcode],al		;default drive = current disk
	mov	ax,offset firtbl		;set end pointer
	mov	[endpnt],ax

	mov	ah,getver			;check DOS version
	int	21h
	xchg	al,ah
	cmp	ax,20h				;no d v2.0 or higher
	jae	init0
	mov	si,offset txver
	jmp	error

init0:	mov	ah,alloc			;keep 1 segment allocated
	mov	bx,1000h			;64k/16 paragraphs
	int	21h
	jnc	init1
	mov	si,offset txmem
	jmp	error

init1:	call	rdargs				;read command arguments

	test	[byte ptr optstr+ofshlp],true
	jz	init2
	jmp	errhlp
init2:	call	dstats				;read disk statistics

	test	[byte ptr optstr+ofspff],true	;formfeed?
	jz	init3
	or	[byte ptr optstr+ofslst],true	;  yes: printer echo
init3:	mov	al,1				;save column count
	mov	ch,al
	test	[byte ptr optstr+ofskl1],true
	jnz	init4
	mov	al,2
	mov	ch,maxprm
	test	[byte ptr optstr+ofskl2],true
	jnz	init4
	mov	al,maxcol
init4:	mov	[dirkol],al
	mov	[vrgkol],ch
;	calret	domsk

; get attribute mask
;
domsk:
	test	[byte ptr cmdflg],true			;show hidden files?
	jnz	domsk2

	test	[byte ptr optstr+ofsdir],true		;subdir:
	jz	domsk1
	test	[byte ptr optstr+ofsall],true		;  yes:	also hidden?
	jnz	domsk4					;	yes: all
	jmp	short domsk5				;	no : only dir
domsk1:	test	[byte ptr optstr+ofsall],true		;  no :	check hidden
	jz	domsk3

domsk2:	mov	al,rdomsk+hidmsk+sysmsk+arcmsk		;RHSvdA
	jmp	short domsk6
domsk3:	mov	al,rdomsk+sysmsk+arcmsk			;RhSvdA
	jmp	short domsk6
domsk4:	mov	al,rdomsk+hidmsk+sysmsk+dirmsk+arcmsk	;RHSvDA
	jmp	short domsk6
domsk5:	mov	al,dirmsk				;rhsvDa

domsk6:	mov	[atrmsk],al
	ret

%subttl "-- Read command arguments"
%newpage
;--------------------------------------------------------------------------
; READ COMMAND ARGUMENTS
;--------------------------------------------------------------------------

;internal register usage for routine rdargs:
;
;ch : (number of characters in parameter buffer) + 1
;bx : pointer to position of next character in parameter buffer
;

rdargs:	mov	bx,offset fspstr		;init fspstr
	mov	[byte ptr bx],0
	mov	[fspdir],bx
	mov	[fspfnm],bx
	mov	[fspend],bx

	mov	bx,offset argbuf
	mov	ch,[bx]
	inc	ch

	call	skpspa
	jz	rdarg3

	cmp	al,optgen			;1st parm is an option?
	jz	rdarg1				;  yes
	cmp	al,optset
	jz	rdarg1
	cmp	al,optres
	jz	rdarg1
	call	rdfsp				;  no :	read fsp
	jz	rdarg3

	cmp	al,optgen			;	2nd parm is an option?
	jz	rdarg1
	cmp	al,optset
	jz	rdarg1
	cmp	al,optres
	jz	rdarg1
	mov	[byte ptr optstr+ofslst],false	;	  no :	print echo off
	jmp	errhlp				;		display help

rdarg1:	mov	[optchr],al			;save option prefix
	call	rdchr				;read option character
	jz	rdarg3				;  no more options: exit

rdarg2:	call	codopt				;code option
	call	skpspa				;skip spaces
	jz	rdarg3				;  no more options: exit

	cmp	al,optgen
	jz	rdarg1				;next parameter
	cmp	al,optset
	jz	rdarg1
	cmp	al,optres
	jz	rdarg1
	jmp	short rdarg2			;next option

rdarg3:	cmp	[fspend],offset fspstr		;fsp specified?
	jnz	rdarg4
	mov	bx,offset txdmy			;  no : expand empty string
	mov	ch,1
	mov	al,0
	call	rdfsp
rdarg4:	mov	si,offset fspstr		;get drive code
	cmp	si,[fspdir]
	jz	rdarg5
	lodsb
	sub	al,'A'-1
	mov	[byte ptr drcode],al
rdarg5:	mov	di,[fspend]			;filename.ext specified?
	cmp	di,[fspfnm]
	jz	rdarg6				;  no : add '*.*'
	call	isdir				;fsp is directory?
	jz	rdarg7
	mov	al,'\'				;  yes: add '\*.*'
	stosb
	mov	[fspfnm],di
rdarg6:	mov	si,offset txwild
	call	strcpy
	dec	di
	mov	[fspend],di
rdarg7:	ret


;check if fspstr is a (sub)directory
; out:	flags	cond nz = yes, fspstr is a directory
;
isdir:	mov	dx,offset fspstr		;get file attribute
	mov	ax,getatr
	int	21h
	jnc	isdir1				;succes?
	xor	cx,cx				;  no :	return z
isdir1:	and	cx,dirmsk			;  yes:	return attr and dirmsk
	ret


rdfsp:	mov	si,bx				;si= start address fsp inp
rdfsp1:	cmp	al,cr				;locate end of fsp inp
	je	rdfsp2
	cmp	al,' '
	je	rdfsp2
	cmp	al,0
	je	rdfsp2
	call	rdchr
	jmp	short rdfsp1
rdfsp2:	mov	[byte ptr bx],0			;add end-of-string marker
	mov	di,offset fspstr		;di= start address fsp out
	call	FExpand				;expand fsp inp to fsp out

	mov	si,di				;scan expanded fsp
rdfsp3:	lodsb
	and	al,al
	jz	rdfsp6
	cmp	al,':'				;':'?
	jnz	rdfsp4
	mov	[fspdir],si			;  yes:	begin dirpath
	mov	[fspfnm],si
rdfsp4:	cmp	al,'\'				;'\'?
	jnz	rdfsp5
	mov	[fspfnm],si			;  yes:	begin filename
rdfsp5:	jmp	short rdfsp3			;read next character

rdfsp6:	dec	si
	mov	[fspend],si			;save end address

	and	ch,ch				;check for end of command
	jz	rdfsp7
	call	skpspa
rdfsp7:	ret

%newpage

;
;skip spaces
;out:	flags	cond z  : no more parameters
;		cond nz : parameter found
;	al	current character, if a parameter was found
;
skpspa:	call	rdchr
	jz	skpsp1
	cmp	al,' '
	jz	skpspa
skpsp1:	ret


;
; read next character from buffer
;
; out	flags	cond z	: no more characters
;	al	character (if present)
;
rdchr:	inc	bx
	mov	al,[bx]
	call	upcase
	dec	ch
	ret

%newpage
;
;code option
;error exit if not found in table
;
;in	al		option character from command line
codopt:	push	cx

	mov	di,offset opttbl
	mov	cx,optcnt
	repne	scasb				;help if not in table
	dec	di
	sub	di,offset opttbl
	cmp	di,cmdcnt
	jnb	codop1
	mov	[byte ptr cmdflg],true
codop1:	add	di,offset optstr
	mov	al,[optchr]
	stosb

	pop	cx
	ret

;
;convert ASCII character in al register to upper case
;
upcase:	and	al,7fh				;clear parity
	cmp	al,'a'
	jc	upcas1
	cmp	al,'z'+1
	jnc	upcas1
	sub	al,'a'-'A'
upcas1:	ret

%subttl "-- Read disk statistics"
%newpage
;--------------------------------------------------------------------------
; READ DISK STATISTICS
;--------------------------------------------------------------------------

dstats:	mov	dl,[drcode]
	mov	ah,getfre			;get free disk space
	int	21h
	cmp	ax,-1
	jnz	dstat1
	mov	si,offset txildr
	jmp	error

	;ax = sectors per cluster
	;cx = bytes per sector
	;bx = number of free clusters
	;dx = total number of clusters	 

dstat1:	mov	di,dx				;save total numer of clusters
	mul	bx				;number of free sectors
dstat2:	add	[frebyt+0],ax			;multiply by bytes/sector
	adc	[frebyt+2],dx			;= number of bytes available
	loop	dstat2
	mov	ax,bx				;number of free clusters
	mov	bx,100				;* 100
	mul	bx
	div	di				;/ total number of clusters
	mov	[frepct],ax			;= percentage free on disk
	ret

%subttl "-- Scan directory"
%newpage
;--------------------------------------------------------------------------
; SCAN DIRECTORY
;--------------------------------------------------------------------------

scan:	mov	cl,[atrmsk]
	mov	ch,0
	mov	dx,offset fspstr
	mov	ah,sfirst		;search first
	int	21h
	jc	scan2
scan1:	call	includ
	mov	ah,snext		;search next
	int	21h
	jnc	scan1

scan2:	ret


;include entry in table
;
;in	[dtabuf]	file info record search first/next
;
includ:	mov	si,offset dtabuf

	cmp	[byte ptr si+Sfsp],'.'			;skip '.' and '..'
	je	incl3

	mov	al,[atrmsk]				;show dir only?
	cmp	al,dirmsk
	je	incl1
	cmp	[byte ptr si+Satr],0			;  no :	include attr=0
	je	incl2

incl1:	mov	al,[si+Satr]				;check attribute
	and	al,[atrmsk]
	jz	incl3

incl2:	mov	ax,[si+Ssize+0]
	add	[totbyt+0],ax
	mov	ax,[si+Ssize+2]
	adc	[totbyt+2],ax
	add	si,Satr
	mov	di,[endpnt]
	mov	cx,entsiz
	rep	movsb
	mov	[endpnt],di
	inc	[word ptr fcount]

incl3:	ret

%subttl "-- Sort table"
%newpage
;--------------------------------------------------------------------------
; SORT TABEL
;--------------------------------------------------------------------------

;Selection sort of entries with size entsiz each, from firtbl .. [endpnt]-1
;
; register usage:	
;	bx	current pointer
;	dx	pointer to smallest entry
;
sort:
	cmp	[word ptr fcount],0
	je	sort3

	mov	bx,offset firtbl
sort1:	call	select
	cmp	bx,dx
	jz	sort2
	call	exchng
sort2:	add	bx,entsiz
	cmp	bx,[endpnt]
	jb	sort1
sort3:	ret


;select smallest entry from [bx]..[endpnt]
;store a pointer to this entry in dx
;
;register usage:
;	ax	current pointer
;	dx	pointer to smallest entry
;
select:	mov	ax,bx
	mov	dx,bx
	jmp	short selec2
selec1:	call	compare
	jnc	selec2
	mov	dx,ax
selec2: add	ax,entsiz
	cmp	ax,[endpnt]
	jb	selec1
	ret

%newpage
;Compare filespec of entry [ax] with filespec of entry [dx]
;
;out	carry condition if [ax.key] < [dx.key]
compare:
	test	[byte ptr optstr+ofsext],true
	jnz	cmpext
	test	[byte ptr optstr+ofslen],true
	jnz	cmplen
	test	[byte ptr optstr+ofstim],true
	jnz	cmptim
	jmp	short cmpfnm

cmpext:	mov	si,dx
	call	fndext
	mov	di,si
	mov	si,ax
	call	fndext
	push	ax
cmpex1:	mov	al,[si]
	cmp	al,[di]
	jne	cmpex2
	inc	si
	inc	di
	and	al,al
	jnz	cmpex1

cmpex2:	pop	ax
	jne	cmpx
	jmp	short cmpfnm

fndext:	push	ax
	add	si,Tfsp
fndex1:	lodsb
	cmp	al,'.'
	jz	fndex2
	and	al,al
	jnz	fndex1
	dec	si
fndex2:	pop	ax
	ret

cmplen:	mov	si,ax
	add	si,Tsize+2
	mov	di,dx
	add	di,Tsize+2
	mov	cx,2
	std
	repe	cmpsw
	cld
	jne	cmpx
	jmp	short cmpfnm

cmptim:	mov	si,ax				;compare timestamp
	add	si,Tdate
	mov	di,dx
	add	di,Tdate
	mov	cx,2
	std
	repe	cmpsw
	cld
	jne	cmpx
;	jmp	short cmpfnm

cmpfnm:	mov	si,ax				;compare filename.ext
	add	si,Tfsp
	mov	di,dx
	add	di,Tfsp
	mov	cx,maxfnm
	repe	cmpsb
cmpx:	ret


;exchange entries [bx] and [dx]
;use dtabuf for temporary storage
;
exchng:	mov	ax,entsiz

	mov	si,bx
	mov	di,offset dtabuf
	mov	cx,ax
	rep	movsb

	mov	si,dx
	mov	di,bx
	mov	cx,ax
	rep	movsb

	mov	si,offset dtabuf
	mov	di,dx
	mov	cx,ax
	rep	movsb

	ret

%subttl "-- Execute command"
%newpage
;--------------------------------------------------------------------------
; EXECUTE COMMAND
;--------------------------------------------------------------------------

; register usage:	bp	near pointer to file info table entry
;
execute:
	cmp	[fcount],0
	jnz	exec1
	jmp	errfnf

exec1:	mov	si,offset fspstr
	call	outtxt
	mov	al,cr
	call	outchr

	mov	bp,offset firtbl
	mov	bx,[fcount]
	mov	[filcnt],bx

exec2:	mov	si,bp				;copy filename.ext
	add	si,Tfsp
	mov	di,[fspfnm]
	call	strcpy

	mov	si,[fspfnm]
	call	outfnm
	sub	al,al
	mov	[column],al			;prompt counter = 0
	mov	cl,al				;table index	= 0

	mov	ch,cmdcnt			;command counter
	mov	si,offset optstr		;command option pointer
exec3:	test	[byte ptr si],true
	jz	exec4
	call	docmd				;execute command
exec4:	cmp	[byte ptr bp+Tflg],0		;file deleted?
	je	exec5				;  yes:	skip entry
	inc	cl				;  no :	++index
	inc	si				;	next command
	dec	ch
	jnz	exec3

exec5:	mov	al,cr
	call	outchr
	add	bp,entsiz			;next file
	dec	[word ptr filcnt]
	jnz	exec2
	ret

%newpage
docmd:	push	cx
	push	si
	mov	bx,offset column
	inc	[byte ptr bx]
	mov	al,[vrgkol]
	cmp	al,[bx]
	jnc	docmd2

	mov	[byte ptr bx],1
	mov	al,cr				;next prompt on a new line
	call	outchr
	mov	ch,maxfnm-1			;beyond file specification
	mov	al,' '
docmd1:	call	outchr
	dec	ch
	jnz	docmd1

docmd2:	mov	bx,offset opttbl
	add	bl,cl
	adc	bh,0
	mov	si,bx
	mov	bx,offset cmdtbl
	call	gettbl				;bx= start address command
						;si= address option character
	call	bx
	pop	si
	pop	cx
	ret

%newpage
;
;bx <- [bx+2*cl]
;
gettbl:	push	cx
	sub	ch,ch				;cx <- 2*cl
	shl	cx,1
	add	bx,cx
	mov	cx,[bx]
	mov	bx,cx
	pop	cx
	ret

; in 	si= address option character
;
cmdhid:	mov	cl,hidmsk
	cmp	[byte ptr optstr+ofshid],optres
	jmp	short cmd
cmdrdo:	mov	cl,rdomsk
	cmp	[byte ptr optstr+ofsrdo],optres
	jmp	short cmd
cmdsys:	mov	cl,sysmsk
	cmp	[byte ptr optstr+ofssys],optres
	jmp	short cmd
cmdarc:	mov	cl,arcmsk
	cmp	[byte ptr optstr+ofsarc],optres
;	jmp	short cmd

cmd:	mov	ch,false
	je	cmd1
	mov	ch,true
cmd1:	and	ch,cl				;cl= bit mask file attribute
						;ch= bit value file attribute
	call	chkatr
	jz	cmdret				;already has the attribute
	mov	bx,offset txarrow
	call	outopt
	call	oktogo				;ask confirmation
	jz	cmdret				;  not allowed: skip
	not	cl				;invert attribute mask
	and	cl,27h				;mask reserved bits
	and	cl,[byte ptr bp+Tatr]		;remaining attributes unchanged
	or	cl,ch				;set/reset attributes
	mov	[byte ptr bp+Tatr],cl		;save new attribute
	xor	ch,ch				;cx = new attribute
	mov	dx,offset fspstr
	mov	ax,setatr			;set file attribute
	int	21h
	jnc	cmdret
	mov	si,offset txmis
	jmp	error
cmdret:	ret

cmdzap:	call	abort				;test abort key
	test	[byte ptr bp+Tatr],rdomsk	;read-only?
	jz	cmdza1
	mov	si,offset txisrd		;  yes: say so
	call	outtxt
	mov	si,offset txempty
	call	outtxt
	jmp	short cmdza2

cmdza1:	mov	si,offset txzap			;  no : prompt for deletion
	call	outtxt
	call	oktogo				;	ask confirmation
	jz	cmdza2				;	no permission: skip
	mov	[byte ptr bp+Tflg],0		;	mark entry as deleted
	mov	dx,offset fspstr		;	delete file
	mov	ah,delete
	int	21h
	jnc	cmdza2
	jmp	errfnf				;	disk may be removed
cmdza2:	ret

%newpage

;check attribute
;in:	bp	near pointer to file information table entry
;	cl	bit mask file attribute
;	ch	bit value file attribute
;	si	address option character
;
;out:	flags	cond z : already has the attribute
;
chkatr:	push	cx
	and	cl,[bp+Tatr]
	cmp	cl,ch
	jnz	chkat1				;attribute is different

	mov	bx,offset txis			;attribute is the same
	call	outopt
	mov	si,offset txempty
	call	outtxt
	xor	al,al				;return z
chkat1:	pop	cx
	ret

;ask confirmation (ok to go?)
;
;out:	flags	cond z: permission denied
;
oktogo:	test	[byte ptr optstr+ofsyes],true
	jz	oktog0
	mov	si,offset txempty		;process all: no more questions
	jmp	outtxt				;  (call & return)
oktog0:	mov	si,offset txprmp		;vraag j/n/a/x
	call	outtxt
oktog1:	call	inchr
	cmp	al,'X'				;'X': exit
	jz	oktog4
	cmp	al,'N'				;'N': skip this entry
	jz	oktog3
	cmp	al,'Y'				;'Y': execute command
	jz	oktog2
	cmp	al,'A'
	jnz	oktog1
	or	[byte ptr optstr+ofsyes],true	;'A': set 'all' flag
oktog2:	cmp	al,'N'				;'Y' and 'A' : reset z-flag
oktog3:	call	outchr				;echo
	mov	al,' '
	CalRet	outchr

oktog4:	call	outchr				;echo 'X'
	mov	si,offset txstop
	jmp	error

;display option prompt
;
;in:	bx	address text prefix (' -> ' or ' is ')
;	si	address option character
;
outopt:	push	si
	mov	si,bx
	call	outtxt
	pop	si
	mov	bx,si
	sub	bx,offset opttbl
	add	bx,offset optstr
	mov	al,[bx]
	cmp	al,'/'
	jnz	outop1
	mov	al,'+'
outop1:	call	outchr
	mov	al,[si]
	call	outchr
	mov	al,' '
	CalRet	outchr

%subttl "-- Display"
%newpage
;--------------------------------------------------------------------------
; DISPLAY
;--------------------------------------------------------------------------
;
displ:	mov	[byte ptr curlin],0
	call	outhdr

	mov	bx,[fcount]			;compute numer of lines
	dec	bx
	js	displ7
	mov	dl,[dirkol]			;number of display columns
	sub	dh,dh
	sub	cx,cx
displ1:	inc	cx
	sub	bx,dx
	jnc	displ1

	mov	[lintot],cx			;total number of display lines
	mov	[lincnt],cx			;display line counter
	mov	[byte ptr column],0		;current column
	mov	[word ptr bufpt1],offset firtbl	;entry to display
	mov	[word ptr bufpt2],offset firtbl	;first entry on current line

displ2:	mov	ax,[bufpt1]			;end of buffer?
	cmp	ax,[endpnt]
	jb	displ4

displ3:	mov	al,cr				;  yes:	next line
	call	outchr
	dec	[word ptr lincnt]		;	or done
	jz	displ7

	add	[bufpt2],entsiz
	mov	ax,[bufpt2]
	mov	[bufpt1],ax
	mov	[byte ptr column],0

displ4:	cmp	[byte ptr column],0		;column separator?
	je	displ5
	mov	al,colchr			;  yes
	call	outchr
displ5:	mov	bp,[bufpt1]			;display entry
	call	outent
	inc	[byte ptr column]
	mov	cx,[lintot]			;move pointer
displ6:	add	[word ptr bufpt1],entsiz
	loop	displ6
	jmp	short displ2			;next entry

displ7:	CalRet	outtot				;display totals

%newpage

;Display directory listing header
;
outhdr:	call	outlbl				;volume label
	mov	si,[fspdir]			;dirpath + filename.ext mask
	call	outtxt
	mov	al,' '
	call	outchr
	call	outchr
	mov	bp,offset dtabuf
	call	outdte				;date
	mov	al,','
	call	outchr
	mov	al,' '
	call	outchr
	call	outtim				;time
	mov	al,cr
	calret	outchr

;
; Display volume label
;

outlbl:	mov	al,[fspstr]			;copy drive letter
	mov	[txroot],al			;  to root dir string
	mov	di,offset olddir		;  and old dirpath buffer
	stosb
	mov	al,':'				;save current dirpath
	stosb
	mov	al,'\'
	stosb
	mov	[byte ptr di],0
	mov	dl,[drcode]
	mov	si,di
	mov	ah,getdir
	int	21h

	mov	dx,offset txroot		;set active dir path to root
	mov	ah,setdir
	int	21h

	mov	al,[drcode]			;find volume label
	mov	[volfcb+Fdrn],al
	mov	dx,offset volfcb
	mov	ah,sfsfcb
	int	21h
	and	al,al				;found?
	jnz	outlb1

	mov	al,'['				; yes: "["
	call	outchr
	mov	si,offset dtabuf+FFnm		;	volume label
	mov	[byte ptr si+11],0		;	  (make ASCIIZ)
	call	outtxt
	mov	al,']'				;	"] "
	call	outchr
	mov	al,' '
	call	outchr

outlb1:	mov	dx,offset olddir		;restore active dirpath
	mov	ah,setdir
	int	21h	

	ret

%newpage

; Display current date
;
outdte:	mov	ah,getdate
	int	21h
	push	cx				;push year
	push	dx				;push month (high) + day (low)

	mov	ah,al				;day of week
	mov	si,offset dagtbl
	call	outtbl

	pop	cx				;day of month
	push	cx				;(saver month number)
	sub	ch,ch
	sub	dx,dx
	DecOff	2,0				;2 digits, no leading zeroes 
	mov	al,' '
	call	outchr

	pop	ax				;month name
	dec	ah
	mov	si,offset mndtbl
	call	outtbl

	pop	cx				;year
	sub	dx,dx
	DecOff	4,'0'				;4 digits, leading zeroes
	ret	

; display current time
;
outtim:	mov	ah,gettime
	int	21h
	push	cx				;save minutes (low)

	mov	cl,ch				;hours
	sub	ch,ch
	sub	dx,dx
	DecOff	2,'0'				;2 digits, leading zero

	mov	al,':'
	call	outchr

	pop	cx				;minutes
	sub	ch,ch
	sub	dx,dx
	DecOff	2,'0'				;2 digits, leading zero
	ret

; Display text from table
;
; in :	si	start address of table
;	ah	table index (0..255)
;
; table format :
; 1 byte	length text entries (including end-of-string marker)
; per entry	fixed length text plus end-of-string marker
; 
outtbl:	lodsb
	mul	ah
	add	si,ax
	call	outtxt
	ret
%newpage

;Display entry
;
;in :	bp	near pointer to file information table entry
;
;Display format		(filename:extnnnnk)sa dd-mm-jj uu:mm 
;  always:		         :				read only
;			         .				read/write
;			             nnnn			number of kbyte
;  with /* option:	(                 )			hidden
;  1 column display:                       S			system file
;			                    A			archive flag
;			                      dd-mm-yy hh:mm	date and time
;
outent:	AtrOff	hidmsk,'(',' '			;"("

	mov	si,bp
	add	si,Tfsp

	test	[byte ptr bp+Tatr],dirmsk	;subdirectory?
	jz	outen1
	call	outfnd				;  yes:	"subdirname  "
	mov	si,offset txdir			;	"<DIR>"
	call	outtxt
	jmp	short outen2

outen1:	test	[byte ptr bp+Tatr],rdomsk	;  no :	"filename.ext"
	call	outfnx

	mov	cx,[bp+Tsize+0]			;	"nnnnk"
	mov	dx,[bp+Tsize+2]
	mov	bh,4				;	display in 4 digits
	mov	bl,' '				;	with leading spaces
	call	outkb

outen2:	AtrOff	hidmsk,')',' '			'")"

	cmp	[byte ptr dirkol],2		;1 or 2 column display?
	ja	outenZ

	AtrOff	sysmsk,'S',' '			;  yes:	"S"
	AtrOff	arcmsk,'A',' '			;	"A"
	mov	al,' '				;	" "
	call	outchr
	call	outdts				;	"dd-mm-yy hh:mm"

outenZ:	ret

%newpage
;Display file attribute
;
; in :	flags	nz = attribute on
;	al	character to be displayed for cond nz
;	ah	character to be displayed for cond z
;
outattr:	jnz	outat1
	mov	al,ah
outat1:	CalRet	outchr


;Display size in kbyte
;in	dx:cx	size in bytes
;	bh	number of digits
;	bl	leading 0 character (00h = suppress)
outkb:	add	cx,1023				;round to next-higher integer
	adc	dx,0	
	mov	cl,ch				;divide dx:cx by 256
	mov	ch,dl
	mov	dl,dh
	sub	dh,dh
	shr	dx,1				;and then by 4
	rcr	cx,1
	shr	dx,1
	rcr	cx,1
	call	outdec
	mov	al,'k'
	call	outchr
	ret

%newpage
; oisplay file date and time
;
; in :	bp	near pointer to file information table entry
; out:	bp	unchanged
;
outdts:	sub	dx,dx				;outdec cx only
	mov	bh,2				;display in 2 digits
	mov	bl,'0'				;leading zeroes

	mov	di,[bp+Tdate]			;file date
	mov	cx,di				;"dd" day
	and	cx,001Fh
	call	outdec

	mov	al,'-'				;"-"
	call	outchr

	mov	cl,5				;"mm" month
	shr	di,cl
	mov	cx,di
	and	cx,000fh
	call	outdec

	mov	al,'-'				;"-"
	call	outchr

	mov	cl,4				;year
	shr	di,cl
	mov	cx,di
	add	cx,1980
	call	outdec

	mov	al,' '				;" "
	call	outchr

	mov	di,[bp+Ttime]			;file time
	mov	cl,5				;"hh"
	rol	di,cl
	mov	cx,di
	and	cx,001Fh
	call	outdec

	mov	al,':'				;":"
	call	outchr

	mov	cl,6				;"mm"
	rol	di,cl
	mov	cx,di
	and	cx,003fh
	call	outdec
	
	mov	al,' '				;" "
	call	outchr
	ret

%newpage
;Display number of files, kb total and kb free
;
outtot:	mov	si,offset txtot			;"Total: "
	call	outtxt
	mov	cx,[fcount]			;file count
	sub	dx,dx
	DecOff	10,0				;10 digits, no leading zeroes
	mov	si,offset txfile
	call	outtxt

	mov	cx,[totbyt+0]			;kb total
	mov	dx,[totbyt+2]
	mov	bh,10				;max 10 digits
	sub	bl,bl				;no leading zeroes
	call	outkb

	test	[byte ptr optstr+ofskl1],true	;newline if 1 column display
	jz	outto1
	mov	al,cr
	call	outchr
outto1:	mov	si,offset txfree		;"  Free: "
	call	outtxt
	mov	cx,[frebyt+0]			;kb free
	mov	dx,[frebyt+2]
	mov	bh,10				;max 10 digits
	sub	bl,bl				;no leading zeroes
	call	outkb

	mov	si,offset txpct1		;" ("
	call	outtxt
	mov	cx,[frepct]			;percentage free on disk
	sub	dx,dx
	DecOff	10,0				;10 digits, no leading zeroes
	mov	si,offset txpct2		;"%)"
	call	outtxt

	ret

%newpage
;Display decimal number
;in:	dx:cx	number to be displayed (32 bit unsigned integer)
;	bh	number of digits (1..10)
;	bl	leading zero character (00h = no leading zeroes)
;
;out:	si,di	unchanged
;
outdec:	push	si
	push	di
	;fill buffer
	mov	si,offset tentbl		;denom= 10^9; (max 9 digits)
	mov	di,offset digbuf
outdc1:						;do {
	mov	al,'0'-1			;  digit= -1;
outdc2:	inc	al				;  do {	++digit;
	sub	cx,[word ptr si+0]		;	number -= denom;
	sbb	dx,[word ptr si+2]
	jnc	outdc2				;  } while (number >= 0)

	add	cx,[word ptr si+0]		;  number += denom;
	adc	dx,[word ptr si+2]
	stosb					;  *di++ = digit;
	add	si,4				;  denom /= 10;
	cmp	[byte ptr si],1
	jne	outdc1				;} until (denom=1);
	add	cl,'0'				;*di++ = '0' + number;
	mov	[byte ptr di],cl

	;schrijf buffer
	mov	cl,bh				;cx= number of digits
	sub	ch,ch
	mov	si,offset digbuf+10		;si= buffer pointer
	sub	si,cx
outdc4:	lodsb					;read digit
	cmp	cx,1				;last digit?
	jz	outdc6				;  yes:	display
	cmp	al,'0'				;  no :	digit = '0'?
	jne	outdc5
	and	bl,bl				;    yes: suppress
	jz	outdc7
	mov	al,bl				;         or 'leading 0' char
	jmp	short outdc6
outdc5:	mov	bl,'0'				;    no : stop '0' suppression
outdc6:	call	outchr				;display digit
outdc7:	loop	outdc4				;next digit
	pop	di
	pop	si
	ret

%subttl "-- String handling routines"
%newpage
;--------------------------------------------------------------------------
; STRING HANDLING ROUTINES
;--------------------------------------------------------------------------

; strcpy : copy ASCIIZ string
;
; in :	ds:si	source string address
;	es:di	destination string address
; out:	ds:si	past end of source string
;	es:di	past end of destination string
;
; other registers unchanged
;
strcpy:	pushf
	push	ax
strcp1:	lodsb
	stosb
	and	al,al
	jnz	strcp1
	pop	ax
	popf
	ret

%subttl "-- Subroutines console I/O"
%newpage
;--------------------------------------------------------------------------
; SUBROUTINES CONSOLE I/O
;--------------------------------------------------------------------------

;
;Exit if "cancel" key is pressed
;
;changed:	ax,flags
;
abort:	push	cx
	push	dx
	push	bx

	mov	dl,0ffh				;if key pressed {
	mov	ah,conio
	int	21h
	and	al,al
	jz	abort2

	cmp	al,can				;  if cancel
	jnz	abort1
	mov	si,offset txstop		;    exit;
	jmp	error

abort1:	and	al,al				;  if extended keycode
	jnz	abort2
	mov	dl,0ffh				;    empty key buffer;
	mov	ah,conio
	int	21h

abort2:	pop	bx				;}
	pop	dx
	pop	cx
	ret

;
;character input without echo
;
;out	:	al		character code
;changed:	ax,flags
;
inchr:	push	bx
	push	cx
	push	dx

inchr1:	mov	dl,0ffh				;wait for key
	mov	ah,conio
	int	21h
	jz	inchr1

	and	al,al				;if extended keycode
	jnz	inchr2
	mov	dl,0ffh				;	return scancode + 12
	mov	ah,conio
	int	21h
	add	al,128
	jmp	short inchr3
inchr2:	call	upcase				;else	convert to upper case
inchr3:	pop	dx
	pop	cx
	pop	bx
	ret

%newpage

;Display character with optional printer echo
;Adds lf after cr
;
;in	:	al	character code
;changed:	-
;
outchr:	pushf
	push	ax
	and	al,7fh
	call	putch
	cmp	al,cr
	jnz	outka1
	mov	al,lf
	call	putch
	inc	[byte ptr curlin]
	cmp	[byte ptr curlin],maxlin
	jne	outka1
	call	waitcr				;wait if screen is full
	mov	[byte ptr curlin],0
outka1:	pop	ax
	popf
	ret


;Display character to console with optional printer echo
;
;in	:	al	character code
;changed:	-
;
putch:	pushf
	push	ax
	push	dx

	call	outcon
	call	outlst				;optional prnter echo

	pop	dx
	pop	ax
	popf
	ret


;Display character to console
;
;in:		al		character code
;changed:	ah,dl
;
outcon:	mov	dl,al
	mov	ah,conout
	int	21h
	ret


;outvoer character naar printer indien lstpat aan
;
;in:		al		charactercode
;wijzigt	ah,dl
;
outlst:	test	[byte ptr optstr+ofslst],true
	jz      outls1
	mov	dl,al
	mov	ah,lstout
	int	21h
outls1:	ret

%newpage
;outvoer textstring
;in		si	beginaddress text, afgesloten met byte 0
;wijzigt	si
outtxt:	pushf
	push	ax
outtx1:	lodsb
	and	al,al
	jz	outtx2
	call	outchr
	jmp	short outtx1
outtx2:	pop	ax
	popf
	ret

;outvoer subdirectory naam in veld van 12 posities
;in	si	address subdirectory naam
outfnd:	mov	ah,' '
	jmp	short outfn1

;outvoer filename:typ bij nz-conditie, anders filename.typ
;in	si	address filename
outfnx:	mov	ah,rdochr
	jnz	short outfn1
						;ga verder met outfnm
;outvoer filename.typ
;in	si	address filename
outfnm:	mov	ah,rdwchr
outfn1:	mov	cx,8				;filename
	call	outfn2
	mov	al,ah				;scheidingscharacter
	call	outchr
	mov	cx,3				;extensie
outfn2:	lodsb
	and	al,al
	jz	outfn3
	cmp	al,'.'
	jnz	outfn4
outfn3:	dec	si
	mov	al,' '
outfn4:	call	outchr
	loop	outfn2
	cmp	[byte ptr si],'.'
	jnz	outfn5
	inc	si
outfn5:	ret


; wacht op CR indien /W option is gegeven
;
waitcr:	test	[byte ptr optstr+ofswai],true
	jz	waitc2

	mov	dx,offset txwait
	mov	ah,constr		;console out (geen printer echo)
	int	21h
waitc1:	call	inchr
	cmp	al,cr
	jnz	waitc1
	call	outcon

waitc2:	ret


	end	xd
 