%pagesize 77,132

; Title		: FExpand
; Version	: 2.0
; Date		: Nov 29,1996
; Author	: J R Ferguson
; Language	: Intel 8068/8088 assembler
; O.S.		: MS-DOS v3.2
; Assembler	: Turbo Assembler v1.0
; Function	: Replacement of Turbo Pascal FExpand function

;----------------------------------------------------------------------
; DECLARATIONS
;----------------------------------------------------------------------

	ideal
	model	tiny

;----------------------------------------------------------------------
; EQUATES
;----------------------------------------------------------------------

MaxDir	=	20		;max dir stack depth

;----------------------------------------------------------------------
; DATA
;----------------------------------------------------------------------

	dataseg

DrCode	db	?
CurDir	db	67 dup(?)

StkPtr	dw	?			;subdir stack pointer
DirStk	dw	MaxDir dup(?)		;subdir offset stack
StkTop	=	this word

%newpage
;----------------------------------------------------------------------
; CODE
;----------------------------------------------------------------------

	codeseg
	assume	cs:@code,ds:@data,es:@data

proc	FExpand	near
public	FExpand
;
; Expand DOS file specification
; Replacement of Turbo Pascal FExpand function
;
; in: 	ds:si	address input filespec	(ASCIIZ string)
; 	es:di	address output filespec	(ASCIIZ string)
;
; out:	registers unchanged
;
	pushf
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di

	cld
	mov	[StkPtr],offset DirStk	;initialize subdir stack pointer

	mov	dx,si			;save address of input fsp
	call	GetChr			;'d:'
	jz	FExp1
	mov	ah,al
	call	GetChr
	jz	FExp1
	cmp	al,':'
	jne	FExp1

	xchg	al,ah			;  yes : copy
	stosw
	sub	al,'A'-1		;	drive code 1='A', 2='B', etc
	mov	[DrCode],al	
	jmp	short FExp2

FExp1:	mov	ah,19h			;  no:	default to current drive
	int	21h
	add	al,'A'
	stosb
	mov	al,':'
	stosb
	mov	[DrCode],0		;	drive code 0=current drive
	mov	si,dx			;	back to start of fsp input

FExp2:	call	GetChr			;'\' ?
	jz	FExp3
	cmp	al,'\'
	je	FExp5

FExp3:	dec	si			;  no : save character
	push	si			;	save si
	mov	si,offset CurDir	;  	get current directory path
	mov	dl,[DrCode]
	mov	ah,47h
	int	21h
	jc	FExp4			;	ok and not empty?
	mov	si,offset CurDir
	cmp	[byte ptr si],0	
	jz	FExp4
	call	Path			;	  yes:	copy current dirpath
FExp4:	pop	si			;	restore si
FExp5:	call	Path			;	read remaining part of fsp
FExp6:	xor	al,al
	stosb

	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	popf

	ret

	endp

%newpage
proc	Path	near
;
; internal register usage:
;	ah	state : 0=normal, 1='\', 2='\.', 3='\..'
;
	mov	ah,0
	mov	al,'\'
Path1:	stosb
	call	ChkDir
	call	GetChr
	jnz	Path1
	call	ChkDir
	ret

	endp


proc	ChkDir	near
;
; in/out :	ah	state : 0=normal, 1='\', 2='\.', 3='\..'
;
Chk0:	cmp	ah,0		;if (state == 0) {
	jne	Chk1
	cmp	al,'\'		;  if (c=='\')
	jne	Chk0X
	mov	ah,1		;    state= 1;
	call	PushDir
Chk0X:	ret			;}

Chk1:	cmp	ah,1		;else if (state == 1) {
	jne	Chk2
	mov	ah,2		;  state= (c=='.') ? 2 : 0;
	cmp	al,'.'
	je	Chk1X
	mov	ah,0
Chk1X:	ret			;}

Chk2:	cmp	ah,2		;else if (state == 2) {
	jne	Chk3
	mov	ah,3		;  if (c=='.') state= 3;
	cmp	al,'.'
	je	Chk2X
	mov	ah,0		;  else if ((c=='\\') || (c=='\0')) {
	cmp	al,'\'
	je	Chk2A
	cmp	al,0
	jne	Chk2X
Chk2A:	mov	ah,1		;    state= 1;
	call	PopDir		;    PopDir(); PushDir();
	call	PushDir		;  }
Chk2X:	ret			;}

Chk3:	cmp	ah,3		;else if (state == 3) {
	mov	ah,0		;  state= 0;
	jne	Chk3X
	cmp	al,'\'		;  if ((c=='\\') || (c=='\0')) {
	je	Chk3A
	cmp	al,0
	jne	Chk3X
Chk3A:	mov	ah,1		;    state= 1;
	call	PopDir		;    PopDir(); PopDir(); PushDir();
	call	PopDir
	call	PushDir		;    }
Chk3X:	ret			;}

	endp


%newpage
proc	PushDir	near
;
; Push subdirectory offset in expanded filespec
;
; in :	di	offset to push on subdir stack
;
	mov	bx,[StkPtr]		;if (StkPtr < StkTop)
	cmp	bx,offset StkTop
	jnb	Push1
	mov	[bx],di			;  *StkPtr++ = DI;
	add	bx,2
	mov	[StkPtr],bx
Push1:	ret

	endp


proc	PopDir	near
;
; Pop subdirectory offset from stack
;
; out:	di	offset previous subdirectory
;
	mov	bx,[StkPtr]		;DI= *StkPtr;
	cmp	bx,offset DirStk	;if (StkPtr > DirStk)
	jna	Pop1
	sub	bx,2			;  --StkPtr;
	mov	[StkPtr],bx
Pop1:	mov	di,[bx]
	ret

	endp	


proc	GetChr	near
;
; Get string character from ASCIIZ string, 
; strip parity bit, convert to uppercase
;
; in :	ds:si	current string pointer
; out:	ds:di	updated
;	al	character
;	flags	cond z = end of string
;
	lodsb
	and	al,7fh
	cmp	al,'a'
	jb	Get1
	cmp	al,'z'
	ja	Get1
	sub	al,'a'-'A'
Get1:	and	al,al
	ret

	endp

	end
