/*
    WLX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                   WLX2FAR WLX PLUGIN WINDOW PROCEDURE                      //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wlx2far                                                           //
// PART:    WLX plugin window procedure                                       //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wlx2far.h>
/*============================================================================*/
LRESULT CALLBACK Wnd_WLXPlugin(HWND hWnd,UINT iMsg,WPARAM wParam,LPARAM lParam)
{
 // Lock function
 Defender lock;
 switch (iMsg)
 {
  case WM_COMMAND:
  {
   if (HIWORD(wParam)==itm_quit)
   {
    WLXPluginInstance* inst;
    if (visible_LQViewer)
    {
     inst=(WLXPluginInstance*)GetProp(hWnd_LQViewer,"WLXQView");
     if (inst!=NULL)
      if (inst->GetWindow()==(HWND)lParam)
       wlx2far_CloseQViewer(true);
    }
    if (visible_RQViewer)
    {
     inst=(WLXPluginInstance*)GetProp(hWnd_RQViewer,"WLXQView");
     if (inst!=NULL)
      if (inst->GetWindow()==(HWND)lParam)
       wlx2far_CloseQViewer(false);
    }
    if (visible_Lister)
    {
     HWND hTabWnd=(HWND)GetProp(hWnd_Lister,"WLXListerTabWindow");
     WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd_Lister,"WLXListerTab");
     std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd_Lister,"WLXLister");
     if ((tabinst!=NULL)&&(vect!=NULL))
     {
      bool end=false;
      while (!end)
      {
       unsigned i=0;
       end=true;
       for (std::vector<WLXPluginInstance*>::iterator it=vect->begin();it!=vect->end();it++,i++)
        if ((*it)->GetWindow()==(HWND)lParam)
        {
         if (vect->size()>1)
          TabCtrl_SetCurFocus(hTabWnd,i);
         SendMessage(hWnd_Lister,WM_WLXLISTERCURDEL,0,0);
         end=false;
         break;
        }
      }
      if (vect->size()>1)
       for (unsigned i=0;i<vect->size();i++)
        if ((*vect)[i]==tabinst)
         TabCtrl_SetCurFocus(hTabWnd,i);
     }
    }
   }
   break;
  }
 }
 return DefWindowProc(hWnd,iMsg,wParam,lParam);
}
/*============================================================================*/
