/*
    WLX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                     WLX2FAR VIEWER WINDOW PROCEDURE                        //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wlx2far                                                           //
// PART:    Viewer window procedure                                           //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wlx2far.h>
/*============================================================================*/
#define GET_X_LPARAM(lp)                        ((int)(short)LOWORD(lp))
#define GET_Y_LPARAM(lp)                        ((int)(short)HIWORD(lp))
/*============================================================================*/
void TopWindow(HWND hWnd)
{
 LONG style=GetWindowLong(hWnd,GWL_EXSTYLE);
 if (!(style&WS_EX_TOPMOST))
  SetWindowPos(hWnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
}
/*----------------------------------------------------------------------------*/
void UnTopWindow(HWND hWnd)
{
 LONG style=GetWindowLong(hWnd,GWL_EXSTYLE);
 if (style&WS_EX_TOPMOST)
  SetWindowPos(hWnd,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
}
/*============================================================================*/
LRESULT CALLBACK Wnd_Viewer(HWND hWnd,UINT iMsg,WPARAM wParam,LPARAM lParam)
{
 // Lock function
 Defender lock;
 switch (iMsg)
 {
  case WM_CREATE:
  {
   SetTimer(hWnd,666,100,NULL);
   return 0;
  }
  case WM_TIMER:
  {
   if (timerstopped)
    return 0;
   WINDOWPLACEMENT winplace;
   winplace.length=sizeof(WINDOWPLACEMENT);
   GetWindowPlacement(hWnd_Global,&winplace);
   if (winplace.showCmd==SW_SHOWMINIMIZED)
   {
    if ((pinlister)&&(visible_Lister))
    {
     resore_Lister=true;
     wlx2far_HideLister();
    }
    if (visible_LQViewer)
    {
     resore_LQViewer=true;
     wlx2far_HideQViewer(true);
    }
    if (visible_RQViewer)
    {
     resore_RQViewer=true;
     wlx2far_HideQViewer(false);
    }
   }
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_Global,&wininfo);
   if (wininfo.dwWindowStatus!=WS_ACTIVECAPTION)
   {
    if (visible_LQViewer)
    {
     GetWindowInfo(hWnd_LQViewer,&wininfo);
     if (wininfo.dwWindowStatus!=WS_ACTIVECAPTION)
     {
      if (visible_RQViewer)
      {
       GetWindowInfo(hWnd_RQViewer,&wininfo);
       if (wininfo.dwWindowStatus!=WS_ACTIVECAPTION)
        UnTopWindow(hWnd_LQViewer);
      }
      else
       UnTopWindow(hWnd_LQViewer);
     }
     else
      if (GetForegroundWindow()!=hWnd_LQViewer)
       UnTopWindow(hWnd_LQViewer);
    }
    if (visible_RQViewer)
    {
     GetWindowInfo(hWnd_RQViewer,&wininfo);
     if (wininfo.dwWindowStatus!=WS_ACTIVECAPTION)
     {
      if (visible_LQViewer)
      {
       GetWindowInfo(hWnd_LQViewer,&wininfo);
       if (wininfo.dwWindowStatus!=WS_ACTIVECAPTION)
        UnTopWindow(hWnd_RQViewer);
      }
      else
       UnTopWindow(hWnd_RQViewer);
     }
     else
      if (GetForegroundWindow()!=hWnd_RQViewer)
       UnTopWindow(hWnd_RQViewer);
    }
   }
   else
   {
    if (GetForegroundWindow()==hWnd_Global)
    {
     if ((pinlister)&&(visible_Lister))
     {
      ShowWindow(hWnd_Lister,SW_SHOW);
      SetForegroundWindow(hWnd_Lister);
     }
     if (visible_LQViewer)
      TopWindow(hWnd_LQViewer);
     if (visible_RQViewer)
      TopWindow(hWnd_RQViewer);
    }
   }
   if (hWnd==hWnd_Lister)
   {
    bool redraw=false;
    POINT p;
    RECT rect;
    GetCursorPos(&p);
    GetWindowRect(hWnd,&rect);
    if (!((p.y>=rect.top+5)&&(p.y<=rect.top+18)))
    {
     GetWindowText(hWnd,buffer1,MYMAXPATH);
     if (strlen(buffer1)>0)
     {
      unsigned i=(unsigned)(strlen(buffer1)-1);
      while ((i>0)&&(buffer1[i]!='*'))
       i--;
      if (buffer1[i]=='*')
      {
       buffer1[i-1]='\0';
       tooltip[0]=false;
       tooltip[1]=false;
       tooltip[2]=false;
       SetWindowText(hWnd,buffer1);
       SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
      }
     }
    }
   }
   return 0;
  }
  case WM_CLOSE:
  {
   if ((hWnd==hWnd_Lister)&&(visible_Lister))
    wlx2far_HideLister();
   if ((hWnd==hWnd_LQViewer)&&(visible_LQViewer))
    wlx2far_CloseQViewer(true);
   if ((hWnd==hWnd_RQViewer)&&(visible_RQViewer))
    wlx2far_CloseQViewer(false);
   return 0;
  }
  case WM_DESTROY:
  {
   std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd,"WLXLister");
   if (vect!=NULL)
   {
    if (vect->size()>1)
    {
     HWND hTabWnd=(HWND)GetProp(hWnd,"WLXListerTabWindow");
     if (hTabWnd!=NULL)
     {
      TabCtrl_DeleteAllItems(hTabWnd);
      DestroyWindow(hTabWnd);
     }
     RemoveProp(hWnd,"WLXListerTabWindow");
    }
    for (std::vector<WLXPluginInstance*>::iterator it=vect->begin();it!=vect->end();it++)
    {
     (*it)->Hide();
     (*it)->Close();
     delete *it;
    }
    vect->clear();
    delete vect;
    RemoveProp(hWnd,"WLXLister");
    RemoveProp(hWnd,"WLXListerTab");
   }
   SendMessage(hWnd,WM_WLXDELETE,NULL,NULL);
   KillTimer(hWnd,666);
   return 0;
  }
  case WM_MOVE:
  case WM_SIZE:
  {
   WLXPluginInstance* inst=(WLXPluginInstance*)GetProp(hWnd,"WLXQView");
   if (inst!=NULL)
   {
    RECT rect;
    GetClientRect(hWnd,&rect);
    inst->Size(rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top);
   }
   std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd,"WLXLister");
   WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
   if ((vect!=NULL)&&(tabinst!=NULL))
   {
    if (vect->size()==1)
    {
     RECT rect;
     GetClientRect(hWnd,&rect);
     tabinst->Size(rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top);
    }
    if (vect->size()>1)
    {
     RECT rect;
     HWND hTabWnd=(HWND)GetProp(hWnd,"WLXListerTabWindow");
     GetClientRect(hWnd,&rect);
     MoveWindow(hTabWnd,rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,TRUE);
     GetClientRect(hTabWnd,&rect);
     TabCtrl_AdjustRect(hTabWnd,FALSE,&rect);
     tabinst->Size(rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top);
    }
   }
   wlx2far_ListerResize();
   return 0;
  }
  case WM_SETFOCUS:
  {
   WLXPluginInstance* inst=(WLXPluginInstance*)GetProp(hWnd,"WLXQView");
   if (inst!=NULL)
    inst->Focus();
   WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
   if (tabinst!=NULL)
    tabinst->Focus();
   return 0;
  }
  case WM_COMMAND:
  {
   WLXPluginInstance* inst=(WLXPluginInstance*)GetProp(hWnd,"WLXQView");
   if (inst!=NULL)
    return inst->Notify(hWnd,(HWND)lParam,iMsg,wParam,lParam);
   WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
   if (tabinst!=NULL)
    return tabinst->Notify(hWnd,(HWND)lParam,iMsg,wParam,lParam);
   return DefWindowProc(hWnd,iMsg,wParam,lParam);
  }
  case WM_NOTIFY:
  {
   std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd,"WLXLister");
   if (vect!=NULL)
   {
    LPNMTTDISPINFO lpToolTipText;
    LPNMHDR lpNMHdr=(LPNMHDR)lParam;
    switch (lpNMHdr->code)
    {
     case TTN_NEEDTEXT:
     {
      lpToolTipText=(LPNMTTDISPINFO)lParam;
      strncpy(lpToolTipText->lpszText,(*vect)[lpToolTipText->hdr.idFrom]->GetArguments(),80);
      break;
     }
     case TCN_SELCHANGE:
     {
      HWND hTabWnd=(HWND)GetProp(hWnd,"WLXListerTabWindow");
      WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
      std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd,"WLXLister");
      if ((hTabWnd!=NULL)&&(tabinst!=NULL)&&(vect!=NULL))
      {
       RECT rect;
       tabinst->Hide();
       tabinst=(*vect)[TabCtrl_GetCurSel(hTabWnd)];
       SetProp(hWnd,"WLXListerTab",(HANDLE)tabinst);
       tabinst->Show();
       tabinst->Focus();
       GetClientRect(hTabWnd,&rect);
       TabCtrl_AdjustRect(hTabWnd,FALSE,&rect);
       tabinst->Size(rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top);
       SetWindowText(hWnd,tabinst->GetArguments());
       SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
       break;
      }
     }
    }
   }
   LPNMHDR notifyheader=(LPNMHDR)lParam;
   WLXPluginInstance* inst=(WLXPluginInstance*)GetProp(hWnd,"WLXQView");
   if (inst!=NULL)
    return inst->Notify(hWnd,notifyheader->hwndFrom,iMsg,wParam,lParam);
   WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
   if (tabinst!=NULL)
    return tabinst->Notify(hWnd,notifyheader->hwndFrom,iMsg,wParam,lParam);
   return DefWindowProc(hWnd,iMsg,wParam,lParam);
  }
  case WM_DRAWITEM:
  {
   std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd,"WLXLister");
   LPDRAWITEMSTRUCT lpDrawItem=(LPDRAWITEMSTRUCT)lParam;
   if ((lpDrawItem->CtlType==ODT_TAB)&&(lpDrawItem->itemAction==ODA_DRAWENTIRE)&&(lpDrawItem->itemID!=-1)&&(vect!=NULL))
   {
    HBRUSH hBrush=CreateSolidBrush(GetBkColor(lpDrawItem->hDC));
    FillRect(lpDrawItem->hDC,&lpDrawItem->rcItem,hBrush);
    DeleteObject(hBrush);

    HFONT hfnt,hOldFont;
    hfnt=(HFONT)GetStockObject(ANSI_VAR_FONT);
    if (hOldFont=(HFONT)SelectObject(lpDrawItem->hDC,hfnt))
    {
     if (((*vect)[lpDrawItem->itemID]->GetPlugin()->GetAlias()==NULL)||(strcmp((*vect)[lpDrawItem->itemID]->GetPlugin()->GetAlias(),"")==0))
      strcpy(buffer1,(*vect)[lpDrawItem->itemID]->GetPlugin()->GetName());
     else
      strcpy(buffer1,(*vect)[lpDrawItem->itemID]->GetPlugin()->GetAlias());
     RECT rect;
     rect.left=lpDrawItem->rcItem.left+5;
     rect.right=lpDrawItem->rcItem.right-5;
     rect.top=lpDrawItem->rcItem.top+1;
     rect.bottom=lpDrawItem->rcItem.bottom;
     DrawText(lpDrawItem->hDC,buffer1,(int)strlen(buffer1),&rect,DT_LEFT|DT_VCENTER|DT_SINGLELINE|DT_END_ELLIPSIS);
     SelectObject(lpDrawItem->hDC,hOldFont);
     return 0;
    }
   }
   LPDRAWITEMSTRUCT drawstruct=(LPDRAWITEMSTRUCT)lParam;
   WLXPluginInstance* inst=(WLXPluginInstance*)GetProp(hWnd,"WLXQView");
   if (inst!=NULL)
    return inst->Notify(hWnd,drawstruct->hwndItem,iMsg,wParam,lParam);
   WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
   if (tabinst!=NULL)
    return tabinst->Notify(hWnd,drawstruct->hwndItem,iMsg,wParam,lParam);
   return DefWindowProc(hWnd,iMsg,wParam,lParam);
  }
  case WM_MEASUREITEM:
  {
   WLXPluginInstance* inst=(WLXPluginInstance*)GetProp(hWnd,"WLXQView");
   if (inst!=NULL)
    return inst->Notify(hWnd,inst->GetWindow(),iMsg,wParam,lParam);
   WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
   if (tabinst!=NULL)
    return tabinst->Notify(hWnd,inst->GetWindow(),iMsg,wParam,lParam);
   return DefWindowProc(hWnd,iMsg,wParam,lParam);
  }
  case WM_NCMOUSEMOVE:
  {
   if (hWnd!=hWnd_Lister)
    return DefWindowProc(hWnd,iMsg,wParam,lParam);
   bool redraw=false;
   bool redrawstr=false;
   RECT rect;
   GetWindowText(hWnd,buffer1,MYMAXPATH);
   if (strlen(buffer1)>0)
   {
    unsigned i=(unsigned)(strlen(buffer1)-1);
    while ((i>0)&&(buffer1[i]!='*'))
     i--;
    if (buffer1[i]=='*')
    {
     buffer1[i-1]='\0';
     redrawstr=true;
    }
   }
   GetWindowRect(hWnd,&rect);
   for (int i=0;i<3;i++)
    if (((GET_Y_LPARAM(lParam)>=rect.top+5)&&(GET_Y_LPARAM(lParam)<=rect.top+18))&&((GET_X_LPARAM(lParam)>=(rect.right-80-15*i))&&(GET_X_LPARAM(lParam)<=(rect.right-67-15*i))))
    {
     if (!tooltip[i])
      redraw=true;
     tooltip[i]=true;
     if (i==0)
      strcat(buffer1," * Destroy all tabs");
     if (i==1)
      strcat(buffer1," * Close current tab");
     if (i==2)
      strcat(buffer1," * Pin to FAR window");
    }
    else
     tooltip[i]=false;
   if (redrawstr)
   {
    for (int i=0;i<3;i++)
     if (tooltip[i])
      redrawstr=false;
    if (redrawstr)
     redraw=true;
   }
   if (redraw)
   {
    SetWindowText(hWnd,buffer1);
    SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
   }
   return DefWindowProc(hWnd,iMsg,wParam,lParam);
  }
  case WM_NCLBUTTONDOWN:
  {
   if (hWnd!=hWnd_Lister)
    return DefWindowProc(hWnd,iMsg,wParam,lParam);
   RECT rect;
   GetWindowRect(hWnd,&rect);
   if ((GET_Y_LPARAM(lParam)>=rect.top+5)&&(GET_Y_LPARAM(lParam)<=rect.top+18))
   {
    for (int i=0;i<3;i++)
     if ((GET_X_LPARAM(lParam)>=(rect.right-80-15*i))&&(GET_X_LPARAM(lParam)<=(rect.right-67-15*i)))
     {
      button[i]=true;
      SetCapture(hWnd);
      SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
      break;
     }
   }
   return DefWindowProc(hWnd,iMsg,wParam,lParam);
  }
  case WM_LBUTTONUP:
  {
   if (hWnd!=hWnd_Lister)
    return DefWindowProc(hWnd,iMsg,wParam,lParam);
   ReleaseCapture();
   if (button[0])
   {
    SendMessage(hWnd_Lister,WM_WLXLISTERALLDEL,0,0);
    button[0]=false;
    SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
   }
   if (button[1])
   {
    SendMessage(hWnd_Lister,WM_WLXLISTERCURDEL,0,0);
    button[1]=false;
    SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
   }
   if (button[2])
   {
    wlx2far_PinLister(!pinlister);
    button[2]=false;
    SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
   }
   return DefWindowProc(hWnd,iMsg,wParam,lParam);
  }
  case WM_NCACTIVATE:
  case WM_NCPAINT:
  {
   LRESULT res=DefWindowProc(hWnd,iMsg,wParam,lParam);
   if (hWnd!=hWnd_Lister)
    return res;
   RECT rect,buttonrect;
   HDC hDC=GetWindowDC(hWnd);
   GetWindowRect(hWnd,&rect);
   buttonrect.left=rect.right-rect.left-80;
   buttonrect.top=5;
   buttonrect.right=rect.right-rect.left-67;
   buttonrect.bottom=18;
   if (!button[0])
   {
    DrawFrameControl(hDC,&buttonrect,DFC_BUTTON,DFCS_BUTTONPUSH);
    DrawIconEx(hDC,buttonrect.left+1,buttonrect.top+1,LoadIcon(hinst,MAKEINTRESOURCE(IDI_DESTROY)),10,10,0,NULL,DI_NORMAL);
   }
   else
   {
    DrawFrameControl(hDC,&buttonrect,DFC_BUTTON,DFCS_BUTTONPUSH|DFCS_CHECKED);
    DrawIconEx(hDC,buttonrect.left+1,buttonrect.top+1,LoadIcon(hinst,MAKEINTRESOURCE(IDI_DESTROY)),10,10,0,NULL,DI_NORMAL);
   }
   buttonrect.left=rect.right-rect.left-95;
   buttonrect.top=5;
   buttonrect.right=rect.right-rect.left-82;
   buttonrect.bottom=18;
   if (!button[1])
   {
    DrawFrameControl(hDC,&buttonrect,DFC_BUTTON,DFCS_BUTTONPUSH);
    DrawIconEx(hDC,buttonrect.left+1,buttonrect.top+1,LoadIcon(hinst,MAKEINTRESOURCE(IDI_CLOSE)),10,10,0,NULL,DI_NORMAL);
   }
   else
   {
    DrawFrameControl(hDC,&buttonrect,DFC_BUTTON,DFCS_BUTTONPUSH|DFCS_CHECKED);
    DrawIconEx(hDC,buttonrect.left+1,buttonrect.top+1,LoadIcon(hinst,MAKEINTRESOURCE(IDI_CLOSE)),10,10,0,NULL,DI_NORMAL);
   }
   buttonrect.left=rect.right-rect.left-110;
   buttonrect.top=5;
   buttonrect.right=rect.right-rect.left-97;
   buttonrect.bottom=18;
   if ((!button[2])&&(!pinlister))
   {
    DrawFrameControl(hDC,&buttonrect,DFC_BUTTON,DFCS_BUTTONPUSH);
    DrawIconEx(hDC,buttonrect.left+1,buttonrect.top+1,LoadIcon(hinst,MAKEINTRESOURCE(IDI_PIN)),10,10,0,NULL,DI_NORMAL);
   }
   else
   {
    DrawFrameControl(hDC,&buttonrect,DFC_BUTTON,DFCS_BUTTONPUSH|DFCS_CHECKED);
    DrawIconEx(hDC,buttonrect.left+1,buttonrect.top+1,LoadIcon(hinst,MAKEINTRESOURCE(IDI_PIN)),10,10,0,NULL,DI_NORMAL);
   }
   ReleaseDC(hWnd,hDC);
   return res;
  }
  case WM_WLXLISTEROPEN:
  {
   std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd_Lister,"WLXLister");
   if (vect==NULL)
   {
    vect=new std::vector<WLXPluginInstance*>;
    SetProp(hWnd_Lister,"WLXLister",(HANDLE)vect);
   }
   bool found=false;
   for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    if (((*it)->IsValid())&&(_stricmp((*it)->GetName(),PluginName)==0))
    {
     found=true;
     if (vect->size()==0)
     {
      SetFileApisToANSI();
      WLXPluginInstance* inst=new WLXPluginInstance(*it,PluginArgs);
      if (inst->Load(hWnd))
      {
       RECT rect;
       vect->push_back(inst);
       GetClientRect(hWnd,&rect);
       SetProp(hWnd,"WLXListerTab",(HANDLE)inst);
       SendMessage(hWnd,WM_SIZE,NULL,MAKELPARAM(rect.right-rect.left,rect.bottom-rect.top));
      }
      else
      {
       delete inst;
       break;
      }
      Sleep(100);
      SetFileApisToOEM();
      wlx2far_ShowLister();
      break;
     }
     if (vect->size()==1)
     {
      SetFileApisToANSI();
      WLXPluginInstance* inst=new WLXPluginInstance(*it,PluginArgs);
      WLXPluginInstance* instold=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
      if (inst->Load(hWnd))
      {
       RECT rect;
       vect->push_back(inst);
       GetClientRect(hWnd,&rect);
       SetProp(hWnd,"WLXListerTab",(HANDLE)inst);
      }
      else
      {
       delete inst;
       break;
      }
      Sleep(100);
      SetFileApisToOEM();
      RECT rect;
      TC_ITEM TabItem;
      GetClientRect(hWnd,&rect);
      HWND hTabWnd=CreateWindow(WC_TABCONTROL,"",WS_VISIBLE|WS_TABSTOP|WS_CHILD|TCS_SINGLELINE|TCS_FORCEICONLEFT|TCS_FORCELABELLEFT|TCS_FOCUSNEVER|TCS_FIXEDWIDTH|TCS_OWNERDRAWFIXED|TCS_TOOLTIPS,rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,hWnd,NULL,hinst,NULL);
      if (hTabWnd==NULL)
       return -1;
      SetWindowPos(hTabWnd,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
      TabCtrl_SetItemSize(hTabWnd,100,18);
      TabItem.mask=TCIF_TEXT;
      TabItem.iImage=-1;
      TabItem.pszText=(*vect)[0]->GetArguments();
      TabItem.lParam=(LPARAM)(*vect)[0];
      TabCtrl_InsertItem(hTabWnd,0,&TabItem);
      TabItem.mask=TCIF_TEXT;
      TabItem.iImage=-1;
      TabItem.pszText=(*vect)[1]->GetArguments();
      TabItem.lParam=(LPARAM)(*vect)[1];
      TabCtrl_InsertItem(hTabWnd,1,&TabItem);
      TabCtrl_SetCurFocus(hTabWnd,1);
      ShowWindow(hTabWnd,SW_SHOW);
      instold->Hide();
      inst->Show();
      inst->Focus();
      SetProp(hWnd,"WLXListerTabWindow",(HANDLE)hTabWnd);
      SendMessage(hWnd,WM_SIZE,NULL,MAKELPARAM(rect.right-rect.left,rect.bottom-rect.top));
      wlx2far_ShowLister();
      break;
     }
     if (vect->size()>1)
     {
      SetFileApisToANSI();
      WLXPluginInstance* inst=new WLXPluginInstance(*it,PluginArgs);
      WLXPluginInstance* instold=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
      if (inst->Load(hWnd))
      {
       RECT rect;
       vect->push_back(inst);
       GetClientRect(hWnd,&rect);
       SetProp(hWnd,"WLXListerTab",(HANDLE)inst);
      }
      else
      {
       delete inst;
       break;
      }
      Sleep(100);
      SetFileApisToOEM();
      RECT rect;
      TC_ITEM TabItem;
      GetClientRect(hWnd,&rect);
      HWND hTabWnd=(HWND)GetProp(hWnd,"WLXListerTabWindow");
      SetWindowPos(hTabWnd,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
      TabItem.mask=TCIF_TEXT;
      TabItem.iImage=-1;
      TabItem.pszText=(*vect)[vect->size()-1]->GetArguments();
      TabItem.lParam=(LPARAM)(*vect)[vect->size()-1];
      TabCtrl_InsertItem(hTabWnd,vect->size()-1,&TabItem);
      TabCtrl_SetCurFocus(hTabWnd,vect->size()-1);
      instold->Hide();
      inst->Show();
      inst->Focus();
      SendMessage(hWnd,WM_SIZE,NULL,MAKELPARAM(rect.right-rect.left,rect.bottom-rect.top));
      wlx2far_ShowLister();
      break;
     }
    }
   if (!found)
   {
    if (wParam==0)
    {
     sprintf(buffer1,"%s\n%s","wlx plugin not found",PluginName);
     Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)buffer1,0,0);
    }
    return -1;
   }
   return 0;
  }
  case WM_WLXLISTERCLOSE:
  {
   HWND hTabWnd=(HWND)GetProp(hWnd,"WLXListerTabWindow");
   WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
   std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd,"WLXLister");
   if ((tabinst!=NULL)&&(vect!=NULL))
   {
    bool end=false;
    while (!end)
    {
     unsigned i=0;
     end=true;
     for (std::vector<WLXPluginInstance*>::iterator it=vect->begin();it!=vect->end();it++,i++)
      if (_stricmp((*it)->GetPlugin()->GetName(),PluginName)==0)
      {
       if (vect->size()>1)
        TabCtrl_SetCurFocus(hTabWnd,i);
       SendMessage(hWnd,WM_WLXLISTERCURDEL,0,0);
       end=false;
       break;
      }
    }
    if (vect->size()>1)
     for (unsigned i=0;i<vect->size();i++)
      if ((*vect)[i]==tabinst)
       TabCtrl_SetCurFocus(hTabWnd,i);
   }
   return 0;
  }
  case WM_WLXLISTERNEXT:
  {
   HWND hTabWnd=(HWND)GetProp(hWnd,"WLXListerTabWindow");
   WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
   std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd,"WLXLister");
   if ((hTabWnd!=NULL)&&(tabinst!=NULL)&&(vect!=NULL))
   {
    for (unsigned i=0;i<vect->size();i++)
     if ((*vect)[i]==tabinst)
     {
      if (i==vect->size()-1)
       TabCtrl_SetCurFocus(hTabWnd,0);
      else
       TabCtrl_SetCurFocus(hTabWnd,i+1);
      break;
     }
   }
   return 0;
  }
  case WM_WLXLISTERALLDEL:
  {
   std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd,"WLXLister");
   if (vect!=NULL)
   {
    if (vect->size()>1)
    {
     HWND hTabWnd=(HWND)GetProp(hWnd,"WLXListerTabWindow");
     if (hTabWnd!=NULL)
     {
      TabCtrl_DeleteAllItems(hTabWnd);
      DestroyWindow(hTabWnd);
     }
     RemoveProp(hWnd,"WLXListerTabWindow");
    }
    for (std::vector<WLXPluginInstance*>::iterator it=vect->begin();it!=vect->end();it++)
    {
     (*it)->Hide();
     (*it)->Close();
     delete *it;
    }
    vect->clear();
    delete vect;
    RemoveProp(hWnd,"WLXLister");
    RemoveProp(hWnd,"WLXListerTab");
   }
   SetWindowText(hWnd,"wlx2far lister");
   SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
   return 0;
  }
  case WM_WLXLISTERCURDEL:
  {
   HWND hTabWnd=(HWND)GetProp(hWnd,"WLXListerTabWindow");
   WLXPluginInstance* tabinst=(WLXPluginInstance*)GetProp(hWnd,"WLXListerTab");
   std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd,"WLXLister");
   if ((tabinst!=NULL)&&(vect!=NULL))
    if (vect->size()>0)
    {
     unsigned i;
     unsigned CurPlugin=(vect->size()>1)?TabCtrl_GetCurFocus(hTabWnd):0;
     unsigned NewPlugin=0;
     // Find new current plugin
     for (i=0;i<vect->size();i++)
      if (i==CurPlugin)
      {
       NewPlugin=i;
       if (NewPlugin+1>=vect->size())
        NewPlugin--;
       break;
      }
     i=0;
     for (std::vector<WLXPluginInstance*>::iterator it=vect->begin();it!=vect->end();it++,i++)
      if (i==CurPlugin)
      {
       (*it)->Hide();
       (*it)->Close();
       delete *it;
       vect->erase(it);
       break;
      }
     if (vect->size()>0)
     {
      RECT rect;
      GetClientRect(hWnd,&rect);
      (*vect)[NewPlugin]->Show();
      (*vect)[NewPlugin]->Focus();
      (*vect)[NewPlugin]->Size(rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top);
      SetWindowText(hWnd,(*vect)[NewPlugin]->GetArguments());
      SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
     }
     else
     {
      SetWindowText(hWnd,"wlx2far lister");
      SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
     }
     if (vect->size()>1)
     {
      TabCtrl_DeleteItem(hTabWnd,CurPlugin);
      TabCtrl_SetCurSel(hTabWnd,NewPlugin);
     }
     if (vect->size()==1)
     {
      SetProp(hWnd,"WLXListerTabWindow",NULL);
      TabCtrl_DeleteAllItems(hTabWnd);
      DestroyWindow(hTabWnd);
     }
     RECT rect;
     GetClientRect(hWnd,&rect);
     SetProp(hWnd,"WLXListerTab",(HANDLE)((vect->size()>0)?(*vect)[NewPlugin]:NULL));
     SendMessage(hWnd,WM_SIZE,NULL,MAKELPARAM(rect.right-rect.left,rect.bottom-rect.top));
    }
   return 0;
  }
  case WM_WLXOPEN:
  {
   Info.FSF->Unquote(PluginArgs);
   Info.FSF->ExpandEnvironmentStr(PluginArgs,PluginArgs,MYMAXPATH);
   OemToChar(PluginArgs,PluginArgs);
   SetWindowText(hWnd,PluginArgs);
   SendMessage(hWnd,WM_NCPAINT,NULL,NULL);
   SendMessage(hWnd,WM_WLXDELETE,NULL,NULL);
   if (PluginName[0]=='?')
   {
    bool found=false;
    for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    {
     if (((*it)->IsValid())&&(Info.FSF->ProcessName((*it)->GetMask(),PluginArgs,PN_CMPNAMELIST|PN_SKIPPATH)==TRUE))
     {
      strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
      found=true;
      break;
     }
    }
    if (!found)
     for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
     {
      if (((*it)->IsValid())&&((*it)->IsSupportedMask(PluginArgs)))
      {
       strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
       found=true;
       break;
      }
     }
    if (!found)
    {
     int length=0;
     FILE* inifile;
     inifile=fopen(PluginName,"rb");
     if (inifile!=NULL)
     {
      length=(int)fread(hugebuffer,1,2048,inifile);
      fclose(inifile);
     }
     for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
     {
      if (((*it)->IsValid())&&((*it)->IsSupported(PluginArgs,hugebuffer,length)))
      {
       strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
       found=true;
       break;
      }
     }
    }
    if (!found)
    {
     if (wParam==0)
     {
      if (hWnd==hWnd_LQViewer)
       wlx2far_ShowQViewer(true);
      if (hWnd==hWnd_RQViewer)
       wlx2far_ShowQViewer(false);
     }
     return -1;
    }
   }
   for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    if (((*it)->IsValid())&&(_stricmp((*it)->GetAlias(),PluginName)==0))
    {
     strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
     break;
    }
   bool found=false;
   for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    if (((*it)->IsValid())&&(_stricmp((*it)->GetName(),PluginName)==0))
    {
     found=true;
     WLXPluginInstance* inst=new WLXPluginInstance(*it,PluginArgs);
     SetFileApisToANSI();
     if (inst->Load(hWnd))
     {
      RECT rect;
      GetClientRect(hWnd,&rect);
      SetProp(hWnd,"WLXQView",(HANDLE)inst);
      SendMessage(hWnd,WM_SIZE,NULL,MAKELPARAM(rect.right-rect.left,rect.bottom-rect.top));
     }
     else
      delete inst;
     Sleep(100);
     SetFileApisToOEM();
     break;
    }
   if (hWnd==hWnd_LQViewer)
    wlx2far_ShowQViewer(true);
   if (hWnd==hWnd_RQViewer)
    wlx2far_ShowQViewer(false);
   return 0;
  }
  case WM_WLXCLOSE:
  {
   WLXPluginInstance* inst=(WLXPluginInstance*)GetProp(hWnd,"WLXQView");
   if (inst!=NULL)
   {
    if (_stricmp(inst->GetPlugin()->GetName(),PluginName)==0)
    {
     SendMessage(hWnd,WM_WLXDELETE,NULL,NULL);
     SendMessage(hWnd,WM_CLOSE,NULL,NULL);
    }
   }
   return 0;
  }
  case WM_WLXDELETE:
  {
   WLXPluginInstance* inst=(WLXPluginInstance*)GetProp(hWnd,"WLXQView");
   if (inst!=NULL)
   {
    inst->Close();
    delete inst;
    RemoveProp(hWnd,"WLXQView");
   }
   InvalidateRect(hWnd,NULL,TRUE);
   return 0;
  }
  case WM_WLXDUBLICATE:
  {
   strcpy(PluginName,"");
   strcpy(PluginArgs,"");
   WLXPluginInstance* inst=(WLXPluginInstance*)GetProp(hWnd,"WLXQView");
   if (inst!=NULL)
   {
    strcpy(PluginName,inst->GetPlugin()->GetName());
    strcpy(PluginArgs,inst->GetArguments());
   }
   return 0;
  }
  case WM_LQVIEW_OPEN:
  case WM_RQVIEW_OPEN:
  {
   LRESULT res=-1;
   bool left=(iMsg==WM_LQVIEW_OPEN);
   GetRegKey(HKEY_CURRENT_USER,"","PluginPath",buffer1,"",MYMAXPATH);
   if ((lParam==GetCurrentProcessId())&&(strcmp(buffer1,"")!=0))
   {
    strcat(buffer1,"\\wlx2far.tmp");
    FILE* inifile;
    inifile=fopen(buffer1,"rt");
    if (inifile!=NULL)
    {
     fgets(PluginName,MYMAXPATH,inifile);
     fgets(PluginArgs,MYMAXPATH,inifile);
     if (((left)&&(visible_LQViewer))||((!left)&&(visible_RQViewer)))
      res=SendMessage((left)?hWnd_LQViewer:hWnd_RQViewer,WM_WLXOPEN,1,NULL);
     else
      if (wlx2far_OpenQViewer(left,true))
       res=0;
     fclose(inifile);
    }
   }
   return res;
  }
  case WM_LQVIEW_CLOSE:
  case WM_RQVIEW_CLOSE:
  {
   if (lParam==GetCurrentProcessId())
   {
    wlx2far_CloseQViewer((iMsg==WM_LQVIEW_CLOSE));
    return 0;
   }
   else
    return -1;
  }
  case WM_LQVIEW_FOCUS:
  case WM_RQVIEW_FOCUS:
  {
   if (lParam==GetCurrentProcessId())
   {
    wlx2far_FocusQViewer((iMsg==WM_LQVIEW_FOCUS));
    return 0;
   }
   else
    return -1;
  }
  case WM_LQVIEW_SHOW:
  case WM_RQVIEW_SHOW:
  {
   if (lParam==GetCurrentProcessId())
   {
    wlx2far_ShowQViewer((iMsg==WM_LQVIEW_SHOW));
    return 0;
   }
   else
    return -1;
  }
  case WM_LQVIEW_HIDE:
  case WM_RQVIEW_HIDE:
  {
   if (lParam==GetCurrentProcessId())
   {
    wlx2far_HideQViewer((iMsg==WM_LQVIEW_HIDE));
    return 0;
   }
   else
    return -1;
  }
  case WM_LISTER_OPEN:
  {
   LRESULT res=-1;
   GetRegKey(HKEY_CURRENT_USER,"","PluginPath",buffer1,"",MYMAXPATH);
   if ((lParam==GetCurrentProcessId())&&(strcmp(buffer1,"")!=0))
   {
    strcat(buffer1,"\\wlx2far.tmp");
    FILE* inifile;
    inifile=fopen(buffer1,"rt");
    if (inifile!=NULL)
    {
     fgets(PluginName,MYMAXPATH,inifile);
     fgets(PluginArgs,MYMAXPATH,inifile);
     if (wlx2far_OpenLister(true))
      res=0;
     fclose(inifile);
    }
   }
   return res;
  }
  case WM_LISTER_CLOSEALL:
  {
   if (lParam==GetCurrentProcessId())
   {
    SendMessage(hWnd_Lister,WM_WLXLISTERALLDEL,0,0);
    return 0;
   }
   else
    return -1;
  }
  case WM_LISTER_CLOSECUR:
  {
   if (lParam==GetCurrentProcessId())
   {
    SendMessage(hWnd_Lister,WM_WLXLISTERCURDEL,0,0);
    return 0;
   }
   else
    return -1;
  }
  case WM_LISTER_SHOW:
  {
   if (lParam==GetCurrentProcessId())
   {
    wlx2far_ShowLister();
    return 0;
   }
   else
    return -1;
  }
  case WM_LISTER_HIDE:
  {
   if (lParam==GetCurrentProcessId())
   {
    wlx2far_HideLister();
    return 0;
   }
   else
    return -1;
  }
  case WM_LISTER_PIN:
  {
   if (lParam==GetCurrentProcessId())
   {
    wlx2far_PinLister(true);
    return 0;
   }
   else
    return -1;
  }
  case WM_LISTER_UNPIN:
  {
   if (lParam==GetCurrentProcessId())
   {
    wlx2far_PinLister(false);
    return 0;
   }
   else
    return -1;
  }
 }
 return DefWindowProc(hWnd,iMsg,wParam,lParam);
}
/*============================================================================*/
