/*
    WLX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                    WLX2FAR CONSOLE WINDOW PROCEDURE                        //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wlx2far                                                           //
// PART:    Console window procedure                                          //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wlx2far.h>
/*============================================================================*/
LRESULT CALLBACK Wnd_Console(HWND hWnd,UINT iMsg,WPARAM wParam,LPARAM lParam)
{
 // Lock function
 Defender lock;
 static RECT cacherect,rect;
 switch (iMsg)
 {
  case WM_CREATE:
  {
   cacherect.left=0;
   cacherect.right=0;
   cacherect.top=0;
   cacherect.bottom=0;
   return 0;
  }
  case WM_LBUTTONDBLCLK:
  case WM_LBUTTONDOWN:
  case WM_LBUTTONUP:
  case WM_MBUTTONDBLCLK:
  case WM_MBUTTONDOWN:
  case WM_MBUTTONUP:
  case WM_RBUTTONDBLCLK:
  case WM_RBUTTONDOWN:
  case WM_RBUTTONUP:
  case WM_NCLBUTTONDBLCLK:
  case WM_NCLBUTTONDOWN:
  case WM_NCLBUTTONUP:
  case WM_NCMBUTTONDBLCLK:
  case WM_NCMBUTTONDOWN:
  case WM_NCMBUTTONUP:
  case WM_NCRBUTTONDBLCLK:
  case WM_NCRBUTTONDOWN:
  case WM_NCRBUTTONUP:
  {
   SetForegroundWindow(GetParent(hWnd));
   SendMessage(GetParent(hWnd),iMsg,wParam,lParam);
   return 0;
  }
  case WM_MOUSEHOVER:
  case WM_MOUSELEAVE:
  case WM_MOUSEMOVE:
  case WM_MOUSEWHEEL:
  {
   SendMessage(GetParent(hWnd),iMsg,wParam,lParam);
   return 0;
  }
  case WM_MOVE:
  case WM_SIZE:
  case WM_PAINT:
  {
   LRESULT res=0;
   GetWindowRect(hWnd_Global,&rect);
   if ((rect.left!=cacherect.left)||(rect.right!=cacherect.right)||(rect.top!=cacherect.top)||(rect.bottom!=cacherect.bottom))
   {
    MoveWindow(hWnd,0,0,rect.right-rect.left,rect.bottom-rect.top,TRUE);
    cacherect=rect;
   }
   else
   {
    if (iMsg==WM_PAINT)
    {
     PAINTSTRUCT ps;
     BeginPaint(hWnd,&ps);
     EndPaint(hWnd,&ps);
    }
    else
     res=DefWindowProc(hWnd,iMsg,wParam,lParam);
   }
   POINT p1,p2;
   GetClientRect(hWnd_Global,&rect);
   p1.x=rect.left;
   p1.y=rect.top;
   p2.x=rect.right;
   p2.y=rect.bottom;
   ClientToScreen(hWnd_Global,&p1);
   ClientToScreen(hWnd_Global,&p2);
   if (pinlister)
   {
    MoveWindow(hWnd_Lister,p1.x,p1.y,p2.x-p1.x,p2.y-p1.y,TRUE);
    if (resore_Lister)
    {
     resore_Lister=false;
     wlx2far_ShowLister();
    }
   }
   if (resore_LQViewer)
   {
    resore_LQViewer=false;
    wlx2far_ShowQViewer(true);
   }
   if (resore_RQViewer)
   {
    resore_RQViewer=false;
    wlx2far_ShowQViewer(false);
   }
   if ((visible_LQViewer)||(visible_RQViewer))
   {
    PanelInfo PInfo;
    if (Info.Control(INVALID_HANDLE_VALUE,FCTL_CHECKPANELSEXIST,&PInfo)==TRUE)
    {
     RECT rect1,rect2;
     Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELSHORTINFO,&PInfo);
     rect1.left=PInfo.PanelRect.left;
     rect1.right=PInfo.PanelRect.right;
     rect1.top=PInfo.PanelRect.top;
     rect1.bottom=PInfo.PanelRect.bottom;
     Info.Control(INVALID_HANDLE_VALUE,FCTL_GETANOTHERPANELSHORTINFO,&PInfo);
     if (PInfo.PanelRect.left<rect1.left)
     {
      rect2.left=rect1.left;
      rect2.right=rect1.right;
      rect2.top=rect1.top;
      rect2.bottom=rect1.bottom;
      rect1.left=PInfo.PanelRect.left;
      rect1.right=PInfo.PanelRect.right;
      rect1.top=PInfo.PanelRect.top;
      rect1.bottom=PInfo.PanelRect.bottom;
     }
     else
     {
      rect2.left=PInfo.PanelRect.left;
      rect2.right=PInfo.PanelRect.right;
      rect2.top=PInfo.PanelRect.top;
      rect2.bottom=PInfo.PanelRect.bottom;
     }
     // Calculating actual panel sizes (like in PicView Advanced plugin by Alex Yaroslavsky & Vadim Yegorov)
     {
      static OSVERSIONINFO Version;
      Version.dwOSVersionInfoSize=sizeof(Version);
      GetVersionEx(&Version);
      HWND hWnd_FAR;
      if(Version.dwPlatformId==VER_PLATFORM_WIN32_NT)
       hWnd_FAR=(HWND)Info.AdvControl(Info.ModuleNumber,ACTL_GETFARHWND,0);
      else
       hWnd_FAR=FindWindowEx(FindWindow("tty",0),NULL,"ttyGrab",NULL);
      RECT farrect;
      CONSOLE_SCREEN_BUFFER_INFO info;
      GetClientRect(hWnd_FAR,&farrect);
      GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE),&info);
      int dx=farrect.right/(info.srWindow.Right-info.srWindow.Left);
      int dy=farrect.bottom/(info.srWindow.Bottom-info.srWindow.Top);
      rect1.left=dx*(rect1.left-info.srWindow.Left);
      rect1.right=dx*(rect1.right+1-info.srWindow.Left);
      rect1.top=dy*(rect1.top-info.srWindow.Top);
      rect1.bottom=dy*(rect1.bottom+1-info.srWindow.Top);
      rect2.left=dx*(rect2.left-info.srWindow.Left);
      rect2.right=dx*(rect2.right+1-info.srWindow.Left);
      rect2.top=dy*(rect2.top-info.srWindow.Top);
      rect2.bottom=dy*(rect2.bottom+1-info.srWindow.Top);
     }
     // End snapshoot
     if (visible_LQViewer)
      MoveWindow(hWnd_LQViewer,p1.x+rect1.left,p1.y,rect1.right-rect1.left,rect1.bottom-rect1.top,TRUE);
     if (visible_RQViewer)
      MoveWindow(hWnd_RQViewer,p1.x+rect2.left,p1.y,rect2.right-rect2.left,rect2.bottom-rect2.top,TRUE);
    }
    else
    {
     if (visible_LQViewer)
      MoveWindow(hWnd_LQViewer,p1.x,p1.y,(p2.x-p1.x)/2,p2.y-p1.y-25,TRUE);
     if (visible_RQViewer)
      MoveWindow(hWnd_RQViewer,p1.x+(p2.x-p1.x)/2,p1.y,(p2.x-p1.x)/2,p2.y-p1.y-25,TRUE);
    }
   }
   return res;
  }
 }
 return DefWindowProc(hWnd,iMsg,wParam,lParam);
}
/*============================================================================*/
