/*
    WLX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                              WLX2FAR                                       //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wlx2far                                                           //
// PART:    Main header                                                       //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#ifndef __WLX2FAR_HPP__
#define __WLX2FAR_HPP__
#define MYMAXPATH          1024
#define WM_WLXLISTEROPEN   WM_USER+0
#define WM_WLXLISTERCLOSE  WM_USER+1
#define WM_WLXLISTERNEXT   WM_USER+2
#define WM_WLXLISTERALLDEL WM_USER+3
#define WM_WLXLISTERCURDEL WM_USER+4
#define WM_WLXOPEN         WM_USER+5
#define WM_WLXCLOSE        WM_USER+6
#define WM_WLXDELETE       WM_USER+7
#define WM_WLXDUBLICATE    WM_USER+8

#define WM_LQVIEW_OPEN     WM_USER+100
#define WM_LQVIEW_CLOSE    WM_USER+101
#define WM_LQVIEW_FOCUS    WM_USER+102
#define WM_LQVIEW_SHOW     WM_USER+103
#define WM_LQVIEW_HIDE     WM_USER+104

#define WM_RQVIEW_OPEN     WM_USER+105
#define WM_RQVIEW_CLOSE    WM_USER+106
#define WM_RQVIEW_FOCUS    WM_USER+107
#define WM_RQVIEW_SHOW     WM_USER+108
#define WM_RQVIEW_HIDE     WM_USER+109

#define WM_LISTER_OPEN     WM_USER+110
#define WM_LISTER_CLOSEALL WM_USER+111
#define WM_LISTER_CLOSECUR WM_USER+112
#define WM_LISTER_SHOW     WM_USER+113
#define WM_LISTER_HIDE     WM_USER+114
#define WM_LISTER_PIN      WM_USER+115
#define WM_LISTER_UNPIN    WM_USER+116
/*============================================================================*/
#include <vector>
#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <string.h>
#include <plugin.h>
#include <resource.h>
#include <WLXplugin.h>
#include <hooks.h>
#include <wnd_console.h>
#include <wnd_viewer.h>
#include <wnd_wlxplugin.h>
/*============================================================================*/
#pragma warning(disable:4311)
#pragma warning(disable:4312)
/*============================================================================*/
#include <wlx2far-lng.h>
const char *GetMsg(int MsgId);
/*============================================================================*/
extern struct PluginStartupInfo Info;
extern struct FarStandardFunctions FSF;
extern volatile bool button[3];
extern volatile bool tooltip[3];
extern volatile bool pinlister;
extern volatile bool timerstopped;
extern volatile bool installed;
extern volatile bool toinstall;
extern volatile bool touninstall;
extern volatile bool resore_Lister;
extern volatile bool resore_LQViewer;
extern volatile bool resore_RQViewer;
extern volatile bool visible_Lister;
extern volatile bool visible_LQViewer;
extern volatile bool visible_RQViewer;
extern volatile HINSTANCE hinst;
extern volatile HWND hWnd_Global;
extern volatile HWND hWnd_Console;
extern volatile HWND hWnd_Lister;
extern volatile HWND hWnd_LQViewer;
extern volatile HWND hWnd_RQViewer;
extern std::vector<WLXPlugin*> Plugins;
extern char* WndClassName_Console;
extern char* WndClassName_Viewer;
extern char* WndClassName_WLXPlugin;
extern char PluginName[MYMAXPATH];
extern char PluginArgs[MYMAXPATH];
extern char buffer1[MYMAXPATH];
extern char buffer2[MYMAXPATH];
extern char hugebuffer[2048];
extern char PluginRootKey[80];
extern unsigned modulenamelength;
extern HHOOK hKeyHook;
extern HHOOK hSysKeyHook;
/*============================================================================*/
struct InitDialogItem
{
 int Type;
 int X1,Y1,X2,Y2;
 int Focus;
 int Selected;
 DWORD Flags;
 int DefaultButton;
 const char *Data;
 const char *History;
};
/*----------------------------------------------------------------------------*/
void InitDialogItems(const struct InitDialogItem *Init,struct FarDialogItem *Item,int ItemsNumber);
/*==========================================================================*/
class Defender
{
public:
  static bool initialize(void)
  {
    mutex = CreateMutex(NULL, FALSE, "FarConsoleMutex");
    if (mutex == NULL)
    {
      mutex = OpenMutex(MUTEX_ALL_ACCESS, TRUE, "FarConsoleMutex");
      if (mutex == NULL)
        return false;
    }
    return true;
  }
  static bool deinitialize(void)
  {
    if (mutex != NULL)
    {
      CloseHandle(mutex);
      mutex = NULL;
    }
    return true;
  }

  Defender(void)
  {
    if (mutex != NULL)
      WaitForSingleObject(mutex, INFINITE);
  }
 ~Defender(void)
  {
    if (mutex != NULL)
      ReleaseMutex(mutex);
  }

private:
  static HANDLE mutex;
};
/*==========================================================================*/
#include <registry.h>
/*============================================================================*/
bool wlx2far_Command(const char* cmd);

bool wlx2far_Install(void);
bool wlx2far_Uninstall(void);

bool wlx2far_InstallPlugin(char hotkey,char* alias,char* pluginname,char* pluginmask);
bool wlx2far_UninstallPlugin(char* pluginname);

bool wlx2far_OpenLister(bool silent=false);
bool wlx2far_ShowLister(void);
bool wlx2far_HideLister(void);
bool wlx2far_PinLister(const bool pin);
bool wlx2far_ListerResize(void);

bool wlx2far_OpenQViewer(const bool LeftQViewer,bool silent=false);
bool wlx2far_ShowQViewer(const bool LeftQViewer);
bool wlx2far_HideQViewer(const bool LeftQViewer);
bool wlx2far_FocusQViewer(const bool LeftQViewer);
bool wlx2far_CloseQViewer(const bool LeftQViewer);
/*============================================================================*/
#endif /* __WLX2FAR_HPP__ */
