/*
    WLX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                              WLX2FAR                                       //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wlx2far                                                           //
// PART:    Main part                                                         //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wlx2far.h>
/*============================================================================*/
volatile bool button[]={false,false,false};
volatile bool tooltip[]={false,false,false};
volatile bool pinlister=false;
volatile bool timerstopped=false;
volatile bool installed=false;
volatile bool toinstall=false;
volatile bool touninstall=false;
volatile bool resore_Lister=false;
volatile bool resore_LQViewer=false;
volatile bool resore_RQViewer=false;
volatile bool visible_Lister=false;
volatile bool visible_LQViewer=false;
volatile bool visible_RQViewer=false;
volatile HINSTANCE hinst=NULL;
volatile HWND hWnd_Global=NULL;
volatile HWND hWnd_Console=NULL;
volatile HWND hWnd_Lister=NULL;
volatile HWND hWnd_LQViewer=NULL;
volatile HWND hWnd_RQViewer=NULL;
std::vector<WLXPlugin*> Plugins;
char* WndClassName_Console="wlx2far";
char* WndClassName_Viewer="TTOTAL_CMD";
char* WndClassName_WLXPlugin="TLister";
char PluginName[MYMAXPATH]="";
char PluginArgs[MYMAXPATH]="";
char buffer1[MYMAXPATH]="";
char buffer2[MYMAXPATH]="";
char hugebuffer[2048]="";
char PluginRootKey[80];
unsigned modulenamelength=0;
HHOOK hKeyHook=NULL;
HHOOK hSysKeyHook=NULL;
/*============================================================================*/
HANDLE Defender::mutex = NULL;
/*==========================================================================*/
bool ShowPluginMenu(void)
{
 bool result=false;
 int BreakCode=0;
 int BreakKeys[]={VK_F4,0};
 int ExitCode;
 int SelectedItem=0;
 while (BreakCode!=-1)
 {
  FarMenuItemEx *MenuItems=new FarMenuItemEx[Plugins.size()];
  int i=0;
  for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++,i++)
  {
   MenuItems[i].Flags=((*it)->IsValid())?0:MIF_DISABLE;
   sprintf(MenuItems[i].Text.Text,"&%c %s",(*it)->GetHotkey(),(*it)->GetAlias());
   MenuItems[i].AccelKey=0;
   MenuItems[i].Reserved=0;
   MenuItems[i].UserData=0;
  }
  MenuItems[SelectedItem].Flags|=MIF_SELECTED;
  ExitCode=Info.Menu(Info.ModuleNumber,-1,-1,0,FMENU_USEEXT|FMENU_WRAPMODE,GetMsg(lngPluginNotFound),GetMsg(lngMenuBottomStringEx),NULL,BreakKeys,&BreakCode,(struct FarMenuItem *)MenuItems,(int)(Plugins.size()));
  if (ExitCode>=0)
  {
   if (BreakCode==0)
   {
    char temp[2];
    temp[0]=Plugins[ExitCode]->GetHotkey();
    temp[1]='\0';
    struct InitDialogItem InitItems[]=
    {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
     /*00*/ { DI_DOUBLEBOX,   3, 1,55,12, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngEdit),                              NULL},
     /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngPluginHotKey),                      NULL},
     /*02*/ { DI_FIXEDIT,     5, 3, 5, 3, 0, 0, 0,                                    0,      temp,                                         NULL},
     /*03*/ { DI_TEXT,        5, 4, 0, 4, 0, 0, 0,                                    0,      GetMsg(lngPluginAlias),                       NULL},
     /*04*/ { DI_EDIT,        5, 5,53, 5, 0, 0, DIF_HISTORY,                          0,      Plugins[ExitCode]->GetAlias(),                "wlx2far.History.InastallPlugin.Alias"},
     /*05*/ { DI_TEXT,        5, 6, 0, 6, 0, 0, 0,                                    0,      GetMsg(lngPluginFileName),                    NULL},
     /*06*/ { DI_EDIT,        5, 7,53, 7, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode]->GetName(),                 NULL},
     /*07*/ { DI_TEXT,        5, 8, 0, 8, 0, 0, 0,                                    0,      GetMsg(lngPluginMask),                        NULL},
     /*08*/ { DI_EDIT,        5, 9,53, 9, 1, 0, DIF_HISTORY,                          0,      Plugins[ExitCode]->GetMask(),                 "wlx2far.History.InastallPlugin.Mask"},
     /*09*/ { DI_TEXT,        0,10, 0,10, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                                           NULL},
     /*10*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),                                NULL},
     /*11*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),                            NULL}
    };
    struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
    InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
    int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,14,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
    if (n==10)
    {
     bool found=false;
     for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
      if ((_stricmp((*it)->GetAlias(),DialogItems[4].Data)==0)&&((*it)!=Plugins[ExitCode]))
      {
       found=true;
       char errormessage[256];
       sprintf(errormessage,"Alias '%s' already exist",DialogItems[4].Data);
       Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
       break;
      }
     Plugins[ExitCode]->SetHotkey((DialogItems[2].Data[0]=='\0')?' ':DialogItems[2].Data[0]);
     if (!found)
      Plugins[ExitCode]->SetAlias(DialogItems[4].Data);
     char *buf=DialogItems[8].Data;
     unsigned i,l=(unsigned)strlen(buf);
     i=l; while ((i>0)&&(isspace(buf[i-1]))) { i--; buf[i-1]='\0'; }
     i=0; while ((i<l)&&(isspace(buf[i]))) i++;
     Plugins[ExitCode]->SetMask(buf+i);
    }
   }
   if (BreakCode==1)
    BreakCode=-1;
   else
   {
    MenuItems[SelectedItem].Flags&=~MIF_SELECTED;
    SelectedItem=ExitCode;
   }
   if (BreakCode==-1)
   {
    strncpy(PluginName,Plugins[ExitCode]->GetName(),MYMAXPATH);
    result=true;
   }
  }
  delete [] MenuItems;
 }
 return result;
}
/*============================================================================*/
int WINAPI SearchFunct(const WIN32_FIND_DATA *FData,const char *FullName,void *Param)
{
 for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  if (_stricmp((*it)->GetName(),FullName)==0)
   return TRUE;
 char Alias[256];
 strncpy(Alias,Info.FSF->PointToName(FullName),256);
 bool end=false;
 while (!end)
 {
  end=true;
  for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
   if (_stricmp((*it)->GetAlias(),Alias)==0)
   {
    strcat(Alias,"_");
    end=false;
    break;
   }
 }
 SetFileApisToANSI();
 WLXPlugin* newplugin=new WLXPlugin;
 if (newplugin->Register(' ',Alias,FullName,""))
  Plugins.push_back(newplugin);
 else
  delete newplugin;
 SetFileApisToOEM();
 return TRUE;
}
/*============================================================================*/
bool wlx2far_Command(const char* cmd)
{
 if (strncmp(cmd,"wlx2far:install",strlen("wlx2far:install"))==0)
 {
  if (installed)
  {
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is already installed",0,0);
   return false;
  }
  else
  {
   toinstall=true;
   while (toinstall) Sleep(1);
   while (!installed) Sleep(1);
   return true;
  }
 }
 if (strncmp(cmd,"wlx2far:uninstall",strlen("wlx2far:uninstall"))==0)
 {
  if (!installed)
  {
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
   return false;
  }
  else
  {
   touninstall=true;
   while (touninstall) Sleep(1);
   while (installed) Sleep(1);
   return true;
  }
 }
 if (strncmp(cmd,"wlx2far:search",strlen("wlx2far:search"))==0)
 {
  if (!installed)
  {
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
   return false;
  }
  else
  {
   HANDLE hScreen=Info.SaveScreen(0,0,-1,-1);
   int i=GetRegKey(HKEY_CURRENT_USER,"","ShowStartupInfo",1);
   if (i==1)
   {
    const char *MsgItems[]={GetMsg(lngMessage),GetMsg(lngMessageScan)};
    Info.Message(Info.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(*MsgItems),0);
   }
   Info.FSF->FarRecursiveSearch(cmd+strlen("wlx2far:search")+1,"*.wlx",SearchFunct,FRS_RECUR,NULL);
   SetFileApisToANSI();
   for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    (*it)->Verify();
   SetFileApisToOEM();
   Info.RestoreScreen(hScreen);
   return true;
  }
 }
 if (strncmp(cmd,"wlx2far:plugin_install",strlen("wlx2far:plugin_install"))==0)
 {
  char alias[256];
  char pluginname[MYMAXPATH];
  char pluginmask[MYMAXPATH];
  sscanf(cmd,"wlx2far:plugin_install %s %s",alias,pluginname);
  strncpy(pluginmask,cmd+strlen("wlx2far:plugin_install")+strlen(alias)+strlen(pluginname)+3,MYMAXPATH);
  return wlx2far_InstallPlugin(' ',alias,pluginname,pluginmask);
 }
 if (strncmp(cmd,"wlx2far:plugin_uninstall",strlen("wlx2far:plugin_uninstall"))==0)
 {
  char pluginname[MYMAXPATH];
  sscanf(cmd,"wlx2far:plugin_uninstall %s",pluginname);
  return wlx2far_UninstallPlugin(pluginname);
 }
 if (strncmp(cmd,"wlx2far:lister_open",strlen("wlx2far:lister_open"))==0)
 {
  sscanf(cmd,"wlx2far:lister_open %s",PluginName);
  strncpy(PluginArgs,cmd+strlen("wlx2far:lister_open")+strlen(PluginName)+2,MYMAXPATH);
  return wlx2far_OpenLister();
 }
 if (strncmp(cmd,"wlx2far:lister_show",strlen("wlx2far:lister_show"))==0)
  return wlx2far_ShowLister();
 if (strncmp(cmd,"wlx2far:lister_hide",strlen("wlx2far:lister_hide"))==0)
  return wlx2far_HideLister();
 if (strncmp(cmd,"wlx2far:leftqviewer_open",strlen("wlx2far:leftqviewer_open"))==0)
 {
  if (!installed)
  {
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
   return false;
  }
  else
  {
   sscanf(cmd,"wlx2far:leftqviewer_open %s",PluginName);
   strncpy(PluginArgs,cmd+strlen("wlx2far:leftqviewer_open")+strlen(PluginName)+2,MYMAXPATH);
   wlx2far_OpenQViewer(true);
   return true;
  }
 }
 if (strncmp(cmd,"wlx2far:rightqviewer_open",strlen("wlx2far:rightqviewer_open"))==0)
 {
  if (!installed)
  {
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
   return false;
  }
  else
  {
   sscanf(cmd,"wlx2far:rightqviewer_open %s",PluginName);
   strncpy(PluginArgs,cmd+strlen("wlx2far:rightqviewer_open")+strlen(PluginName)+2,MYMAXPATH);
   wlx2far_OpenQViewer(false);
   return true;
  }
 }
 if (strncmp(cmd,"wlx2far:leftqviewer_focus",strlen("wlx2far:leftqviewer_focus"))==0)
  return wlx2far_FocusQViewer(true);
 if (strncmp(cmd,"wlx2far:rightqview_focus",strlen("wlx2far:rightqview_focus"))==0)
  return wlx2far_FocusQViewer(false);
 if (strncmp(cmd,"wlx2far:leftqviewer_close",strlen("wlx2far:leftqviewer_close"))==0)
  return wlx2far_CloseQViewer(true);
 if (strncmp(cmd,"wlx2far:rightqview_close",strlen("wlx2far:rightqview_close"))==0)
  return wlx2far_CloseQViewer(false);
 strcpy(PluginName,"?");
 GetCurrentDirectory(MYMAXPATH,PluginArgs);
 strcat(PluginArgs,"\\");
 strcat(PluginArgs,cmd+4);
 return wlx2far_OpenLister();
}
/*----------------------------------------------------------------------------*/
bool wlx2far_Install(void)
{
 if (installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is already installed",0,0);
  return false;
 }

 // Initialize mutex
 if (!Defender::initialize())
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't initialize console mutex",0,0);
  return false;
 }

 // Lock function
 Defender lock;

 CoInitialize(NULL);
 hKeyHook=SetWindowsHookEx(WH_KEYBOARD,Hook_KeyboardProc,(HMODULE)NULL,GetCurrentThreadId());
 if (hKeyHook==NULL)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't set windows hook 'WH_KEYBOARD'",0,0);
  return false;
 }
 hSysKeyHook=SetWindowsHookEx(WH_KEYBOARD_LL,Hook_SysKeyboardProc,hinst,0);
 if (hSysKeyHook==NULL)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't set windows hook 'WH_KEYBOARD_LL'",0,0);
  return false;
 }
 InitCommonControls();
 WNDCLASSEX WndClass;
 WndClass.cbSize        = sizeof(WndClass);
 WndClass.style         = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;
 WndClass.lpfnWndProc   = Wnd_Console;
 WndClass.cbClsExtra    = 0;
 WndClass.cbWndExtra    = 0;
 WndClass.hInstance     = hinst;
 WndClass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
 WndClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
 WndClass.hbrBackground = (HBRUSH)GetStockObject(NULL_BRUSH);
 WndClass.lpszMenuName  = NULL;
 WndClass.lpszClassName = WndClassName_Console;
 WndClass.hIconSm       = LoadIcon(NULL,IDI_APPLICATION);
 RegisterClassEx(&WndClass);
 WndClass.cbSize        = sizeof(WndClass);
 WndClass.style         = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;
 WndClass.lpfnWndProc   = Wnd_Viewer;
 WndClass.cbClsExtra    = 0;
 WndClass.cbWndExtra    = 0;
 WndClass.hInstance     = hinst;
 WndClass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
 WndClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
 WndClass.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
 WndClass.lpszMenuName  = NULL;
 WndClass.lpszClassName = WndClassName_Viewer;
 WndClass.hIconSm       = LoadIcon(NULL,IDI_APPLICATION);
 RegisterClassEx(&WndClass);
 WndClass.cbSize        = sizeof(WndClass);
 WndClass.style         = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;
 WndClass.lpfnWndProc   = Wnd_WLXPlugin;
 WndClass.cbClsExtra    = 0;
 WndClass.cbWndExtra    = 0;
 WndClass.hInstance     = hinst;
 WndClass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
 WndClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
 WndClass.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
 WndClass.lpszMenuName  = NULL;
 WndClass.lpszClassName = WndClassName_WLXPlugin;
 WndClass.hIconSm       = LoadIcon(NULL,IDI_APPLICATION);
 RegisterClassEx(&WndClass);
 // Create console window
 hWnd_Global=GetConsoleWindow();
 hWnd_Console=CreateWindow(WndClassName_Console,"",WS_CHILD|WS_CLIPSIBLINGS,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,hWnd_Global,NULL,hinst,NULL);
 if (hWnd_Console==NULL)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't create console window",0,0);
  return false;
 }
 ShowWindow(hWnd_Console,SW_SHOWMAXIMIZED);
 UpdateWindow(hWnd_Console);
 // Create lister window
 int p=GetRegKey(HKEY_CURRENT_USER,"","PinToFar",0);
 if (p==0)
 {
  RECT listerrect;
  listerrect.left=GetRegKey(HKEY_CURRENT_USER,"","lister_left",100);
  listerrect.top=GetRegKey(HKEY_CURRENT_USER,"","lister_top",100);
  listerrect.right=GetRegKey(HKEY_CURRENT_USER,"","lister_right",500);
  listerrect.bottom=GetRegKey(HKEY_CURRENT_USER,"","lister_bottom",400);
  hWnd_Lister=CreateWindowEx(0,WndClassName_Viewer,"wlx2far lister",WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN|WS_CLIPSIBLINGS,listerrect.left,listerrect.top,listerrect.right-listerrect.left,listerrect.bottom-listerrect.top,NULL,NULL,hinst,NULL);
 }
 else
  hWnd_Lister=CreateWindowEx(WS_EX_TOOLWINDOW,WndClassName_Viewer,"wlx2far lister",WS_CAPTION|WS_THICKFRAME|WS_SYSMENU|WS_CLIPCHILDREN|WS_CLIPSIBLINGS,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,NULL,NULL,hinst,NULL);
 if (hWnd_Lister==NULL)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't create lister window",0,0);
  return false;
 }
 ShowWindow(hWnd_Lister,SW_HIDE);
 UpdateWindow(hWnd_Lister);
 // Create QView windows
 hWnd_LQViewer=CreateWindowEx(WS_EX_TOOLWINDOW,WndClassName_Viewer,"wlx2far left quick viewer",WS_CAPTION|WS_SYSMENU|WS_CLIPCHILDREN|WS_CLIPSIBLINGS,10000,10000,11000,11000,NULL,NULL,hinst,NULL);
 if (hWnd_LQViewer==NULL)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't create left quick viewer window",0,0);
  return false;
 }
 ShowWindow(hWnd_LQViewer,SW_HIDE);
 UpdateWindow(hWnd_LQViewer);
 hWnd_RQViewer=CreateWindowEx(WS_EX_TOOLWINDOW,WndClassName_Viewer,"wlx2far right quick viewer",WS_CAPTION|WS_SYSMENU|WS_CLIPCHILDREN|WS_CLIPSIBLINGS,10000,10000,11000,11000,NULL,NULL,hinst,NULL);
 if (hWnd_RQViewer==NULL)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't create right quick viewer window",0,0);
  return false;
 }
 ShowWindow(hWnd_RQViewer,SW_HIDE);
 UpdateWindow(hWnd_RQViewer);

 FILE* inifile;
 char hotkey;
 char alias[256];
 char inifilename[MYMAXPATH];
 char fullpluginname[MYMAXPATH];
 GetModuleFileName(hinst,inifilename,MYMAXPATH);
 inifilename[strlen(inifilename)-1]='i';
 inifilename[strlen(inifilename)-2]='n';
 inifilename[strlen(inifilename)-3]='i';
 inifile=fopen(inifilename,"rb");
 if (inifile!=NULL)
 {
  while (fgets(inifilename,MYMAXPATH,inifile)!=NULL)
  {
   for (unsigned i=0;i<strlen(inifilename);i++)
    if ((inifilename[i]=='\r')||(inifilename[i]=='\n'))
    {
     inifilename[i]='\0';
     break;
    }
   if (inifilename[0]!='#')
   {
    unsigned i,j=0;
    sscanf(inifilename,"%c - %s ? ",&hotkey,&alias);
    i=(unsigned)(strlen(alias)+6);
    while (inifilename[++i]!='?')
     fullpluginname[j++]=inifilename[i];
    fullpluginname[j-1]='\0';
    bool exist=false;
    for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    {
     if ((_stricmp((*it)->GetAlias(),alias)==0)&&(_stricmp((*it)->GetName(),fullpluginname)==0))
     {
      exist=true;
      break;
     }
    }
    if (exist)
    {
     sprintf(inifilename,"Plugin '%s' already exist",fullpluginname);
     Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)inifilename,0,0);
    }
    else
    {
     bool end=false;
     while (!end)
     {
      end=true;
      for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
       if (_stricmp((*it)->GetAlias(),alias)==0)
       {
        strcat(alias,"_");
        end=false;
        break;
       }
     }
     SetFileApisToANSI();
     WLXPlugin* newplugin=new WLXPlugin;
     if (newplugin->Register(hotkey,alias,fullpluginname,inifilename+i+2))
      Plugins.push_back(newplugin);
     else
     {
      sprintf(inifilename,"Can't register default plugin '%s'",fullpluginname);
      Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)inifilename,0,0);
      delete newplugin;
     }
     SetFileApisToOEM();
    }
   }
  }
  fclose(inifile);
 }
 installed=true;
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_Uninstall(void)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }

 if (UnhookWindowsHookEx(hKeyHook)==FALSE)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't delete windows hook 'WH_KEYBOARD'",0,0);
  return false;
 }
 if (UnhookWindowsHookEx(hSysKeyHook)==FALSE)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't delete windows hook 'WH_KEYBOARD_LL''",0,0);
  return false;
 }
 wlx2far_CloseQViewer(true);
 wlx2far_CloseQViewer(false);
 DestroyWindow(hWnd_LQViewer);
 DestroyWindow(hWnd_RQViewer);
 DestroyWindow(hWnd_Lister);
 DestroyWindow(hWnd_Console);
 UnregisterClass(WndClassName_WLXPlugin,hinst);
 UnregisterClass(WndClassName_Viewer,hinst);
 UnregisterClass(WndClassName_Console,hinst);
 for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
 {
  (*it)->UnRegister();
  delete *it;
 }
 Plugins.clear();
 CoUninitialize();
 // Deinitialize mutex
 if (!Defender::deinitialize())
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't deinitialize console mutex",0,0);
  return false;
 }
 installed=false;
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_InstallPlugin(char hotkey,char* alias,char* pluginname,char* pluginmask)
{
 char errormessage[MYMAXPATH];
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 bool exist=false;
 for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  if ((_stricmp((*it)->GetAlias(),alias)==0)&&(_stricmp((*it)->GetName(),pluginname)==0))
  {
   exist=true;
   break;
  }
 if (exist)
 {
  sprintf(errormessage,"Plugin '%s' already exist",alias);
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
  return false;
 }
 else
 {
  char Alias[256];
  strncpy(Alias,alias,256);
  bool end=false;
  while (!end)
  {
   end=true;
   for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    if (_stricmp((*it)->GetAlias(),Alias)==0)
    {
     strcat(Alias,"_");
     end=false;
     break;
    }
  }
  SetFileApisToANSI();
  WLXPlugin* newplugin=new WLXPlugin;
  if (newplugin->Register(hotkey,Alias,pluginname,pluginmask)&&(newplugin->Verify()))
   Plugins.push_back(newplugin);
  else
  {
   sprintf(errormessage,"Can't instal plugin '%s'",pluginname);
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
   delete newplugin;
   SetFileApisToOEM();
   return false;
  }
  SetFileApisToOEM();
 }
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_UninstallPlugin(char* pluginname)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 strncpy(PluginName,pluginname,MYMAXPATH);
 for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  if (_stricmp((*it)->GetAlias(),pluginname)==0)
  {
   strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
   break;
  }
 SendMessage(hWnd_Lister,WM_WLXLISTERCLOSE,NULL,NULL);
 SendMessage(hWnd_LQViewer,WM_WLXCLOSE,NULL,NULL);
 SendMessage(hWnd_RQViewer,WM_WLXCLOSE,NULL,NULL);
 for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  if ((_stricmp((*it)->GetAlias(),pluginname)==0)||(_stricmp((*it)->GetName(),pluginname)==0))
  {
   if (!(*it)->UnRegister())
   {
    char errormessage[MYMAXPATH];
    sprintf(errormessage,"Can't unregister plugin '%s'",pluginname);
    Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
    return false;
   }
   else
   {
    delete *it;
    Plugins.erase(it);
   }
   break;
  }
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_OpenLister(bool silent)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 std::vector<WLXPluginInstance*> *vect=(std::vector<WLXPluginInstance*>*)GetProp(hWnd_Lister,"WLXLister");
 if (vect==NULL)
 {
  vect=new std::vector<WLXPluginInstance*>;
  SetProp(hWnd_Lister,"WLXLister",(HANDLE)vect);
 }
 Info.FSF->Unquote(PluginArgs);
 Info.FSF->ExpandEnvironmentStr(PluginArgs,PluginArgs,MYMAXPATH);
 OemToChar(PluginArgs,PluginArgs);
 SetWindowText(hWnd_Lister,PluginArgs);
 SendMessage(hWnd_Lister,WM_NCPAINT,NULL,NULL);
 for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  if (((*it)->IsValid())&&(_stricmp((*it)->GetAlias(),PluginName)==0))
  {
   strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
   break;
  }
 if (PluginName[0]=='?')
 {
  bool found=false;
  for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  {
   if (((*it)->IsValid())&&(Info.FSF->ProcessName((*it)->GetMask(),PluginArgs,PN_CMPNAMELIST|PN_SKIPPATH)==TRUE))
   {
    strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
    found=true;
    break;
   }
  }
  if (!found)
   for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
   {
    if (((*it)->IsValid())&&((*it)->IsSupportedMask(PluginArgs)))
    {
     strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
     found=true;
     break;
    }
   }
  if (!found)
  {
   int length=0;
   FILE* inifile;
   inifile=fopen(PluginName,"rb");
   if (inifile!=NULL)
   {
    length=(int)fread(hugebuffer,1,2048,inifile);
    fclose(inifile);
   }
   for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
   {
    if (((*it)->IsValid())&&((*it)->IsSupported(PluginArgs,hugebuffer,length)))
    {
     strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
     found=true;
     break;
    }
   }
  }
  if (!found)
  {
   if (silent)
    return false;
   if (!ShowPluginMenu())
    return false;
  }
 }
 return (SendMessage(hWnd_Lister,WM_WLXLISTEROPEN,silent?1:0,NULL)==0);
}
/*----------------------------------------------------------------------------*/
bool wlx2far_ShowLister(void)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 ShowWindow(hWnd_Lister,SW_SHOW);
 SetForegroundWindow(hWnd_Lister);
 SetFocus(hWnd_Lister);
 if (pinlister)
  InvalidateRect(hWnd_Console,NULL,FALSE);
 visible_Lister=true;
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_HideLister(void)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 ShowWindow(hWnd_Lister,SW_HIDE);
 visible_Lister=false;
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_PinLister(const bool pin)
{
 RECT listerrect;
 if (visible_Lister)
  ShowWindow(hWnd_Lister,SW_HIDE);
 if ((pin)&&(!pinlister))
 {
  GetWindowRect(hWnd_Lister,&listerrect);
  SetRegKey(HKEY_CURRENT_USER,"","lister_left",listerrect.left);
  SetRegKey(HKEY_CURRENT_USER,"","lister_top",listerrect.top);
  SetRegKey(HKEY_CURRENT_USER,"","lister_right",listerrect.right);
  SetRegKey(HKEY_CURRENT_USER,"","lister_bottom",listerrect.bottom);
 }
 pinlister=pin;
 SetRegKey(HKEY_CURRENT_USER,"","PinToFar",pin?1:0);
 if (pinlister)
 {
  LONG style=WS_CAPTION|WS_THICKFRAME|WS_SYSMENU|WS_CLIPCHILDREN|WS_CLIPSIBLINGS;
  LONG styleex=WS_EX_TOOLWINDOW;
  SetWindowLong(hWnd_Lister,GWL_STYLE,style);
  SetWindowLong(hWnd_Lister,GWL_EXSTYLE,styleex);
  SetWindowPos(hWnd_Lister,NULL,0,0,0,0,SWP_FRAMECHANGED|SWP_NOMOVE|SWP_NOSIZE);
 }
 else
 {
  LONG style=WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN|WS_CLIPSIBLINGS;
  LONG styleex=0;
  listerrect.left=GetRegKey(HKEY_CURRENT_USER,"","lister_left",100);
  listerrect.top=GetRegKey(HKEY_CURRENT_USER,"","lister_top",100);
  listerrect.right=GetRegKey(HKEY_CURRENT_USER,"","lister_right",500);
  listerrect.bottom=GetRegKey(HKEY_CURRENT_USER,"","lister_bottom",400);
  SetWindowLong(hWnd_Lister,GWL_STYLE,style);
  SetWindowLong(hWnd_Lister,GWL_EXSTYLE,styleex);
  SetWindowPos(hWnd_Lister,NULL,listerrect.left,listerrect.top,listerrect.right-listerrect.left,listerrect.bottom-listerrect.top,SWP_FRAMECHANGED);
 }
 if (visible_Lister)
  ShowWindow(hWnd_Lister,SW_SHOW);
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_ListerResize(void)
{
 if ((visible_Lister)&&(!pinlister))
 {
  RECT listerrect;
  GetWindowRect(hWnd_Lister,&listerrect);
  SetRegKey(HKEY_CURRENT_USER,"","lister_left",listerrect.left);
  SetRegKey(HKEY_CURRENT_USER,"","lister_top",listerrect.top);
  SetRegKey(HKEY_CURRENT_USER,"","lister_right",listerrect.right);
  SetRegKey(HKEY_CURRENT_USER,"","lister_bottom",listerrect.bottom);
 }
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_OpenQViewer(const bool LeftQViewer,bool silent)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 if ((LeftQViewer)&&(!visible_LQViewer))
  if (visible_RQViewer)
   SendMessage(hWnd_RQViewer,WM_WLXDUBLICATE,NULL,NULL);
 if ((!LeftQViewer)&&(!visible_RQViewer))
  if (visible_LQViewer)
   SendMessage(hWnd_LQViewer,WM_WLXDUBLICATE,NULL,NULL);
 bool res=(SendMessage(LeftQViewer?hWnd_LQViewer:hWnd_RQViewer,WM_WLXOPEN,silent?1:0,NULL)==0);
 SetForegroundWindow(hWnd_Global);
 SetFocus(hWnd_Global);
 if ((LeftQViewer)&&(visible_RQViewer))
  wlx2far_FocusQViewer(!LeftQViewer);
 if ((!LeftQViewer)&&(visible_LQViewer))
  wlx2far_FocusQViewer(LeftQViewer);
 return res;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_ShowQViewer(const bool LeftQViewer)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 if (LeftQViewer)
  visible_LQViewer=true;
 else
  visible_RQViewer=true;
 InvalidateRect(hWnd_Console,NULL,FALSE);
 if (LeftQViewer)
 {
  ShowWindow(hWnd_LQViewer,SW_SHOW);
  SetWindowPos(hWnd_LQViewer,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
 }
 else
 {
  ShowWindow(hWnd_RQViewer,SW_SHOW);
  SetWindowPos(hWnd_RQViewer,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
 }
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_HideQViewer(const bool LeftQViewer)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 if (LeftQViewer)
 {
  ShowWindow(hWnd_LQViewer,SW_HIDE);
  visible_LQViewer=false;
 }
 else
 {
  ShowWindow(hWnd_RQViewer,SW_HIDE);
  visible_RQViewer=false;
 }
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_FocusQViewer(const bool LeftQViewer)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 if (LeftQViewer)
 {
  SetForegroundWindow(hWnd_LQViewer);
  SetFocus(hWnd_LQViewer);
 }
 else
 {
  SetForegroundWindow(hWnd_RQViewer);
  SetFocus(hWnd_RQViewer);
 }
 return true;
}
/*----------------------------------------------------------------------------*/
bool wlx2far_CloseQViewer(const bool LeftQViewer)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
  return false;
 }
 SendMessage(LeftQViewer?hWnd_LQViewer:hWnd_RQViewer,WM_WLXDELETE,NULL,NULL);
 return wlx2far_HideQViewer(LeftQViewer);
}
/*============================================================================*/
