/*
    WLX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                            WLX2FAR PLUGIN                                  //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wlx2far                                                           //
// PART:    FAR plugin                                                        //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wlx2far.h>
/*============================================================================*/
DWORD threadID=0;
HANDLE hThread=NULL;
/*============================================================================*/
DWORD WINAPI ThreadProc(LPVOID lpParameter)
{
 while (true)
 {
  if (toinstall)
  {
   toinstall=false;
   if (wlx2far_Install())
   {
     HANDLE* pObjects = NULL;
     int objects = 0;

     while (TRUE)
     {
       DWORD result;
       MSG msg;

       while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
       {
         if (msg.message == WM_QUIT)
         {
           wlx2far_Uninstall();
           return 1;
         }

         TranslateMessage(&msg);
         DispatchMessage(&msg);
       }
       result = MsgWaitForMultipleObjects(objects, pObjects, FALSE, INFINITE, QS_ALLINPUT);
       if (result == (WAIT_OBJECT_0 + objects))
       {
         if (touninstall)
         {
           wlx2far_Uninstall();
           touninstall=false;
           break;
         }
         continue;
       }
     }
   }
  }
  else
   SwitchToThread();
 }
 return 0;
}
/*============================================================================*/
/*
  PluginStartupInfo   
 SetStartupInfo     
 .
*/
struct PluginStartupInfo Info;
/*----------------------------------------------------------------------------*/
/*
  FarStandardFunctions     
   Far.exe
*/
static FarStandardFunctions FSF;
/*============================================================================*/
/*
  GetMsg      .
     Info.GetMsg   
*/
const char *GetMsg(int MsgId)
{
 return (Info.GetMsg(Info.ModuleNumber,MsgId));
}
/*----------------------------------------------------------------------------*/
/*
  InitDialogItems     
 InitDialogItem  FarDialogItem
*/
void InitDialogItems(const struct InitDialogItem *Init,struct FarDialogItem *Item,int ItemsNumber)
{
 int I;
 struct FarDialogItem *PItem=Item;
 const struct InitDialogItem *PInit=Init;
 for (I=0;I<ItemsNumber;I++,PItem++,PInit++)
 {
  PItem->Type=PInit->Type;
  PItem->X1=PInit->X1;
  PItem->Y1=PInit->Y1;
  PItem->X2=PInit->X2;
  PItem->Y2=PInit->Y2;
  PItem->Focus=PInit->Focus;
  PItem->Selected=PInit->Selected;
  if (PInit->History!=NULL)
   PItem->History=PInit->History;
  PItem->Flags=PInit->Flags;
  PItem->DefaultButton=PInit->DefaultButton;
  if ((unsigned int)PInit->Data<2000)
   strcpy(PItem->Data,GetMsg((unsigned int)PInit->Data));
  else
   strcpy(PItem->Data,PInit->Data);
 }
}
/*----------------------------------------------------------------------------*/
/*
 FAR   GetMinFarVersion  
    ,   
  .
*/
int WINAPI GetMinFarVersion(void)
{
 return MAKEFARVERSION(1,70,5);
}
/*----------------------------------------------------------------------------*/
/*
  SetStartupInfo   ,  
  .    ,
    .
*/
void WINAPI SetStartupInfo(const struct PluginStartupInfo *psi)
{
 Info=*psi;
 FSF=*psi->FSF;
 Info.FSF=&FSF;
 strcpy(PluginRootKey,Info.RootKey);
 strcat(PluginRootKey,"\\wlx2far");
 PreloadKeys();
 hThread=CreateThread(NULL,0,ThreadProc,NULL,0,&threadID);
 if (!installed)
 {
  int PinToFar=GetRegKey(HKEY_CURRENT_USER,"","PinToFar",0);
  pinlister=(PinToFar!=0);
  HANDLE hScreen=Info.SaveScreen(0,0,-1,-1);
  int i=GetRegKey(HKEY_CURRENT_USER,"","ShowStartupInfo",1);
  if (i==1)
  {
   const char *MsgItems[]={GetMsg(lngMessage),GetMsg(lngMessageUpdate)};
   Info.Message(Info.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(*MsgItems),0);
  }
  wlx2far_Command("wlx2far:install");
  Info.RestoreScreen(hScreen);
  char command[MYMAXPATH];
  char rootpathname[MYMAXPATH];
  GetModuleFileName(hinst,command,MYMAXPATH);
  modulenamelength=(unsigned)strlen(command);
  unsigned l=modulenamelength-1;
  while ((l>0)&&(command[l]!='\\')&&(command[l]!='/'))
   l--;
  command[l]='\0';
  modulenamelength-=l+1;
  SetRegKey(HKEY_CURRENT_USER,"","PluginPath",command);
  strcat(command,"\\Plugins");
  GetRegKey(HKEY_CURRENT_USER,"","DefaultPath",rootpathname,command,MYMAXPATH);
  int StartSearch=GetRegKey(HKEY_CURRENT_USER,"","StartSearch",1);
  if (StartSearch!=0)
  {
   strcpy(command,"wlx2far:search ");
   strcat(command,rootpathname);
   wlx2far_Command(command);
  }
 }
 SetForegroundWindow(hWnd_Global);
}
/*----------------------------------------------------------------------------*/
/*
  GetPluginInfo    
   
*/
void WINAPI GetPluginInfo(struct PluginInfo *pi)
{
 static const char *PluginMenuStrings[1];
 static const char *PluginConfigStrings[1];
 PluginMenuStrings[0]=GetMsg(lngPluginName);
 PluginConfigStrings[0]=GetMsg(lngPluginConfigName);
 pi->StructSize=sizeof(struct PluginInfo);
 pi->Flags=PF_PRELOAD|PF_EDITOR|PF_VIEWER|PF_FULLCMDLINE;
 pi->DiskMenuStringsNumber=0;
 pi->PluginMenuStrings=PluginMenuStrings;
 pi->PluginMenuStringsNumber=sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);
 pi->PluginConfigStrings=PluginConfigStrings;
 pi->PluginConfigStringsNumber=sizeof(PluginConfigStrings)/sizeof(PluginConfigStrings[0]);
 pi->CommandPrefix="wlx2far:wlx";
}
/*----------------------------------------------------------------------------*/
/*
  OpenPlugin      
*/
HANDLE WINAPI OpenPlugin(int OpenFrom,int Item)
{
 switch (OpenFrom)
 {
  case OPEN_PLUGINSMENU:
  case OPEN_EDITOR:
  case OPEN_VIEWER:
  {
   PreloadKeys();
   if (!installed)
   {
    Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wlx2far is not installed",0,0);
    break;
   }
   bool leftpanel=false;
   PanelInfo PInfo;
   if (Info.Control(INVALID_HANDLE_VALUE,FCTL_CHECKPANELSEXIST,&PInfo)==TRUE)
   {
    RECT rect;
    Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&PInfo);
    if (PInfo.ItemsNumber>0)
    {
     strcpy(PluginName,"?");
     strcpy(PluginArgs,PInfo.CurDir);
     strcat(PluginArgs,"\\");
     strcat(PluginArgs,PInfo.PanelItems[PInfo.CurrentItem].FindData.cFileName);
    }
    else
     break;
    rect.left=PInfo.PanelRect.left;
    rect.right=PInfo.PanelRect.right;
    rect.top=PInfo.PanelRect.top;
    rect.bottom=PInfo.PanelRect.bottom;
    Info.Control(INVALID_HANDLE_VALUE,FCTL_GETANOTHERPANELSHORTINFO,&PInfo);
    if (PInfo.PanelRect.left<rect.left)
     leftpanel=true;
   }
   else
    break;
   int BreakCode=0;
   int BreakKeys[]={VK_INSERT,VK_DELETE,VK_F4,MAKELONG(VK_UP,PKF_CONTROL),MAKELONG(VK_DOWN,PKF_CONTROL),0};
   int ExitCode;
   int SelectedItem=0;
   while (BreakCode!=-1)
   {
    const int MenuItemsCount=10;
    FarMenuItemEx *MenuItems=new FarMenuItemEx[MenuItemsCount+Plugins.size()];
    MenuItems[0].Flags=MIF_USETEXTPTR;
    MenuItems[0].Text.TextPtr=GetMsg(lngToggleQViewer);
    MenuItems[0].AccelKey=0;
    MenuItems[0].Reserved=0;
    MenuItems[0].UserData=0;
    MenuItems[1].Flags=MIF_USETEXTPTR;
    MenuItems[1].Text.TextPtr=GetMsg(lngFocusQViewer);
    MenuItems[1].AccelKey=0;
    MenuItems[1].Reserved=0;
    MenuItems[1].UserData=0;
    MenuItems[2].Flags=MIF_USETEXTPTR;
    MenuItems[2].Text.TextPtr=GetMsg(lngUpdateQViewer);
    MenuItems[2].AccelKey=0;
    MenuItems[2].Reserved=0;
    MenuItems[2].UserData=0;
    MenuItems[3].Flags=MIF_SEPARATOR;
    MenuItems[3].Text.TextPtr=NULL;
    MenuItems[3].AccelKey=0;
    MenuItems[3].Reserved=0;
    MenuItems[3].UserData=0;
    MenuItems[4].Flags=MIF_USETEXTPTR;
    MenuItems[4].Text.TextPtr=GetMsg(lngOpenLister);
    MenuItems[4].AccelKey=0;
    MenuItems[4].Reserved=0;
    MenuItems[4].UserData=0;
    MenuItems[5].Flags=MIF_USETEXTPTR;
    MenuItems[5].Text.TextPtr=GetMsg(lngShowLister);
    MenuItems[5].AccelKey=0;
    MenuItems[5].Reserved=0;
    MenuItems[5].UserData=0;
    MenuItems[6].Flags=MIF_USETEXTPTR;
    MenuItems[6].Text.TextPtr=GetMsg(lngHideLister);
    MenuItems[6].AccelKey=0;
    MenuItems[6].Reserved=0;
    MenuItems[6].UserData=0;
    MenuItems[7].Flags=MIF_SEPARATOR;
    MenuItems[7].Text.TextPtr=NULL;
    MenuItems[7].AccelKey=0;
    MenuItems[7].Reserved=0;
    MenuItems[7].UserData=0;
    MenuItems[8].Flags=MIF_USETEXTPTR;
    MenuItems[8].Text.TextPtr=GetMsg(lngScanForNew);
    MenuItems[8].AccelKey=0;
    MenuItems[8].Reserved=0;
    MenuItems[8].UserData=0;
    MenuItems[9].Flags=MIF_SEPARATOR;
    MenuItems[9].Text.TextPtr=NULL;
    MenuItems[9].AccelKey=0;
    MenuItems[9].Reserved=0;
    MenuItems[9].UserData=0;
    int i=MenuItemsCount;
    for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++,i++)
    {
     MenuItems[i].Flags=((*it)->IsValid())?0:MIF_DISABLE;
     sprintf(MenuItems[i].Text.Text,"&%c %s",(*it)->GetHotkey(),(*it)->GetAlias());
     MenuItems[i].AccelKey=0;
     MenuItems[i].Reserved=0;
     MenuItems[i].UserData=0;
    }
    MenuItems[SelectedItem].Flags|=MIF_SELECTED;
    ExitCode=Info.Menu(Info.ModuleNumber,-1,-1,0,FMENU_USEEXT|FMENU_WRAPMODE,GetMsg(lngPluginName),GetMsg(lngMenuBottomString),NULL,BreakKeys,&BreakCode,(struct FarMenuItem *)MenuItems,(int)(MenuItemsCount+Plugins.size()));
    if (ExitCode>=0)
    {
     timerstopped=true;
     KillTimer(hWnd_LQViewer,666);
     KillTimer(hWnd_RQViewer,666);
     if (BreakCode==0)
     {
      char* Alias=Info.FSF->PointToName(PluginArgs);
      struct InitDialogItem InitItems[]=
      {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
       /*00*/ { DI_DOUBLEBOX,   3, 1,55,12, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngInstall),               NULL},
       /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngPluginHotKey),          NULL},
       /*02*/ { DI_FIXEDIT,     5, 3, 5, 3, 0, 0, 0,                                    0,      " ",                              NULL},
       /*03*/ { DI_TEXT,        5, 4, 0, 4, 0, 0, 0,                                    0,      GetMsg(lngInstallPluginAlias),    NULL},
       /*04*/ { DI_EDIT,        5, 5,53, 5, 0, 0, DIF_HISTORY,                          0,      Alias,          "wlx2far.History.InastallPlugin.Alias"},
       /*05*/ { DI_TEXT,        5, 6, 0, 6, 0, 0, 0,                                    0,      GetMsg(lngInstallPluginFileName), NULL},
       /*06*/ { DI_EDIT,        5, 7,53, 7, 1, 0, DIF_HISTORY,                          0,      PluginArgs,     "wlx2far.History.InastallPlugin.Name"},
       /*07*/ { DI_TEXT,        5, 8, 0, 8, 0, 0, 0,                                    0,      GetMsg(lngInstallPluginMask),     NULL},
       /*08*/ { DI_EDIT,        5, 9,53, 9, 0, 0, DIF_HISTORY,                          0,      "",             "wlx2far.History.InastallPlugin.Mask"},
       /*09*/ { DI_TEXT,        0,10, 0,10, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                               NULL},
       /*10*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),                    NULL},
       /*11*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),                NULL}
      };
      struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
      InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,14,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      if (n==10)
       wlx2far_InstallPlugin((DialogItems[2].Data[0]=='\0')?' ':DialogItems[2].Data[0],DialogItems[4].Data,DialogItems[6].Data,DialogItems[8].Data);
     }
     if ((BreakCode==1)&&(ExitCode>MenuItemsCount-1))
     {
      struct InitDialogItem InitItems[]=
      {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
       /*00*/ { DI_DOUBLEBOX,   3, 1,55, 8, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngUninstall),                         NULL},
       /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngPluginAlias),                       NULL},
       /*02*/ { DI_EDIT,        5, 3,53, 3, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode-MenuItemsCount]->GetAlias(), NULL},
       /*03*/ { DI_TEXT,        5, 4, 0, 4, 0, 0, 0,                                    0,      GetMsg(lngPluginFileName),                    NULL},
       /*04*/ { DI_EDIT,        5, 5,53, 5, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode-MenuItemsCount]->GetName(),  NULL},
       /*05*/ { DI_TEXT,        0, 6, 0, 6, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                                           NULL},
       /*06*/ { DI_BUTTON,      0, 7, 0, 7, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngOK),                                NULL},
       /*07*/ { DI_BUTTON,      0, 7, 0, 7, 1, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngCancel),                            NULL}
      };
      struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
      InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,10,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      if (n==6)
      {
       wlx2far_UninstallPlugin(DialogItems[4].Data);
       ExitCode--;
      }
     }
     if ((BreakCode==2)&&(ExitCode>MenuItemsCount-1))
     {
      char temp[2];
      temp[0]=Plugins[ExitCode-MenuItemsCount]->GetHotkey();
      temp[1]='\0';
      struct InitDialogItem InitItems[]=
      {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
       /*00*/ { DI_DOUBLEBOX,   3, 1,55,12, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngEdit),                              NULL},
       /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngPluginHotKey),                      NULL},
       /*02*/ { DI_FIXEDIT,     5, 3, 5, 3, 0, 0, 0,                                    0,      temp,                                         NULL},
       /*03*/ { DI_TEXT,        5, 4, 0, 4, 0, 0, 0,                                    0,      GetMsg(lngPluginAlias),                       NULL},
       /*04*/ { DI_EDIT,        5, 5,53, 5, 0, 0, DIF_HISTORY,                          0,      Plugins[ExitCode-MenuItemsCount]->GetAlias(), "wlx2far.History.InastallPlugin.Alias"},
       /*05*/ { DI_TEXT,        5, 6, 0, 6, 0, 0, 0,                                    0,      GetMsg(lngPluginFileName),                    NULL},
       /*06*/ { DI_EDIT,        5, 7,53, 7, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode-MenuItemsCount]->GetName(),  NULL},
       /*07*/ { DI_TEXT,        5, 8, 0, 8, 0, 0, 0,                                    0,      GetMsg(lngPluginMask),                        NULL},
       /*08*/ { DI_EDIT,        5, 9,53, 9, 1, 0, DIF_HISTORY,                          0,      Plugins[ExitCode-MenuItemsCount]->GetMask(),  "wlx2far.History.InastallPlugin.Mask"},
       /*09*/ { DI_TEXT,        0,10, 0,10, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                                           NULL},
       /*10*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),                                NULL},
       /*11*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),                            NULL}
      };
      struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
      InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,14,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      if (n==10)
      {
       bool found=false;
       for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
        if ((_stricmp((*it)->GetAlias(),DialogItems[4].Data)==0)&&((*it)!=Plugins[ExitCode-MenuItemsCount]))
        {
         found=true;
         char errormessage[256];
         sprintf(errormessage,"Alias '%s' already exist",DialogItems[4].Data);
         Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
         break;
        }
       Plugins[ExitCode-MenuItemsCount]->SetHotkey((DialogItems[2].Data[0]=='\0')?' ':DialogItems[2].Data[0]);
       if (!found)
        Plugins[ExitCode-MenuItemsCount]->SetAlias(DialogItems[4].Data);
       char *buf=DialogItems[8].Data;
       unsigned i,l=(unsigned)strlen(buf);
       i=l; while ((i>0)&&(isspace(buf[i-1]))) { i--; buf[i-1]='\0'; }
       i=0; while ((i<l)&&(isspace(buf[i]))) i++;
       Plugins[ExitCode-MenuItemsCount]->SetMask(buf+i);
      }
     }
     if ((BreakCode==3)&&(ExitCode>MenuItemsCount-1))
     {
      if (ExitCode-MenuItemsCount>0)
      {
       WLXPlugin* tmp=Plugins[ExitCode-MenuItemsCount-1];
       Plugins[ExitCode-MenuItemsCount-1]=Plugins[ExitCode-MenuItemsCount];
       Plugins[ExitCode-MenuItemsCount]=tmp;
       ExitCode--;
      }
     }
     if ((BreakCode==4)&&(ExitCode>MenuItemsCount-1))
     {
      if (ExitCode-MenuItemsCount<(int)Plugins.size()-1)
      {
       WLXPlugin* tmp=Plugins[ExitCode-MenuItemsCount+1];
       Plugins[ExitCode-MenuItemsCount+1]=Plugins[ExitCode-MenuItemsCount];
       Plugins[ExitCode-MenuItemsCount]=tmp;
       ExitCode++;
      }
     }
     if (BreakCode==5)
      BreakCode=-1;
     else
     {
      MenuItems[SelectedItem].Flags&=~MIF_SELECTED;
      SelectedItem=ExitCode;
     }
     if ((BreakCode==-1)&&(ExitCode==0))
     {
      if (leftpanel)
      {
       if (visible_LQViewer)
        wlx2far_CloseQViewer(true);
       else
       {
        if (!visible_RQViewer)
         wlx2far_OpenQViewer(true);
       }
      }
      else
      {
       if (visible_RQViewer)
        wlx2far_CloseQViewer(false);
       else
       {
        if (!visible_LQViewer)
         wlx2far_OpenQViewer(false);
       }
      }
     }
     if ((BreakCode==-1)&&(ExitCode==1))
      wlx2far_FocusQViewer(leftpanel);
     if (((BreakCode==-1)&&ExitCode==2))
     {
      if (leftpanel)
      {
       if (visible_LQViewer)
        SendMessage(hWnd_LQViewer,WM_WLXOPEN,NULL,NULL);
      }
      else
      {
       if (visible_RQViewer)
        SendMessage(hWnd_RQViewer,WM_WLXOPEN,NULL,NULL);
      }
     }
     if ((BreakCode==-1)&&(ExitCode==4))
      wlx2far_OpenLister();
     if ((BreakCode==-1)&&(ExitCode==5))
      wlx2far_ShowLister();
     if ((BreakCode==-1)&&(ExitCode==6))
      wlx2far_HideLister();
     if ((BreakCode==-1)&&(ExitCode==8))
     {
      char command[MYMAXPATH];
      char rootpathname[MYMAXPATH];
      GetModuleFileName(hinst,command,MYMAXPATH);
      command[strlen(command)-modulenamelength]='\0';
      strcat(command,"Plugins");
      GetRegKey(HKEY_CURRENT_USER,"","DefaultPath",rootpathname,command,MYMAXPATH);
      struct InitDialogItem InitItems[]=
      {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
       /*00*/ { DI_DOUBLEBOX,   3, 1,55, 6, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngScan),       NULL},
       /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngScanPath),   NULL},
       /*02*/ { DI_EDIT,        5, 3,53, 3, 1, 0, DIF_HISTORY,                          0,      rootpathname,          "wlx2far.History.Scan.Path"},
       /*03*/ { DI_TEXT,        0, 4, 0, 4, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                    NULL},
       /*04*/ { DI_BUTTON,      0, 5, 0, 5, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),         NULL},
       /*05*/ { DI_BUTTON,      0, 5, 0, 5, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),     NULL}
      };
      struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
      InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,8,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      if (n==4)
      {
       strcpy(command,"wlx2far:search ");
       strcat(command,DialogItems[2].Data);
       wlx2far_Command(command);
      }
     }
     if ((BreakCode==-1)&&(ExitCode>MenuItemsCount-1))
     {
      struct InitDialogItem InitItems[]=
      {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
       /*00*/ { DI_DOUBLEBOX,   3, 1,55,10, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngOpen),                              NULL},
       /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngPluginAlias),                       NULL},
       /*02*/ { DI_EDIT,        5, 3,53, 3, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode-MenuItemsCount]->GetAlias(), NULL},
       /*03*/ { DI_TEXT,        5, 4, 0, 4, 0, 0, 0,                                    0,      GetMsg(lngPluginFileName),                    NULL},
       /*04*/ { DI_EDIT,        5, 5,53, 5, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode-MenuItemsCount]->GetName(),  NULL},
       /*05*/ { DI_TEXT,        5, 6, 0, 6, 0, 0, 0,                                    0,      GetMsg(lngPluginArguments),                   NULL},
       /*06*/ { DI_EDIT,        5, 7,53, 7, 1, 0, DIF_HISTORY,                          0,      PluginArgs,                                   "wlx2far.History.OpenLister.Arguments"},
       /*07*/ { DI_TEXT,        0, 8, 0, 8, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                                           NULL},
       /*08*/ { DI_BUTTON,      0, 9, 0, 9, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),                                NULL},
       /*09*/ { DI_BUTTON,      0, 9, 0, 9, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),                            NULL}
      };
      struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
      InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,12,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      if (n==8)
      {
       strncpy(PluginName,DialogItems[4].Data,MYMAXPATH);
       strncpy(PluginArgs,DialogItems[6].Data,MYMAXPATH);
       wlx2far_OpenLister();
      }
     }
    }
    FILE* inifile;
    GetModuleFileName(hinst,buffer1,MYMAXPATH);
    buffer1[strlen(buffer1)-1]='i';
    buffer1[strlen(buffer1)-2]='n';
    buffer1[strlen(buffer1)-3]='i';
    inifile=fopen(buffer1,"wt");
    if (inifile!=NULL)
    {
     for (std::vector<WLXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
      if ((*it)->IsValid())
       fprintf(inifile,"%c - %s ? %s ? %s\n",(*it)->GetHotkey(),(*it)->GetAlias(),(*it)->GetName(),(*it)->GetMask());
     fclose(inifile);
    }
    timerstopped=false;
    SetTimer(hWnd_LQViewer,666,100,NULL);
    SetTimer(hWnd_RQViewer,666,100,NULL);
    delete [] MenuItems;
   }
   break;
  }
  case OPEN_COMMANDLINE:
  {
   PreloadKeys();
   timerstopped=true;
   KillTimer(hWnd_LQViewer,666);
   KillTimer(hWnd_RQViewer,666);
   wlx2far_Command((const char*)Item);
   timerstopped=false;
   SetTimer(hWnd_LQViewer,666,100,NULL);
   SetTimer(hWnd_RQViewer,666,100,NULL);
   break;
  }
 }
 return INVALID_HANDLE_VALUE;
}
/*----------------------------------------------------------------------------*/
/*
  Configure ,     
 "Plugins configuration" ("  ") ,
    .
*/
int WINAPI Configure(int ItemNumber)
{
 PreloadKeys();
 char temp[MYMAXPATH];
 char rootpathname[MYMAXPATH];
 GetModuleFileName(hinst,temp,MYMAXPATH);
 temp[strlen(temp)-modulenamelength]='\0';
 strcat(temp,"Plugins");
 int p=GetRegKey(HKEY_CURRENT_USER,"","PinToFar",0);
 int i=GetRegKey(HKEY_CURRENT_USER,"","ShowStartupInfo",1);
 int s=GetRegKey(HKEY_CURRENT_USER,"","StartSearch",1);
 GetRegKey(HKEY_CURRENT_USER,"","DefaultPath",rootpathname,temp,MYMAXPATH);
 struct InitDialogItem InitItems[]=
 {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
  /*00*/ { DI_DOUBLEBOX,   3, 1,55,10, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngPluginConfigName),  NULL},
  /*01*/ { DI_CHECKBOX,    5, 2, 0, 2, 0, p, 0,                                    0,      GetMsg(lngConfigPin),         NULL},
  /*02*/ { DI_TEXT,        0, 3, 0, 3, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                           NULL},
  /*03*/ { DI_CHECKBOX,    5, 4, 0, 4, 0, i, 0,                                    0,      GetMsg(lngConfigShowStatup),  NULL},
  /*04*/ { DI_CHECKBOX,    5, 5, 0, 5, 0, s, 0,                                    0,      GetMsg(lngConfigStartSearch), NULL},
  /*05*/ { DI_TEXT,        5, 6, 0, 6, 0, 0, 0,                                    0,      GetMsg(lngConfigPath),        NULL},
  /*06*/ { DI_EDIT,        5, 7,53, 7, 1, 0, DIF_HISTORY,                          0,      rootpathname,                 "wlx2far.History.Scan.Path"},
  /*07*/ { DI_TEXT,        0, 8, 0, 8, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                           NULL},
  /*08*/ { DI_BUTTON,      0, 9, 0, 9, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),                NULL},
  /*09*/ { DI_BUTTON,      0, 9, 0, 9, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),            NULL}
 };
 struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
 InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
 int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,12,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
 if (n=8)
 {
  SetRegKey(HKEY_CURRENT_USER,"","ShowStartupInfo",(DialogItems[3].Selected==TRUE)?1:0);
  SetRegKey(HKEY_CURRENT_USER,"","StartSearch",(DialogItems[4].Selected==TRUE)?1:0);
  SetRegKey(HKEY_CURRENT_USER,"","DefaultPath",DialogItems[6].Data);
  wlx2far_PinLister(DialogItems[1].Selected==TRUE);
  InvalidateRect(hWnd_Console,NULL,FALSE);
 }
 return TRUE;
}
/*----------------------------------------------------------------------------*/
/*
  ExitFAR     FAR.     
    , ,   .
*/
void WINAPI ExitFAR(void)
{
// if (installed)
//  wlx2far_Command("wlx2far:uninstall");
 wlx2far_Uninstall();
 TerminateThread(hThread,0);
}
/*============================================================================*/
