/*
    WLX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                             WLX2FAR HOOKS                                  //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wlx2far                                                           //
// PART:    Hooks header                                                      //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wlx2far.h>
/*============================================================================*/
HotKey keys[10];
int keyslength=10;
/*----------------------------------------------------------------------------*/
void PreloadKeys(void)
{
 keys[Lister_Pin-1].vk=0x0D;
 keys[Lister_Pin-1].alt=true;
 keys[Lister_Pin-1].ctrl=false;
 keys[Lister_Pin-1].shift=false;
 keys[Lister_Pin-1].win=false;

 keys[Lister_Hide-1].vk=0x1B;
 keys[Lister_Hide-1].alt=false;
 keys[Lister_Hide-1].ctrl=false;
 keys[Lister_Hide-1].shift=false;
 keys[Lister_Hide-1].win=false;

 keys[Lister_NextTab-1].vk=0x09;
 keys[Lister_NextTab-1].alt=false;
 keys[Lister_NextTab-1].ctrl=true;
 keys[Lister_NextTab-1].shift=false;
 keys[Lister_NextTab-1].win=false;

 keys[Lister_DeleteTab-1].vk=0x2E;
 keys[Lister_DeleteTab-1].alt=false;
 keys[Lister_DeleteTab-1].ctrl=true;
 keys[Lister_DeleteTab-1].shift=false;
 keys[Lister_DeleteTab-1].win=false;

 keys[Lister_DeleteTabHide-1].vk=0x22;
 keys[Lister_DeleteTabHide-1].alt=false;
 keys[Lister_DeleteTabHide-1].ctrl=true;
 keys[Lister_DeleteTabHide-1].shift=false;
 keys[Lister_DeleteTabHide-1].win=false;

 keys[Lister_DeleteAllTabs-1].vk=0x2E;
 keys[Lister_DeleteAllTabs-1].alt=false;
 keys[Lister_DeleteAllTabs-1].ctrl=true;
 keys[Lister_DeleteAllTabs-1].shift=true;
 keys[Lister_DeleteAllTabs-1].win=false;

 keys[Lister_DeleteAllTabsHide-1].vk=0x22;
 keys[Lister_DeleteAllTabsHide-1].alt=false;
 keys[Lister_DeleteAllTabsHide-1].ctrl=true;
 keys[Lister_DeleteAllTabsHide-1].shift=true;
 keys[Lister_DeleteAllTabsHide-1].win=false;

 keys[QView_Hide-1].vk=0x1B;
 keys[QView_Hide-1].alt=false;
 keys[QView_Hide-1].ctrl=false;
 keys[QView_Hide-1].shift=false;
 keys[QView_Hide-1].win=false;

 keys[QView_NewPanel-1].vk=0x51;
 keys[QView_NewPanel-1].alt=false;
 keys[QView_NewPanel-1].ctrl=true;
 keys[QView_NewPanel-1].shift=false;
 keys[QView_NewPanel-1].win=false;

 keys[QView_ToggleFocus-1].vk=0x09;
 keys[QView_ToggleFocus-1].alt=false;
 keys[QView_ToggleFocus-1].ctrl=true;
 keys[QView_ToggleFocus-1].shift=false;
 keys[QView_ToggleFocus-1].win=false;

 FILE* inifile;
 GetModuleFileName(hinst,buffer1,MYMAXPATH);
 buffer1[strlen(buffer1)-3]='\0';
 strcat(buffer1,"keys.ini");
 inifile=fopen(buffer1,"rb");
 if (inifile!=NULL)
 {
  while (fgets(buffer1,MYMAXPATH,inifile)!=NULL)
  {
   if (buffer1[0]!='#')
   {
    unsigned vk,a,c,s,w;
    sscanf(buffer1,"%s = %x,%d,%d,%d,%d",buffer2,&vk,&a,&c,&s,&w);
    if (strcmp(buffer2,"Lister_Pin")==0)
    {
     keys[Lister_Pin-1].vk=vk;
     keys[Lister_Pin-1].alt=(a!=0);
     keys[Lister_Pin-1].ctrl=(c!=0);
     keys[Lister_Pin-1].shift=(s!=0);
     keys[Lister_Pin-1].win=(w!=0);
    }
    if (strcmp(buffer2,"Lister_Hide")==0)
    {
     keys[Lister_Hide-1].vk=vk;
     keys[Lister_Hide-1].alt=(a!=0);
     keys[Lister_Hide-1].ctrl=(c!=0);
     keys[Lister_Hide-1].shift=(s!=0);
     keys[Lister_Hide-1].win=(w!=0);
    }
    if (strcmp(buffer2,"Lister_NextTab")==0)
    {
     keys[Lister_NextTab-1].vk=vk;
     keys[Lister_NextTab-1].alt=(a!=0);
     keys[Lister_NextTab-1].ctrl=(c!=0);
     keys[Lister_NextTab-1].shift=(s!=0);
     keys[Lister_NextTab-1].win=(w!=0);
    }
    if (strcmp(buffer2,"Lister_DeleteTab")==0)
    {
     keys[Lister_DeleteTab-1].vk=vk;
     keys[Lister_DeleteTab-1].alt=(a!=0);
     keys[Lister_DeleteTab-1].ctrl=(c!=0);
     keys[Lister_DeleteTab-1].shift=(s!=0);
     keys[Lister_DeleteTab-1].win=(w!=0);
    }
    if (strcmp(buffer2,"Lister_DeleteTabHide")==0)
    {
     keys[Lister_DeleteTabHide-1].vk=vk;
     keys[Lister_DeleteTabHide-1].alt=(a!=0);
     keys[Lister_DeleteTabHide-1].ctrl=(c!=0);
     keys[Lister_DeleteTabHide-1].shift=(s!=0);
     keys[Lister_DeleteTabHide-1].win=(w!=0);
    }
    if (strcmp(buffer2,"Lister_DeleteAllTabs")==0)
    {
     keys[Lister_DeleteAllTabs-1].vk=vk;
     keys[Lister_DeleteAllTabs-1].alt=(a!=0);
     keys[Lister_DeleteAllTabs-1].ctrl=(c!=0);
     keys[Lister_DeleteAllTabs-1].shift=(s!=0);
     keys[Lister_DeleteAllTabs-1].win=(w!=0);
    }
    if (strcmp(buffer2,"Lister_DeleteAllTabsHide")==0)
    {
     keys[Lister_DeleteAllTabsHide-1].vk=vk;
     keys[Lister_DeleteAllTabsHide-1].alt=(a!=0);
     keys[Lister_DeleteAllTabsHide-1].ctrl=(c!=0);
     keys[Lister_DeleteAllTabsHide-1].shift=(s!=0);
     keys[Lister_DeleteAllTabsHide-1].win=(w!=0);
    }
    if (strcmp(buffer2,"QView_Hide")==0)
    {
     keys[QView_Hide-1].vk=vk;
     keys[QView_Hide-1].alt=(a!=0);
     keys[QView_Hide-1].ctrl=(c!=0);
     keys[QView_Hide-1].shift=(s!=0);
     keys[QView_Hide-1].win=(w!=0);
    }
    if (strcmp(buffer2,"QView_NewPanel")==0)
    {
     keys[QView_NewPanel-1].vk=vk;
     keys[QView_NewPanel-1].alt=(a!=0);
     keys[QView_NewPanel-1].ctrl=(c!=0);
     keys[QView_NewPanel-1].shift=(s!=0);
     keys[QView_NewPanel-1].win=(w!=0);
    }
    if (strcmp(buffer2,"QView_ToggleFocus")==0)
    {
     keys[QView_ToggleFocus-1].vk=vk;
     keys[QView_ToggleFocus-1].alt=(a!=0);
     keys[QView_ToggleFocus-1].ctrl=(c!=0);
     keys[QView_ToggleFocus-1].shift=(s!=0);
     keys[QView_ToggleFocus-1].win=(w!=0);
    }
   }
  }
  fclose(inifile);
 }
}
/*----------------------------------------------------------------------------*/
void TestKeys(WPARAM wParam)
{
 for (int i=0;i<keyslength;i++)
 {
  if (keys[i].vk==wParam)
  {
   if (keys[i].alt)
   {
    if (((GetKeyState(VK_LMENU)&0x8000)==0)&&((GetKeyState(VK_RMENU)&0x8000)==0))
     continue;
   }
   else
    if (((GetKeyState(VK_LMENU)&0x8000)!=0)||((GetKeyState(VK_RMENU)&0x8000)!=0))
     continue;
   if (keys[i].ctrl)
   {
    if (((GetKeyState(VK_LCONTROL)&0x8000)==0)&&((GetKeyState(VK_RCONTROL)&0x8000)==0))
     continue;
   }
   else
    if (((GetKeyState(VK_LCONTROL)&0x8000)!=0)||((GetKeyState(VK_RCONTROL)&0x8000)!=0))
     continue;
   if (keys[i].shift)
   {
    if (((GetKeyState(VK_LSHIFT)&0x8000)==0)&&((GetKeyState(VK_RSHIFT)&0x8000)==0))
     continue;
   }
   else
    if (((GetKeyState(VK_LSHIFT)&0x8000)!=0)||((GetKeyState(VK_RSHIFT)&0x8000)!=0))
     continue;
   if (keys[i].win)
   {
    if (((GetKeyState(VK_LWIN)&0x8000)==0)&&((GetKeyState(VK_RWIN)&0x8000)==0))
     continue;
   }
   else
    if (((GetKeyState(VK_LWIN)&0x8000)!=0)||((GetKeyState(VK_RWIN)&0x8000)!=0))
     continue;
    ActivateKey((HotKeyEnum)(None+i+1));
  }
 }
}
/*----------------------------------------------------------------------------*/
void ActivateKey(HotKeyEnum key)
{
 switch (key)
 {
  case None:
  break;
  case Lister_Pin:
  wlx2far_PinLister(!pinlister);
  break;
  case Lister_Hide:
  if (visible_Lister)
  {
   wlx2far_HideLister();
   SetForegroundWindow(hWnd_Global);
  }
  break;
  case Lister_NextTab:
  if (visible_Lister)
   SendMessage(hWnd_Lister,WM_WLXLISTERNEXT,0,0);
  break;
  case Lister_DeleteTab:
  if (visible_Lister)
   SendMessage(hWnd_Lister,WM_WLXLISTERCURDEL,0,0);
  break;
  case Lister_DeleteTabHide:
  if (visible_Lister)
  {
   SendMessage(hWnd_Lister,WM_WLXLISTERCURDEL,0,0);
   wlx2far_HideLister();
   SetForegroundWindow(hWnd_Global);
  }
  break;
  case Lister_DeleteAllTabs:
  if (visible_Lister)
   SendMessage(hWnd_Lister,WM_WLXLISTERALLDEL,0,0);
  break;
  case Lister_DeleteAllTabsHide:
  if (visible_Lister)
  {
   SendMessage(hWnd_Lister,WM_WLXLISTERALLDEL,0,0);
   wlx2far_HideLister();
   SetForegroundWindow(hWnd_Global);
  }
  break;
  case QView_Hide:
  if ((visible_LQViewer)&&(visible_RQViewer))
  {
   bool leftdel,rightdel;
   leftdel=false;
   rightdel=false;
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_LQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_LQViewer))
    leftdel=true;
   GetWindowInfo(hWnd_RQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_RQViewer))
    rightdel=true;
   if (leftdel)
   {
    wlx2far_CloseQViewer(true);
    wlx2far_FocusQViewer(false);
   }
   if (rightdel)
   {
    wlx2far_CloseQViewer(false);
    wlx2far_FocusQViewer(true);
   }
   return;
  }
  if ((visible_LQViewer)&&(!visible_RQViewer))
  {
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_LQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_LQViewer))
   {
    wlx2far_CloseQViewer(true);
    SetForegroundWindow(hWnd_Global);
    SetFocus(hWnd_Global);
   }
   return;
  }
  if ((!visible_LQViewer)&&(visible_RQViewer))
  {
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_RQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_RQViewer))
   {
    wlx2far_CloseQViewer(false);
    SetForegroundWindow(hWnd_Global);
    SetFocus(hWnd_Global);
   }
   return;
  }
  break;
  case QView_NewPanel:
  if ((visible_LQViewer)&&(visible_RQViewer))
  {
   bool leftdel,rightdel;
   leftdel=false;
   rightdel=false;
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_LQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_LQViewer))
    leftdel=true;
   GetWindowInfo(hWnd_RQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_RQViewer))
    rightdel=true;
   if (leftdel)
    wlx2far_CloseQViewer(false);
   if (rightdel)
    wlx2far_CloseQViewer(true);
   return;
  }
  if ((visible_LQViewer)&&(!visible_RQViewer))
  {
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_LQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_LQViewer))
   {
    wlx2far_OpenQViewer(false);
    wlx2far_FocusQViewer(true);
   }
   return;
  }
  if ((!visible_LQViewer)&&(visible_RQViewer))
  {
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_RQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_RQViewer))
   {
    wlx2far_OpenQViewer(true);
    wlx2far_FocusQViewer(false);
   }
   return;
  }
  break;
  case QView_ToggleFocus:
  if ((visible_LQViewer)&&(visible_RQViewer))
  {
   bool lefttab,righttab;
   lefttab=false;
   righttab=false;
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_LQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_LQViewer))
    lefttab=true;
   GetWindowInfo(hWnd_RQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_RQViewer))
    righttab=true;
   if (lefttab)
    wlx2far_FocusQViewer(false);
   if (righttab)
    wlx2far_FocusQViewer(true);
   return;
  }
  if ((visible_LQViewer)&&(!visible_RQViewer))
  {
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_LQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_LQViewer))
   {
    SetForegroundWindow(hWnd_Global);
    SetFocus(hWnd_Global);
   }
   return;
  }
  if ((!visible_LQViewer)&&(visible_RQViewer))
  {
   WINDOWINFO wininfo;
   wininfo.cbSize=sizeof(WINDOWINFO);
   GetWindowInfo(hWnd_RQViewer,&wininfo);
   if ((wininfo.dwWindowStatus==WS_ACTIVECAPTION)&&(GetForegroundWindow()==hWnd_RQViewer))
   {
    SetForegroundWindow(hWnd_Global);
    SetFocus(hWnd_Global);
   }
   return;
  }
  break;
 }
}
/*============================================================================*/
LRESULT CALLBACK Hook_KeyboardProc(int code,WPARAM wParam,LPARAM lParam)
{
 if (code<0)
  return CallNextHookEx(hKeyHook,code,wParam,lParam);
 if (!(HIWORD(lParam)&KF_UP))
  TestKeys(wParam);
 return CallNextHookEx(hKeyHook,code,wParam,lParam);
}
/*----------------------------------------------------------------------------*/
LRESULT CALLBACK Hook_SysKeyboardProc(int code,WPARAM wParam,LPARAM lParam)
{
 if (code<0)
  return CallNextHookEx(hSysKeyHook,code,wParam,lParam);
 KBDLLHOOKSTRUCT* hKbdStruct=(KBDLLHOOKSTRUCT*)lParam;
 if ((hKbdStruct->flags&LLKHF_UP)&&(((hKbdStruct->vkCode==VK_LEFT)||(hKbdStruct->vkCode==VK_RIGHT)||(hKbdStruct->vkCode==VK_UP)||(hKbdStruct->vkCode==VK_DOWN))&&(((GetKeyState(VK_LCONTROL)&0x8000)!=0)||((GetKeyState(VK_RCONTROL)&0x8000)!=0))))
 {
  WINDOWINFO wininfo;
  wininfo.cbSize=sizeof(WINDOWINFO);
  GetWindowInfo(hWnd_Global,&wininfo);
  if (wininfo.dwWindowStatus==WS_ACTIVECAPTION)
  {
   LRESULT result=CallNextHookEx(hSysKeyHook,code,wParam,lParam);
   InvalidateRect(NULL,NULL,FALSE);
   return result;
  }
 }
 return CallNextHookEx(hSysKeyHook,code,wParam,lParam);
}
/*============================================================================*/
