/*
    WLX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                          WLX PLUGIN FOR WLX2FAR                            //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wlx2far                                                           //
// PART:    WLX plugin header                                                 //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
/*============================================================================*/
#define lc_copy          1
#define lc_newparams     2
#define lc_selectall     3
#define lc_setpercent    4

#define lcp_wraptext     1
#define lcp_fittowindow  2
#define lcp_ansi         4
#define lcp_ascii        8
#define lcp_variable     12
#define lcp_forceshow    16

#define lcs_findfirst    1
#define lcs_matchcase    2
#define lcs_wholewords   4
#define lcs_backwards    8

#define itm_percent      0xFFFE
#define itm_fontstyle    0xFFFD
#define itm_wrap         0xFFFC
#define itm_fit          0xFFFB

#define itm_quit         0xFF0F

#define LISTPLUGIN_OK    0
#define LISTPLUGIN_ERROR 1
/*============================================================================*/
typedef struct
{
 int size;
 DWORD PluginInterfaceVersionLow;
 DWORD PluginInterfaceVersionHi;
 char DefaultIniName[MAX_PATH];
} ListDefaultParamStruct;
/*----------------------------------------------------------------------------*/
typedef HWND    (__stdcall *WLXLISTLOAD)(HWND ParentWin,char* FileToLoad,int ShowFlags);
typedef void    (__stdcall *WLXLISTCLOSEWINDOW)(HWND ListWin);
typedef void    (__stdcall *WLXLISTGETDETECTSTRING)(char* DetectString,int maxlen);
typedef int     (__stdcall *WLXLISTSEARCHTEXT)(HWND ListWin,char* SearchString,int SearchParameter);
typedef int     (__stdcall *WLXLISTSENDCOMMAND)(HWND ListWin,int Command,int Parameter);
typedef int     (__stdcall *WLXLISTPRINT)(HWND ListWin,char* FileToPrint,char* DefPrinter,int PrintFlags,RECT* Margins);
typedef int     (__stdcall *WLXLISTNOTIFICATIONRECEIVED)(HWND ListWin,int Message,WPARAM wParam,LPARAM lParam);
typedef int     (__stdcall *WLXLISTSETDEFAULTPARAMS)(ListDefaultParamStruct* dps);
typedef HBITMAP (__stdcall *WLXLISTGETPREVIEWBITMAP)(char* FileToLoad,int width,int height,char* contentbuf,int contentbuflen);

typedef void    (__stdcall *WLXLISTGETEXTENSIONS)(char* extbuffer,int bufferlength);
typedef int     (__stdcall *WLXLISTISSUPPORTED)(const char *FileName,const char *Buffer,DWORD BufferSize);
/*============================================================================*/
class WLXPlugin
{
 friend class WLXPluginInstance;
 friend LRESULT CALLBACK Wnd_WLXPlugin(HWND hWnd,UINT iMsg,WPARAM wParam,LPARAM lParam);
public:
 WLXPlugin();

 bool IsValid(void);

 bool Incriment(void);
 bool Decriment(void);

 void SetHotkey(const char hotkey);
 void SetAlias(const char* alias);
 void SetName(const char* pluginname);
 void SetMask(const char* pluginmask);

 char  GetHotkey(void) const;
 char* GetAlias(void) const;
 char* GetName(void) const;
 char* GetMask(void) const;

 bool Load(void);
 bool Unload(void);
 bool Verify(void);
 bool Register(const char hotkey,const char* alias,const char* pluginname,const char* pluginmask);
 bool UnRegister(void);

 bool IsSupportedMask(char* filename);
 bool IsSupported(char* filename,char* buffer,int length);

private:
 int counter;
 bool valid;
 char hotkey;
 char alias[256];
 char name[MYMAXPATH];
 char mask[MYMAXPATH];
 HMODULE hDLL;
 HMODULE hMetaDLL;

 WLXLISTLOAD WLX_Load;
 WLXLISTCLOSEWINDOW WLX_CloseWindow;
 WLXLISTGETDETECTSTRING WLX_GetDetectString;
 WLXLISTSEARCHTEXT WLX_SearchText;
 WLXLISTSENDCOMMAND WLX_SendCommand;
 WLXLISTPRINT WLX_Print;
 WLXLISTNOTIFICATIONRECEIVED WLX_NotificationReceived;
 WLXLISTSETDEFAULTPARAMS WLX_SetDefaultParams;
 WLXLISTGETPREVIEWBITMAP WLX_GetPrevivBitmap;

 WLXLISTGETEXTENSIONS WLX_ListGetExtensions;
 WLXLISTISSUPPORTED WLX_ListIsSupported;
};
/*============================================================================*/
class WLXPluginInstance
{
public:
 WLXPluginInstance(WLXPlugin* plugin,char* arguments);

 char*      GetArguments(void) const;
 WLXPlugin* GetPlugin(void) const;
 HWND       GetWindow(void) const;

 bool Load(HWND ParentWin);
 bool Size(int x,int y,int w,int h);
 bool Focus(void);
 bool Show(void);
 bool Hide(void);
 bool Close(void);

 int Notify(HWND ParentWin,HWND hWnd,UINT iMsg,WPARAM wParam,LPARAM lParam);

private:
 HWND hWnd;
 HWND hWndStatic;
 WLXPlugin* plugin;
 char arguments[MYMAXPATH];
};
/*============================================================================*/
