/*
    WLX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                          WLX PLUGIN FOR WLX2FAR                            //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wlx2far                                                           //
// PART:    WLX plugin                                                        //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wlx2far.h>
/*============================================================================*/
WLXPlugin::WLXPlugin()
{
 this->counter=0;
 this->valid=true;
 this->hotkey=' ';
 this->alias[0]='\0';
 this->name[0]='\0';
 this->mask[0]='\0';
 this->hDLL=NULL;
 this->hMetaDLL=NULL;
 this->WLX_Load=NULL;
 this->WLX_CloseWindow=NULL;
 this->WLX_GetDetectString=NULL;
 this->WLX_SearchText=NULL;
 this->WLX_SendCommand=NULL;
 this->WLX_Print=NULL;
 this->WLX_NotificationReceived=NULL;
 this->WLX_SetDefaultParams=NULL;
 this->WLX_ListGetExtensions=NULL;
 this->WLX_ListIsSupported=NULL;
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::IsValid(void)
{
 return this->valid;
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::Incriment(void)
{
 if (this->valid)
 {
  if (this->counter==0)
  {
   if (this->Load())
   {
    this->counter++;
    return true;
   }
   else
   {
    this->valid=false;
    return false;
   }
  }
  else
  {
   this->counter++;
   return true;
  }
 }
 else
  return false;
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::Decriment(void)
{
 if ((this->valid)&&(this->counter>0))
 {
  this->counter--;
  if (this->counter==0)
   this->Unload();
  return true;
 }
 else
  return false;
}
/*----------------------------------------------------------------------------*/
void WLXPlugin::SetHotkey(const char hotkey)
{
 this->hotkey=(hotkey==' ')?' ':hotkey;
}
/*----------------------------------------------------------------------------*/
void WLXPlugin::SetAlias(const char* alias)
{
 strncpy(this->alias,alias,256);
}
/*----------------------------------------------------------------------------*/
void WLXPlugin::SetName(const char* pluginname)
{
 strncpy(this->name,pluginname,MYMAXPATH);
}
/*----------------------------------------------------------------------------*/
void WLXPlugin::SetMask(const char* pluginmask)
{
 Info.FSF->ExpandEnvironmentStr(pluginmask,this->mask,MYMAXPATH);
}
/*----------------------------------------------------------------------------*/
char WLXPlugin::GetHotkey(void) const
{
 return this->hotkey;
}
/*----------------------------------------------------------------------------*/
char* WLXPlugin::GetAlias(void) const
{
 return (char*)this->alias;
}
/*----------------------------------------------------------------------------*/
char* WLXPlugin::GetName(void) const
{
 return (char*)this->name;
}
/*----------------------------------------------------------------------------*/
char* WLXPlugin::GetMask(void) const
{
 return (char*)this->mask;
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::Load(void)
{
 OemToChar(this->name,this->name);
 this->hDLL=LoadLibrary(this->name);
 CharToOem(this->name,this->name);
 if (this->hDLL==NULL)
  return false;
 this->WLX_Load=(WLXLISTLOAD)GetProcAddress(this->hDLL,"ListLoad");
 if (this->WLX_Load==NULL)
 {
  FreeLibrary(this->hDLL);
  return false;
 }
 this->WLX_CloseWindow=(WLXLISTCLOSEWINDOW)GetProcAddress(this->hDLL,"ListCloseWindow");
 this->WLX_GetDetectString=(WLXLISTGETDETECTSTRING)GetProcAddress(this->hDLL,"ListGetDetectString");
 this->WLX_SearchText=(WLXLISTSEARCHTEXT)GetProcAddress(this->hDLL,"ListSearchText");
 this->WLX_SendCommand=(WLXLISTSENDCOMMAND)GetProcAddress(this->hDLL,"ListSendCommand");
 this->WLX_Print=(WLXLISTPRINT)GetProcAddress(this->hDLL,"ListPrint");
 this->WLX_NotificationReceived=(WLXLISTNOTIFICATIONRECEIVED)GetProcAddress(this->hDLL,"ListNotificationReceived");
 this->WLX_SetDefaultParams=(WLXLISTSETDEFAULTPARAMS)GetProcAddress(this->hDLL,"ListSetDefaultParams");
 this->WLX_GetPrevivBitmap=(WLXLISTGETPREVIEWBITMAP)GetProcAddress(this->hDLL,"ListGetPreviewBitmap");
 if (this->WLX_SetDefaultParams!=NULL)
 {
  ListDefaultParamStruct params;
  params.size=sizeof(ListDefaultParamStruct);
  params.PluginInterfaceVersionLow=50;
  params.PluginInterfaceVersionHi=1;
  GetModuleFileName(hinst,params.DefaultIniName,MAX_PATH);
  unsigned modulenamelength=(unsigned)(strlen(params.DefaultIniName)-1);
  while ((modulenamelength>0)&&(params.DefaultIniName[modulenamelength]!='\\')&&(params.DefaultIniName[modulenamelength]!='/'))
   modulenamelength--;
  params.DefaultIniName[modulenamelength]='\0';
  if (modulenamelength!=0)
  {
   strcat(params.DefaultIniName,"\\wlx.ini");
   this->WLX_SetDefaultParams(&params);
  }
 }
 return true;
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::Unload(void)
{
 if (this->hDLL!=NULL)
  FreeLibrary(this->hDLL);
 return true;
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::Verify(void)
{
 if (this->Load())
 {
  this->Unload();
  this->valid=true;
  return true;
 }
 else
 {
  this->valid=false;
  return false;
 }
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::Register(const char hotkey,const char* alias,const char* pluginname,const char* pluginmask)
{
 SetHotkey(hotkey);
 SetAlias(alias);
 SetName(pluginname);
 SetMask(pluginmask);

 OemToChar(this->name,this->name);
 int length=(int)strlen(this->name);
 if (length>3)
 {
  this->name[length-3]='w';
  this->name[length-2]='l';
  this->name[length-1]='m';
  this->hMetaDLL=LoadLibrary(this->name);
  this->name[length-3]='w';
  this->name[length-2]='l';
  this->name[length-1]='x';
  if (this->hMetaDLL!=NULL)
  {
   this->WLX_ListGetExtensions=(WLXLISTGETEXTENSIONS)GetProcAddress(this->hMetaDLL,"ListGetExtensions");
   this->WLX_ListIsSupported=(WLXLISTISSUPPORTED)GetProcAddress(this->hMetaDLL,"ListIsSupported");
  }
 }
 CharToOem(this->name,this->name);
 return true;
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::UnRegister(void)
{
 if (this->hMetaDLL!=NULL)
  FreeLibrary(this->hMetaDLL);
 return true;
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::IsSupportedMask(char* filename)
{
 if (this->WLX_ListGetExtensions!=NULL)
 {
  this->WLX_ListGetExtensions(hugebuffer,2048);
  return (Info.FSF->ProcessName(hugebuffer,filename,PN_CMPNAMELIST|PN_SKIPPATH)==TRUE);
 }
 else
  return false;
}
/*----------------------------------------------------------------------------*/
bool WLXPlugin::IsSupported(char* filename,char* buffer,int length)
{
 if (this->WLX_ListIsSupported!=NULL)
  return (this->WLX_ListIsSupported(filename,buffer,length)!=0);
 else
  return false;
}
/*============================================================================*/
WLXPluginInstance::WLXPluginInstance(WLXPlugin* plugin,char* arguments)
{
 this->hWnd=NULL;
 this->hWndStatic=NULL;
 this->plugin=plugin;
 strncpy(this->arguments,arguments,MYMAXPATH);
}
/*----------------------------------------------------------------------------*/
char* WLXPluginInstance::GetArguments(void) const
{
 return (char*)this->arguments;
}
/*----------------------------------------------------------------------------*/
WLXPlugin* WLXPluginInstance::GetPlugin(void) const
{
 return this->plugin;
}
/*----------------------------------------------------------------------------*/
HWND WLXPluginInstance::GetWindow(void) const
{
 return this->hWnd;
}
/*----------------------------------------------------------------------------*/
bool WLXPluginInstance::Load(HWND ParentWin)
{
 if (this->plugin!=NULL)
  if (this->plugin->Incriment())
  {
   if (this->plugin->WLX_Load!=NULL)
   {
    RECT rect;
    GetClientRect(ParentWin,&rect);
    this->hWndStatic=CreateWindow(WndClassName_WLXPlugin,"",WS_CHILD|WS_CLIPCHILDREN|WS_CLIPSIBLINGS|WS_VISIBLE,rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,ParentWin,NULL,hinst,NULL);
    this->hWnd=this->plugin->WLX_Load(this->hWndStatic,this->arguments,lcp_fittowindow|lcp_forceshow);
    if (this->hWnd==NULL)
    {
     DestroyWindow(this->hWndStatic);
     this->hWndStatic=NULL;
     this->plugin->Decriment();
     return false;
    }
    return true;
   }
   this->plugin->Decriment();
  }
 return false;
}
/*----------------------------------------------------------------------------*/
bool WLXPluginInstance::Size(int x,int y,int w,int h)
{
 if (this->hWnd!=NULL)
 {
  MoveWindow(this->hWndStatic,x,y,w,h,TRUE);
  MoveWindow(this->hWnd,0,0,w,h,TRUE);
  return true;
 }
 return false;
}
/*----------------------------------------------------------------------------*/
bool WLXPluginInstance::Focus(void)
{
 if (this->hWnd!=NULL)
 {
  SetFocus(this->hWnd);
  return true;
 }
 return false;
}
/*----------------------------------------------------------------------------*/
bool WLXPluginInstance::Show(void)
{
 if (this->hWndStatic!=NULL)
  ShowWindow(this->hWndStatic,SW_SHOW);
 if (this->hWnd!=NULL)
  ShowWindow(this->hWnd,SW_SHOW);
 return true;
}
/*----------------------------------------------------------------------------*/
bool WLXPluginInstance::Hide(void)
{
 if (this->hWnd!=NULL)
  ShowWindow(this->hWnd,SW_HIDE);
 if (this->hWndStatic!=NULL)
  ShowWindow(this->hWndStatic,SW_HIDE);
 return true;
}
/*----------------------------------------------------------------------------*/
bool WLXPluginInstance::Close(void)
{
 if (this->hWnd!=NULL)
 {
  if ((this->plugin!=NULL)&&(this->plugin->WLX_CloseWindow!=NULL))
   this->plugin->WLX_CloseWindow(this->hWnd);
  else
   DestroyWindow(this->hWnd);
  this->hWnd=NULL;
 }
 if (this->hWndStatic!=NULL)
 {
  DestroyWindow(this->hWndStatic);
  this->hWndStatic=NULL;
 }
 if (this->plugin!=NULL)
  this->plugin->Decriment();
 return true;
}
/*----------------------------------------------------------------------------*/
int WLXPluginInstance::Notify(HWND ParentWin,HWND hWnd,UINT iMsg,WPARAM wParam,LPARAM lParam)
{
 if (this->hWnd!=NULL)
  if (this->plugin!=NULL)
   if (this->plugin->WLX_NotificationReceived!=NULL)
    return this->plugin->WLX_NotificationReceived(hWnd,iMsg,wParam,lParam);
 return (int)DefWindowProc(ParentWin,iMsg,wParam,lParam);
}
/*============================================================================*/
