Unit DirCache;

{
 ***** version 1.0 ***** 
 (c) Pavel Zampach (zampach@volny.cz), 2004
 GNU GENERAL PUBLIC LICENSE 
 Source code for Borland Delphi Compiler (originally ver. 7.0)
}

interface

uses
  Filer;

const
  CACHE_OK      = 0;
  CACHE_EMPTY   = 1;
  CACHE_NOTREAD = 2;

procedure cacheInit;
procedure cacheReset;
function  cacheRead (var Data : TDirEntry) : byte;
function  cacheWrite (const Data : TDirEntry) : boolean;
function  cacheDelete (Delname : string) : boolean;

{ ------------------------------------------------------------------ }

implementation

uses
  SysUtils;

const
  MAX_ITEM = 1024;

var
  Items, ReadPtr : word;
  DirArray : array [1..MAX_ITEM] of TDirEntry;

{ ------------------------------------------------------------------ }

procedure cacheInit;
begin
  Items   := 0;
  ReadPtr := 0;
end;

{ ------------------------------------------------------------------ }

procedure cacheReset;
begin
  ReadPtr := 0;
end;

{ ------------------------------------------------------------------ }

function cacheRead (VAR Data : TDirEntry) : byte;
begin
  if Items = 0 then begin
    Result := CACHE_EMPTY;
    exit;
  end;  
  if ReadPtr = Items then begin
    Result := CACHE_NOTREAD;
    exit;
  end;
  
  inc (ReadPtr);
  Data := DirArray[ReadPtr];
  Result := CACHE_OK;
end;

{ ------------------------------------------------------------------ }

function cacheWrite (const Data : TDirEntry) : boolean;
begin
  Result := (Items < MAX_ITEM);
  if Result then begin
    inc (Items);
    DirArray[Items] := Data;
  end;
end;

{ ------------------------------------------------------------------ }

function  cacheDelete (Delname : string) : boolean;

var
  i : word;
  Sfname :string;
  
begin
  if Items = 0 then begin
    Result := false;
    exit;
  end;
  
  Delname := upperCase (Delname);
  i := 0;
  repeat
    inc (i);
    Sfname := string (DirArray[i].fname);
  until (i = Items) or (Delname = Sfname);
  Result := (Delname = Sfname);
  
  if Result then begin
    move (DirArray[i + 1], DirArray[i], (Items - i) * sizeOf (TDirEntry));
    dec (Items);
  end;
end;

{ ------------------------------------------------------------------ }

initialization
  cacheInit;
end.