/*
    WFX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan
    Copyright (C) 2005 Alex Yaroslavsky

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                    WFX2FAR CONSOLE WINDOW PROCEDURE                        //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
//          Alex Yaroslavsky aka T-Rex                                        //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wfx2far                                                           //
// PART:    Console window procedure                                          //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wfx2far.h>
/*============================================================================*/
bool pass;
char title[512];
char text[1024];
char retn[1024];
/*============================================================================*/
BOOL CALLBACK ProcessDlgProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
    case WM_INITDIALOG:
       SendMessage(GetDlgItem(hwndDlg,IDC_PROGRESS1),PBM_SETRANGE,0,MAKELPARAM(0,100));
       return TRUE;
    case WM_COMMAND:
      switch (LOWORD(wParam))
      {
        case IDCANCEL:
          process_cancel = true;
          return TRUE;
      }
  }
  return FALSE;
}
/*============================================================================*/
int __stdcall ProgressProc(int PluginNr,char* SourceName,char* TargetName,int PercentDone)
{
  if (process_cancel)
  {
    ShowWindow(hWnd_Process,SW_HIDE);
    return 1;
  }
  SendMessage(GetDlgItem(hWnd_Process,IDC_PROGRESS1),PBM_SETPOS,PercentDone,0);
  return 0;
}
/*============================================================================*/
void __stdcall LogProc(int PluginNr,int MsgType,char* LogString)
{
  WFXPluginInstance *inst = (WFXPluginInstance *) PluginNr;

  if (MsgType==MSGTYPE_CONNECT && lstrlen(LogString)>8 && LogString[8]=='\\')
  {
    inst->Connected(LogString+8);/*CONNECT \SomeRoot*/
  }
  else if (MsgType==MSGTYPE_DISCONNECT)
  {
    inst->Disconnected();
  }
}
/*============================================================================*/
BOOL CALLBACK RequestDlgProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
    case WM_INITDIALOG:
       SetWindowText(hwndDlg,title);
       SetWindowText(GetDlgItem(hwndDlg,IDC_BUTTON1),text);
       SetWindowText(GetDlgItem(hwndDlg,IDC_EDIT1),retn);
       if (pass)
       {
         SendMessage(GetDlgItem(hwndDlg,IDC_EDIT1),EM_SETPASSWORDCHAR,'*',0);
       }
       if (GetDlgCtrlID((HWND) wParam) != IDC_EDIT1)
       {
         SetFocus(GetDlgItem(hwndDlg, IDC_EDIT1));
         return FALSE;
       }
       return TRUE;
    case WM_COMMAND:
      switch (LOWORD(wParam))
      {
        case IDOK:
          if (!GetDlgItemText(hwndDlg,IDC_EDIT1,retn, 1024))
          {
            lstrcpyn(retn, "", 1024);
          }
        case IDCANCEL:
          EndDialog(hwndDlg, wParam);
          return TRUE;
      }
  }
  return FALSE;
}
/*----------------------------------------------------------------------------*/
BOOL __stdcall RequestProc(int PluginNr,int RequestType,char* CustomTitle,char* CustomText,char* ReturnedText,int maxlen)
{
  pass = ((RequestType == RT_Password) || (RequestType == RT_PasswordFirewall));
  if ((CustomTitle == NULL) || (*CustomTitle == '\0'))
  {
    lstrcpyn(title, "wfx2far", 512);
  }
  else
  {
    lstrcpyn(title, CustomTitle, 512);
    CharToOem(title,title);
  }
  if ((CustomText == NULL) || (*CustomText == '\0'))
  {
    switch (RequestType)
    {
      case RT_Other:
        lstrcpyn(text, "Other", 1024);
        break;
      case RT_UserName:
        lstrcpyn(text, "Enter user name", 1024);
        break;
      case RT_Password:
        lstrcpyn(text, "Enter password", 1024);
        break;
      case RT_Account:
        lstrcpyn(text, "Enter account", 1024);
        break;
      case RT_UserNameFirewall:
        lstrcpyn(text, "Enter firewall user name", 1024);
        break;
      case RT_PasswordFirewall:
        lstrcpyn(text, "Enter firewall password", 1024);
        break;
      case RT_TargetDir:
        lstrcpyn(text, "Enter target directory", 1024);
        break;
      case RT_URL:
        lstrcpyn(text, "Enter URL", 1024);
        break;
      default:
        lstrcpyn(text, "", 1024);
        break;
    }
  }
  else
  {
    lstrcpyn(text, CustomText, 1024);
    CharToOem(text,text);
  }
  if ((ReturnedText == NULL) || (*ReturnedText == '\0'))
  {
    lstrcpyn(retn, "", 1024);
  }
  else
  {
    lstrcpyn(retn, ReturnedText, min(1024, maxlen));
    CharToOem(retn,retn);
  }

  if ((RequestType == RT_MsgOK) ||
      (RequestType == RT_MsgYesNo) ||
      (RequestType == RT_MsgOKCancel))
  {
    SetForegroundWindow(hWnd_Dialog);
    UINT type;
    if (RequestType == RT_MsgOK)
    {
      type = MB_OK;
    }
    if (RequestType == RT_MsgYesNo)
    {
      type = MB_YESNO;
    }
    if (RequestType == RT_MsgOKCancel)
    {
      type = MB_OKCANCEL;
    }
    int res = MessageBox(hWnd_Dialog, text, title, type);
    SetForegroundWindow(hWnd_Global);
    return ((res == IDOK) || (res == IDYES)) ? TRUE : FALSE;
  }
  else
  {
    SetForegroundWindow(hWnd_Dialog);
    INT_PTR res = DialogBox(hinst,MAKEINTRESOURCE(IDD_DIALOG1),hWnd_Dialog,(DLGPROC)RequestDlgProc);
    lstrcpyn(ReturnedText, retn, min(1024, maxlen));
    SetForegroundWindow(hWnd_Global);
    return (res == IDOK);
  }
}
/*============================================================================*/
LRESULT CALLBACK Wnd_Console(HWND hWnd,UINT iMsg,WPARAM wParam,LPARAM lParam)
{
 // Lock function
 // Defender lock;
 static RECT cacherect,rect;
 switch (iMsg)
 {
  case WM_CREATE:
  {
   cacherect.left=0;
   cacherect.right=0;
   cacherect.top=0;
   cacherect.bottom=0;
   return 0;
  }
  case WM_LBUTTONDBLCLK:
  case WM_LBUTTONDOWN:
  case WM_LBUTTONUP:
  case WM_MBUTTONDBLCLK:
  case WM_MBUTTONDOWN:
  case WM_MBUTTONUP:
  case WM_RBUTTONDBLCLK:
  case WM_RBUTTONDOWN:
  case WM_RBUTTONUP:
  case WM_NCLBUTTONDBLCLK:
  case WM_NCLBUTTONDOWN:
  case WM_NCLBUTTONUP:
  case WM_NCMBUTTONDBLCLK:
  case WM_NCMBUTTONDOWN:
  case WM_NCMBUTTONUP:
  case WM_NCRBUTTONDBLCLK:
  case WM_NCRBUTTONDOWN:
  case WM_NCRBUTTONUP:
  {
   SetForegroundWindow(GetParent(hWnd));
   SendMessage(GetParent(hWnd),iMsg,wParam,lParam);
   return 0;
  }
  case WM_MOUSEHOVER:
  case WM_MOUSELEAVE:
  case WM_MOUSEMOVE:
  case WM_MOUSEWHEEL:
  {
   SendMessage(GetParent(hWnd),iMsg,wParam,lParam);
   return 0;
  }
  case WM_MOVE:
  case WM_SIZE:
  case WM_PAINT:
  {
   LRESULT res=0;
   GetWindowRect(hWnd_Global,&rect);
   if ((rect.left!=cacherect.left)||(rect.right!=cacherect.right)||(rect.top!=cacherect.top)||(rect.bottom!=cacherect.bottom))
   {
    MoveWindow(hWnd,0,0,rect.right-rect.left,rect.bottom-rect.top,TRUE);
    cacherect=rect;
   }
   else
   {
    if (iMsg==WM_PAINT)
    {
     PAINTSTRUCT ps;
     BeginPaint(hWnd,&ps);
     EndPaint(hWnd,&ps);
    }
    else
     res=DefWindowProc(hWnd,iMsg,wParam,lParam);
   }
   POINT p1,p2;
   GetClientRect(hWnd_Global,&rect);
   p1.x=rect.left;
   p1.y=rect.top;
   p2.x=rect.right;
   p2.y=rect.bottom;
   ClientToScreen(hWnd_Global,&p1);
   ClientToScreen(hWnd_Global,&p2);
   return res;
  }
  case WM_WFXOPEN:
  {
   WFXPluginInstance* inst=new WFXPluginInstance(Plugins[wParam]);
   if (inst->Load((int)inst,ProgressProc,LogProc,RequestProc))
    return (LRESULT)inst;
   else
   {
    delete inst;
    return (LRESULT)INVALID_HANDLE_VALUE;
   }
   break;
  }
  case WM_WFXCLOSE:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   if (inst!=NULL)
   {
    inst->Close();
    delete inst;
   }
   break;
  }
  case WM_WFXGETINFO:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   struct OpenPluginInfo *info=(struct OpenPluginInfo*)lParam;
   if ((inst!=NULL)&&(info!=NULL))
   {
    static char PanelTitle[1024*2+1];
    sprintf(PanelTitle,"wfx2far:%s:%s",inst->GetPlugin()->GetAlias(),inst->GetDir());
    info->StructSize = sizeof(struct OpenPluginInfo);
    info->Flags = OPIF_ADDDOTS|OPIF_USEHIGHLIGHTING;
    info->HostFile = NULL;
    info->CurDir = inst->GetDir();
    info->Format = inst->GetPlugin()->GetAlias();
    info->PanelTitle = PanelTitle;
    info->InfoLines = NULL;
    info->InfoLinesNumber = 0;
    info->DescrFiles = NULL;
    info->DescrFilesNumber = 0;
    info->PanelModesArray = NULL;
    info->PanelModesNumber = 0;
    info->StartPanelMode = 0;
    info->StartSortMode = 0;
    info->StartSortOrder = 0;
    info->KeyBar = NULL;
    info->ShortcutData = NULL;
    info->Reserverd = 0;
    return 0;
   }
   break;
  }
  case WM_WFXSETDIR:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   void **tmp=(void**)lParam;
   if ((inst!=NULL)&&(tmp[0]!=NULL))
    return (inst->SetDir((const char*)tmp[0])?TRUE:FALSE);
   else
    return FALSE;
  }
  case WM_WFXGETFILE:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   void **tmp=(void**)lParam;
   if ((inst!=NULL)&&(tmp[0]!=NULL)&&(tmp[1]!=NULL))
    return (inst->GetFileList((struct PluginPanelItem **)tmp[0],(int*)tmp[1])?TRUE:FALSE);
   else
    return FALSE;
   break;
  }
  case WM_WFXFREEFILE:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   void **tmp=(void**)lParam;
   if ((inst!=NULL)&&(tmp[0]!=NULL)&&(tmp[1]!=NULL))
    return (inst->FreeFileList((struct PluginPanelItem *)tmp[0],*((int*)tmp[1]))?TRUE:FALSE);
   else
    return FALSE;
   break;
  }
  case WM_WFXPROCESSKEY:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   void **tmp=(void**)lParam;
   if ((inst!=NULL)&&(tmp[0]!=NULL)&&(tmp[1]!=NULL)&&(tmp[2]!=NULL))
    return (inst->ProcessKey(*((int*)tmp[0]),*((unsigned int*)tmp[1]),(const char*)tmp[2])?TRUE:FALSE);
   else
    return FALSE;
   break;
  }
  case WM_WFXGETFILES:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   void **tmp=(void**)lParam;
   if ((inst!=NULL)&&(tmp[0]!=NULL)&&(tmp[1]!=NULL)&&(tmp[2]!=NULL)&&(tmp[3]!=NULL)&&(tmp[4]!=NULL))
   {
    inst->StatusInfo(FS_STATUS_START,(*((int*)tmp[1]))==1?FS_STATUS_OP_GET_SINGLE:FS_STATUS_OP_GET_MULTI);
    BOOL res=(inst->GetFiles((struct PluginPanelItem *)tmp[0],*((int*)tmp[1]),*((int*)tmp[2]),(char *)tmp[3],*((int*)tmp[4]))?TRUE:FALSE);
    inst->StatusInfo(FS_STATUS_END,(*((int*)tmp[1]))==1?FS_STATUS_OP_GET_SINGLE:FS_STATUS_OP_GET_MULTI);
    return res;
   }
   else
    return FALSE;
   break;
  }
  case WM_WFXPUTFILES:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   void **tmp=(void**)lParam;
   if ((inst!=NULL)&&(tmp[0]!=NULL)&&(tmp[1]!=NULL)&&(tmp[2]!=NULL)&&(tmp[3]!=NULL))
   {
    inst->StatusInfo(FS_STATUS_START,(*((int*)tmp[1]))==1?FS_STATUS_OP_GET_SINGLE:FS_STATUS_OP_GET_MULTI);
    BOOL res=(inst->PutFiles((struct PluginPanelItem *)tmp[0],*((int*)tmp[1]),*((int*)tmp[2]),*((int*)tmp[3]))?TRUE:FALSE);
    inst->StatusInfo(FS_STATUS_END,(*((int*)tmp[1]))==1?FS_STATUS_OP_GET_SINGLE:FS_STATUS_OP_GET_MULTI);
    return res;
   }
   else
    return FALSE;
   break;
  }
  case WM_WFXDELFILE:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   void **tmp=(void**)lParam;
   if ((inst!=NULL)&&(tmp[0]!=NULL)&&(tmp[1]!=NULL)&&(tmp[2]!=NULL))
   {
    inst->StatusInfo(FS_STATUS_START,FS_STATUS_OP_DELETE);
    BOOL res=(inst->DeleteFiles((struct PluginPanelItem *)tmp[0],*((int*)tmp[1]),*((int*)tmp[2]))?TRUE:FALSE);
    inst->StatusInfo(FS_STATUS_END,FS_STATUS_OP_DELETE);
    return res;
   }
   else
    return FALSE;
   break;
  }
  case WM_WFXMKDIR:
  {
   WFXPluginInstance* inst=(WFXPluginInstance*)wParam;
   void **tmp=(void**)lParam;
   if ((inst!=NULL)&&(tmp[0]!=NULL)&&(tmp[1]!=NULL))
   {
    inst->StatusInfo(FS_STATUS_START,FS_STATUS_OP_MKDIR);
    BOOL res=(inst->MakeDirectory((char *)tmp[0],*((int*)tmp[1]))?TRUE:FALSE);
    inst->StatusInfo(FS_STATUS_END,FS_STATUS_OP_MKDIR);
    return res;
   }
   else
    return FALSE;
   break;
  }
 }
 return DefWindowProc(hWnd,iMsg,wParam,lParam);
}
/*============================================================================*/
