/*
    WFX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan
    Copyright (C) 2005 Alex Yaroslavsky

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                              WFX2FAR                                       //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
//          Alex Yaroslavsky aka T-Rex                                        //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wfx2far                                                           //
// PART:    Main header                                                       //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#ifndef __WFX2FAR_HPP__
#define __WFX2FAR_HPP__
/*============================================================================*/
#if (_WIN32_WINNT < 0x0500)
  #if defined(_WIN32_WINNT)
    #undef _WIN32_WINNT
  #endif
  #define _WIN32_WINNT 0x0500
#endif
/*============================================================================*/
#define MYMAXPATH 1024
#define sizeofa(array) (sizeof(array)/sizeof(array[0]))
#define WM_WFXOPEN         WM_USER+0
#define WM_WFXCLOSE        WM_USER+1
#define WM_WFXSETDIR       WM_USER+2
#define WM_WFXGETFILE      WM_USER+3
#define WM_WFXFREEFILE     WM_USER+4
#define WM_WFXGETINFO      WM_USER+5
#define WM_WFXPROCESSKEY   WM_USER+6
#define WM_WFXGETFILES     WM_USER+7
#define WM_WFXPUTFILES     WM_USER+8
#define WM_WFXDELFILE      WM_USER+9
#define WM_WFXMKDIR        WM_USER+10
/*============================================================================*/
#include <vector>
#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <string.h>
#include <plugin.h>
#include <WFXplugin.h>
#include <wnd_console.h>
#include <resource.h>
/*============================================================================*/
#pragma warning(disable:4311)
#pragma warning(disable:4312)
/*==========================================================================*/
#include <wfx2far-lng.h>
const char *GetMsg(int MsgId);
/*============================================================================*/
extern struct PluginStartupInfo Info;
extern struct FarStandardFunctions FSF;
extern volatile bool process_cancel;
extern volatile bool installed;
extern volatile bool toinstall;
extern volatile bool touninstall;
extern volatile HINSTANCE hinst;
extern volatile HWND hWnd_Global;
extern volatile HWND hWnd_Console;
extern volatile HWND hWnd_Dialog;
extern volatile HWND hWnd_Process;
extern std::vector<WFXPlugin*> Plugins;
extern char* WndClassName_Console;
extern char* WndClassName_Dialog;
extern char buffer1[MYMAXPATH];
extern char PluginArgs[MYMAXPATH];
extern char PluginName[MYMAXPATH];
extern char PluginRootKey[80];
extern unsigned modulenamelength;

extern volatile bool Exec_Start;
extern volatile bool Exec_End;
extern volatile int Exec_Result;
extern volatile WFX_EXECUTEFILE Exec_Function;
extern char Exec_Path[MYMAXPATH];
extern char Exec_Command[256];
/*============================================================================*/
struct InitDialogItem
{
 int Type;
 int X1,Y1,X2,Y2;
 int Focus;
 int Selected;
 DWORD Flags;
 int DefaultButton;
 const char *Data;
 const char *History;
};
/*----------------------------------------------------------------------------*/
void InitDialogItems(const struct InitDialogItem *Init,struct FarDialogItem *Item,int ItemsNumber);
BOOL CALLBACK ProcessDlgProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam);
/*============================================================================*/
class Defender
{
public:
  static bool initialize(void)
  {
    mutex = CreateMutex(NULL, FALSE, "FarConsoleMutex");
    if (mutex == NULL)
    {
      mutex = OpenMutex(MUTEX_ALL_ACCESS, TRUE, "FarConsoleMutex");
      if (mutex == NULL)
        return false;
    }
    return true;
  }
  static bool deinitialize(void)
  {
    if (mutex != NULL)
    {
      CloseHandle(mutex);
      mutex = NULL;
    }
    return true;
  }

  Defender(void)
  {
    if (mutex != NULL)
      WaitForSingleObject(mutex, INFINITE);
  }
 ~Defender(void)
  {
    if (mutex != NULL)
      ReleaseMutex(mutex);
  }

private:
  static HANDLE mutex;
};
/*============================================================================*/
#include <registry.h>
/*============================================================================*/
bool wfx2far_Install(void);
bool wfx2far_Uninstall(void);

bool wfx2far_InstallPlugin(char hotkey,char* alias,char* pluginname,bool showinmenu);
bool wfx2far_UninstallPlugin(char* pluginname);

HANDLE wfx2far_Command(const char* cmd);
HANDLE wfx2far_Run(const char* pluginname,bool alias);
/*============================================================================*/
#endif /* __WFX2FAR_HPP__ */
