/*
    WFX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan
    Copyright (C) 2005 Alex Yaroslavsky

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                              WFX2FAR                                       //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
//          Alex Yaroslavsky aka T-Rex                                        //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wfx2far                                                           //
// PART:    Main part                                                         //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wfx2far.h>
/*============================================================================*/
volatile bool process_cancel=false;
volatile bool installed=false;
volatile bool toinstall=false;
volatile bool touninstall=false;
volatile HINSTANCE hinst=NULL;
volatile HWND hWnd_Global=NULL;
volatile HWND hWnd_Console=NULL;
volatile HWND hWnd_Dialog=NULL;
volatile HWND hWnd_Process=NULL;
std::vector<WFXPlugin*> Plugins;
char* WndClassName_Console="wfx2far";
char* WndClassName_Dialog="TTOTAL_CMD";
char buffer1[MYMAXPATH]="";
char PluginArgs[MYMAXPATH]="";
char PluginName[MYMAXPATH]="";
char PluginRootKey[80];
unsigned modulenamelength=0;

volatile bool Exec_Start = false;
volatile bool Exec_End = false;
volatile int Exec_Result = 0;
volatile WFX_EXECUTEFILE Exec_Function = NULL;
char Exec_Path[MYMAXPATH] = "";
char Exec_Command[256] = "";
/*============================================================================*/
HANDLE Defender::mutex = NULL;
/*==========================================================================*/
bool ShowPluginMenu(void)
{
 bool result=false;
 int BreakCode=0;
 int BreakKeys[]={VK_F4,0};
 int ExitCode;
 int SelectedItem=0;
 while (BreakCode!=-1)
 {
  FarMenuItemEx *MenuItems=new FarMenuItemEx[Plugins.size()];
  int i=0;
  for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++,i++)
  {
   MenuItems[i].Flags=((*it)->IsValid())?0:MIF_DISABLE;
   sprintf(MenuItems[i].Text.Text,"&%c %s",(*it)->GetHotkey(),(*it)->GetAlias());
   MenuItems[i].AccelKey=0;
   MenuItems[i].Reserved=0;
   MenuItems[i].UserData=0;
  }
  MenuItems[SelectedItem].Flags|=MIF_SELECTED;
  ExitCode=Info.Menu(Info.ModuleNumber,-1,-1,0,FMENU_USEEXT|FMENU_WRAPMODE,GetMsg(lngPluginNotFound),GetMsg(lngMenuBottomStringEx),NULL,BreakKeys,&BreakCode,(struct FarMenuItem *)MenuItems,(int)(Plugins.size()));
  if (ExitCode>=0)
  {
   if (BreakCode==0)
   {
    char temp[2];
    temp[0]=Plugins[ExitCode]->GetHotkey();
    temp[1]='\0';
    struct InitDialogItem InitItems[]=
    {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
     /*00*/ { DI_DOUBLEBOX,   3, 1,55,10, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngEdit),                              NULL},
     /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngPluginHotKey),                      NULL},
     /*02*/ { DI_FIXEDIT,     5, 3, 5, 3, 0, 0, 0,                                    0,      temp,                                         NULL},
     /*03*/ { DI_TEXT,        5, 4, 0, 4, 0, 0, 0,                                    0,      GetMsg(lngPluginAlias),                       NULL},
     /*04*/ { DI_EDIT,        5, 5,53, 5, 0, 0, DIF_HISTORY,                          0,      Plugins[ExitCode]->GetAlias(),                "wfx2far.History.InastallPlugin.Alias"},
     /*05*/ { DI_TEXT,        5, 6, 0, 6, 0, 0, 0,                                    0,      GetMsg(lngPluginFileName),                    NULL},
     /*06*/ { DI_EDIT,        5, 7,53, 7, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode]->GetName(),                 NULL},
     /*07*/ { DI_TEXT,        0, 8, 0, 8, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                                           NULL},
     /*08*/ { DI_BUTTON,      0, 9, 0, 9, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),                                NULL},
     /*09*/ { DI_BUTTON,      0, 9, 0, 9, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),                            NULL}
    };
    struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
    InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
    int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,12,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
    if (n==8)
    {
     bool found=false;
     for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
      if ((_stricmp((*it)->GetAlias(),DialogItems[4].Data)==0)&&((*it)!=Plugins[ExitCode]))
      {
       found=true;
       char errormessage[256];
       sprintf(errormessage,"Alias '%s' already exist",DialogItems[4].Data);
       Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
       break;
      }
     Plugins[ExitCode]->SetHotkey((DialogItems[2].Data[0]=='\0')?' ':DialogItems[2].Data[0]);
     if (!found)
      Plugins[ExitCode]->SetAlias(DialogItems[4].Data);
    }
   }
   if (BreakCode==1)
    BreakCode=-1;
   else
   {
    MenuItems[SelectedItem].Flags&=~MIF_SELECTED;
    SelectedItem=ExitCode;
   }
   if (BreakCode==-1)
   {
    strncpy(PluginName,Plugins[ExitCode]->GetName(),MYMAXPATH);
    result=true;
   }
  }
  delete [] MenuItems;
 }
 return result;
}
/*============================================================================*/
int WINAPI SearchFunct(const WIN32_FIND_DATA *FData,const char *FullName,void *Param)
{
 for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  if (_stricmp((*it)->GetName(),FullName)==0)
   return TRUE;
 char Alias[256];
 strncpy(Alias,Info.FSF->PointToName(FullName),256);
 bool end=false;
 while (!end)
 {
  end=true;
  for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
   if (_stricmp((*it)->GetAlias(),Alias)==0)
   {
    strcat(Alias,"_");
    end=false;
    break;
   }
 }
 SetFileApisToANSI();
 WFXPlugin* newplugin=new WFXPlugin;
 if (newplugin->Register(' ',Alias,FullName,false))
  Plugins.push_back(newplugin);
 else
  delete newplugin;
 SetFileApisToOEM();
 return TRUE;
}
/*============================================================================*/
HANDLE wfx2far_Command(const char* cmd)
{
 if (strncmp(cmd,"wfx2far:install",strlen("wfx2far:install"))==0)
 {
  if (installed)
  {
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wfx2far is already installed",0,0);
   return INVALID_HANDLE_VALUE;
  }
  else
  {
   toinstall=true;
   while (toinstall) Sleep(1);
   while (!installed) Sleep(1);
   return INVALID_HANDLE_VALUE;
  }
 }
 if (strncmp(cmd,"wfx2far:uninstall",strlen("wfx2far:uninstall"))==0)
 {
  if (!installed)
  {
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wfx2far is not installed",0,0);
   return INVALID_HANDLE_VALUE;
  }
  else
  {
   touninstall=true;
   while (touninstall) Sleep(1);
   while (installed) Sleep(1);
   return INVALID_HANDLE_VALUE;
  }
 }
 if (strncmp(cmd,"wfx2far:search",strlen("wfx2far:search"))==0)
 {
  if (!installed)
  {
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wfx2far is not installed",0,0);
   return INVALID_HANDLE_VALUE;
  }
  else
  {
   HANDLE hScreen=Info.SaveScreen(0,0,-1,-1);
   int i=GetRegKey(HKEY_CURRENT_USER,"","ShowStartupInfo",1);
   if (i==1)
   {
    const char *MsgItems[]={GetMsg(lngMessage),GetMsg(lngMessageScan)};
    Info.Message(Info.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(*MsgItems),0);
   }
   Info.FSF->FarRecursiveSearch(cmd+strlen("wfx2far:search")+1,"*.wfx",SearchFunct,FRS_RECUR,NULL);
   SetFileApisToANSI();
   for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    (*it)->Verify();
   SetFileApisToOEM();
   Info.RestoreScreen(hScreen);
   return INVALID_HANDLE_VALUE;
  }
 }
 if (strncmp(cmd,"wfx2far:plugin_install",strlen("wfx2far:plugin_install"))==0)
 {
  char alias[256];
  char pluginname[MYMAXPATH];
  char pluginmask[MYMAXPATH];
  sscanf(cmd,"wfx2far:plugin_install %s %s",alias,pluginname);
  strncpy(pluginmask,cmd+strlen("wfx2far:plugin_install")+strlen(alias)+strlen(pluginname)+3,MYMAXPATH);
  wfx2far_InstallPlugin(' ',alias,pluginname,false);
  return INVALID_HANDLE_VALUE;
 }
 if (strncmp(cmd,"wfx2far:plugin_uninstall",strlen("wfx2far:plugin_uninstall"))==0)
 {
  char pluginname[MYMAXPATH];
  sscanf(cmd,"wfx2far:plugin_uninstall %s",pluginname);
  wfx2far_UninstallPlugin(pluginname);
  return INVALID_HANDLE_VALUE;
 }
 if (strncmp(cmd,"wfx2far:",strlen("wfx2far:"))==0)
 {
   return wfx2far_Run(cmd+strlen("wfx2far:"),true);
 }
 else
 {
   return wfx2far_Run(cmd+strlen("wfx:"),true);
 }
}
/*----------------------------------------------------------------------------*/
bool wfx2far_Install(void)
{
 if (installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wfx2far is already installed",0,0);
  return false;
 }

 // Initialize mutex
 if (!Defender::initialize())
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't initialize console mutex",0,0);
  return false;
 }

 // Lock function
 Defender lock;

 CoInitialize(NULL);
 InitCommonControls();

 WNDCLASSEX WndClass;
 WndClass.cbSize        = sizeof(WndClass);
 WndClass.style         = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;
 WndClass.lpfnWndProc   = Wnd_Console;
 WndClass.cbClsExtra    = 0;
 WndClass.cbWndExtra    = 0;
 WndClass.hInstance     = hinst;
 WndClass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
 WndClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
 WndClass.hbrBackground = (HBRUSH)GetStockObject(NULL_BRUSH);
 WndClass.lpszMenuName  = NULL;
 WndClass.lpszClassName = WndClassName_Console;
 WndClass.hIconSm       = LoadIcon(NULL,IDI_APPLICATION);
 RegisterClassEx(&WndClass);
 // Create console window
 hWnd_Global=GetConsoleWindow();
 hWnd_Console=CreateWindow(WndClassName_Console,"",WS_CHILD|WS_CLIPSIBLINGS,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,hWnd_Global,NULL,hinst,NULL);
 if (hWnd_Console==NULL)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't create console window",0,0);
  return false;
 }
 ShowWindow(hWnd_Console,SW_SHOWMAXIMIZED);
 UpdateWindow(hWnd_Console);

 FILE* inifile;
 char hotkey;
 char alias[256];
 char inifilename[MYMAXPATH];
 char fullpluginname[MYMAXPATH];
 GetModuleFileName(hinst,inifilename,MYMAXPATH);
 inifilename[strlen(inifilename)-1]='i';
 inifilename[strlen(inifilename)-2]='n';
 inifilename[strlen(inifilename)-3]='i';
 inifile=fopen(inifilename,"rb");
 if (inifile!=NULL)
 {
  while (fgets(inifilename,MYMAXPATH,inifile)!=NULL)
  {
   for (unsigned i=0;i<strlen(inifilename);i++)
    if ((inifilename[i]=='\r')||(inifilename[i]=='\n'))
    {
     inifilename[i]='\0';
     break;
    }
   if (inifilename[0]!='#')
   {
    unsigned i,j=0;
    sscanf(inifilename,"%c - %s ? ",&hotkey,&alias);
    i=(unsigned)(strlen(alias)+6);
    while (inifilename[++i]!='?')
     fullpluginname[j++]=inifilename[i];
    fullpluginname[j-1]='\0';
    bool exist=false;
    for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    {
     if ((_stricmp((*it)->GetAlias(),alias)==0)&&(_stricmp((*it)->GetName(),fullpluginname)==0))
     {
      exist=true;
      break;
     }
    }
    if (exist)
    {
     sprintf(inifilename,"Plugin '%s' already exist",fullpluginname);
     Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)inifilename,0,0);
    }
    else
    {
     bool end=false;
     while (!end)
     {
      end=true;
      for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
       if (_stricmp((*it)->GetAlias(),alias)==0)
       {
        strcat(alias,"_");
        end=false;
        break;
       }
     }
     SetFileApisToANSI();
     WFXPlugin* newplugin=new WFXPlugin;
     if (newplugin->Register(hotkey,alias,fullpluginname,(inifilename[i+2]=='1')))
      Plugins.push_back(newplugin);
     else
     {
      sprintf(inifilename,"Can't register default plugin '%s'",fullpluginname);
      Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)inifilename,0,0);
      delete newplugin;
     }
     SetFileApisToOEM();
    }
   }
  }
  fclose(inifile);
 }
 SetForegroundWindow(hWnd_Global);
 installed=true;
 return true;
}
/*----------------------------------------------------------------------------*/
bool wfx2far_Uninstall(void)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wfx2far is not installed",0,0);
  return false;
 }
 DestroyWindow(hWnd_Process);
 DestroyWindow(hWnd_Console);
 DestroyWindow(hWnd_Dialog);
 UnregisterClass(WndClassName_Console,hinst);
 UnregisterClass(WndClassName_Dialog,hinst);
 for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
 {
  (*it)->UnRegister();
  delete *it;
 }
 Plugins.clear();
 CoUninitialize();
 // Deinitialize mutex
 if (!Defender::deinitialize())
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't deinitialize console mutex",0,0);
  return false;
 }
 installed=false;
 return true;
}
/*----------------------------------------------------------------------------*/
bool wfx2far_InstallPlugin(char hotkey,char* alias,char* pluginname,bool showinmenu)
{
 char errormessage[MYMAXPATH];
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wfx2far is not installed",0,0);
  return false;
 }
 bool exist=false;
 for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  if ((_stricmp((*it)->GetAlias(),alias)==0)&&(_stricmp((*it)->GetName(),pluginname)==0))
  {
   exist=true;
   break;
  }
 if (exist)
 {
  sprintf(errormessage,"Plugin '%s' already exist",alias);
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
  return false;
 }
 else
 {
  char Alias[256];
  strncpy(Alias,alias,256);
  bool end=false;
  while (!end)
  {
   end=true;
   for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
    if (_stricmp((*it)->GetAlias(),Alias)==0)
    {
     strcat(Alias,"_");
     end=false;
     break;
    }
  }
  SetFileApisToANSI();
  WFXPlugin* newplugin=new WFXPlugin;
  if (newplugin->Register(hotkey,Alias,pluginname,showinmenu)&&(newplugin->Verify()))
   Plugins.push_back(newplugin);
  else
  {
   sprintf(errormessage,"Can't instal plugin '%s'",pluginname);
   Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
   delete newplugin;
   SetFileApisToOEM();
   return false;
  }
  SetFileApisToOEM();
 }
 return true;
}
/*----------------------------------------------------------------------------*/
bool wfx2far_UninstallPlugin(char* pluginname)
{
 if (!installed)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wfx2far is not installed",0,0);
  return false;
 }
 strncpy(PluginName,pluginname,MYMAXPATH);
 for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  if (_stricmp((*it)->GetAlias(),pluginname)==0)
  {
   strncpy(PluginName,(*it)->GetName(),MYMAXPATH);
   break;
  }
 for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
  if ((_stricmp((*it)->GetAlias(),pluginname)==0)||(_stricmp((*it)->GetName(),pluginname)==0))
  {
   if (!(*it)->UnRegister())
   {
    char errormessage[MYMAXPATH];
    sprintf(errormessage,"Can't unregister plugin '%s'",pluginname);
    Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
    return false;
   }
   else
   {
    delete *it;
    Plugins.erase(it);
   }
   break;
  }
 return true;
}
/*----------------------------------------------------------------------------*/
HANDLE wfx2far_Run(const char* pluginname,bool alias)
{
  int i=0;
  for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++,i++)
    if (_stricmp((alias)?((*it)->GetAlias()):((*it)->GetName()),pluginname)==0)
      break;
  if (i==Plugins.size())
  {
    char errormessage[MYMAXPATH];
    sprintf(errormessage,"Can't run plugin '%s'",pluginname);
    SetForegroundWindow(hWnd_Global);
    Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
    return INVALID_HANDLE_VALUE;
  }
  return (HANDLE)SendMessage(hWnd_Console,WM_WFXOPEN,i,0);
}
/*============================================================================*/
