/*
    WFX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan
    Copyright (C) 2005 Alex Yaroslavsky

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                            WFX2FAR PLUGIN                                  //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
//          Alex Yaroslavsky aka T-Rex                                        //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wfx2far                                                           //
// PART:    FAR plugin                                                        //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wfx2far.h>
/*============================================================================*/
DWORD confirmDelete;
DWORD confirmCopy;
DWORD threadID=0;
HANDLE hThread=NULL;
DWORD dlgthreadID=0;
HANDLE hdlgThread=NULL;
/*============================================================================*/
DWORD WINAPI dlgThreadProc(LPVOID lpParameter)
{
 while (!installed)
   Sleep(1);

 WNDCLASSEX WndClass;
 WndClass.cbSize        = sizeof(WndClass);
 WndClass.style         = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;
 WndClass.lpfnWndProc   = Wnd_Console;
 WndClass.cbClsExtra    = 0;
 WndClass.cbWndExtra    = 0;
 WndClass.hInstance     = hinst;
 WndClass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
 WndClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
 WndClass.hbrBackground = (HBRUSH)GetStockObject(NULL_BRUSH);
 WndClass.lpszMenuName  = NULL;
 WndClass.lpszClassName = WndClassName_Dialog;
 WndClass.hIconSm       = LoadIcon(NULL,IDI_APPLICATION);
 RegisterClassEx(&WndClass);
 // Create console window
 hWnd_Dialog=CreateWindow(WndClassName_Dialog,"",WS_CHILD|WS_CLIPSIBLINGS,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,hWnd_Global,NULL,hinst,NULL);
 if (hWnd_Dialog==NULL)
 {
  Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"Can't create console window",0,0);
  return false;
 }
 ShowWindow(hWnd_Dialog,SW_SHOWMAXIMIZED);
 UpdateWindow(hWnd_Dialog);

 // Create dialog box
 hWnd_Process=CreateDialog(hinst,MAKEINTRESOURCE(IDD_DIALOG2),GetDesktopWindow(),(DLGPROC)ProcessDlgProc);
 SetForegroundWindow(hWnd_Global);

 HANDLE* pObjects = NULL;
 int objects = 0;
 while (TRUE)
 {
   DWORD result;
   MSG msg;

   while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
   {
     if (msg.message == WM_QUIT)
     {
       return 1;
     }

     if (!IsWindow(hWnd_Process) || !IsDialogMessage(hWnd_Process, &msg))
     {
       TranslateMessage(&msg);
       DispatchMessage(&msg);
     }
   }

   if (Exec_Start)
   {
     Exec_Result = FS_EXEC_OK;
     if (Exec_Function!=NULL)
     {
       SetForegroundWindow(hWnd_Dialog);
       SetFileApisToANSI();
       Exec_Result = Exec_Function(hWnd_Dialog,Exec_Path,Exec_Command);
     }
     Exec_Start = false;
     Exec_End = false;
   }

   result = MsgWaitForMultipleObjects(objects, pObjects, FALSE, 1, QS_ALLINPUT);
   if (result == (WAIT_OBJECT_0 + objects))
     continue;
 }
 return 0;
}
/*============================================================================*/
DWORD WINAPI ThreadProc(LPVOID lpParameter)
{
 while (true)
 {
  if (toinstall)
  {
   toinstall=false;
   if (wfx2far_Install())
   {
     HANDLE* pObjects = NULL;
     int objects = 0;

     while (TRUE)
     {
       DWORD result;
       MSG msg;

       while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
       {
         if (msg.message == WM_QUIT)
         {
           wfx2far_Uninstall();
           return 1;
         }

         TranslateMessage(&msg);
         DispatchMessage(&msg);
       }
       result = MsgWaitForMultipleObjects(objects, pObjects, FALSE, INFINITE, QS_ALLINPUT);
       if (result == (WAIT_OBJECT_0 + objects))
       {
         if (touninstall)
         {
           wfx2far_Uninstall();
           touninstall=false;
           break;
         }
         continue;
       }
     }
   }
  }
  else
   Sleep(1);
 }
 return 0;
}
/*============================================================================*/
/*
  PluginStartupInfo   
 SetStartupInfo     
 .
*/
struct PluginStartupInfo Info;
/*----------------------------------------------------------------------------*/
/*
  FarStandardFunctions     
   Far.exe
*/
static FarStandardFunctions FSF;
/*============================================================================*/
/*
  GetMsg      .
     Info.GetMsg   
*/
const char *GetMsg(int MsgId)
{
 return (Info.GetMsg(Info.ModuleNumber,MsgId));
}
/*----------------------------------------------------------------------------*/
/*
  InitDialogItems     
 InitDialogItem  FarDialogItem
*/
void InitDialogItems(const struct InitDialogItem *Init,struct FarDialogItem *Item,int ItemsNumber)
{
 int I;
 struct FarDialogItem *PItem=Item;
 const struct InitDialogItem *PInit=Init;
 for (I=0;I<ItemsNumber;I++,PItem++,PInit++)
 {
  PItem->Type=PInit->Type;
  PItem->X1=PInit->X1;
  PItem->Y1=PInit->Y1;
  PItem->X2=PInit->X2;
  PItem->Y2=PInit->Y2;
  PItem->Focus=PInit->Focus;
  PItem->Selected=PInit->Selected;
  if (PInit->History!=NULL)
   PItem->History=PInit->History;
  PItem->Flags=PInit->Flags;
  PItem->DefaultButton=PInit->DefaultButton;
  if ((unsigned int)PInit->Data<2000)
   strcpy(PItem->Data,GetMsg((unsigned int)PInit->Data));
  else
   strcpy(PItem->Data,PInit->Data);
 }
}
/*----------------------------------------------------------------------------*/
/*
 FAR   GetMinFarVersion  
    ,   
  .
*/
int WINAPI GetMinFarVersion(void)
{
 return MAKEFARVERSION(1,70,5);
}
/*----------------------------------------------------------------------------*/
/*
  SetStartupInfo   ,  
  .    ,
    .
*/
void WINAPI SetStartupInfo(const struct PluginStartupInfo *psi)
{
 Info=*psi;
 FSF=*psi->FSF;
 Info.FSF=&FSF;
 strcpy(PluginRootKey,Info.RootKey);
 strcat(PluginRootKey,"\\wfx2far");
 hThread=CreateThread(NULL,0,ThreadProc,NULL,0,&threadID);
 hdlgThread=CreateThread(NULL,0,dlgThreadProc,NULL,0,&dlgthreadID);
 if (!installed)
 {
  HANDLE hScreen=Info.SaveScreen(0,0,-1,-1);
  int i=GetRegKey(HKEY_CURRENT_USER,"","ShowStartupInfo",1);
  if (i==1)
  {
   const char *MsgItems[]={GetMsg(lngMessage),GetMsg(lngMessageUpdate)};
   Info.Message(Info.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(*MsgItems),0);
  }
  wfx2far_Command("wfx2far:install");
  Info.RestoreScreen(hScreen);
  char command[MYMAXPATH];
  char rootpathname[MYMAXPATH];
  GetModuleFileName(hinst,command,MYMAXPATH);
  modulenamelength=(unsigned)strlen(command);
  unsigned l=modulenamelength-1;
  while ((l>0)&&(command[l]!='\\')&&(command[l]!='/'))
   l--;
  command[l]='\0';
  modulenamelength-=l+1;
  SetRegKey(HKEY_CURRENT_USER,"","PluginPath",command);
  strcat(command,"\\Plugins");
  GetRegKey(HKEY_CURRENT_USER,"","DefaultPath",rootpathname,command,MYMAXPATH);
  int StartSearch=GetRegKey(HKEY_CURRENT_USER,"","StartSearch",1);
  if (StartSearch!=0)
  {
   strcpy(command,"wfx2far:search ");
   strcat(command,rootpathname);
   wfx2far_Command(command);
  }
  confirmDelete = GetRegKey(HKEY_CURRENT_USER,"","ConfirmDelete", 1);
  confirmCopy = GetRegKey(HKEY_CURRENT_USER,"","ConfirmCopy", 0);
  SetForegroundWindow(hWnd_Global);
 }
}
/*----------------------------------------------------------------------------*/
/*
  GetPluginInfo    
   
*/
void WINAPI GetPluginInfo(struct PluginInfo *pi)
{
 static char PluginDiskMenuStringsFull[100][256];
 static const char *PluginDiskMenuStrings[100];
 static const char *PluginMenuStrings[1];
 static const char *PluginConfigStrings[1];
 PluginMenuStrings[0]=GetMsg(lngPluginName);
 PluginConfigStrings[0]=GetMsg(lngPluginConfigName);
 pi->StructSize=sizeof(struct PluginInfo);
 pi->Flags=PF_PRELOAD|PF_FULLCMDLINE;
 pi->DiskMenuStringsNumber=0;
 for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
 {
  if ((*it)->GetShowInMenu())
  {
   PluginDiskMenuStrings[pi->DiskMenuStringsNumber]=PluginDiskMenuStringsFull[pi->DiskMenuStringsNumber];
   strncpy(PluginDiskMenuStringsFull[pi->DiskMenuStringsNumber],(*it)->GetAlias(),255);
   pi->DiskMenuStringsNumber++;
  }
 }
 pi->DiskMenuStrings=PluginDiskMenuStrings;
 pi->PluginMenuStrings=PluginMenuStrings;
 pi->PluginMenuStringsNumber=sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);
 pi->PluginConfigStrings=PluginConfigStrings;
 pi->PluginConfigStringsNumber=sizeof(PluginConfigStrings)/sizeof(PluginConfigStrings[0]);
 pi->CommandPrefix="wfx2far:wfx";
}
/*----------------------------------------------------------------------------*/
/*
  OpenPlugin      
*/
HANDLE WINAPI OpenPlugin(int OpenFrom,int Item)
{
 switch (OpenFrom)
 {
  case OPEN_DISKMENU:
  {
   if (!installed)
   {
    Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wfx2far is not installed",0,0);
    break;
   }
   bool leftpanel=false;
   PanelInfo PInfo;
   if (Info.Control(INVALID_HANDLE_VALUE,FCTL_CHECKPANELSEXIST,&PInfo)==TRUE)
   {
    RECT rect;
    Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&PInfo);
    if (PInfo.ItemsNumber>0)
    {
     strcpy(PluginName,"?");
     strcpy(PluginArgs,PInfo.CurDir);
     strcat(PluginArgs,"\\");
     strcat(PluginArgs,PInfo.PanelItems[PInfo.CurrentItem].FindData.cFileName);
    }
    else
     break;
    rect.left=PInfo.PanelRect.left;
    rect.right=PInfo.PanelRect.right;
    rect.top=PInfo.PanelRect.top;
    rect.bottom=PInfo.PanelRect.bottom;
    Info.Control(INVALID_HANDLE_VALUE,FCTL_GETANOTHERPANELSHORTINFO,&PInfo);
    if (PInfo.PanelRect.left<rect.left)
     leftpanel=true;
   }
   else
    break;
   int i=0;
   int index=0;
   for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++,i++)
   {
    if ((*it)->GetShowInMenu())
    {
     if (index==Item)
     {
      SetForegroundWindow(hWnd_Console);
      HANDLE res=wfx2far_Run(Plugins[i]->GetName(),false);
      SetForegroundWindow(hWnd_Global);
      return res;
     }
     index++;
    }
   }
   break;
  }
  case OPEN_PLUGINSMENU:
  {
   if (!installed)
   {
    Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)"wfx2far is not installed",0,0);
    break;
   }
   bool leftpanel=false;
   PanelInfo PInfo;
   if (Info.Control(INVALID_HANDLE_VALUE,FCTL_CHECKPANELSEXIST,&PInfo)==TRUE)
   {
    RECT rect;
    Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&PInfo);
    if (PInfo.ItemsNumber>0)
    {
     strcpy(PluginName,"?");
     strcpy(PluginArgs,PInfo.CurDir);
     strcat(PluginArgs,"\\");
     strcat(PluginArgs,PInfo.PanelItems[PInfo.CurrentItem].FindData.cFileName);
    }
    else
     break;
    rect.left=PInfo.PanelRect.left;
    rect.right=PInfo.PanelRect.right;
    rect.top=PInfo.PanelRect.top;
    rect.bottom=PInfo.PanelRect.bottom;
    Info.Control(INVALID_HANDLE_VALUE,FCTL_GETANOTHERPANELSHORTINFO,&PInfo);
    if (PInfo.PanelRect.left<rect.left)
     leftpanel=true;
   }
   else
    break;
   int BreakCode=0;
   int BreakKeys[]={VK_INSERT,VK_DELETE,VK_F4,MAKELONG(VK_UP,PKF_CONTROL),MAKELONG(VK_DOWN,PKF_CONTROL),0};
   int ExitCode;
   int SelectedItem=0;
   while (BreakCode!=-1)
   {
    const int MenuItemsCount=2;
    FarMenuItemEx *MenuItems=new FarMenuItemEx[MenuItemsCount+Plugins.size()];
    MenuItems[0].Flags=MIF_USETEXTPTR;
    MenuItems[0].Text.TextPtr=GetMsg(lngScanForNew);
    MenuItems[0].AccelKey=0;
    MenuItems[0].Reserved=0;
    MenuItems[0].UserData=0;
    MenuItems[1].Flags=MIF_SEPARATOR;
    MenuItems[1].Text.TextPtr=NULL;
    MenuItems[1].AccelKey=0;
    MenuItems[1].Reserved=0;
    MenuItems[1].UserData=0;
    int i=MenuItemsCount;
    for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++,i++)
    {
     MenuItems[i].Flags=((*it)->IsValid())?0:MIF_DISABLE;
     sprintf(MenuItems[i].Text.Text,"&%c %s",(*it)->GetHotkey(),(*it)->GetAlias());
     MenuItems[i].AccelKey=0;
     MenuItems[i].Reserved=0;
     MenuItems[i].UserData=0;
    }
    MenuItems[SelectedItem].Flags|=MIF_SELECTED;
    ExitCode=Info.Menu(Info.ModuleNumber,-1,-1,0,FMENU_USEEXT|FMENU_WRAPMODE,GetMsg(lngPluginName),GetMsg(lngMenuBottomString),NULL,BreakKeys,&BreakCode,(struct FarMenuItem *)MenuItems,(int)(MenuItemsCount+Plugins.size()));
    if (ExitCode>=0)
    {
     if (BreakCode==0)
     {
      char* Alias=Info.FSF->PointToName(PluginArgs);
      struct InitDialogItem InitItems[]=
      {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
       /*00*/ { DI_DOUBLEBOX,   3, 1,55,12, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngInstall),               NULL},
       /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngPluginHotKey),          NULL},
       /*02*/ { DI_FIXEDIT,     5, 3, 5, 3, 0, 0, 0,                                    0,      " ",                              NULL},
       /*03*/ { DI_TEXT,        5, 4, 0, 4, 0, 0, 0,                                    0,      GetMsg(lngInstallPluginAlias),    NULL},
       /*04*/ { DI_EDIT,        5, 5,53, 5, 0, 0, DIF_HISTORY,                          0,      Alias,          "wfx2far.History.InastallPlugin.Alias"},
       /*05*/ { DI_TEXT,        5, 6, 0, 6, 0, 0, 0,                                    0,      GetMsg(lngInstallPluginFileName), NULL},
       /*06*/ { DI_EDIT,        5, 7,53, 7, 1, 0, DIF_HISTORY,                          0,      PluginArgs,     "wfx2far.History.InastallPlugin.Name"},
       /*07*/ { DI_TEXT,        0, 8, 0, 8, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                               NULL},
       /*08*/ { DI_CHECKBOX,    5, 9, 0, 9, 0, 0, 0,                                    0,      GetMsg(lngInstallPluginMenu),     NULL},
       /*09*/ { DI_TEXT,        0,10, 0,10, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                               NULL},
       /*10*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),                    NULL},
       /*11*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),                NULL}
      };
      struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
      InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,14,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      if (n==10)
      {
        SetForegroundWindow(hWnd_Console);
        wfx2far_InstallPlugin((DialogItems[2].Data[0]=='\0')?' ':DialogItems[2].Data[0],DialogItems[4].Data,DialogItems[6].Data,(DialogItems[8].Selected==TRUE));
        SetForegroundWindow(hWnd_Global);
      }
     }
     if ((BreakCode==1)&&(ExitCode>MenuItemsCount-1))
     {
      struct InitDialogItem InitItems[]=
      {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
       /*00*/ { DI_DOUBLEBOX,   3, 1,55, 8, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngUninstall),                         NULL},
       /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngPluginAlias),                       NULL},
       /*02*/ { DI_EDIT,        5, 3,53, 3, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode-MenuItemsCount]->GetAlias(), NULL},
       /*03*/ { DI_TEXT,        5, 4, 0, 4, 0, 0, 0,                                    0,      GetMsg(lngPluginFileName),                    NULL},
       /*04*/ { DI_EDIT,        5, 5,53, 5, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode-MenuItemsCount]->GetName(),  NULL},
       /*05*/ { DI_TEXT,        0, 6, 0, 6, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                                           NULL},
       /*06*/ { DI_BUTTON,      0, 7, 0, 7, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngOK),                                NULL},
       /*07*/ { DI_BUTTON,      0, 7, 0, 7, 1, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngCancel),                            NULL}
      };
      struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
      InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,10,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      if (n==6)
      {
       SetForegroundWindow(hWnd_Console);
       wfx2far_UninstallPlugin(DialogItems[4].Data);
       SetForegroundWindow(hWnd_Global);
       ExitCode--;
      }
     }
     if ((BreakCode==2)&&(ExitCode>MenuItemsCount-1))
     {
      char temp[2];
      temp[0]=Plugins[ExitCode-MenuItemsCount]->GetHotkey();
      temp[1]='\0';
      int m=(Plugins[ExitCode-MenuItemsCount]->GetShowInMenu())?1:0;
      struct InitDialogItem InitItems[]=
      {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
       /*00*/ { DI_DOUBLEBOX,   3, 1,55,12, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngEdit),                              NULL},
       /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngPluginHotKey),                      NULL},
       /*02*/ { DI_FIXEDIT,     5, 3, 5, 3, 0, 0, 0,                                    0,      temp,                                         NULL},
       /*03*/ { DI_TEXT,        5, 4, 0, 4, 0, 0, 0,                                    0,      GetMsg(lngPluginAlias),                       NULL},
       /*04*/ { DI_EDIT,        5, 5,53, 5, 0, 0, DIF_HISTORY,                          0,      Plugins[ExitCode-MenuItemsCount]->GetAlias(), "wfx2far.History.InastallPlugin.Alias"},
       /*05*/ { DI_TEXT,        5, 6, 0, 6, 0, 0, 0,                                    0,      GetMsg(lngPluginFileName),                    NULL},
       /*06*/ { DI_EDIT,        5, 7,53, 7, 0, 0, DIF_READONLY,                         0,      Plugins[ExitCode-MenuItemsCount]->GetName(),  NULL},
       /*07*/ { DI_TEXT,        0, 8, 0, 8, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                               NULL},
       /*08*/ { DI_CHECKBOX,    5, 9, 0, 9, 0, m, 0,                                    0,      GetMsg(lngPluginMenu),            NULL},
       /*09*/ { DI_TEXT,        0,10, 0,10, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                                           NULL},
       /*10*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),                                NULL},
       /*11*/ { DI_BUTTON,      0,11, 0,11, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),                            NULL}
      };
      struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
      InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,14,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      if (n==10)
      {
       bool found=false;
       for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
        if ((_stricmp((*it)->GetAlias(),DialogItems[4].Data)==0)&&((*it)!=Plugins[ExitCode-MenuItemsCount]))
        {
         found=true;
         char errormessage[256];
         sprintf(errormessage,"Alias '%s' already exist",DialogItems[4].Data);
         Info.Message(Info.ModuleNumber,FMSG_ALLINONE|FMSG_WARNING|FMSG_MB_OK,NULL,(const char * const *)errormessage,0,0);
         break;
        }
       Plugins[ExitCode-MenuItemsCount]->SetHotkey((DialogItems[2].Data[0]=='\0')?' ':DialogItems[2].Data[0]);
       if (!found)
        Plugins[ExitCode-MenuItemsCount]->SetAlias(DialogItems[4].Data);
       Plugins[ExitCode-MenuItemsCount]->SetShowInMenu((DialogItems[8].Selected==TRUE));
      }
     }
     if ((BreakCode==3)&&(ExitCode>MenuItemsCount-1))
     {
      if (ExitCode-MenuItemsCount>0)
      {
       WFXPlugin* tmp=Plugins[ExitCode-MenuItemsCount-1];
       Plugins[ExitCode-MenuItemsCount-1]=Plugins[ExitCode-MenuItemsCount];
       Plugins[ExitCode-MenuItemsCount]=tmp;
       ExitCode--;
      }
     }
     if ((BreakCode==4)&&(ExitCode>MenuItemsCount-1))
     {
      if (ExitCode-MenuItemsCount<(int)Plugins.size()-1)
      {
       WFXPlugin* tmp=Plugins[ExitCode-MenuItemsCount+1];
       Plugins[ExitCode-MenuItemsCount+1]=Plugins[ExitCode-MenuItemsCount];
       Plugins[ExitCode-MenuItemsCount]=tmp;
       ExitCode++;
      }
     }
     if (BreakCode==5)
      BreakCode=-1;
     else
     {
      MenuItems[SelectedItem].Flags&=~MIF_SELECTED;
      SelectedItem=ExitCode;
     }
     if ((BreakCode==-1)&&(ExitCode==0))
     {
      char command[MYMAXPATH];
      char rootpathname[MYMAXPATH];
      GetModuleFileName(hinst,command,MYMAXPATH);
      command[strlen(command)-modulenamelength]='\0';
      strcat(command,"Plugins");
      GetRegKey(HKEY_CURRENT_USER,"","DefaultPath",rootpathname,command,MYMAXPATH);
      struct InitDialogItem InitItems[]=
      {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
       /*00*/ { DI_DOUBLEBOX,   3, 1,55, 6, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngScan),       NULL},
       /*01*/ { DI_TEXT,        5, 2, 0, 2, 0, 0, 0,                                    0,      GetMsg(lngScanPath),   NULL},
       /*02*/ { DI_EDIT,        5, 3,53, 3, 1, 0, DIF_HISTORY,                          0,      rootpathname,          "wfx2far.History.Scan.Path"},
       /*03*/ { DI_TEXT,        0, 4, 0, 4, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                    NULL},
       /*04*/ { DI_BUTTON,      0, 5, 0, 5, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),         NULL},
       /*05*/ { DI_BUTTON,      0, 5, 0, 5, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),     NULL}
      };
      struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
      InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,8,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
      if (n==4)
      {
       strcpy(command,"wfx2far:search ");
       strcat(command,DialogItems[2].Data);
       SetForegroundWindow(hWnd_Console);
       wfx2far_Command(command);
       SetForegroundWindow(hWnd_Global);
      }
     }
     if ((BreakCode==-1)&&(ExitCode>MenuItemsCount-1))
     {
      delete [] MenuItems;
      SetForegroundWindow(hWnd_Console);
      HANDLE res=wfx2far_Run(Plugins[ExitCode-MenuItemsCount]->GetName(),false);
      SetForegroundWindow(hWnd_Global);
      return res;
     }
    }
    FILE* inifile;
    GetModuleFileName(hinst,buffer1,MYMAXPATH);
    buffer1[strlen(buffer1)-1]='i';
    buffer1[strlen(buffer1)-2]='n';
    buffer1[strlen(buffer1)-3]='i';
    inifile=fopen(buffer1,"wt");
    if (inifile!=NULL)
    {
     for (std::vector<WFXPlugin*>::iterator it=Plugins.begin();it!=Plugins.end();it++)
      if ((*it)->IsValid())
      {
       fprintf(inifile,"%c - %s ? %s ? %s\n",(*it)->GetHotkey(),(*it)->GetAlias(),(*it)->GetName(),((*it)->GetShowInMenu())?"1":"0");
      }
     fclose(inifile);
    }
    delete [] MenuItems;
   }
   break;
  }
  case OPEN_COMMANDLINE:
  {
   SetForegroundWindow(hWnd_Console);
   HANDLE res=wfx2far_Command((const char*)Item);
   SetForegroundWindow(hWnd_Global);
   return res;
  }
 }
 return INVALID_HANDLE_VALUE;
}
/*----------------------------------------------------------------------------*/
void WINAPI ClosePlugin(HANDLE hPlugin)
{
 SetFileApisToANSI();
 SetForegroundWindow(hWnd_Console);
 SendMessage(hWnd_Console,WM_WFXCLOSE,(WPARAM)hPlugin,0);
 SetForegroundWindow(hWnd_Global);
 SetFileApisToOEM();
}
/*----------------------------------------------------------------------------*/
void WINAPI GetOpenPluginInfo(HANDLE hPlugin, struct OpenPluginInfo *Info)
{
 SetFileApisToANSI();
 SendMessage(hWnd_Console,WM_WFXGETINFO,(WPARAM)hPlugin,(LPARAM)Info);
 SetFileApisToOEM();
 static char Dir[1024];
 static char Format[1024];
 static char Title[1024*2+1];
 CharToOem(Info->CurDir,Dir);
 Info->CurDir=Dir;
 CharToOem(Info->Format,Format);
 Info->Format=Format;
 CharToOem(Info->PanelTitle,Title);
 Info->PanelTitle=Title;
}
/*----------------------------------------------------------------------------*/
int WINAPI SetDirectory(HANDLE hPlugin, const char *FarDir, int OpMode)
{
 static char Dir[1024];
 OemToChar(FarDir,Dir);
 SetFileApisToANSI();
 void *tmp[2];
 tmp[0]=(void*)(Dir);
 tmp[1]=(void*)(&OpMode);
 int ret=(int)SendMessage(hWnd_Console,WM_WFXSETDIR,(WPARAM)hPlugin,(LPARAM)tmp);
 SetFileApisToOEM();
 return ret;
}
/*----------------------------------------------------------------------------*/
int WINAPI GetFindData(HANDLE hPlugin, struct PluginPanelItem **pPanelItem,  int *pItemsNumber, int OpMode)
{
 SetFileApisToANSI();
 void *tmp[3];
 tmp[0]=(void*)(pPanelItem);
 tmp[1]=(void*)(pItemsNumber);
 tmp[2]=(void*)(&OpMode);
 int ret=(int)SendMessage(hWnd_Console,WM_WFXGETFILE,(WPARAM)hPlugin,(LPARAM)tmp);
 SetFileApisToOEM();
 if (ret)
 {
  for (int i=0; i<*pItemsNumber; i++)
  {
   CharToOem((*pPanelItem)[i].FindData.cFileName,(*pPanelItem)[i].FindData.cFileName);
   CharToOem((*pPanelItem)[i].FindData.cAlternateFileName,(*pPanelItem)[i].FindData.cAlternateFileName);
  }
 }
 return ret;
}
/*----------------------------------------------------------------------------*/
void WINAPI FreeFindData(HANDLE hPlugin, struct PluginPanelItem *PanelItem, int ItemsNumber)
{
 SetFileApisToANSI();
 void *tmp[2];
 tmp[0]=(void*)(PanelItem);
 tmp[1]=(void*)(&ItemsNumber);
 SendMessage(hWnd_Console,WM_WFXFREEFILE,(WPARAM)hPlugin,(LPARAM)tmp);
 SetFileApisToOEM();
}
/*----------------------------------------------------------------------------*/
int WINAPI ProcessKey(HANDLE hPlugin, int Key, unsigned int ControlState)
{
 SetFileApisToANSI();
 void *tmp[3];
 tmp[0]=(void*)(&Key);
 tmp[1]=(void*)(&ControlState);

 PanelInfo pi;
 Info.Control(hPlugin,FCTL_GETPANELINFO,(void *)&pi);
 if (pi.ItemsNumber<=0 || (((!ControlState && Key==VK_RETURN))&&(pi.PanelItems[pi.CurrentItem].FindData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)))
   return FALSE;
 OemToChar(pi.PanelItems[pi.CurrentItem].FindData.cFileName,pi.PanelItems[pi.CurrentItem].FindData.cFileName);
 tmp[2]=(void*)(pi.PanelItems[pi.CurrentItem].FindData.cFileName);
 int ret=(int)SendMessage(hWnd_Console,WM_WFXPROCESSKEY,(WPARAM)hPlugin,(LPARAM)tmp);
/*
 if (ret==TRUE)
 {
  Info.Control(hPlugin,FCTL_UPDATEPANEL,NULL);
  Info.Control(hPlugin,FCTL_REDRAWPANEL,NULL);
 }
*/

 bool need_focus = Exec_End;
 while (Exec_End)
 {
   MSG msg;
   ZeroMemory(&msg,sizeof(MSG));
   if (msg.message!=WM_QUIT)
   {
     if (PeekMessage(&msg,NULL,0U,0U,PM_REMOVE))
     {
       TranslateMessage(&msg);
       DispatchMessage(&msg);
     }
   }
   else
     break;
 }
 if (need_focus)
   SetForegroundWindow(hWnd_Global);

 if ((ret==TRUE)&&(lstrcmp(Exec_Command,"properties")!=0))
 {
   switch (Exec_Result)
   {
     case FS_EXEC_OK:
       ret=TRUE;
       break;
     case FS_EXEC_ERROR:
     case FS_EXEC_YOURSELF:
       ret=FALSE;
       break;
     case FS_EXEC_SYMLINK:
     {
       int OpMode=0;
       void *tmp[2];
       tmp[0]=(void*)(Exec_Path);
       tmp[1]=(void*)(&OpMode);
       SendMessage(hWnd_Console,WM_WFXSETDIR,(WPARAM)hPlugin,(LPARAM)tmp);
       ret=TRUE;
       break;
     }
   }
 }

 // Show message for safe launching
 if ((ControlState==PKF_SHIFT) && Key==VK_RETURN)
 {
   const char *msg[2];
   msg[0]=GetMsg(lngExecDoneTitle);
   msg[1]=GetMsg(lngExecDoneMessage);
   Info.Message(Info.ModuleNumber,FMSG_MB_OK,NULL,msg,2,0);
 }

 SetFileApisToOEM();
 return ret;
}
/*----------------------------------------------------------------------------*/
int WINAPI GetFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,char *DestPath,int OpMode)
{
 const char *msg[2];
 char Title[1024];
 WFXPluginInstance* inst=(WFXPluginInstance*)hPlugin;
 if (inst==NULL)
  return FALSE;
 if (confirmCopy)
 {
   CharToOem(inst->GetPlugin()->GetAlias(),Title);
   msg[0]=Title;
   msg[1]=GetMsg(lngCopyAsk);
   if (Info.Message(Info.ModuleNumber,FMSG_MB_YESNO,NULL,msg,2,0))
    return FALSE;
 }
 static char Dest[1024];
 OemToChar(DestPath,Dest);
 for (int i=0; i<ItemsNumber; i++)
  OemToChar(PanelItem[i].FindData.cFileName,PanelItem[i].FindData.cFileName);
 SetFileApisToANSI();
 void *tmp[5];
 tmp[0]=(void*)(PanelItem);
 tmp[1]=(void*)(&ItemsNumber);
 tmp[2]=(void*)(&Move);
 tmp[3]=(void*)(Dest);
 tmp[4]=(void*)(&OpMode);
 SetForegroundWindow(hWnd_Console);
 int ret=(int)SendMessage(hWnd_Console,WM_WFXGETFILES,(WPARAM)hPlugin,(LPARAM)tmp);
 SetForegroundWindow(hWnd_Global);
 SetFileApisToOEM();
 return ret;
}
/*----------------------------------------------------------------------------*/
int WINAPI PutFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode)
{
 for (int i=0; i<ItemsNumber; i++)
  OemToChar(PanelItem[i].FindData.cFileName,PanelItem[i].FindData.cFileName);
 SetFileApisToANSI();
 void *tmp[4];
 tmp[0]=(void*)(PanelItem);
 tmp[1]=(void*)(&ItemsNumber);
 tmp[2]=(void*)(&Move);
 tmp[3]=(void*)(&OpMode);
 SetForegroundWindow(hWnd_Console);
 int ret=(int)SendMessage(hWnd_Console,WM_WFXPUTFILES,(WPARAM)hPlugin,(LPARAM)tmp);
 SetForegroundWindow(hWnd_Global);
 SetFileApisToOEM();
 return ret;
}
/*----------------------------------------------------------------------------*/
int WINAPI DeleteFiles(HANDLE hPlugin,struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode)
{
 const char *msg[2];
 char Title[1024];
 WFXPluginInstance* inst=(WFXPluginInstance*)hPlugin;
 if (inst==NULL)
  return FALSE;
 if (confirmDelete)
 {
   CharToOem(inst->GetPlugin()->GetAlias(),Title);
   msg[0]=Title;
   msg[1]=GetMsg(lngDeleteAsk);
   if (Info.Message(Info.ModuleNumber,FMSG_MB_YESNO,NULL,msg,2,0))
    return FALSE;
 }
 for (int i=0; i<ItemsNumber; i++)
 {
  OemToChar(PanelItem[i].FindData.cFileName,PanelItem[i].FindData.cFileName);
  OemToChar(PanelItem[i].FindData.cAlternateFileName,PanelItem[i].FindData.cAlternateFileName);
 }
 SetFileApisToANSI();
 void *tmp[3];
 tmp[0]=(void*)(PanelItem);
 tmp[1]=(void*)(&ItemsNumber);
 tmp[2]=(void*)(&OpMode);
 SetForegroundWindow(hWnd_Console);
 int ret=(int)SendMessage(hWnd_Console,WM_WFXDELFILE,(WPARAM)hPlugin,(LPARAM)tmp);
 SetForegroundWindow(hWnd_Global);
 SetFileApisToOEM();
 return ret;
}
/*----------------------------------------------------------------------------*/
int WINAPI MakeDirectory(HANDLE hPlugin,char *Name,int OpMode)
{
 char Title[1024];
 WFXPluginInstance* inst=(WFXPluginInstance*)hPlugin;
 if (inst==NULL)
  return FALSE;
 CharToOem(inst->GetPlugin()->GetAlias(),Title);
 static const char History[]="wfx2far\\makedir";
 InitDialogItem InitItems[]=
 {
  // type,x1,y1,x2,y2,focus,selected,flags,default,data
  {DI_DOUBLEBOX,3,1,56,6,0,0,0,0,Title},
  {DI_TEXT,5,2,0,0,0,0,0,0,(char *)lngMakeDir},
  {DI_EDIT,5,3,54,0,1,(DWORD)History,DIF_HISTORY,0,""},
  {DI_TEXT,0,4,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
  {DI_BUTTON,3,5,0,0,0,0,DIF_CENTERGROUP,1,(char *)lngOK},
  {DI_BUTTON,3,5,0,0,0,0,DIF_CENTERGROUP,0,(char *)lngCancel},
 };
 FarDialogItem DialogItems[sizeofa(InitItems)];
 InitDialogItems(InitItems,DialogItems,sizeofa(InitItems));

 if (Info.Dialog(Info.ModuleNumber,-1,-1,60,8,NULL,DialogItems,sizeofa(DialogItems))!=4)
  return (-1);
 char Dir[1024];
 OemToChar(DialogItems[2].Data,Dir);
 SetFileApisToANSI();
 void *tmp[2];
 tmp[0]=(void*)(Dir);
 tmp[1]=(void*)(&OpMode);
 SetForegroundWindow(hWnd_Console);
 int ret=(int)SendMessage(hWnd_Console,WM_WFXMKDIR,(WPARAM)hPlugin,(LPARAM)tmp);
 SetForegroundWindow(hWnd_Global);
 SetFileApisToOEM();
 return ret;
}
/*----------------------------------------------------------------------------*/
/*
  Configure ,     
 "Plugins configuration" ("  ") ,
    .
*/
int WINAPI Configure(int ItemNumber)
{
 char temp[MYMAXPATH];
 char rootpathname[MYMAXPATH];
 GetModuleFileName(hinst,temp,MYMAXPATH);
 temp[strlen(temp)-modulenamelength]='\0';
 strcat(temp,"Plugins");
 int d=GetRegKey(HKEY_CURRENT_USER,"","ConfirmDelete",1);
 int c=GetRegKey(HKEY_CURRENT_USER,"","ConfirmCopy",0);
 int i=GetRegKey(HKEY_CURRENT_USER,"","ShowStartupInfo",1);
 int s=GetRegKey(HKEY_CURRENT_USER,"","StartSearch",1);
 GetRegKey(HKEY_CURRENT_USER,"","DefaultPath",rootpathname,temp,MYMAXPATH);
 struct InitDialogItem InitItems[]=
 {//       Type            X1 Y1 X2 Y2 Fo Se Fl                                    DB      Data
  /*00*/ { DI_DOUBLEBOX,   3, 1,55,11, 0, 0, DIF_BOXCOLOR,                         0,      GetMsg(lngPluginConfigName),    NULL},
  /*01*/ { DI_CHECKBOX,    5, 2, 0, 2, 0, d, 0,                                    0,      GetMsg(lngConfigConfirmDelete), NULL},
  /*02*/ { DI_CHECKBOX,    5, 3, 0, 3, 0, c, 0,                                    0,      GetMsg(lngConfigConfirmCopy),   NULL},
  /*03*/ { DI_CHECKBOX,    5, 4, 0, 4, 0, i, 0,                                    0,      GetMsg(lngConfigShowStatup),    NULL},
  /*04*/ { DI_CHECKBOX,    5, 5, 0, 5, 0, s, 0,                                    0,      GetMsg(lngConfigStartSearch),   NULL},
  /*05*/ { DI_TEXT,        0, 6, 0, 6, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                             NULL},
  /*06*/ { DI_TEXT,        5, 7, 0, 7, 0, 0, 0,                                    0,      GetMsg(lngConfigPath),          NULL},
  /*07*/ { DI_EDIT,        5, 8,53, 8, 1, 0, DIF_HISTORY,                          0,      rootpathname,                   "wfx2far.History.Scan.Path"},
  /*08*/ { DI_TEXT,        0, 9, 0, 9, 0, 0, DIF_BOXCOLOR|DIF_SEPARATOR,           0,      "",                             NULL},
  /*09*/ { DI_BUTTON,      0,10, 0,10, 0, 0, DIF_CENTERGROUP,                      1,      GetMsg(lngOK),                  NULL},
  /*10*/ { DI_BUTTON,      0,10, 0,10, 0, 0, DIF_CENTERGROUP,                      0,      GetMsg(lngCancel),              NULL}
 };
 struct FarDialogItem DialogItems[(sizeof(InitItems)/sizeof(InitItems[0]))];
 InitDialogItems(InitItems,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
 int n=Info.Dialog(Info.ModuleNumber,-1,-1,59,13,NULL,DialogItems,(sizeof(InitItems)/sizeof(InitItems[0])));
 if (n=9)
 {
  SetRegKey(HKEY_CURRENT_USER,"","ConfirmDelete",(DialogItems[1].Selected==TRUE)?1:0);
  SetRegKey(HKEY_CURRENT_USER,"","ConfirmCopy",(DialogItems[2].Selected==TRUE)?1:0);
  SetRegKey(HKEY_CURRENT_USER,"","ShowStartupInfo",(DialogItems[3].Selected==TRUE)?1:0);
  SetRegKey(HKEY_CURRENT_USER,"","StartSearch",(DialogItems[4].Selected==TRUE)?1:0);
  SetRegKey(HKEY_CURRENT_USER,"","DefaultPath",DialogItems[7].Data);
  confirmDelete = GetRegKey(HKEY_CURRENT_USER,"","ConfirmDelete", 1);
  confirmCopy = GetRegKey(HKEY_CURRENT_USER,"","ConfirmCopy", 0);
  InvalidateRect(hWnd_Console,NULL,FALSE);
 }
 return TRUE;
}
/*----------------------------------------------------------------------------*/
/*
  ExitFAR     FAR.     
    , ,   .
*/
void WINAPI ExitFAR(void)
{
// if (installed)
//  wfx2far_Command("wfx2far:uninstall");
 wfx2far_Uninstall();
 TerminateThread(hThread,0);
 TerminateThread(hdlgThread,0);
}
/*============================================================================*/
