/*
    WFX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan
    Copyright (C) 2005 Alex Yaroslavsky

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                          WFX PLUGIN FOR WFX2FAR                            //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
//          Alex Yaroslavsky aka T-Rex                                        //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wfx2far                                                           //
// PART:    WFX plugin header                                                 //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
/*============================================================================*/
// ids for FsGetFile
#define FS_FILE_OK 0
#define FS_FILE_EXISTS 1
#define FS_FILE_NOTFOUND 2
#define FS_FILE_READERROR 3
#define FS_FILE_WRITEERROR 4
#define FS_FILE_USERABORT 5
#define FS_FILE_NOTSUPPORTED 6
#define FS_FILE_EXISTSRESUMEALLOWED 7

#define FS_EXEC_OK 0
#define FS_EXEC_ERROR 1
#define FS_EXEC_YOURSELF -1
#define FS_EXEC_SYMLINK -2

#define FS_COPYFLAGS_OVERWRITE 1
#define FS_COPYFLAGS_RESUME 2
#define FS_COPYFLAGS_MOVE 4
#define FS_COPYFLAGS_EXISTS_SAMECASE 8
#define FS_COPYFLAGS_EXISTS_DIFFERENTCASE 16

// flags for tRequestProc
#define RT_Other 0
#define RT_UserName 1
#define RT_Password 2
#define RT_Account 3
#define RT_UserNameFirewall 4
#define RT_PasswordFirewall 5
#define RT_TargetDir 6
#define RT_URL 7
#define RT_MsgOK 8
#define RT_MsgYesNo 9
#define RT_MsgOKCancel 10

// flags for tLogProc
#define MSGTYPE_CONNECT 1
#define MSGTYPE_DISCONNECT 2
#define MSGTYPE_DETAILS 3
#define MSGTYPE_TRANSFERCOMPLETE 4
#define MSGTYPE_CONNECTCOMPLETE 5
#define MSGTYPE_IMPORTANTERROR 6
#define MSGTYPE_OPERATIONCOMPLETE 7

// flags for FsStatusInfo
#define FS_STATUS_START 0
#define FS_STATUS_END 1

#define FS_STATUS_OP_LIST 1
#define FS_STATUS_OP_GET_SINGLE 2
#define FS_STATUS_OP_GET_MULTI 3
#define FS_STATUS_OP_PUT_SINGLE 4
#define FS_STATUS_OP_PUT_MULTI 5
#define FS_STATUS_OP_RENMOV_SINGLE 6
#define FS_STATUS_OP_RENMOV_MULTI 7
#define FS_STATUS_OP_DELETE 8
#define FS_STATUS_OP_ATTRIB 9
#define FS_STATUS_OP_MKDIR 10
#define FS_STATUS_OP_EXEC 11
#define FS_STATUS_OP_CALCSIZE 12
#define FS_STATUS_OP_SEARCH 13
#define FS_STATUS_OP_SEARCH_TEXT 14
#define FS_STATUS_OP_SYNC_SEARCH 15
#define FS_STATUS_OP_SYNC_GET 16
#define FS_STATUS_OP_SYNC_PUT 17
#define FS_STATUS_OP_SYNC_DELETE 18

#define FS_ICONFLAG_SMALL 1
#define FS_ICONFLAG_BACKGROUND 2

#define FS_ICON_USEDEFAULT 0
#define FS_ICON_EXTRACTED 1
#define FS_ICON_EXTRACTED_DESTROY 2
#define FS_ICON_DELAYED 3
/*============================================================================*/
typedef struct {
    DWORD SizeLow,SizeHigh;
    FILETIME LastWriteTime;
    int Attr;
} RemoteInfoStruct;

typedef struct {
  int size;
  DWORD PluginInterfaceVersionLow;
  DWORD PluginInterfaceVersionHi;
  char DefaultIniName[MAX_PATH];
} FsDefaultParamStruct;
/*============================================================================*/
// callback functions
typedef int   (__stdcall *CALLBACK_PROGRESSPROC)(int PluginNr,char* SourceName,char* TargetName,int PercentDone);
typedef void  (__stdcall *CALLBACK_LOGPROC)(int PluginNr,int MsgType,char* LogString);
typedef BOOL  (__stdcall *CALLBACK_REQUESTPROC)(int PluginNr,int RequestType,char* CustomTitle,char* CustomText,char* ReturnedText,int maxlen);
/*============================================================================*/
// Function prototypes
typedef int     (__stdcall *WFX_INIT)(int PluginNr,CALLBACK_PROGRESSPROC pProgressProc,CALLBACK_LOGPROC pLogProc,CALLBACK_REQUESTPROC pRequestProc);
typedef HANDLE  (__stdcall *WFX_FINDFIRST)(char* Path,WIN32_FIND_DATA *FindData);
typedef BOOL    (__stdcall *WFX_FINDNEXT)(HANDLE Hdl,WIN32_FIND_DATA *FindData);
typedef int     (__stdcall *WFX_FINDCLOSE)(HANDLE Hdl);
typedef BOOL    (__stdcall *WFX_MKDIR)(char* Path);
typedef int     (__stdcall *WFX_EXECUTEFILE)(HWND MainWin,char* RemoteName,char* Verb);
typedef int     (__stdcall *WFX_RENMOVFILE)(char* OldName,char* NewName,BOOL Move,BOOL OverWrite,RemoteInfoStruct* ri);
typedef int     (__stdcall *WFX_GETFILE)(char* RemoteName,char* LocalName,int CopyFlags,RemoteInfoStruct* ri);
typedef int     (__stdcall *WFX_PUTFILE)(char* LocalName,char* RemoteName,int CopyFlags);
typedef BOOL    (__stdcall *WFX_DELETEFILE)(char* RemoteName);
typedef BOOL    (__stdcall *WFX_REMOVEDIR)(char* RemoteName);
typedef BOOL    (__stdcall *WFX_DISCONNECT)(char* DisconnectRoot);
typedef BOOL    (__stdcall *WFX_SETATTR)(char* RemoteName,int NewAttr);
typedef BOOL    (__stdcall *WFX_SETTIME)(char* RemoteName,FILETIME *CreationTime,FILETIME *LastAccessTime,FILETIME *LastWriteTime);
typedef void    (__stdcall *WFX_STATUSINFO)(char* RemoteDir,int InfoStartEnd,int InfoOperation);
typedef void    (__stdcall *WFX_GETDEFROOTNAME)(char* DefRootName,int maxlen);
typedef int     (__stdcall *WFX_EXTRACTCUSTOMICON)(char* RemoteName,int ExtractFlags,HICON* TheIcon);
typedef void    (__stdcall *WFX_SETDEFAULTPARAMS)(FsDefaultParamStruct* dps);
/*============================================================================*/
class WFXPlugin
{
 friend class WFXPluginInstance;
 friend bool CopyToWfx(WFXPluginInstance* pinstance, char dirname[1024], char dirnameshort[1024], int Move);
 friend bool CopyFromWfx(WFXPluginInstance* pinstance, char dirname[1024], char dirnameshort[1024], char dstpath[1024], int Move);
 friend bool RemoveFromWfx(WFXPluginInstance* pinstance, char dirname[1024]);
public:
 WFXPlugin();

 bool IsValid(void);

 bool Incriment(void);
 bool Decriment(void);

 void SetHotkey(const char hotkey);
 void SetAlias(const char* alias);
 void SetName(const char* pluginname);
 void SetShowInMenu(const bool show);

 char  GetHotkey(void) const;
 char* GetAlias(void) const;
 char* GetName(void) const;
 bool  GetShowInMenu(void) const;

 bool Load(void);
 bool Unload(void);
 bool Verify(void);
 bool Register(const char hotkey,const char* alias,const char* pluginname,bool showinmenu);
 bool UnRegister(void);

private:
 int counter;
 bool valid;
 bool showinmenu;
 char hotkey;
 char alias[256];
 char name[MYMAXPATH];
 HMODULE hDLL;

 WFX_INIT WFX_Init;
 WFX_FINDFIRST WFX_FindFirst;
 WFX_FINDNEXT WFX_FindNext;
 WFX_FINDCLOSE WFX_FindClose;
 WFX_MKDIR WFX_MkDir;
 WFX_EXECUTEFILE WFX_ExecuteFile;
 WFX_RENMOVFILE WFX_RenMovFile;
 WFX_GETFILE WFX_GetFile;
 WFX_PUTFILE WFX_PutFile;
 WFX_DELETEFILE WFX_DeleteFile;
 WFX_REMOVEDIR WFX_RemoveDir;
 WFX_DISCONNECT WFX_Disconnect;
 WFX_SETATTR WFX_SetAttr;
 WFX_SETTIME WFX_SetTime;
 WFX_STATUSINFO WFX_StatusInfo;
 WFX_GETDEFROOTNAME WFX_GetDefRootName;
 WFX_EXTRACTCUSTOMICON WFX_ExtractCustomInfo;
 WFX_SETDEFAULTPARAMS WFX_SetDefaultParams;
};
/*============================================================================*/
class WFXPluginInstance
{
public:
 WFXPluginInstance(WFXPlugin* plugin);

 WFXPlugin* GetPlugin(void) const;
 const char* GetDir(void) const;

 bool Load(int PluginNr,CALLBACK_PROGRESSPROC pProgressProc,CALLBACK_LOGPROC pLogProc,CALLBACK_REQUESTPROC pRequestProc);
 bool Close(void);

 bool SetDir(const char* Dir);

 bool GetFileList(struct PluginPanelItem **pPanelItem, int *pItemsNumber);
 bool FreeFileList(struct PluginPanelItem *PanelItem, int ItemsNumber);

 void CheckConnection(const char *NewDir);
 void Connected(const char *Root);
 void Disconnected();

 bool ProcessKey(int Key, unsigned int ControlState,const char* curfilename);

 bool GetFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,char *DestPath,int OpMode);
 bool PutFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode);

 bool DeleteFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode);
 bool MakeDirectory(char *Name,int OpMode);

 void StatusInfo(int InfoStartEnd,int InfoOperation);

private:
 WFXPlugin* plugin;
 char curdir[1024];

 char DisconnectRoot[1024];
 bool connected;
 WIN32_FIND_DATA fd;
 bool NoMoreFiles;
 HANDLE fh;
 HANDLE hScreen;

 static const unsigned char ILLEGAL_SYMB[];
 static const unsigned char ILLEGAL_REPL[];

 static void ReplaceIllegalChars(unsigned char *ptr);
 static char* PointToName(char *str);
 static void WinFindDataToFarFindData(struct FAR_FIND_DATA *ffd, WIN32_FIND_DATA *wfd);
};
/*============================================================================*/
