/*
    WFX2FAR plugin for FAR Manager
    Copyright (C) 2005 Shynkarenka Ivan
    Copyright (C) 2005 Alex Yaroslavsky

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*//////////////////////////////////////////////////////////////////////////////
//                          WFX PLUGIN FOR WFX2FAR                            //
//                                                                            //
// AUTHOR:  Shynkarenka Ivan aka 4ekucT                                       //
//          Alex Yaroslavsky aka T-Rex                                        //
// GROUP:   NULL workgroup                                                    //
// PROJECT: wfx2far                                                           //
// PART:    WFX plugin                                                        //
// CREATED: 19.04.2005                                                        //
//////////////////////////////////////////////////////////////////////////////*/
#include <wfx2far.h>
/*============================================================================*/
const unsigned char WFXPluginInstance::ILLEGAL_SYMB[] = "/<>:\\|?*\"";
const unsigned char WFXPluginInstance::ILLEGAL_REPL[] = "!()_!!__'";
/*============================================================================*/
void RemoveDirEx(char dirname[1024])
{
  HANDLE Handle;
  WIN32_FIND_DATAA FindFileData;
  char newsrc[1024];

  lstrcpy(newsrc,dirname);
  Info.FSF->AddEndSlash(newsrc);
  lstrcat(newsrc,"*");
  Handle=FindFirstFile(newsrc,&FindFileData);
  if (Handle!=INVALID_HANDLE_VALUE)
  {
    do
    {
      // If we find '.' or '..' go forward
      if ((FindFileData.cFileName[0]=='.')&&((FindFileData.cFileName[1]=='\0')||((FindFileData.cFileName[1]=='.')&&(FindFileData.cFileName[2]=='\0'))))
        continue;
      lstrcpy(newsrc,dirname);
      Info.FSF->AddEndSlash(newsrc);
      lstrcat(newsrc,FindFileData.cFileName);
      if (FindFileData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
      {
        RemoveDirEx(newsrc);
      }
      else
      {
        DeleteFile(newsrc);
      }
    } while (FindNextFile(Handle,&FindFileData));
  }
  FindClose(Handle);
  /*----------------------------------------------------------------------------*/
  RemoveDirectory(dirname);
}
/*----------------------------------------------------------------------------*/
bool RemoveFromWfx(WFXPluginInstance* pinstance, char dirname[1024])
{
  /*----------------------------------------------------------------------------*/
  HANDLE Handle;
  WIN32_FIND_DATAA FindFileData;
  char newsrc[1024];

  Handle = pinstance->GetPlugin()->WFX_FindFirst(dirname,&FindFileData);
  if (Handle!=INVALID_HANDLE_VALUE)
  {
    do
    {
next:
      // If we find '.' or '..' go forward
      if ((FindFileData.cFileName[0]=='.')&&((FindFileData.cFileName[1]=='\0')||((FindFileData.cFileName[1]=='.')&&(FindFileData.cFileName[2]=='\0'))))
        continue;
      lstrcpy(newsrc,dirname);
      Info.FSF->AddEndSlash(newsrc);
      lstrcat(newsrc,FindFileData.cFileName);
      if (FindFileData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
      {
        RemoveFromWfx(pinstance, newsrc);
        pinstance->GetPlugin()->WFX_FindClose(Handle);
        Handle = pinstance->GetPlugin()->WFX_FindFirst(dirname,&FindFileData);
        if (Handle!=INVALID_HANDLE_VALUE)
          goto next;
        else
          break;
      }
      else
      {
        pinstance->GetPlugin()->WFX_DeleteFile(newsrc);
        pinstance->GetPlugin()->WFX_FindClose(Handle);
        Handle = pinstance->GetPlugin()->WFX_FindFirst(dirname,&FindFileData);
        if (Handle!=INVALID_HANDLE_VALUE)
          goto next;
        else
          break;
      }
    } while (pinstance->GetPlugin()->WFX_FindNext(Handle,&FindFileData));
  }
  pinstance->GetPlugin()->WFX_FindClose(Handle);
  /*----------------------------------------------------------------------------*/
  if (pinstance->GetPlugin()->WFX_RemoveDir)
    pinstance->GetPlugin()->WFX_RemoveDir(dirname);
  return true;
}
/*----------------------------------------------------------------------------*/
bool CopyToWfx(WFXPluginInstance* pinstance, char dirname[1024], char dirnameshort[1024], int Move)
{
  char dest[1024];
  lstrcpy(dest,pinstance->GetDir());
  Info.FSF->AddEndSlash(dest);
  int dest_len=lstrlen(dest);
  lstrcpy(dest+dest_len,dirnameshort);
  if (pinstance->GetPlugin()->WFX_MkDir)
    pinstance->GetPlugin()->WFX_MkDir(dest);
  /*----------------------------------------------------------------------------*/
  HANDLE Handle;
  WIN32_FIND_DATAA FindFileData;
  char newsrc[1024];
  char newdst[1024];
  char newdir[1024];

  lstrcpy(newsrc,dirname);
  Info.FSF->AddEndSlash(newsrc);
  lstrcat(newsrc,"*");
  Handle=FindFirstFile(newsrc,&FindFileData);
  if (Handle!=INVALID_HANDLE_VALUE)
  {
    do
    {
      if (process_cancel)
        break;
      // If we find '.' or '..' go forward
      if ((FindFileData.cFileName[0]=='.')&&((FindFileData.cFileName[1]=='\0')||((FindFileData.cFileName[1]=='.')&&(FindFileData.cFileName[2]=='\0'))))
        continue;
      lstrcpy(newdir,dirnameshort);
      Info.FSF->AddEndSlash(newdir);
      lstrcat(newdir,FindFileData.cFileName);
      lstrcpy(newsrc,dirname);
      Info.FSF->AddEndSlash(newsrc);
      lstrcat(newsrc,FindFileData.cFileName);
      lstrcpy(newdst,pinstance->GetDir());
      Info.FSF->AddEndSlash(newdst);
      lstrcat(newdst,dirnameshort);
      Info.FSF->AddEndSlash(newdst);
      lstrcat(newdst,FindFileData.cFileName);
      if (FindFileData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
      {
        if (!CopyToWfx(pinstance, newsrc, newdir, Move))
        {
          FindClose(Handle);
          return false;
        }
      }
      else
      {
        SetWindowText(GetDlgItem(hWnd_Process,IDC_EDIT1),newsrc);
        SetWindowText(GetDlgItem(hWnd_Process,IDC_EDIT2),newdst);
        if (pinstance->GetPlugin()->WFX_PutFile(newsrc,newdst,Move)!=FS_FILE_OK)
        {
          FindClose(Handle);
          return false;
        }
      }
    } while (FindNextFile(Handle,&FindFileData));
  }
  FindClose(Handle);
  /*----------------------------------------------------------------------------*/
  return true;
}
/*----------------------------------------------------------------------------*/
bool CopyFromWfx(WFXPluginInstance* pinstance, char dirname[1024], char dirnameshort[1024], char dstpath[1024], int Move)
{
  CreateDirectory(dstpath,NULL);
  /*----------------------------------------------------------------------------*/
  HANDLE Handle;
  WIN32_FIND_DATAA FindFileData;
  char newsrc[1024];
  char newdst[1024];
  char newdir[1024];

  Handle = pinstance->GetPlugin()->WFX_FindFirst(dirname,&FindFileData);
  if (Handle!=INVALID_HANDLE_VALUE)
  {
    do
    {
      if (process_cancel)
        break;
      // If we find '.' or '..' go forward
      if ((FindFileData.cFileName[0]=='.')&&((FindFileData.cFileName[1]=='\0')||((FindFileData.cFileName[1]=='.')&&(FindFileData.cFileName[2]=='\0'))))
        continue;
      lstrcpy(newdir,dirnameshort);
      Info.FSF->AddEndSlash(newdir);
      lstrcat(newdir,FindFileData.cFileName);
      lstrcpy(newsrc,dirname);
      Info.FSF->AddEndSlash(newsrc);
      lstrcat(newsrc,FindFileData.cFileName);
      lstrcpy(newdst,dstpath);
      Info.FSF->AddEndSlash(newdst);
      lstrcat(newdst,FindFileData.cFileName);
      if (FindFileData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
      {
        if (!CopyFromWfx(pinstance, newsrc, newdir, newdst, Move))
        {
          FindClose(Handle);
          return false;
        }
      }
      else
      {
        RemoteInfoStruct ri;
        ri.SizeLow=FindFileData.nFileSizeLow;
        ri.SizeHigh=FindFileData.nFileSizeHigh;
        ri.LastWriteTime=FindFileData.ftLastWriteTime;
        ri.Attr=FindFileData.dwFileAttributes;
        SetWindowText(GetDlgItem(hWnd_Process,IDC_EDIT1),newsrc);
        SetWindowText(GetDlgItem(hWnd_Process,IDC_EDIT2),newdst);
        if (pinstance->GetPlugin()->WFX_GetFile(newsrc,newdst,Move,&ri)!=FS_FILE_OK)
        {
          FindClose(Handle);
          return false;
        }
      }
    } while (pinstance->GetPlugin()->WFX_FindNext(Handle,&FindFileData));
  }
  pinstance->GetPlugin()->WFX_FindClose(Handle);
  /*----------------------------------------------------------------------------*/
  return true;
}
/*============================================================================*/
WFXPlugin::WFXPlugin()
{
 this->counter=0;
 this->valid=true;
 this->showinmenu=false;
 this->hotkey=' ';
 this->alias[0]='\0';
 this->name[0]='\0';
 this->hDLL=NULL;
 this->WFX_Init=NULL;
 this->WFX_FindFirst=NULL;
 this->WFX_FindNext=NULL;
 this->WFX_FindClose=NULL;
 this->WFX_MkDir=NULL;
 this->WFX_ExecuteFile=NULL;
 this->WFX_RenMovFile=NULL;
 this->WFX_GetFile=NULL;
 this->WFX_PutFile=NULL;
 this->WFX_DeleteFile=NULL;
 this->WFX_RemoveDir=NULL;
 this->WFX_Disconnect=NULL;
 this->WFX_SetAttr=NULL;
 this->WFX_SetTime=NULL;
 this->WFX_StatusInfo=NULL;
 this->WFX_GetDefRootName=NULL;
 this->WFX_ExtractCustomInfo=NULL;
 this->WFX_SetDefaultParams=NULL;
}
/*----------------------------------------------------------------------------*/
bool WFXPlugin::IsValid(void)
{
 return this->valid;
}
/*----------------------------------------------------------------------------*/
bool WFXPlugin::Incriment(void)
{
 if (this->valid)
 {
  if (this->counter==0)
  {
   if (this->Load())
   {
    this->counter++;
    return true;
   }
   else
   {
    this->valid=false;
    return false;
   }
  }
  else
  {
   this->counter++;
   return true;
  }
 }
 else
  return false;
}
/*----------------------------------------------------------------------------*/
bool WFXPlugin::Decriment(void)
{
 if ((this->valid)&&(this->counter>0))
 {
  this->counter--;
  if (this->counter==0)
   this->Unload();
  return true;
 }
 else
  return false;
}
/*----------------------------------------------------------------------------*/
void WFXPlugin::SetHotkey(const char hotkey)
{
 this->hotkey=(hotkey==' ')?' ':hotkey;
}
/*----------------------------------------------------------------------------*/
void WFXPlugin::SetAlias(const char* alias)
{
 strncpy(this->alias,alias,256);
}
/*----------------------------------------------------------------------------*/
void WFXPlugin::SetName(const char* pluginname)
{
 strncpy(this->name,pluginname,MYMAXPATH);
}
/*----------------------------------------------------------------------------*/
void WFXPlugin::SetShowInMenu(const bool show)
{
  this->showinmenu=show;
}
/*----------------------------------------------------------------------------*/
char WFXPlugin::GetHotkey(void) const
{
 return this->hotkey;
}
/*----------------------------------------------------------------------------*/
char* WFXPlugin::GetAlias(void) const
{
 return (char*)this->alias;
}
/*----------------------------------------------------------------------------*/
char* WFXPlugin::GetName(void) const
{
 return (char*)this->name;
}
/*----------------------------------------------------------------------------*/
bool WFXPlugin::GetShowInMenu(void) const
{
 return this->showinmenu;
}
/*----------------------------------------------------------------------------*/
bool WFXPlugin::Load(void)
{
 OemToChar(this->name,this->name);
 this->hDLL=LoadLibrary(this->name);
 CharToOem(this->name,this->name);
 if (this->hDLL==NULL)
  return false;
 this->WFX_Init=(WFX_INIT)GetProcAddress(this->hDLL,"FsInit");
 if (this->WFX_Init==NULL)
 {
  FreeLibrary(this->hDLL);
  return false;
 }
 this->WFX_FindFirst=(WFX_FINDFIRST)GetProcAddress(this->hDLL,"FsFindFirst");
 if (this->WFX_FindFirst==NULL)
 {
  FreeLibrary(this->hDLL);
  return false;
 }
 this->WFX_FindNext=(WFX_FINDNEXT)GetProcAddress(this->hDLL,"FsFindNext");
 if (this->WFX_FindNext==NULL)
 {
  FreeLibrary(this->hDLL);
  return false;
 }
 this->WFX_FindClose=(WFX_FINDCLOSE)GetProcAddress(this->hDLL,"FsFindClose");
 if (this->WFX_FindClose==NULL)
 {
  FreeLibrary(this->hDLL);
  return false;
 }
 this->WFX_MkDir=(WFX_MKDIR)GetProcAddress(this->hDLL,"FsMkDir");
 this->WFX_ExecuteFile=(WFX_EXECUTEFILE)GetProcAddress(this->hDLL,"FsExecuteFile");
 this->WFX_RenMovFile=(WFX_RENMOVFILE)GetProcAddress(this->hDLL,"FsRenMovFile");
 this->WFX_GetFile=(WFX_GETFILE)GetProcAddress(this->hDLL,"FsGetFile");
 this->WFX_PutFile=(WFX_PUTFILE)GetProcAddress(this->hDLL,"FsPutFile");
 this->WFX_DeleteFile=(WFX_DELETEFILE)GetProcAddress(this->hDLL,"FsDeleteFile");
 this->WFX_RemoveDir=(WFX_REMOVEDIR)GetProcAddress(this->hDLL,"FsRemoveDir");
 this->WFX_Disconnect=(WFX_DISCONNECT)GetProcAddress(this->hDLL,"FsDisconnect");
 this->WFX_SetAttr=(WFX_SETATTR)GetProcAddress(this->hDLL,"FsSetAttr");
 this->WFX_SetTime=(WFX_SETTIME)GetProcAddress(this->hDLL,"FsSetTime");
 this->WFX_StatusInfo=(WFX_STATUSINFO)GetProcAddress(this->hDLL,"FsStatusInfo");
 this->WFX_GetDefRootName=(WFX_GETDEFROOTNAME)GetProcAddress(this->hDLL,"FsGetDefRootName");
 this->WFX_ExtractCustomInfo=(WFX_EXTRACTCUSTOMICON)GetProcAddress(this->hDLL,"FsExtractCustomIcon");
 this->WFX_SetDefaultParams=(WFX_SETDEFAULTPARAMS)GetProcAddress(this->hDLL,"FsSetDefaultParams");
 if (this->WFX_GetDefRootName!=NULL)
 {
  char rootname[256];
  this->WFX_GetDefRootName(rootname,256);
 }
 return true;
}
/*----------------------------------------------------------------------------*/
bool WFXPlugin::Unload(void)
{
 if (this->hDLL!=NULL)
  FreeLibrary(this->hDLL);
 return true;
}
/*----------------------------------------------------------------------------*/
bool WFXPlugin::Verify(void)
{
 if (this->Load())
 {
  this->Unload();
  this->valid=true;
  return true;
 }
 else
 {
  this->valid=false;
  return false;
 }
}
/*----------------------------------------------------------------------------*/
bool WFXPlugin::Register(const char hotkey,const char* alias,const char* pluginname,bool showinmenu)
{
 SetHotkey(hotkey);
 SetAlias(alias);
 SetName(pluginname);
 SetShowInMenu(showinmenu);

 OemToChar(this->name,this->name);
 return true;
}
/*----------------------------------------------------------------------------*/
bool WFXPlugin::UnRegister(void)
{
 return true;
}
/*============================================================================*/
WFXPluginInstance::WFXPluginInstance(WFXPlugin* plugin)
{
 this->plugin=plugin;
 strcpy(this->curdir,"");

 fh=INVALID_HANDLE_VALUE;
 hScreen=NULL;
 NoMoreFiles=false;
 lstrcpy(this->curdir, "\\");
 connected=false;
 *DisconnectRoot=0;
}
/*----------------------------------------------------------------------------*/
WFXPlugin* WFXPluginInstance::GetPlugin(void) const
{
 return this->plugin;
}
/*----------------------------------------------------------------------------*/
const char* WFXPluginInstance::GetDir(void) const
{
 return this->curdir;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::Load(int PluginNr,CALLBACK_PROGRESSPROC pProgressProc,CALLBACK_LOGPROC pLogProc,CALLBACK_REQUESTPROC pRequestProc)
{
 if (this->plugin!=NULL)
  if (this->plugin->Incriment())
  {
   if (this->plugin->WFX_Init!=NULL)
   {
    if (this->plugin->WFX_Init(PluginNr,pProgressProc,pLogProc,pRequestProc)!=0)
    {
     this->plugin->Decriment();
     return false;
    }
    if (this->plugin->WFX_SetDefaultParams!=NULL)
    {
     FsDefaultParamStruct params;
     params.size=sizeof(FsDefaultParamStruct);
     params.PluginInterfaceVersionLow=30;
     params.PluginInterfaceVersionHi=1;
     GetModuleFileName(hinst,params.DefaultIniName,MAX_PATH);
     unsigned modulenamelength=(unsigned)(strlen(params.DefaultIniName)-1);
     while ((modulenamelength>0)&&(params.DefaultIniName[modulenamelength]!='\\')&&(params.DefaultIniName[modulenamelength]!='/'))
      modulenamelength--;
     params.DefaultIniName[modulenamelength]='\0';
     if (modulenamelength!=0)
     {
      strcat(params.DefaultIniName,"\\wfx.ini");
      this->plugin->WFX_SetDefaultParams(&params);
     }
    }
    return true;
   }
   this->plugin->Decriment();
  }
 return false;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::Close(void)
{
 CheckConnection("");
 if (this->plugin!=NULL)
  this->plugin->Decriment();
 return true;
}
/*----------------------------------------------------------------------------*/
void WFXPluginInstance::CheckConnection(const char *NewDir)
{
  if (connected && (this->plugin!=NULL) && (this->plugin->WFX_Disconnect!=NULL))
  {
    if (lstrlen(NewDir)<lstrlen(DisconnectRoot) || !*NewDir)
      connected=false;
    else
    {
      char temp[1024];
      lstrcpyn(temp,NewDir,lstrlen(DisconnectRoot)+1);
      if (lstrcmp(temp,DisconnectRoot))
        connected=false;
    }
    if (!connected)
    {
      this->plugin->WFX_Disconnect(DisconnectRoot);
      *DisconnectRoot=0;
    }
  }
}
/*----------------------------------------------------------------------------*/
void WFXPluginInstance::Connected(const char *Root)
{
 connected=true;
 lstrcpy(DisconnectRoot,Root);
}
/*----------------------------------------------------------------------------*/
void WFXPluginInstance::Disconnected()
{
  connected=false;
  *DisconnectRoot=0;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::SetDir(const char* Dir)
{
  char NewDir[1024];
  lstrcpy(NewDir,this->curdir);
  if (!lstrcmp(Dir,".."))
  {
    if (lstrlen(this->curdir) == 1)
    {
      *this->curdir = 0;
      return false;
    }
    else
    {
      *(PointToName(NewDir)) = 0;
      CheckConnection(NewDir);
    }
  }
  else if (Dir[0]=='\\')
  {
    lstrcpy(NewDir,Dir);
  }
  else
  {
    Info.FSF->AddEndSlash(NewDir);
    lstrcat(NewDir,Dir);
  }
  {
    int i = lstrlen(NewDir);
    if (i > 1 && NewDir[i-1] == '\\')
      NewDir[i-1] = 0;
  }
  StatusInfo(FS_STATUS_START,FS_STATUS_OP_LIST);
  NoMoreFiles=false;
  hScreen=Info.SaveScreen(0,0,-1,-1);
  fh = this->plugin->WFX_FindFirst(NewDir, &fd);
  if (fh != INVALID_HANDLE_VALUE)
  {
    lstrcpy(this->curdir,NewDir);
  }
  else if (GetLastError() == ERROR_NO_MORE_FILES)
  {
    NoMoreFiles=true;
    lstrcpy(this->curdir,NewDir);
  }
  else
  {
    StatusInfo(FS_STATUS_END,FS_STATUS_OP_LIST);
    return false;
  }
  StatusInfo(FS_STATUS_END,FS_STATUS_OP_LIST);
  CheckConnection(this->curdir);
  return true;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::GetFileList(struct PluginPanelItem **pPanelItem, int *pItemsNumber)
{
  bool ret=false;
  *pPanelItem=NULL;
  *pItemsNumber=0;
  if (!lstrcmp(this->curdir,""))
   return false;
  if (NoMoreFiles)
  {
    if (hScreen)
    {
      Info.RestoreScreen(NULL);
      Info.RestoreScreen(hScreen);
      hScreen=NULL;
    }
    NoMoreFiles=false;
    return true;
  }
  if (fh == INVALID_HANDLE_VALUE)
  {
    hScreen=Info.SaveScreen(0,0,-1,-1);
    fh = this->plugin->WFX_FindFirst(this->curdir,&fd);
  }
  if (fh != INVALID_HANDLE_VALUE)
  {
    BOOL fn;
    do
    {
      if (lstrcmp(fd.cFileName,"."))
      {
        PluginPanelItem *NewPanelItem=(PluginPanelItem *)realloc(*pPanelItem,(*pItemsNumber+1)*sizeof(PluginPanelItem));
        if (!NewPanelItem)
        {
          this->plugin->WFX_FindClose(fh);
          fh=INVALID_HANDLE_VALUE;
          ret=false;
          goto finish;
        }
        *pPanelItem=NewPanelItem;

        memset(&NewPanelItem[*pItemsNumber],0,sizeof(PluginPanelItem));
        WinFindDataToFarFindData(&NewPanelItem[*pItemsNumber].FindData,&fd);
        (*pItemsNumber)++;
      }
      fn = this->plugin->WFX_FindNext(fh, &fd);
    } while (fn);
    this->plugin->WFX_FindClose(fh);
    fh=INVALID_HANDLE_VALUE;
    ret=true;
  }
  else if (GetLastError() == ERROR_NO_MORE_FILES)
    ret=true;

finish:
  if (hScreen)
  {
    Info.RestoreScreen(NULL);
    Info.RestoreScreen(hScreen);
    hScreen=NULL;
  }

  return ret;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::FreeFileList(struct PluginPanelItem *PanelItem, int ItemsNumber)
{
 if (PanelItem)
  free(PanelItem);
 return true;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::ProcessKey(int Key, unsigned int ControlState,const char* curfilename)
{
  if (Key==VK_F8&&(!ControlState||ControlState==PKF_SHIFT))
  {
    if (this->plugin->WFX_DeleteFile)
      return false;
    return true;
  }
  if (Key==VK_F7&&(!ControlState))
  {
    if (this->plugin->WFX_MkDir)
      return false;
    return true;
  }
  if (this->plugin->WFX_ExecuteFile)
  {
    int cmd=0;
    int pth=0;
    if ((!ControlState || (ControlState==PKF_SHIFT)) && Key==VK_RETURN)
      cmd=0;
    else if (ControlState==(PKF_CONTROL|PKF_SHIFT) && Key==VK_F9)
      cmd=1;
    else if (ControlState==(PKF_ALT|PKF_SHIFT) && Key==VK_F9)
    {
     cmd=1;
     pth=1;
    }
    else
      return false;
    char path[MAX_PATH];
    sprintf(path,"%s%s%s",this->curdir,lstrcmp(this->curdir,"\\")?"\\":"",curfilename);
    StatusInfo(FS_STATUS_START,FS_STATUS_OP_EXEC);
    Exec_Function = this->plugin->WFX_ExecuteFile;
    lstrcpy(Exec_Path,pth?"\\":path);
    lstrcpy(Exec_Command,cmd?"properties":"open");
    Exec_Start = true;
    Exec_End = true;
    StatusInfo(FS_STATUS_END,FS_STATUS_OP_EXEC);
    return true;
  }
  return false;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::GetFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,char *DestPath,int OpMode)
{
  if ((this->plugin->WFX_GetFile!=NULL)&&(ItemsNumber>0))
  {
    ShowWindow(hWnd_Process,SW_SHOW);
    SendMessage(GetDlgItem(hWnd_Process,IDC_PROGRESS1),PBM_SETPOS,0,0);
    process_cancel=false;
    char dest[1024];
    lstrcpy(dest,DestPath);
    Info.FSF->AddEndSlash(dest);
    int dest_len=lstrlen(dest);
    Move = Move?FS_COPYFLAGS_MOVE:0;
    for (int i=0; i<ItemsNumber; i++)
    {
      if (process_cancel)
        break;
      lstrcpy(dest+dest_len,PanelItem[i].FindData.cFileName);
      ReplaceIllegalChars((unsigned char*)(dest+dest_len));
      char src[1024];
      sprintf(src,"%s%s%s",this->curdir,lstrcmp(this->curdir,"\\")?"\\":"",PanelItem[i].FindData.cFileName);
      if (PanelItem[i].FindData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
      {
        if (!CopyFromWfx(this,src,PanelItem[i].FindData.cFileName,dest,Move))
          break;
        else
          if (Move)
          {
            StatusInfo(FS_STATUS_START,FS_STATUS_OP_LIST);
            RemoveFromWfx(this,src);
            StatusInfo(FS_STATUS_END,FS_STATUS_OP_LIST);
          }
      }
      else
      {
        RemoteInfoStruct ri;
        ri.SizeLow=PanelItem[i].FindData.nFileSizeLow;
        ri.SizeHigh=PanelItem[i].FindData.nFileSizeHigh;
        ri.LastWriteTime=PanelItem[i].FindData.ftLastWriteTime;
        ri.Attr=PanelItem[i].FindData.dwFileAttributes;
        SetWindowText(GetDlgItem(hWnd_Process,IDC_EDIT1),src);
        SetWindowText(GetDlgItem(hWnd_Process,IDC_EDIT2),dest);
        if (this->plugin->WFX_GetFile(src,dest,Move,&ri)!=FS_FILE_OK)
          break;
        else
        {
          if (Move)
           if (this->plugin->WFX_DeleteFile)
             this->plugin->WFX_DeleteFile(src);
        }
      }
      if (PanelItem[i].Flags&PPIF_SELECTED)
        PanelItem[i].Flags&=~PPIF_SELECTED;
    }
    SendMessage(GetDlgItem(hWnd_Process,IDC_PROGRESS1),PBM_SETPOS,100,0);
    ShowWindow(hWnd_Process,SW_HIDE);
    return true;
  }
  return false;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::PutFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int Move,int OpMode)
{
  if ((this->plugin->WFX_PutFile!=NULL)&&(ItemsNumber>0))
  {
    ShowWindow(hWnd_Process,SW_SHOW);
    SendMessage(GetDlgItem(hWnd_Process,IDC_PROGRESS1),PBM_SETPOS,0,0);
    process_cancel=false;
    char curfile[1024];
    char dest[1024];
    GetCurrentDirectory(1024,curfile);
    Info.FSF->AddEndSlash(curfile);
    lstrcpy(dest,this->curdir);
    Info.FSF->AddEndSlash(dest);
    int dest_len=lstrlen(dest);
    int curfile_len=lstrlen(curfile);
    Move = Move?FS_COPYFLAGS_MOVE:0;
    for (int i=0; i<ItemsNumber; i++)
    {
      if (process_cancel)
        break;
      lstrcpy(dest+dest_len,PanelItem[i].FindData.cFileName);
      lstrcpy(curfile+curfile_len,PanelItem[i].FindData.cFileName);
      if (PanelItem[i].FindData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
      {
        if (!CopyToWfx(this,curfile,PanelItem[i].FindData.cFileName,Move))
          break;
        else
          if (Move)
            RemoveDirEx(curfile);
      }
      else
      {
        SetWindowText(GetDlgItem(hWnd_Process,IDC_EDIT1),curfile);
        SetWindowText(GetDlgItem(hWnd_Process,IDC_EDIT2),dest);
        if (this->plugin->WFX_PutFile(curfile,dest,Move)!=FS_FILE_OK)
          break;
        else
          if (Move)
            DeleteFile(curfile);
      }
      if (PanelItem[i].Flags&PPIF_SELECTED)
        PanelItem[i].Flags&=~PPIF_SELECTED;
    }
    SendMessage(GetDlgItem(hWnd_Process,IDC_PROGRESS1),PBM_SETPOS,100,0);
    ShowWindow(hWnd_Process,SW_HIDE);
    return true;
  }
  return false;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::DeleteFiles(struct PluginPanelItem *PanelItem,int ItemsNumber,int OpMode)
{
  if (this->plugin->WFX_DeleteFile)
  {
    for (int i=0; i<ItemsNumber; i++)
    {
      char src[1024];
      sprintf(src,"%s%s%s",this->curdir,lstrcmp(this->curdir,"\\")?"\\":"",PanelItem[i].FindData.cFileName);
      if (PanelItem[i].FindData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
      {
        StatusInfo(FS_STATUS_START,FS_STATUS_OP_LIST);
        RemoveFromWfx(this,src);
        StatusInfo(FS_STATUS_END,FS_STATUS_OP_LIST);
      }
      else
        this->plugin->WFX_DeleteFile(src);
      if (PanelItem[i].Flags&PPIF_SELECTED)
        PanelItem[i].Flags&=~PPIF_SELECTED;
    }
    return true;
  }
  return false;
}
/*----------------------------------------------------------------------------*/
bool WFXPluginInstance::MakeDirectory(char *Name,int OpMode)
{
  if (this->plugin->WFX_MkDir)
  {
    char src[1024];
    sprintf(src,"%s%s%s",this->curdir,lstrcmp(this->curdir,"\\")?"\\":"",Name);
    this->plugin->WFX_MkDir(src);
    return true;
  }
  return false;
}
/*----------------------------------------------------------------------------*/
void WFXPluginInstance::StatusInfo(int InfoStartEnd,int InfoOperation)
{
  if (this->plugin->WFX_StatusInfo)
  {
    char RemoteDir[1024];
    lstrcpy(RemoteDir,this->curdir);
    this->plugin->WFX_StatusInfo(RemoteDir,InfoStartEnd,InfoOperation);
  }
}
/*----------------------------------------------------------------------------*/
void WFXPluginInstance::ReplaceIllegalChars(unsigned char *ptr)
{
 while (*ptr)
 {
  const unsigned char *zz;
  if ((( zz = (const unsigned char*)strchr((char*)(ILLEGAL_SYMB),*ptr)) != NULL))
   *ptr = ((unsigned char*)ILLEGAL_REPL)[zz-ILLEGAL_SYMB];
  if ((*ptr < 32)||(*ptr == 127)) *ptr = 32;
  ptr++;
 }
}
/*----------------------------------------------------------------------------*/
char* WFXPluginInstance::PointToName(char *str)
{
  char *ptr;
  for (ptr=str+lstrlen(str); ptr>str; ptr--)
    if (*(ptr-1)=='\\')
      break;
  return ptr;
}
/*----------------------------------------------------------------------------*/
void WFXPluginInstance::WinFindDataToFarFindData(struct FAR_FIND_DATA *ffd, WIN32_FIND_DATA *wfd)
{
  lstrcpy(ffd->cFileName, wfd->cFileName);
  lstrcpy(ffd->cAlternateFileName, wfd->cAlternateFileName);
  ffd->dwFileAttributes = wfd->dwFileAttributes;
  ffd->ftCreationTime = wfd->ftCreationTime;
  ffd->ftLastAccessTime = wfd->ftLastAccessTime;
  ffd->ftLastWriteTime = wfd->ftLastWriteTime;
  ffd->nFileSizeHigh = wfd->nFileSizeHigh;
  ffd->nFileSizeLow = wfd->nFileSizeLow;
  ffd->dwReserved0 = wfd->dwReserved0;
  ffd->dwReserved1 = wfd->dwReserved1;
}
/*============================================================================*/
