unit pwdchangeu;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, misc, Menus, language;

type
  TPwdChange = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    OldPwdEdit: TEdit;
    Label2: TLabel;
    NewPwdEdit: TEdit;
    Label3: TLabel;
    NewPwdEdit2: TEdit;
    procedure FormShow(Sender: TObject);
    procedure OldPwdEditKeyPress(Sender: TObject; var Key: Char);
    procedure NewPwdEditKeyPress(Sender: TObject; var Key: Char);
    procedure NewPwdEdit2KeyPress(Sender: TObject; var Key: Char);
    procedure OKBtnClick(Sender: TObject);
    procedure GroupBox1DblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PwdChange: TPwdChange;

implementation

{$R *.dfm}

{=========================================================================}

procedure TPwdChange.FormShow(Sender: TObject);
begin
   OldPwdEdit.SetFocus;
   OldPwdEdit.Clear;
   NewPwdEdit.Clear;
   NewPwdEdit2.Clear;
   Label1.Caption := Strings.PwdChangeStrings.TypeOldPwd;
   Label2.Caption := Strings.PwdChangeStrings.TypeNewPwd;
   Label3.Caption := Strings.PwdChangeStrings.RetypeNewPwd;
   CancelBtn.Caption := Strings.GeneralCaptions.Cancel;
   Caption := 'AES plugin - ' + Strings.PwdChangeStrings.PwdChangeCaption;
   OldPwdEdit.PasswordChar := '*';
   NewPwdEdit.PasswordChar := '*';
   NewPwdEdit2.PasswordChar := '*';
end;

{=========================================================================}

procedure TPwdChange.OldPwdEditKeyPress(Sender: TObject; var Key: Char);
begin
  if key = chr(13) then
     if trim(OldPwdEdit.Text) <> '' then
        NewPwdEdit.SetFocus
     else
        OldPwdEdit.Clear;
end;

{=========================================================================}

procedure TPwdChange.NewPwdEditKeyPress(Sender: TObject; var Key: Char);
begin
  if key = chr(13) then
     if trim(NewPwdEdit.Text) <> '' then
        NewPwdEdit2.SetFocus
     else
        NewPwdEdit.Clear;
end;

{=========================================================================}

procedure TPwdChange.NewPwdEdit2KeyPress(Sender: TObject; var Key: Char);
begin
  if key = chr(13) then
     if trim(NewPwdEdit2.Text) <> '' then
        OKBtnClick(Sender)
     else
        NewPwdEdit2.Clear;
end;

{=========================================================================}

procedure TPwdChange.OKBtnClick(Sender: TObject);
begin
  modalResult := mrOK;
  Hide;
end;

{=========================================================================}

procedure TPwdChange.GroupBox1DblClick(Sender: TObject);
begin
  if OldPwdEdit.PasswordChar = #0 then begin
     OldPwdEdit.PasswordChar := '*';
     NewPwdEdit.PasswordChar := '*';
     NewPwdEdit2.PasswordChar := '*';
  end else begin
     OldPwdEdit.PasswordChar := #0;
     NewPwdEdit.PasswordChar := #0;
     NewPwdEdit2.PasswordChar := #0;
  end;
  OldPwdEdit.SelStart := Length(OldPwdEdit.Text);
  NewPwdEdit.SelStart := Length(NewPwdEdit.Text);
  NewPwdEdit2.SelStart := Length(NewPwdEdit2.Text);
end;

end.
