
unit ConfigDialog;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, inifiles, dialogs, ComCtrls, elaes, math, misc, shellapi,
  rng, language, filectrl, menus;
                                
type
  TConfigDlg = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    PageControl1: TPageControl;
    SettingsPC: TTabSheet;
    MiscTab: TTabSheet;
    GroupBox2: TGroupBox;
    CheckBox3: TCheckBox;
    Edit1: TEdit;
    CheckBox4: TCheckBox;
    GroupBox3: TGroupBox;
    Label6: TLabel;
    CheckBox1: TCheckBox;
    ComboBox1: TComboBox;
    CheckBox2: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    Misc2Tab: TTabSheet;
    GroupBox4: TGroupBox;
    Button1: TButton;
    Edit3: TEdit;
    Label7: TLabel;
    Edit2: TEdit;
    UpDown1: TUpDown;
    cbLower: TCheckBox;
    cbNumber: TCheckBox;
    cbOther: TCheckBox;
    cbUpper: TCheckBox;
    GroupBox5: TGroupBox;
    Label12: TLabel;
    ComboBox2: TComboBox;
    LangTab: TTabSheet;
    GroupBox7: TGroupBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    Button2: TButton;
    GroupBox8: TGroupBox;
    ListBox2: TListBox;
    Button3: TButton;
    Button4: TButton;
    GroupBox9: TGroupBox;
    Edit4: TEdit;
    Button5: TButton;
    OpenDialog1: TOpenDialog;
    AboutTab: TTabSheet;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label5: TLabel;
    Label1: TLabel;
    VersionLabel: TLabel;
    Bevel1: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    GroupBox6: TGroupBox;
    Label11: TLabel;
    ListBox1: TListBox;
    HotkeyTab: TTabSheet;
    GroupBox10: TGroupBox;
    Label13: TLabel;
    HotKey1: THotKey;
    Label14: TLabel;
    HotKey2: THotKey;
    Label15: TLabel;
    HotKey3: THotKey;
    Label16: TLabel;
    HotKey4: THotKey;
    Misc3tab: TTabSheet;
    GroupBox11: TGroupBox;
    CheckBox11: TCheckBox;
    GroupBox12: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Edit5: TEdit;
    Edit6: TEdit;
    Button6: TButton;
    RadioButton3: TRadioButton;
    Edit7: TEdit;
    procedure OKBtnClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Label10Click(Sender: TObject);
    procedure SetLang;
    procedure ListBox1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Edit4Change(Sender: TObject);
    procedure ListBox2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ListBox2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure cbOtherClick(Sender: TObject);
    procedure HotKey1Change(Sender: TObject);
    procedure HotKey2Change(Sender: TObject);
    procedure HotKey3Change(Sender: TObject);
    procedure HotKey4Change(Sender: TObject);
    procedure CheckBox11Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure SetIniPlacingSettings;
    procedure Button6Click(Sender: TObject);
    procedure Edit6Change(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ConfigDlg: TConfigDlg;
  uninstall: boolean;
implementation

{$R *.DFM}

{=========================================================================}

procedure TConfigDlg.OKBtnClick(Sender: TObject);
begin
  SaveSettings;
end;

{=========================================================================}

procedure TConfigDlg.CheckBox1Click(Sender: TObject);
begin
  Settings.wipeorigfile := CheckBox1.Checked;
end;

{=========================================================================}

procedure TConfigDlg.ComboBox1Change(Sender: TObject);
begin
  Settings.complevel := Combobox1.Itemindex;
end;

{=========================================================================}

procedure TConfigDlg.CheckBox2Click(Sender: TObject);
begin
  Settings.wipetempfile := CheckBox2.Checked;
end;

{=========================================================================}

procedure TConfigDlg.BitBtn1Click(Sender: TObject);
var i: byte;
begin
   Settings.dontcompress_filetypes := '';
   if ListBox2.Count > 0 then
      for i := 0 to ListBox2.Count - 1 do
          Settings.dontcompress_filetypes := Settings.dontcompress_filetypes + ListBox2.Items[i] + ':';
   if not uninstall then
     SaveSettings;
end;

{=========================================================================}

procedure TConfigDlg.CheckBox3Click(Sender: TObject);
begin
   if CheckBox3.Checked then begin
      Edit1.Enabled := TRUE;
      Edit1.Color := clWindow;
      Edit1.SetFocus;
      Edit1.SelStart := 2;
   end else begin
      Edit1.Text := '';
      CheckBox3.SetFocus;
      Edit1.Enabled := FALSE;
      Edit1.Color := clBtnFace;
      mpl := '';
      Settings.minpwdlen := 0;
   end;
end;

{=========================================================================}

procedure TConfigDlg.CheckBox4Click(Sender: TObject);
begin
  if CheckBox4.Checked then begin
     CheckBox5.Enabled := TRUE;
     CheckBox6.Enabled := TRUE;
     CheckBox7.Enabled := TRUE;
  end else begin
     CheckBox5.Checked := FALSE;
     CheckBox6.Checked := FALSE;
     CheckBox7.Checked := FALSE;
     CheckBox5.Enabled := FALSE;
     CheckBox6.Enabled := FALSE;
     CheckBox7.Enabled := FALSE;
  end;
end;

{=========================================================================}

procedure TConfigDlg.Edit1Change(Sender: TObject);
begin
   mpl := Edit1.Text;
end;

{=========================================================================}

procedure TConfigDlg.CheckBox5Click(Sender: TObject);
begin
   Settings.reqnumber := CheckBox5.Checked;
end;

{=========================================================================}

procedure TConfigDlg.CheckBox6Click(Sender: TObject);
begin
   Settings.reqspecial := CheckBox6.Checked;
end;

{=========================================================================}

procedure TConfigDlg.CheckBox7Click(Sender: TObject);
begin
   Settings.reqalpha := CheckBox7.Checked;
end;

{=========================================================================}

procedure TConfigDlg.Label2Click(Sender: TObject);
begin
   ShellExecute(Handle, 'open', 'mailto:ludolf@intermail.hu' , '', '', SW_SHOWNORMAL);
end;

{=========================================================================}

procedure TConfigDlg.ComboBox2Change(Sender: TObject);
begin
   Settings.destkeytime := Combobox2.Itemindex;
end;

{=========================================================================}
procedure TConfigDlg.SetIniPlacingSettings;
var fn: string;
    Reg: TInifile;
begin

  Settings.userdefined_inipath := '';
  FillChar(dllpath, sizeof(dllpath), #0);
  GetModuleFileName(hInstance, dllpath, sizeof(dllpath));
  fn := ExtractFilePath(dllpath) + 'aes.ini';
  Edit5.Text := Settings.inipath;
  Edit7.Text := fn;
  RadioButton1.Checked := TRUE;  
  if FileExists(fn) then begin
     Reg := TInifile.Create(fn);
     try
       if Reg.ValueExists('AES', 'IniPath') then begin
          Settings.userdefined_inipath := Reg.ReadString('AES', 'IniPath', '');
          if not FileExists(Settings.userdefined_inipath) then
             Settings.userdefined_inipath := ''
          else begin
             RadioButton1.Checked := TRUE;
             Edit6.Text := Settings.userdefined_inipath;
          end;
       end else begin
          RadioButton3.Checked := TRUE;
          Exit;
       end;
     finally
        Reg.Free;
     end;
     if Settings.userdefined_inipath <> '' then begin
        RadioButton2.Checked := TRUE;
        Edit6.Text := Settings.userdefined_inipath;
        Exit;
     end;
  end;
end;

procedure TConfigDlg.FormShow(Sender: TObject);
begin
   Caption := 'AES encryptor plugin - ' + VERSIONTEXT;
   VersionLabel.Left := (GroupBox1.Width - VersionLabel.Width) div 2;
   mpl := '';
   Settings.dontcompress_filetypes := '';
   LoadSettings;
   LoadLanguage(Settings.langfile);
   SetLang;
   SetIniPlacingSettings;
   Update;
   Combobox1.Itemindex := Settings.complevel;
   CheckBox1.Checked := Settings.wipeorigfile;
   CheckBox2.Checked := Settings.wipetempfile;
   Combobox2.ItemIndex := Settings.destkeytime;
   if Settings.minpwdlen > 0 then begin
      CheckBox3.Checked := TRUE;
      Edit1.Text := itos(Settings.minpwdlen);
   end;

   if Settings.reqnumber OR Settings.reqspecial OR Settings.reqalpha then begin
      Checkbox4.Checked := TRUE;
      CheckBox5.Checked := Settings.reqnumber;
      CheckBox6.Checked := Settings.reqspecial;
      CheckBox7.Checked := Settings.reqalpha;
   end;
   Listbox1.ItemIndex := LangFileList.IndexOf(ExtractFileName(Settings.langfile));
   ExtractStrings([':'], [' '], PChar(Settings.dontcompress_filetypes), ListBox2.Items);
   Edit4.Text := Settings.default_keyfile;
   Hotkey1.HotKey := TextToShortcut(Settings.hotkey_encryptwith);
   Hotkey2.HotKey := TextToShortcut(Settings.hotkey_createsfx);
   Hotkey3.HotKey := TextToShortcut(Settings.hotkey_complevel);
   Hotkey4.HotKey := TextToShortcut(Settings.hotkey_openkeyfile);
   CheckBox11.Checked := Settings.always_create_sfx;   
end;

{=========================================================================}

procedure TConfigDlg.Button1Click(Sender: TObject);
var pwd: string;
    i, len, b: byte;
    c: char;
begin
  pwd := '';
  len := Min(UpDown1.Position, 128);
  i := 0;
  if not ((cbLower.Checked) OR (cbUpper.Checked) OR
         (cbNumber.Checked) OR (cbOther.Checked)) then Exit;
  while (i < len) do begin
      Rnd.Seed('', -1);
      Rnd.Buffer(b, 1); //get random byte
      c := chr(b);
      if ((c in ['a'..'z']) AND cbLower.Checked) then begin
         pwd := pwd + c;
         inc(i);
         continue;
      end;
      if ((c in ['A'..'Z']) AND (cbUpper.checked)) then begin
         pwd := pwd + c;
         inc(i);
         continue;
      end;
      if ((c in ['0'..'9']) AND (cbNumber.checked)) then begin
         pwd := pwd + c;
         inc(i);
         continue;
      end;
      if cbOther.Checked then begin
         pwd := pwd + c;
         inc(i);
         continue;
      end else continue;
  end;
  Edit3.Text := pwd;
end;

{=========================================================================}

function AesLng(filename: string; var name: string): boolean;
var Reg: TIniFile;
    s: string;
begin
  Reg := TInifile.Create(filename);
  s := Reg.ReadString('Info', 'PrgName', '');
  s := uppercase(s);
     if s = 'AES ENCRYPTOR PLUGIN' then begin
         name := Reg.ReadString('Info', 'Name', '');
         Result := TRUE;
     end
     else Result := FALSE;
  Reg.Free;
end;

{=========================================================================}

procedure TConfigDlg.FormCreate(Sender: TObject);
var srec: TSearchRec;
    name: string;
begin
  VersionLabel.Caption := 'version ' + VERSIONTEXT;
  FillChar(dllpath, sizeof(dllpath), #0);
  GetModuleFileName(hInstance, dllpath, sizeof(dllpath));
  if FindFirst(ExtractFilePath(dllpath) + '*.lng', faAnyFile - faDirectory, srec) = 0 then begin
       repeat
           if AesLng(ExtractFilePath(dllpath) + srec.Name, name) then begin
              LangFileList.Add(srec.name);
              ListBox1.Items.Add(Name); //lng for this prg
           end;
       until FindNext(srec) <> 0;
       FindClose(srec);
  end;//if
  if LangFileList.Count = 0 then
     Label11.Caption := '[language files not found]';
end;

{=========================================================================}

procedure TConfigDlg.Label10Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'http://free.x3.hu/ural2', '', '',
               SW_SHOWMAXIMIZED);
end;

{=========================================================================}

procedure TConfigDlg.SetLang;
var ii: byte;
begin
   SettingsPC.Caption := Strings.Config_Settings.Settings;
   GroupBox2.Caption := Strings.Config_Settings.PwdPolicy;
   CheckBox3.Caption := Strings.Config_Settings.MinLength;
   CheckBox4.Caption := Strings.Config_Settings.PwdMustContain;
   CheckBox7.Caption := Strings.Config_Settings.Letters;
   CheckBox5.Caption := Strings.Config_Settings.Numbers;
   CheckBox6.Caption := Strings.Config_Settings.SpecialChars;
   Label6.Caption := Strings.Config_Settings.CompressionLevel;
   CheckBox1.Caption := Strings.Config_Settings.WipeOriginalAfterEncrypt;
   CheckBox2.Caption := Strings.Config_Settings.WipeTempFiles;
   MiscTab.Caption := Strings.Config_Misc.Misc;
   Misc2Tab.Caption := Strings.Config_Misc.Misc + '2';
   Misc3Tab.Caption := Strings.Config_Misc.Misc + '3';   
   GroupBox4.Caption := Strings.Config_Misc.RandomPwdGenerator;
   Label7.Caption := Strings.Config_Misc.Length;
   cbLower.Caption := Strings.Config_Misc.LowerCaseLetters;
   cbUpper.Caption := Strings.Config_Misc.UpperCaseLetters;
   cbNumber.Caption := Strings.Config_Misc.Numbers;
   cbOther.Caption := Strings.Config_Misc.AnyASCIIChars;
   Button1.Caption := Strings.Config_Misc.Generate;
   Label12.Caption := Strings.Config_Misc.DestroyKeyInfo;
   ComboBox2.Items[0] := Strings.Config_Misc.Instantly;
   ComboBox2.Items[1] := '10 ' + Strings.Config_Misc.Sec;
   ComboBox2.Items[2] := '30 ' + Strings.Config_Misc.Sec;
   ComboBox2.Items[3] := '1 '  + Strings.Config_Misc.Min;
   ComboBox2.Items[4] := '2 '  + Strings.Config_Misc.Min;
   ComboBox2.Items[5] := '5 '  + Strings.Config_Misc.Min;
   BitBtn1.Caption := Strings.GeneralCaptions.Ok;
   BitBtn2.Caption := Strings.GeneralCaptions.Cancel;
   GroupBox7.Caption := Strings.Config_Uninstall.UninstallGroupBoxCaption;
   GroupBox8.Caption := Strings.GeneralCaptions.DontCompressTheseFileTypes;
   CheckBox9.Caption := Strings.Config_Uninstall.Settings;
   CheckBox10.Caption := Strings.Config_Uninstall.LanguageFiles;
   Button2.Caption := Strings.Config_Uninstall.Uninstall;
   ii := ComboBox1.ItemIndex;
   ComboBox1.Items[0] := Strings.GeneralCaptions.CompLevelMax;
   ComboBox1.Items[1] := Strings.GeneralCaptions.CompLevelNormal;
   ComboBox1.Items[2] := Strings.GeneralCaptions.CompLevelFast;
   ComboBox1.Items[3] := Strings.GeneralCaptions.CompLevelNone;
   ComboBox1.ItemIndex := ii;
   GroupBox9.Caption := Strings.Config_Misc.DefaultKeyFile;
   Button5.Caption := Strings.GeneralCaptions.Open;
   OpenDialog1.Filter := Strings.GeneralCaptions.AllFiles + '|*.*';
   OpenDialog1.Title := Strings.GeneralCaptions.Open;
   LangTab.Caption := Strings.Lang.LanguageCaption;
   GroupBox6.Caption := Strings.Lang.SelectYourLanguage;
   AboutTab.Caption := Strings.Config_About.AboutCaption;
   HotkeyTab.Caption := Strings.HotkeyStr.Hotkeys;
   Label13.Caption := Strings.HotkeyStr.EncryptWith;
   Label14.Caption := Strings.HotkeyStr.CreateSfx;
   Label15.Caption := Strings.HotkeyStr.CompLevelChange;
   Label16.Caption := Strings.HotkeyStr.OpenKeyfile;
   CheckBox11.Caption := Strings.Config_Misc3.AlwaysCreateSfx;
   GroupBox12.Caption := Strings.Config_Misc3.WhereToSaveSettings;
   RadioButton1.Caption := Strings.Config_Misc3.DefIniFile;
   RadioButton2.Caption := Strings.Config_Misc3.UserDefined;
   RadioButton3.Caption := Strings.Config_Misc3.CloseToWcx;
   Button6.Caption := Strings.GeneralCaptions.Browse;
end;

{=========================================================================}

procedure TConfigDlg.ListBox1Click(Sender: TObject);
var i: byte;
begin
  for i := 0 to Listbox1.Items.Count - 1 do begin
      if ListBox1.Selected[i] then begin
         LoadLanguage(ExtractFilePath(dllpath) + LangFileList[i]);
         Settings.langfile := ExtractFilePath(dllpath) + LangFileList[i];
         break;
      end;
  end;
  SetLang;
  Update;
end;

{=========================================================================}

procedure TConfigDlg.Button2Click(Sender: TObject);
var Reg: TIniFile;
    OSInfo: OSVERSIONINFO;
    srec: TSearchRec;
    name: string;
begin
  if MessageBox(0, PChar(Strings.Config_Uninstall.UninstallConfirm),
                   'AES plugin',
                   MB_YESNO + MB_DEFBUTTON2 + MB_ICONQUESTION + MB_APPLMODAL) = idNO then Exit;
  Uninstall := TRUE;  //don't save settings
  FillChar(dllpath, sizeof(dllpath), #0);
  GetModuleFileName(hInstance, dllpath, sizeof(dllpath));
  //get os version
  OSInfo.dwOSVersionInfoSize := Sizeof(OSInfo);
  GetVersionEx(OSInfo);
  case OSInfo.dwPlatformId of
       //win9x
    1: begin
         Reg := TIniFile.Create(FindWindowsDir + '\wininit.ini');
         Reg.WriteString('Rename', 'NUL', dllpath);
         Reg.Free;
       end;

       //winnt
    2: MoveFileEx(dllpath, nil, MOVEFILE_DELAY_UNTIL_REBOOT);

  end;
  Reg := TIniFile.Create(FindWindowsDir + '\wincmd.ini');
  Reg.DeleteKey('PackerPlugins', 'aes');
  Reg.Free;

  if CheckBox9.Checked then begin
     if ExtractFilename(Settings.inipath) = 'aes.ini' then
        DeleteFile2Kuka(PChar(Settings.inipath)) //delete to recycle bin
     else begin
        Reg := TIniFile.Create(Settings.inipath); //from PackSetDefParams()
        Reg.EraseSection('aes');
        Reg.Free;
     end;
  end;
  if CheckBox10.Checked then begin
     //delete .lng files
     if FindFirst(ExtractFilePath(dllpath) + '*.lng', faAnyFile - faDirectory, srec)=0 then begin
        repeat
          if AesLng(ExtractFilePath(dllpath) + srec.Name, name) then
             DeleteFile2Kuka(ExtractFilePath(dllpath) + srec.name);
        until FindNext(srec) <> 0;
        FindClose(srec);
     end;
  end;
  MessageDlg(WrapText(Strings.Config_Uninstall.Finished, 35) + U +
             WrapText(Strings.Config_Uninstall.AesWcxDelete, 35) + U +
             WrapText(Strings.Config_Uninstall.TCRestart, 35), mtInformation, [MBOK], 0);
end;

{=========================================================================}

procedure TConfigDlg.Button3Click(Sender: TObject);
var NewExt: string;
    i: byte;
begin
  if InputQuery('AES plugin', PChar(Strings.GeneralCaptions.TypeAnExtension), NewExt) then begin
     NewExt := trim(NewExt);
     if NewExt <> '' then begin  //skip zero-length strings
        for i := 1 to Length(NewExt) do begin
           if NewExt[i] in [':', '\', '/', '?', '*', '>', '<', '"'] then begin
              MessageBox(0, PChar(Strings.GeneralMessages.InvalidCharInExtension),
                            'AES plugin',
                            MB_OK + MB_ICONERROR);
              Exit;
           end;
        end;
        if ListBox2.Items.IndexOf(NewExt) = -1 then
           ListBox2.Items.Add(NewExt);
     end;
  end;
end;

{=========================================================================}

procedure TConfigDlg.Button4Click(Sender: TObject);
begin
  ListBox2.DeleteSelected;
end;

{=========================================================================}

procedure TConfigDlg.Button5Click(Sender: TObject);
begin
  OpenDialog1.Filter := Strings.GeneralCaptions.AllFiles + '|*.*';
  if Edit4.Text <> '' then
     OpenDialog1.InitialDir := ExtractFilePath(Edit4.Text);
  Button5.Caption := Strings.GeneralCaptions.Open;
  if OpenDialog1.Execute then
     Edit4.Text := OpenDialog1.FileName;
end;

{=========================================================================}

procedure TConfigDlg.Edit4Change(Sender: TObject);
begin
  Settings.default_keyfile := Edit4.Text;
end;

{=========================================================================}

procedure TConfigDlg.ListBox2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (ord(key) = VK_ADD) OR (ord(key) = VK_INSERT) then
      Button3Click(Sender);

  if (ord(key) = VK_SUBTRACT) OR (ord(key) = VK_DELETE) then
      Button4Click(Sender);
end;

{=========================================================================}

procedure TConfigDlg.ListBox2MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var i: integer;
    s: string;
begin
   s := '';
   if ListBox2.Count > 0 then
      for i := 0 to ListBox2.Count - 1 do
          if ListBox2.Selected[i] then
             s := s + ListBox2.Items[i] + U;

   if s <> '' then begin
      SetLength(s, Length(s) - 2);
      ListBox2.Hint := s;
   end else
      ListBox2.Hint := '';
end;


procedure TConfigDlg.cbOtherClick(Sender: TObject);
begin
   cbLower.Enabled := not cbOther.Checked;
   cbUpper.Enabled := not cbOther.Checked;
   cbNumber.Enabled := not cbOther.Checked;
end;

procedure TConfigDlg.HotKey1Change(Sender: TObject);
begin
   Settings.hotkey_encryptwith := ShortcutToText(Hotkey1.HotKey);
end;

procedure TConfigDlg.HotKey2Change(Sender: TObject);
begin
   Settings.hotkey_createsfx := ShortcutToText(Hotkey2.HotKey);
end;

procedure TConfigDlg.HotKey3Change(Sender: TObject);
begin
   Settings.hotkey_complevel := ShortcutToText(Hotkey3.HotKey);
end;

procedure TConfigDlg.HotKey4Change(Sender: TObject);
begin
   Settings.hotkey_openkeyfile := ShortcutToText(Hotkey4.HotKey);
end;

procedure TConfigDlg.CheckBox11Click(Sender: TObject);
begin
   Settings.always_create_sfx := CheckBox11.Checked;
end;

procedure TConfigDlg.RadioButton2Click(Sender: TObject);
begin
   Edit6.Enabled := TRUE;
   Edit6.Color := clWindow;
end;

procedure TConfigDlg.RadioButton1Click(Sender: TObject);
begin
   Edit6.Enabled := FALSE;
   Edit6.Color := clBtnFace;
   Settings.userdefined_inipath := '';
end;

procedure TConfigDlg.RadioButton3Click(Sender: TObject);
begin
   Edit6.Enabled := FALSE;
   Edit6.Color := clBtnFace;
   Settings.userdefined_inipath := ExtractFilePath(dllpath) + 'aes.ini';   
end;

procedure TConfigDlg.Button6Click(Sender: TObject);
var s: string;
begin
  if SelectDirectory(Strings.Config_Misc3.SelectDirWhereYouWantToSaveSettings, '', s) then
     Edit6.Text := s + 'aes.ini';
end;


procedure TConfigDlg.Edit6Change(Sender: TObject);
var h: integer;
begin
   Settings.userdefined_inipath := Edit6.Text;
end;

procedure TConfigDlg.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var h: integer;
    Reg: TIniFile;
begin
   if Settings.userdefined_inipath = '' then Exit;
   h := CreateFile(PChar(Settings.userdefined_inipath),
                   GENERIC_WRITE,
                   FILE_SHARE_READ,
                   NIL,
                   OPEN_ALWAYS,
                   FILE_ATTRIBUTE_NORMAL,
                   0);
   try
     if h = -1 then begin
        MessageBox(0, PChar(Strings.Config_Misc3.WriteError + U +
                   Settings.userdefined_inipath),
                   'AES plugin',
                   MB_ICONERROR + MB_OK);
        CanClose := FALSE;
        FillChar(dllpath, sizeof(dllpath), #0);
        GetModuleFileName(hInstance, dllpath, sizeof(dllpath));
        Reg := TInifile.Create(ExtractFilePath(dllpath) + 'aes.ini');
        Reg.DeleteKey('AES', 'IniPath');
        if not Reg.ValueExists('AES', 'Complevel') then begin
           Reg.Free;
           DeleteFile(ExtractFilePath(dllpath) + 'aes.ini');
        end else
           Reg.Free;
        Exit;            
     end;
   finally
     CloseHandle(h);
   end;
end;

procedure TConfigDlg.BitBtn2Click(Sender: TObject);
begin
   Settings.userdefined_inipath := '';
end;

end.



