{ KOL MCK } // Do not remove this line!
{$DEFINE KOL_MCK}
//{$DEFINE DEB}
unit Unit1;

interface
{$IFDEF KOL_MCK}
uses Windows, Messages, ShellAPI, KOL {$IFNDEF KOL_MCK}, mirror, Classes,  mckCtrls, Controls, mckObjs{$ENDIF},
{$ELSE}
{$I uses.inc}  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,  Dialogs, mirror, ComCtrls, mckCProgBar,
  Menus, StdCtrls;
{$ENDIF}
 Misc, Md5, Kolaes, Err, Crc, KolZlib, language, ren, cof;
type
  {$IFDEF KOL_MCK}
  {$I MCKfakeClasses.inc}
  PForm1 = ^TForm1;
  TForm1 = object(TObj)
 Form: PControl;
  {$ELSE not_KOL_MCK}
  TForm1 = class(TForm)
  {$ENDIF KOL_MCK}
    KOLProject1: TKOLProject;
    OKButton: TKOLButton;
    ExitButton: TKOLButton;
    KOLApplet1: TKOLApplet;
    OpenDirDialog1: TKOLOpenDirDialog;
    szal: TKOLThread;
    GroupBox1: TKOLGroupBox;
    EditBox1: TKOLEditBox;
    ProgressBar1: TKOLProgressBar;
    Browse1Button: TKOLButton;
    RadioBox1: TKOLRadioBox;
    RadioBox2: TKOLRadioBox;
    OpenSaveDialog1: TKOLOpenSaveDialog;
    EditBoxSima: TKOLEditBox;
    OpenSaveDialog2: TKOLOpenSaveDialog;
    EditBox2: TKOLEditBox;
    Browse2Button: TKOLButton;
    LabDecryptTo: TKOLLabel;
    procedure Browse2ButtonClick(Sender: PObj);
    procedure ExitButtonClick(Sender: PObj);
    procedure OKButtonClick(Sender: PObj);
    procedure EditBox2KeyDown(Sender: PControl; var Key: Integer;
                              Shift: Cardinal);
    procedure DecryptAES128StreamCBCEx(Source: PStream; Count: longword;
                                       const ExpandedKey: TAESExpandedKey128;
                                       const InitVector: TAESBuffer;
                                       Dest: PStream;
                                       var newcrc: longword);
    procedure KOLForm1Destroy(Sender: PObj);
    function  szalExecute(Sender: PThread): Integer;
    procedure RadioBox1Click(Sender: PObj);
    procedure RadioBox2Click(Sender: PObj);
    procedure Browse1ButtonClick(Sender: PObj);
    procedure KOLForm1FormCreate(Sender: PObj);
    procedure EditBox1KeyDown(Sender: PControl; var Key: Integer;
                              Shift: Cardinal);
    procedure EditBoxSimaKeyDown(Sender: PControl; var Key: Integer;
                                 Shift: Cardinal);
    procedure KOLForm1Close(Sender: PObj; var Accept: Boolean);
    procedure KOLForm1Show(Sender: PObj);
    procedure EditBox2Enter(Sender: PObj);

  private
 { Private declarations }
  public
 { Public declarations }
  end;

function CreateAESKeyAndCheckPwd: boolean;

var
  Form1 {$IFDEF KOL_MCK} : PForm1 {$ELSE} : TForm1 {$ENDIF} ;
{$IFDEF KOL_MCK}
procedure NewForm1( var Result: PForm1; AParent: PControl );
{$ENDIF}

implementation

{$IFNDEF KOL_MCK} {$R *.DFM} {$ENDIF}

{$IFDEF KOL_MCK}
{$I Unit1_1.inc}
{$ENDIF}

const mrOK = 1;
      mrCancel = 2;
      NO_MORE_FILE = 3;
      READ_ERROR   = 4;
Var
   IV: TAESbuffer=(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15);
   Exepath: array [0..MAX_PATH] of char;
   dest_dir, dest_dir_RO, tempfilename: string;
   A, ContinueAnyway: boolean;
   sfxmarker: array[0..10] of byte=(0,1,2,3,4,5,4,3,2,1,0);
   Dest: PStream;

{=========================================================================}

procedure ErrorMsg(s: string);
begin
     MessageBox(Form1.Form.Handle,
                PChar(s),
                PChar(SfxStrings.Error),
                MB_OK + MB_APPLMODAL + MB_ICONERROR);

end;

{=========================================================================}

function IsExeCorrupted(sfxsize: longint): boolean;
var newcrc, savedcrc: longword;
    h, nr, size: integer;
    buf: array [0..1023] of byte;
begin
{$IFDEF DEB} sm('IsExeCorrupted()');{$ENDIF}
    h := CreateFile(PChar(Paramstr(0)),
                    GENERIC_READ,
                    FILE_SHARE_READ,
                    NIL,
                    OPEN_EXISTING,
                    FILE_ATTRIBUTE_NORMAL,
                    0);
    size := 0;
    CRC32Init(newcrc);
    repeat
        nr := FileRead(h, buf, sizeof(buf));
        inc(size, nr);
        if size > sfxsize then
            dec(nr, size - sfxsize);
        CRC32Update(newcrc, @buf, nr);
        if size = sfxsize then nr := 0;
    until (nr = 0) OR (size > sfxsize);
    newcrc := CRC32Final(newcrc);
    SetFilePos(h, SfxSize);
    FileRead(h, savedcrc, sizeof(savedcrc));
    CloseHandle(h);
    Result := (newcrc <> savedcrc);
end;

{=========================================================================}

function UnpackFile(src, dst: string): byte;
var
  Source, Dest, ZStream: PStream;
  Count: longint;
  buffer: array [0..32767] of byte;
begin
{$IFDEF DEB} sm('UnpackFile()'); {$ENDIF}
 Source := NewReadFileStream(src);
 if Source.Size = STRM_ERROR then begin Result := E_READ; Exit; end;
        try
            Dest := NewWriteFileStream(dst);
            if dest.size = STRM_ERROR then begin Result := E_WRITE; Exit; end;
            ZStream := NewDecompressionStream(Source, nil);
            try
               try
                  while (True) And Working do begin
                         Count := ZStream.Read(Buffer, 32768);
                         if Count <> 0 then
                            Dest.Write(Buffer, Count)
                         else
                            break;
                  end;
               finally
                   ZStream.Free;
                   Dest.Free;
               end;
            finally
               Source.Free;
               WipeFile(src);
            end;
        except
            ErrorMsg(SfxStrings.ErrorDuringDecompression);
        end;
end;

{=========================================================================}

function GetSfxSize: longint;
var
  marker: array [0..10] of byte;
  pos, size: longint;
  sizecrc, r_sizecrc, sfxcrc: longword;
  headsize: word;
  header: THeader;
  h: integer;
begin
{$IFDEF DEB} sm('GetSfxSize()'); {$ENDIF}
    h := CreateFile(PChar(Paramstr(0)),
                    GENERIC_READ,
                    FILE_SHARE_READ,
                    NIL,
                    OPEN_EXISTING,
                    FILE_ATTRIBUTE_NORMAL,
                    0);
    try
       SetFilePos(h, FileSize(ParamStr(0)) - sizeof(size) - sizeof(r_sizecrc));
       FileRead(h, size, sizeof(size));
       FileRead(h, r_sizecrc, sizeof(r_sizecrc));
       CRC32Init(sizecrc);
       CRC32Update(sizecrc, @size, sizeof(size));
       sizecrc := CRC32Final(sizecrc);
       if CompareMem(@sizecrc, @r_sizecrc, sizeof(sizecrc)) then begin
          Result := size;
          SetFilePos(h, size);
          FileRead(h, sfxcrc, sizeof(sfxcrc));
          FileRead(h, marker, sizeof(marker));
          FileRead(h, headsize, sizeof(headsize));
          AESBegin := GetFilePos(h) + headsize;
          Exit;
       end;
       for pos := 50000 to 200000 do begin
           SetFilePos(h, pos);
           FileRead(h, marker, sizeof(marker));
           if CompareMem(@marker, @sfxmarker, sizeof(marker)) then begin
              Result := pos;
              FileRead(h, headsize, sizeof(headsize));
              AESBegin := GetFilePos(h) + headsize;
              FileRead(h, header, sizeof(header));
              if CheckMagic(header.magic) = 0 then Exit;
              SetFilePos(h, AESBegin);
           end;
       end;
       Result := 0;
    finally
        CloseHandle(h);
    end;
    if Result = 0 then begin
        MessageBox(0, 'Corrupted file.', 'Error', MB_ICONERROR);
        Halt;
    end;
end;//GetSfxSize()

{=========================================================================}

function ReadHeader(pos_from: integer; var header: THeader): integer;
var h, nr: integer;
begin
{$IFDEF DEB} sm('ReadHeader()'); {$ENDIF}
    Result := 0;
    try
        h := CreateFile(PChar(Paramstr(0)),
                        GENERIC_READ,
                        FILE_SHARE_READ,
                        NIL,
                        OPEN_EXISTING,
                        FILE_ATTRIBUTE_NORMAL,
                        0);
        SetFilePos(h, pos_from);
        nr := FileRead(h, header, sizeof(header));
        if nr <> sizeof(header) then Result := NO_MORE_FILE;
        CloseHandle(h);
    except
        On E: Exception do begin
          ErrorMsg('ReadHeader' + U +
                   E.Message);
          Result := READ_ERROR;
          Exit;
        end;
    end;
    if CheckMagic(header.magic) = UNKNOWN_FORMAT then
       Result := NO_MORE_FILE;
end;//ReadHeader()

{=========================================================================}

function CreateAESKey(salt: arr11): integer;
var pwdlen, keylen, saltsize, outblocklen: byte;
    cont1, cont2, cont3: TMD5Context;
    dig, dig_1, dig_2: ^TMd5Digest;
    block_szam, i, k, j, iter: word;
    nr, h: integer;
    buf: array[1..1024] of byte;
begin
    try //exc
      dig := VirtualAlloc(nil,
                          sizeof(dig^),
                          MEM_COMMIT,
                          PAGE_READWRITE);
      VirtualLock(dig, sizeof(dig^));
      dig_1 := VirtualAlloc(nil,
                            sizeof(dig_1^),
                            MEM_COMMIT,
                            PAGE_READWRITE);
      VirtualLock(dig, sizeof(dig_1^));
      dig_2 := VirtualAlloc(nil,
                            sizeof(dig_2^),
                            MEM_COMMIT,
                            PAGE_READWRITE);
      VirtualLock(dig, sizeof(dig_2^));

      outblocklen := sizeof(dig^);
      pwdlen := Length(pwd^);
      saltsize := sizeof(salt);
      iter := 1000;
      keylen := 128;
      Md5Init(cont1);

      if UsingKeyFile then begin
          h := FileCreate(pwd^, ofOpenRead + ofOpenExisting);
          if h = -1 then begin
             ErrorMsg(SfxStrings.ErrorOpeningKeyfile + U +
                      pwd^);
             Result := -1;
             Exit;
          end;
          try          
            repeat
              nr := Fileread(h, buf, sizeof(buf));
              Md5UpdateBuffer(cont1, Addr(buf), nr);
            until (nr = 0) OR (nr = -1);
         finally
            FileClose(h);
         end;
      end else begin  //hash pwd
        Md5UpdateBuffer(cont1, pwd, pwdlen);
        Md5UpdateBuffer(cont1, Addr(pwdlen), sizeof(pwdlen));
      end;
      //common:
      try //fin

        Move(cont1, cont2, sizeof(cont1));
        Md5UpdateBuffer(cont2, Addr(salt), saltsize);

        block_szam := 1 + (pwdlen - 1) div outblocklen;
        for i := 0 to block_szam do begin
            FillChar(dig_2^, sizeof(dig_1^), #0);
            Move(cont2, cont3, sizeof(cont1));
            dig_1^[0] := char((i + 1) shr 24);
            dig_1^[1] := char((i + 1) shr 16);
            dig_1^[2] := char((i + 1) shr 8);
            dig_1^[3] := char(i + 1);
            for j := 0 to iter-1 do begin
                Md5UpdateBuffer(cont3, Addr(dig_1^), 4);
                Md5Final(dig_1^, cont3);
                for k := 0 to outblocklen-1 do
                    byte(dig_2^[k]) := byte(dig_2^[k]) xor byte(dig_1^[k]);
                Move(cont1, cont3, sizeof(cont1));
            end;
            j := 0;
            k := i * outblocklen;
            while (j < outblocklen) AND (k < keylen) do begin
                  AESkey^[k] := byte(dig_2^[j]);
                  inc(j);
                  inc(k);
            end;
        end;


      finally
        VirtualFree(dig,   0, MEM_RELEASE);
        VirtualFree(dig_1, 0, MEM_RELEASE);
        VirtualFree(dig_2, 0, MEM_RELEASE);
      end;
    except
      On E: Exception do begin
         ErrorMSG('CreateAESKey()' + U +
                  E.message);
         Result := 1;
         Exit;
      end;
    end;
    Result := 0;
end;

{=========================================================================}

Function MakeKeyHash(const salt: arr11; var keyhash: arr4): integer;
var md5cont: TMd5Context;
    md5dig: TMD5Digest;
    dig: array [0..15] of byte;
    i: byte;
    buf: array [1..1024] of byte;
    nr, h: integer;
begin
{$IFDEF DEB} sm('MakeKeyHash()'); {$ENDIF}
    Result := 0;
    //encrypt with keyfile
    if UsingKeyFile then begin
          h := FileCreate(pwd^, ofOpenRead + ofOpenExisting);
          if h = -1 then begin
             ErrorMsg(SfxStrings.ErrorOpeningKeyfile);
             Exit;
          end;
          try
            Md5Init(md5cont);
            repeat
              nr := FileRead(h, buf, sizeof(buf));
              Md5UpdateBuffer(md5cont, Addr(buf), nr);
            until (nr = 0) OR (nr = -1);
            Md5UpdateBuffer(md5cont, Addr(salt), sizeof(salt));
            Md5Final(md5dig, md5cont);
        finally
            FileClose(h);
        end;
    end else begin
    //decrypt with password
        Md5Init(md5cont);
        Md5UpdateBuffer(md5cont, pwd, Length(pwd^));
        Md5UpdateBuffer(md5cont, Addr(salt), sizeof(salt));
        Md5Final(md5dig, md5cont);
    end;
    //common
    for i := 0 to 15 do
       dig[i] := ord(md5dig[i]);
    keyhash[0] := dig[0] xor dig[4] xor dig[8] xor dig[12];
    keyhash[1] := dig[1] xor dig[5] xor dig[9] xor dig[13];
    keyhash[2] := dig[2] xor dig[6] xor dig[10] xor dig[14];
    keyhash[3] := dig[3] xor dig[7] xor dig[11] xor dig[15];

    ZeroMemory(Addr(dig), sizeof(dig));
    ZeroMemory(Addr(md5dig), sizeof(md5dig));
    ZeroMemory(Addr(md5cont), sizeof(md5cont));
end; //MakeKeyHash()

{=========================================================================}

procedure TForm1.DecryptAES128StreamCBCEx(Source: PStream; Count: longword;
           const ExpandedKey: TAESExpandedKey128;
           const InitVector: TAESBuffer;
           Dest: PStream;
           var newcrc: longword);
var TempIn, TempOut, Vector1, Vector2: TAESBuffer;
    Done: longword;
    cikl: longint;
    AESBufSize, TempInSize, TempOutSize: byte;
begin
{$IFDEF DEB} sm('Dec128()'); {$ENDIF}
    try
    cikl := 0;
    if Count=0 then begin
       Source.Position:=0;
       Count:=Source.Size;
    end else
       Count:=Min(Count,Source.Size-Source.Position);
    if Count=0 then Exit;
    AESBufSize  := Sizeof(TAESBuffer);
    TempInSize  := AESBufSize;
    TempOutSize := AESBufSize;
    if (Count mod AESBufSize)>0 then raise Exception.Create(E_Custom,SInvalidInBufSize);
    Vector1:=InitVector;
    while Count>=AESBufSize do begin
        Done:=Source.Read(TempIn, TempInSize);
        CRC32Update(newcrc, @TempIn, TempInSize);
        if Done < TempInSize then raise Exception.Create(E_InOut,SReadError);
        Vector2 := TempIn;
        DecryptAES128(TempIn, ExpandedKey, TempOut);
        PLongword(@TempOut[0])^:=PLongword(@TempOut[0])^ xor PLongword(@Vector1[0])^;
        PLongword(@TempOut[4])^:=PLongword(@TempOut[4])^ xor PLongword(@Vector1[4])^;
        PLongword(@TempOut[8])^:=PLongword(@TempOut[8])^ xor PLongword(@Vector1[8])^;
        PLongword(@TempOut[12])^:=PLongword(@TempOut[12])^ xor PLongword(@Vector1[12])^;
        Done:=Dest.Write(TempOut, TempOutSize);
        if Done < TempOutSize then raise Exception.Create(E_InOut,SWriteError);
        Vector1 := Vector2;
        Dec(Count, AESBufSize);
        if cikl = 100 then begin
          ProgressBar1.Progress := ProgressBar1.Progress + 1600;
          cikl := 0;
          Form.Update;
          Progressbar1.Update;
          If not Working then
            Exit;
          end else
            inc(cikl);
        end;
    except
        On E: exception do
           ErrorMsg(SysErrorMessage(GetLastError) + U +
                  'DecStr()' + U +
                   itos(E.Errorcode) + U +
                   itos(GetLastError));
    end;
end;//DecryptAES128StreamCBCEx()

{=========================================================================}

procedure DecryptAES128StreamCBC(Source: PStream; Count: longword; const Key: TAESKey128; const InitVector: TAESBuffer; Dest: PStream; var newcrc: longword);
var ExpandedKey: TAESExpandedKey128;
begin
    ExpandAES128KeyForDecryptionEx(Key, ExpandedKey);
    Form1.DecryptAES128StreamCBCEx(Source, Count, ExpandedKey, InitVector, Dest, newcrc);
end;

{=========================================================================}

function DecryptFile(pos_from: integer; var pos_to: integer): integer;
var
  pfname: array [0..MAX_PATH] of char;
  Source: PStream;
  zh: smallint;
  h: integer;
  extfnamelen: word;
  nr: integer;
  dest_filename, temps: string;
  nemkell, newcrc: longword;
  header: misc.THeader;
  Spacereq: int64;
  numb: longint;
  sub_dir: string;
label SpaceCheck, ConfirmLabel;
begin                    {$IFDEF DEB} sm('DecryptFile()'); {$ENDIF}
    Applet.ProcessMessages;
    try    //1
      h := CreateFile(ExePath,
                      GENERIC_READ,
                      FILE_SHARE_READ,
                      NIL,
                      OPEN_EXISTING,
                      FILE_ATTRIBUTE_NORMAL,
                      0);
      if h = -1 then begin
         ErrorMsg(SfxStrings.ReadError);
         Exit;
      end;
      CRC32Init(newcrc);
      dest_dir := dest_dir_RO;
      try  //2
         try //3
             SetFilePos(h, pos_from);
             FileRead(h, header, sizeof(header));
             FileRead(h, pfname, header.fnamelen + header.fname_lastblocksize);
             CRC32Update(newcrc,
                         @header.reserved,
                         sizeof(header) - sizeof(header.crc) - sizeof(header.magic));
             CRC32Update(newcrc, @pfname, header.fnamelen + header.fname_lastblocksize);
             if header.complevel <> misc.CLNONE then begin
                FileRead(h, zh, 2);
                CRC32Update(newcrc, @zh, 2);
             end;
         finally
             CloseHandle(h);
         end; //3
      except
          ErrorMsg(SfxStrings.ReadError);
      end; //2

      CreateAESKey(header.salt);
//------decrypt filename------
      Source := NewReadFileStream(ParamStr(0));

      try //4
         extfnamelen := header.fnamelen + header.fname_lastblocksize;
         nr := Source.Read(pfname, extfnamelen);
         if nr <> extfnamelen then Exit;
         Dest := NewMemoryStream;
         try //5
             Source.Position := pos_from + sizeof(header);
             try
                 DecryptAES128StreamCBC(Source, extfnamelen, AESKey^, IV, Dest, nemkell);
             except
                 On E: Exception do begin
                    ErrorMsg(SfxStrings.UnknownError + U +
                             E.message);
                    Exit;
                 end;
             end;
             Dest.Position := 0;
             Dest.Read(pfname, extfnamelen);
             dest_filename := String(pfname);
             SetLength(dest_filename, header.fnamelen);
         finally
             Dest.Free;
         end; //5
         Form1.Form.SimpleStatusText := PChar(dest_filename);
         SpaceCheck:
         TempFileName := CreateTempName(dest_dir + dest_filename, header.packedsize, header.unpackedsize);
         if TempFileName = LOWSPACE then
            Spacereq := Add64(MakeInt64(header.unpackedsize,0), MakeInt64(header.packedsize,0)) //for the temp file too
         else
            SpaceReq := MakeInt64(header.unpackedsize, 0);
         if (Cmp64(SpaceReq, DiskFreeSpace(String(dest_dir[1] + ':\')))= 1) then begin
            if MessageBox(0, PChar(SfxStrings.NotEnoughSpace),
                          PChar(SfxStrings.ConfirmCaption),
                          MB_YESNO) = idNO then begin

               Form1.OpenDirDialog1.Title := SfxStrings.SelectDestPath;
               Form1.OpenDirDialog1.InitialPath := Form1.EditBox2.Text;
               if Form1.OpenDirDialog1.Execute then begin
                  dest_dir := Form1.OpenDirDialog1.Path;
                  goto SpaceCheck;
                  Exit;
               end else
                  Halt;
            end else
              TempfileName := dest_dir + dest_filename + '.tmp';
         end;
         Form1.EditBox2.Text := dest_dir;
//----if destination exists...---

         ConfirmLabel:
         If FileExists(dest_dir + dest_filename) then begin

         if OvAnswer = OV_SKIPALL then begin
            pos_to := pos_from + sizeof(header) + header.fnamelen +
                      header.fname_lastblocksize + header.packedsize + header.lastblocksize;
            if header.complevel <> misc.CLNONE then inc(pos_to, 2);
            Form1.ProgressBar1.Progress := Form1.ProgressBar1.Progress + header.packedsize;
            Form1.Form.Update;
            Exit;
         end;
         if OvAnswer = OV_AUTOREN then begin
            temps := dest_filename;
            sub_dir := ExtractFilePath(dest_filename);
            numb := 0;
            repeat
               inc(numb);
               dest_filename := ExtractFileNameWOExt(temps) + '_' + itos(numb) + ExtractFileExt(temps);
            until not (FileExists(dest_dir + sub_dir + dest_filename));
            dest_filename := sub_dir + dest_filename;
         end;

         if (OvAnswer <> OV_OVALL) AND (OvAnswer <> OV_AUTOREN) then begin
            OvAnswer := OV_NOTDEF;
            Form1.Form.Hide;
            Form2.Label1.Caption := SfxStrings.OverWriteConfirm;
            Form2.EditBox1.Text := dest_filename;
            Form2.Form.Showmodal;
            Form1.Form.Show;
            if OvAnswer in [ OV_SKIP, OV_SKIPALL ] then begin
               pos_to := pos_from + sizeof(header) + header.fnamelen +
                         header.fname_lastblocksize + header.packedsize + header.lastblocksize;
               if header.complevel <> misc.CLNONE then inc(pos_to, 2);
               Form1.ProgressBar1.Progress := Form1.ProgressBar1.Progress + header.packedsize;
               Form1.Form.Update;               
               Exit;
            end;

            if OvAnswer = OV_NO then begin
               Form1.OpenSaveDialog2.Filename := ExtractFileName(dest_filename);
               Form1.OpenSaveDialog2.Filter := SfxStrings.AllFiles + ' (*.*)|*.*';
               Form1.OpenSaveDialog2.InitialDir := dest_dir+ExtractFilePath(dest_filename);
               Form1.OpenSaveDialog2.OpenDialog := FALSE;
               if Form1.OpenSaveDialog2.Execute then begin
                  dest_dir := ExtractFilePath(Form1.OpenSaveDialog2.Filename);
                  Dest_filename := ExtractFileName(Form1.OpenSaveDialog2.Filename);
               end else begin
                  OVAnswer := OV_NOTDEF;
                  goto ConfirmLabel;
                  //show again ov. form
                  Exit;
               end;
            end;
            if OvAnswer in [ OV_CANCEL, OV_NOTDEF ] then begin //=OV_NOTDEF: ALT-F4
               if MessageBox(Form1.Form.Handle,
                             PChar(SfxStrings.AbortConfirmText),
                             PChar(SfxStrings.ConfirmCaption),
                             MB_YESNO + MB_DEFBUTTON2 + MB_APPLMODAL) = idYES then begin
                  Halt;
               end else begin
                  goto ConfirmLabel;
                  Exit;
               end;
            end;
            if OvAnswer = OV_REN then begin
               NewForm3(Form3, Applet);
               Form3.EditBox1.Text := dest_filename;
               Form3.EditBox1.SelectAll;
               Form3.Form.ShowModal;
               Form3.Form.Free;
               if filename <> '' then
                  dest_filename := filename;
                  goto ConfirmLabel;
                  Exit;
               end;
               if OvAnswer = OV_AUTOREN then begin
                  temps := dest_filename;
                  sub_dir := ExtractFilePath(dest_filename);
                  numb := 0;
                  repeat
                     inc(numb);
                     dest_filename := ExtractFileNameWOExt(temps) + '_' + itos(numb) + ExtractFileExt(temps);
                  until not (FileExists(dest_dir + sub_dir + dest_filename));
                  dest_filename := sub_dir + dest_filename;
               end;
         end;
         DeleteFile(PChar(dest_dir + dest_filename));
         end;

    if DirectoryExists(KOL.ExtractFilePath(dest_dir + Dest_filename))=FALSE then begin
       If CreateDir(KOL.ExtractFilePath(dest_dir + Dest_filename)) = FALSE then begin
          ErrorMsg(SfxStrings.FailedToCreateDir + U +
                   KOL.ExtractFilePath(dest_dir + Dest_filename));
          Exit;
       end;
    end;
    if header.complevel <> misc.CLNONE then
       Dest := NewWriteFileStream(TempFileName)
    else
       Dest := NewWriteFileStream(dest_dir + dest_filename);
       
    Source.Position := pos_from + sizeof(header) + header.fnamelen + header.fname_lastblocksize;
    if header.complevel <> misc.CLNONE then begin
       Source.Read(zh, 2);
       Dest.Write(zh, 2);
    end;
    try //6
         DecryptAES128StreamCBC(Source, header.packedsize + header.lastblocksize, AESKey^, IV, Dest, newcrc);
    except
       On E: Exception do begin
          ErrorMSG('Decryptfile() (1)' + U +
                   E.message);
          Exit;
       end;
    end; //6
    if header.complevel <> Misc.CLNONE then
       Dest.Size := header.packedsize
    else
       Dest.Size := header.unpackedsize;

    pos_to := pos_from + sizeof(header) + header.fnamelen +
              header.fname_lastblocksize + header.packedsize + header.lastblocksize;
    if header.complevel <> misc.CLNONE then inc(pos_to, 2);
    finally
       Source.Free;
       if Assigned(Dest) then Dest.Free;
    end; //4
    newcrc := CRC32Final(newcrc);
    if (header.crc <> newcrc) then begin
       ErrorMsg(SfxStrings.CorruptedFile + ' ' + dest_filename);
       Exit;
    end;
    if header.complevel <> misc.CLNONE then
       UnpackFile(TempFileName, dest_dir + dest_filename);
    if FileSize(dest_dir + dest_filename) <> header.unpackedsize then
       ErrorMsg(SfxStrings.IncompletedFile + U +
                Dest_filename);
    SetDateAndAttr(dest_dir + dest_filename, header.filetime, header.fileattr);
  except
   on E: Exception do begin
     ErrorMSG('Decryptfile() (2)' + U +
              E.message);
   end;
 end;

end;//DecryptFile()

{=========================================================================}

function CreateAESKeyAndCheckPwd: boolean;
//Result = FALSE when wrong password
var
   oldkeyhash, newkeyhash: arr4;
   salt: arr11;
   header: Theader;
begin
{$IFDEF DEB} sm('CreateAESKeyAndCheckPwd()'); {$ENDIF}
   UsingKeyFile := Form1.Radiobox2.Checked;
   ReadHeader(AESBegin, header);
   CreateAESKey(header.salt);
   salt := header.salt;
   FillChar(oldkeyhash, sizeof(oldkeyhash), #0);
   FillChar(newkeyhash, sizeof(oldkeyhash), #0);
   oldkeyhash := Header.keyhash;
   MakeKeyHash(Header.salt, newkeyhash);
   if not CompareMem(Addr(newkeyhash[0]), Addr(oldkeyhash[0]), 4) then begin
      MessageBox(Form1.Form.Handle,
                 PChar(SfxStrings.WrongPassword),
                 PChar(SfxStrings.Error),
                 MB_OK + MB_APPLMODAL + MB_ICONWARNING);
      Result := FALSE;
      if Form1.RadioBox1.Checked then
         Form1.EditBox1.DoSetFocus
      else
         Form1.EditBoxSima.DoSetFocus;
   end else
      Result := TRUE;
end;

{=========================================================================}

function ProperPath(dir: string): boolean; forward;
procedure TForm1.Browse2ButtonClick(Sender: PObj);
begin
   OpenDirDialog1.InitialPath := ExtractFilePath(ParamStr(0));
   OpenDirDialog1.Title := SfxStrings.SelectDestPath;
   if OpenDirDialog1.Execute then begin
      a := TRUE;
      EditBox2.Text := OpenDirDialog1.Path;
   end else begin
      a := FALSE;
      Exit;
   end;
   if not ProperPath(OpenDirDialog1.Path) then begin
      //not exists or write-protected
      Editbox2.Selectall;
      Browse2ButtonClick(Sender);
      Exit;
   end;
end;//Button3Click()  //OpenDir

{=========================================================================}

//IN: a directory path
//OUT: TRUE if the directory exists and not write-protected
//     FALSE otherwise
function ProperPath(dir: string): boolean;
var f: file;
begin
{$IFDEF DEB} sm('ProperPath()'); {$ENDIF}
   Result := TRUE;
   if dir[Length(dir)] <> '\' then
      dir := dir + '\';
   if DirectoryExists(dir) then begin
      {$I-}
      AssignFile(f, dir + 'aestest0.$$$'); Rewrite(f,1); CloseFile(f); Erase(f);
      {$I+}
      if ioresult <> 0 then begin
         ErrorMsg(SfxStrings.DestPathIsWriteProtected);
         Result := FALSE;
         Exit;
      end;
   end else begin
      if CreateDir(dir) = FALSE then begin
         MessageBox(Form1.Form.Handle,
                    PChar(SfxStrings.EnterValidPath),
                    PChar(SfxStrings.Warning),
                    MB_OK + MB_APPLMODAL + MB_ICONWARNING);
         Result := FALSE;
         Exit;
      end;
   end;
   dest_dir_RO := dir;
end;

{=========================================================================}

procedure TForm1.ExitButtonClick(Sender: PObj);
var res: integer;
begin
   if Working then begin
      szal.suspend;
      res := MessageBox(Form.Handle,
                        PChar(SfxStrings.AbortConfirmText),
                        PChar(SfxStrings.ConfirmCaption),
                        MB_YESNO + MB_APPLMODAL + MB_DEFBUTTON2);
      case res of
          idYES:  begin
                    szal.Terminate;
                    szal.Free;
                    Working := FALSE;
                    Dest.Free;
                    DeleteFile(PChar(tempfilename));
                    Halt;
                  end;
          idNO:   begin
                    szal.Resume;
                    Exit;
                  end;
     end;
   end;
   Form1.Form.Close;
end;

{=========================================================================}

procedure TForm1.OKButtonClick(Sender: PObj);
label again;
begin
  if Radiobox2.Checked then begin //decrypt with keyfile
     if not FileExists(EditBoxSima.Text) then begin
        ErrorMsg(SfxStrings.KeyFileNotFound);
        EditBoxSima.DoSetFocus;
        EditBoxSima.SelectAll;
        Exit;
     end;
     if not ProperPath(EditBox2.Text) then begin
        Browse2ButtonClick(Sender);
        if a = FALSE then Exit; //A=FALSE when user presses CANCEL on OpenDirDialog
        goto again;
        Exit;
     end;
     OKButton.Enabled := FALSE;
     Browse1Button.Enabled := FALSE;
     Browse2Button.Enabled := FALSE;
     FillChar(pwd^, sizeof(pwd^), #0);
     StrPcopy(Misc.pwd^, EditBoxSima.Text);
     szal.execute;
     szal.Terminate;
     OKButton.Enabled := TRUE;
     Browse1Button.Enabled := TRUE;
     Browse2Button.Enabled := TRUE;
     Exit;
  end;
  again:
    if (trim(EditBox1.Text) <> '') then begin
       if not ProperPath(EditBox2.Text) then begin
          Browse2ButtonClick(Sender);
          if a = FALSE then Exit;
          goto again;
          Exit;
       end;
       OKButton.Enabled := FALSE;
       Browse1Button.Enabled := FALSE;
       Browse2Button.Enabled := FALSE;
       FillChar(pwd^, sizeof(pwd^), #0);
       StrPcopy(Misc.pwd^, EditBox1.Text);
       szal.execute;
       szal.Terminate;
       OKButton.Enabled := TRUE;
       Browse2Button.Enabled := TRUE;
       EditBox1.DoSetFocus;
    end else
       EditBox1.DoSetFocus;
end;

{=========================================================================}

procedure TForm1.EditBox2KeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  if ord(key) = 13 then
     OKButtonClick(Form1.Form);
end;

{=========================================================================}

procedure TForm1.KOLForm1Destroy(Sender: PObj);
begin
   if Assigned(szal.Data) then
      szal.Free;
end;

{=========================================================================}

function TForm1.szalExecute(Sender: PThread): integer;
var pos_from, pos_to: integer;
    header: THeader;
begin
  try
    try
      SfxSize := GetSfxSize;
      if IsExeCorrupted(SfxSize) then begin
         MessageBox(0, 'Corrupted exe file.', 'Error', MB_ICONERROR);
         Halt;
      end;
      if SfxSize = 0 then Halt;
      GetModuleFileName(0, ExePath, sizeof(ExePath));
      if not CreateAESKeyAndCheckPwd then begin
         EditBox1.Clear;
         Sleep(1000);
         Exit;
      end;
      pos_from := AESBegin;
      OvAnswer := OV_NOTDEF;
      Working := TRUE;
      ContinueAnyway := FALSE;

      while ReadHeader(pos_from, header) = 0 do begin
        Form1.ProgressBar1.MaxProgress := Form1.ProgressBar1.MaxProgress + header.packedsize;
        pos_to := pos_from + sizeof(header) +
                  header.fnamelen +
                  header.fname_lastblocksize +
                  header.lastblocksize+  header.packedsize;
        if header.complevel <> misc.CLNONE then inc(pos_to, 2);          
        pos_from := pos_to;
      end;
      pos_from := AESBegin;

      while ReadHeader(pos_from, header) = 0 do begin
         CreateAESKey(header.salt);
         DecryptFile(pos_from, pos_to);
         pos_from := pos_to;
      end;
    except
      on E: Exception do begin
         ErrorMsg(SfxStrings.UnknownError + U +
                  E.message);
         Halt;
      end;
    end;
  finally
    Working := FALSE;
    DeleteFile(PChar(TempFileName));
  end;
  Form1.ProgressBar1.Progress := 0;
  Halt;
end;

{=========================================================================}

procedure TForm1.RadioBox1Click(Sender: PObj);
begin
    RadioBox1.Checked := TRUE;
    RadioBox2.Checked := FALSE;
    Browse1Button.Enabled := FALSE;
    EditBox1.Visible := TRUE;
    EditBoxSima.Visible := FALSE;
    EditBox1.Clear;
    EditBox1.DoSetFocus;
end;

{=========================================================================}

procedure TForm1.RadioBox2Click(Sender: PObj);
begin
    RadioBox1.Checked := FALSE;
    RadioBox2.Checked := TRUE;
    Browse1Button.Enabled := TRUE;
    EditBox1.Visible := FALSE;
    EditBoxSima.Top := EditBox1.Top;
    EditBoxSima.Height := EditBox1.Height;
    EditBoxSima.Left := EditBox1.Left;
    EditBoxSima.Width := EditBox1.Width;
    EditBoxSima.Visible := TRUE;
    EditBoxSima.DoSetFocus;    
end;

{=========================================================================}

procedure TForm1.Browse1ButtonClick(Sender: PObj);
begin
   OpenSaveDialog1.InitialDir := ExtractFilePath(ParamStr(0));
   OpenSaveDialog1.Filter := SfxStrings.AllFiles + ' (*.*)|*.*';
   if OpenSaveDialog1.Execute then
      EditBoxSima.Text := OpenSaveDialog1.Filename;
end;

{=========================================================================}

procedure TForm1.KOLForm1FormCreate(Sender: PObj);
begin
  SfxSize := GetSfxSize;
  LoadLanguage;
  Form.Caption := 'AES self-decryptor - v' + VERSIONTEXT;
  if IsExeCorrupted(SfxSize) then begin
      MessageBox(0, 'Corrupted exe file.', 'Error', MB_ICONERROR);
      Halt;
  end;
  NewForm2(Form2, Applet);
  Form1.RadioBox1.Caption := SfxStrings.Password;
  Form1.RadioBox2.Caption := SfxStrings.Keyfile;
  Form1.LabDecryptTo.Caption := SfxStrings.DecryptTo;
  Form1.Browse1Button.Caption := SfxStrings.Browse;
  Form1.Browse2Button.Caption := SfxStrings.Browse;
  Form1.ExitButton.Caption := SfxStrings.Exit;
  Form1.EditBox2.Text := ExtractFilePath(ParamStr(0));
  Form1.EditBox1.Clear;
  Form1.EditBox1.DoSetFocus;
end;

{=========================================================================}

procedure TForm1.EditBox1KeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
    VK_F2: begin
             if RadioBox1.Checked then begin
                RadioBox2Click(Sender);
                EditBoxSima.DoSetFocus;
             end else begin
                RadioBox1Click(Sender);
                EditBox1.DoSetFocus;
             end;
           end;
    VK_F3: begin
             if RadioBox2.Checked then
                Browse1ButtonClick(Sender)
             else
                Browse2ButtonClick(Sender);
           end;
  end;
end;

{=========================================================================}

procedure TForm1.EditBoxSimaKeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
    VK_F2: begin
             if RadioBox1.Checked then begin
                RadioBox2Click(Sender);
                EditBoxSima.DoSetFocus;
             end else begin
                RadioBox1Click(Sender);
                EditBox1.DoSetFocus;
             end;   
           end;
    VK_F3: begin
             if RadioBox2.Checked then
                Browse1ButtonClick(Sender)
             else
                Browse2ButtonClick(Sender);
           end;
  end;
end;

{=========================================================================}

procedure TForm1.KOLForm1Close(Sender: PObj; var Accept: Boolean);
begin
   Form2.Form.Free;
end;


procedure TForm1.KOLForm1Show(Sender: PObj);
begin
   EditBox1.DoSetFocus;
end;

procedure TForm1.EditBox2Enter(Sender: PObj);
begin
   EditBox2.SelStart := Length(EditBox2.Text);
end;

initialization
  AESKey := VirtualAlloc(nil,
                         sizeof(AESKey^),
                         MEM_COMMIT,
                         PAGE_READWRITE);
  VirtualLock(AESkey, sizeof(AESKey^) );
  pwd := VirtualAlloc(nil,
                      sizeof(pwd^),
                      MEM_COMMIT,
                      PAGE_READWRITE);
  VirtualLock(pwd, sizeof(pwd^) );
finalization
  VirtualFree(AESKey, 0, MEM_RELEASE);
  VirtualFree(pwd, 0, MEM_RELEASE);
end.
