{ KOL MCK } // Do not remove this line!
{$DEFINE KOL_MCK}
unit cof;

interface

{$IFDEF KOL_MCK}
uses Windows, Messages, ShellAPI, KOL {$IFNDEF KOL_MCK}, mirror, Classes,
  mckCtrls, Controls {$ENDIF};
{$ELSE}
{$I uses.inc}
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;
{$ENDIF}

type
  {$IFDEF KOL_MCK}
  {$I MCKfakeClasses.inc}
  PForm2 = ^TForm2;
  TForm2 = object(TObj)
    Form: PControl;
  {$ELSE not_KOL_MCK}
  TForm2 = class(TForm)
  {$ENDIF KOL_MCK}
    KOLForm1: TKOLForm;
    Label1: TKOLLabel;
    YesButton: TKOLButton;
    OvAllButton: TKOLButton;
    SkipButton: TKOLButton;
    CancelButton: TKOLButton;
    SkipAllButton: TKOLButton;
    RenButton: TKOLButton;
    AutoRenButton: TKOLButton;
    NoButton: TKOLButton;
    EditBox1: TKOLEditBox;
    procedure YesButtonClick(Sender: PObj);
    procedure NoButtonClick(Sender: PObj);
    procedure OvAllButtonClick(Sender: PObj);
    procedure SkipAllButtonClick(Sender: PObj);
    procedure YesButtonKeyDown(Sender: PControl; var Key: Integer;
      Shift: Cardinal);
    procedure NoButtonKeyDown(Sender: PControl; var Key: Integer;
      Shift: Cardinal);
    procedure OvAllButtonKeyDown(Sender: PControl; var Key: Integer;
      Shift: Cardinal);
    function OvAllButtonWWMessage(var Msg: tagMSG;
      var res: integer): boolean;

    procedure SkipAllButtonKeyDown(Sender: PControl; var Key: Integer;
      Shift: Cardinal);
    function SkipAllButtonWWMessage(var Msg: tagMSG;
      var res: integer): boolean;

    procedure SkipButtonClick(Sender: PObj);
    procedure CancelButtonClick(Sender: PObj);
    procedure RenButtonClick(Sender: PObj);
    procedure AutoRenButtonClick(Sender: PObj);
    function  AutoRenButtonWWMessage(var Msg: tagMSG; var res: integer): boolean;
    procedure SkipButtonKeyDown(Sender: PControl; var Key: Integer;
      Shift: Cardinal);
    procedure CancelButtonKeyDown(Sender: PControl; var Key: Integer;
      Shift: Cardinal);
    procedure RenButtonKeyDown(Sender: PControl; var Key: Integer;
      Shift: Cardinal);
    procedure AutoRenButtonKeyDown(Sender: PControl; var Key: Integer;
      Shift: Cardinal);
    procedure KOLForm1FormCreate(Sender: PObj);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2 {$IFDEF KOL_MCK} : PForm2 {$ELSE} : TForm2 {$ENDIF} ;

{$IFDEF KOL_MCK}
procedure NewForm2( var Result: PForm2; AParent: PControl );
{$ENDIF}

implementation

{$IFNDEF KOL_MCK} {$R *.DFM} {$ENDIF}
uses misc, Unit1, language;
{$IFDEF KOL_MCK}
{$I cof_1.inc}
{$ENDIF}

{=============================================================================}

procedure TForm2.YesButtonClick(Sender: PObj);
begin
  OvAnswer := OV_YES;
  Form2.Form.Close;
end;

{=========================================================================}

procedure TForm2.NoButtonClick(Sender: PObj);
begin
  OvAnswer := OV_NO;
  Form2.Form.Close;
end;

{=========================================================================}

procedure TForm2.OvAllButtonClick(Sender: PObj);
begin
  OvAnswer := OV_OVALL;
  Form2.Form.Close;
end;

{=========================================================================}

procedure TForm2.SkipAllButtonClick(Sender: PObj);
begin
  OvAnswer := OV_SKIPALL;
  Form2.Form.Close;
end;

{=========================================================================}

procedure TForm2.YesButtonKeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
      13: YesButtonClick(Sender);
      40: CancelButton.DoSetFocus;
      39: OvAllButton.DoSetFocus;
  end;
end;

{=========================================================================}

procedure TForm2.NoButtonKeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
      13: NoButtonClick(Sender);
      37: CancelButton.DoSetFocus;
      38: OvAllButton.DoSetFocus;
      39: SkipAllButton.DoSetFocus;
      40: AutoRenButton.DoSetFocus;
  end;
end;

{=========================================================================}

procedure TForm2.OvAllButtonKeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
      13: OvAllButtonClick(Sender);
      37: YesButton.DoSetFocus;
      39: SkipButton.DoSetFocus;
      40: NoButton.DoSetFocus;
  end;
end;

{=========================================================================}

function TForm2.OvAllButtonWWMessage(var Msg: tagMSG;
  var res: integer): boolean;
begin
  if (Msg.message >= WM_MOUSEFIRST) And (Msg.message <= WM_MOUSELAST) then begin
    res := OvAllButton.Perform(Msg.message, Msg.wParam, Msg.lParam );
    Result := TRUE;
  end else
    Result := FALSE;
end;

{=========================================================================}

procedure TForm2.SkipAllButtonKeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
      13: SkipAllButtonClick(Sender);
      37: NoButton.DoSetFocus;
      38: SkipButton.DoSetFocus;
  end;
end;

{=========================================================================}

function TForm2.SkipAllButtonWWMessage(var Msg: tagMSG;
  var res: integer): boolean;
begin

  if (Msg.message >= WM_MOUSEFIRST) and (Msg.message <= WM_MOUSELAST) then begin
    res := SkipAllButton.Perform(Msg.message, Msg.wParam, Msg.lParam);
    Result := TRUE;
  end else
    Result := FALSE;
end;

{=========================================================================}

procedure TForm2.SkipButtonKeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
      13: SkipButtonClick(Sender);
      37: OvAllButton.DoSetFocus;
      40: SkipAllButton.DoSetFocus;
  end;
end;

{=========================================================================}

procedure TForm2.SkipButtonClick(Sender: PObj);
begin
  OvAnswer := OV_SKIP;
  Form2.Form.Close;
end;

{=========================================================================}

procedure TForm2.CancelButtonClick(Sender: PObj);
begin
  OvAnswer := OV_CANCEl;
  Form2.Form.Close;
end;

{=========================================================================}

procedure TForm2.RenButtonClick(Sender: PObj);
begin
  OvAnswer := OV_REN;
  Form2.Form.Close;
end;

{=========================================================================}

procedure TForm2.AutoRenButtonClick(Sender: PObj);
begin
  OvAnswer := OV_AUTOREN;
  Form2.Form.Close;
end;

{=========================================================================}

procedure TForm2.CancelButtonKeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
      13: CancelButtonClick(Sender);
      38: YesButton.DoSetFocus;
      40: RenButton.DoSetFocus;
      39: NoButton.DoSetFocus;
  end;
end;

{=========================================================================}

procedure TForm2.RenButtonKeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
      13: RenButtonClick(Sender);
      38: CancelButton.DoSetFocus;
      39: AutoRenButton.DoSetFocus;
  end;
end;

{=========================================================================}

procedure TForm2.AutoRenButtonKeyDown(Sender: PControl; var Key: Integer;
  Shift: Cardinal);
begin
  case Key of
      13: AutoRenButtonClick(Sender);
      37: RenButton.DoSetFocus;
      38: NoButton.DoSetFocus;
  end;
end;

{=========================================================================}

function TForm2.AutoRenButtonWWMessage(var Msg: tagMSG;
  var res: integer): boolean;
begin
  if (Msg.message >= WM_MOUSEFIRST) and (Msg.message <= WM_MOUSELAST) then begin
    res := AutoRenButton.Perform(Msg.message, Msg.wParam, Msg.lParam);
    Result := TRUE;
  end else
    Result := FALSE;
end;

{=========================================================================}

procedure TForm2.KOLForm1FormCreate(Sender: PObj);
var L: PControl;
  procedure SetValues;
  begin
     if not (cofs.ButtonHeight in [1..40]) then
          cofs.ButtonHeight := 22; //default
     if not (cofs.ButtonWidth in [10..120]) then
        cofs.ButtonWidth := 80;
     if not (cofs.OvAllWW in [0..1]) then
        cofs.OvAllWW := 0;
     if not (cofs.SkipAllWW in [0..1]) then
        cofs.SkipAllWW := 0;
     if not (cofs.AutoRenWW in [0..1]) then
        cofs.AutoRenWW := 0;
     YesButton.Width := cofs.ButtonWidth;
     OvAllButton.Width := cofs.ButtonWidth;
     SkipButton.Width := cofs.ButtonWidth;
     CancelButton.Width := cofs.ButtonWidth;
     NoButton.Width := cofs.ButtonWidth;
     SkipAllButton.Width := cofs.ButtonWidth;
     RenButton.Width := cofs.ButtonWidth;
     AutoRenButton.Width := cofs.ButtonWidth;
     YesButton.Height := cofs.ButtonHeight;
     OvAllButton.Height := cofs.ButtonHeight;
     SkipButton.Height := cofs.ButtonHeight;
     CancelButton.Height := cofs.ButtonHeight;
     NoButton.Height := cofs.ButtonHeight;
     SkipAllButton.Height := cofs.ButtonHeight;
     RenButton.Height := cofs.ButtonHeight;
     AutoRenButton.Height := cofs.ButtonHeight;
  end;
begin
   SetValues;
//Autoren button
   if cofs.AutoRenWW = 1 then begin
     AutoRenButton.Border := 4;

     L := NewWordWrapLabel( AutoRenButton, SfxStrings.AutoRename ).SetAlign( caClient );
     L.SetSize(L.Width, L.Height - 17);
     L.Left := cofs.AutoRenLabelAlign;
     L.OnMessage := AutoRenButtonWWMessage;
   end else
     AutoRenButton.Caption := SfxStrings.AutoRename;
//SkipAll button
   if cofs.SkipAllWW = 1 then begin
     SkipAllButton.Border := 4;
     L := NewWordWrapLabel( SkipAllButton, SfxStrings.SkipAll ).SetAlign( caClient );
     L.SetSize(L.Width, L.Height - 17);
     L.Left := cofs.SkipAllLabelAlign;
     L.OnMessage := SkipAllButtonWWMessage;
   end else
     SkipAllButton.Caption := SfxStrings.SkipAll;

//OverwriteAll button
   if cofs.OvAllWW = 1 then begin
     OvAllButton.Border := 4;
     L := NewWordWrapLabel( OvAllButton, SfxStrings.OverwriteAll ).SetAlign( caClient );
     L.SetSize(L.Width, L.Height - 17);
     L.Left := cofs.OvAllLabelAlign;
     L.OnMessage := OvAllButtonWWMessage;
   end else
     OvAllButton.Caption := SfxStrings.OverwriteAll;


   YesButton.Caption := SfxStrings.Yes;
   SkipButton.Caption := SfxStrings.Skip;
   CancelButton.Caption := SfxStrings.Cancel;
   NoButton.Caption := SfxStrings.No;
   RenButton.Caption := SfxStrings.Rename;
   Form2.Form.Caption := SfxStrings.ConfirmCaption;

   Label1.Left := 20;
   EditBox1.Left := 20;
   YesButton.Top := EditBox1.BoundsRect.Bottom + 10;

   OvAllButton.Top := YesButton.Top;
   SkipButton.Top := YesButton.Top;
   CancelButton.Top := YesButton.Top + YesButton.Height + 10;
   NoButton.Top := YesButton.Top + YesButton.Height + 10;
   SkipAllButton.Top := YesButton.Top + YesButton.Height + 10;
   RenButton.Top := CancelButton.Top + CancelButton.Height + 10;
   AutoRenButton.Top := CancelButton.Top + CancelButton.Height + 10;


   YesButton.Left := EditBox1.Left;
   OvAllButton.Left := YesButton.Left + YesButton.Width + 10;
   SkipButton.Left := OvAllButton.Left + OvAllButton.Width + 10;
   CancelButton.Left := YesButton.Left;
   NoButton.Left := OvAllButton.Left;
   SkipAllButton.Left := SkipButton.Left;
   RenButton.Left := CancelButton.Left;
   AutoRenButton.Left := NoButton.Left;
   Form2.Form.Width := YesButton.Width + NoButton.Width + OvAllButton.Width +
        SkipAllButton.Width + 70;

   YesButton.Height := OvAllButton.Height;
   NoButton.Height := OvAllButton.Height;

   Form2.Form.CanResize := TRUE;
   Form2.Form.Width := SkipAllButton.Left + SkipAllButton.Width + 20;

   Form2.Form.Height := RenButton.Top + RenButton.Height + 40;

   if Form2.Form.Width > Form1.Form.Width then
      Form2.Form.Left := Form1.Form.Left - ((Form2.Form.Width div 2)-(Form1.Form.Width div 2))
   else
      if Form2.Form.Width < Form1.Form.Width then
      Form2.Form.Left := Form1.Form.Left + ((Form1.Form.Width div 2)-(Form2.Form.Width div 2))
   else //=
      Form2.Form.Left := Form2.Form.Left;
   Form2.Form.CanResize := FALSE;
   Form2.Form.Top := Form1.Form.Top + (Form1.Form.Height div 2) - (Form2.Form.Height div 2);

   OVAnswer := OV_NOTDEF;

end;


end.


