// wctitle.cpp : Defines the entry point for the console application.
//


#include "wctitle.h"
#include "WcTitleApp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object


const CString IniSettings::m_inifilePath=".\\wctitle.ini";

CWcTitleApp theApp;

using namespace std;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		printf ("Fatal Error: MFC initialization failed\n");
		nRetCode = 1;
	}
	else
	{
		nRetCode=theApp.Main(argc, argv, envp);
	}
	return nRetCode;
}

/*Function: DWORD GetParentProcessID(DWORD dwPID)
 *Description:
 *Returns the parent process ID of the process specified in the
 *'dwPID' parameter.
 *Parameters:
 *dwPID       -   process ID to find parent for
 *Return value:
 *parent process ID on success, -1 otherwise
 */
DWORD ProcessInfo::GetParentProcessID  (DWORD dwPID)
{
    NTSTATUS                        ntStatus;
    DWORD                           dwParentPID =   0xffffffff;

    HANDLE                          hProcess;
    PROCESS_BASIC_INFORMATION       pbi;
    ULONG                           ulRetLen;

    //  create entry point for 'NtQueryInformationProcess()'
    CREATE_DYNFUNC_5    (   NtQueryInformationProcess,
                            NtQueryInformationProcess,
                            ntdll,
                            NTSTATUS,
                            __stdcall,
                            HANDLE,
                            PROCESSINFOCLASS,
                            PVOID,
                            ULONG,
                            PULONG
                        );

    //  get process handle
    hProcess    =   OpenProcess (   PROCESS_QUERY_INFORMATION,
                                    FALSE,
                                    dwPID
                                );

    //  could fail due to invalid PID or insufficiant privileges
    if  (   !hProcess)
            return  (   0xffffffff);

    //  gather information
    ntStatus    =   NtQueryInformationProcess   (   hProcess,
                                                    ProcessBasicInformation,
                                                    ( void*) &pbi,
                                                    sizeof  (   PROCESS_BASIC_INFORMATION),
                                                    &ulRetLen
                                                );

    //  copy PID on success
    if  (   !ntStatus)
            dwParentPID =   pbi.InheritedFromUniqueProcessId;

    CloseHandle (   hProcess);

    return  (   dwParentPID);
}


bool ProcessInfo::Init() {
	
	m_bInitialized=true;
	m_ID=GetParentProcessID(GetCurrentProcessId());
	if(m_ID!=0) {
		m_Handle=OpenProcess(PROCESS_ALL_ACCESS,TRUE, m_ID);
		if(m_Handle==NULL) {
			printf("I cannot find any parent's handle. I'll not work!!\n");
			return(false);
		}
	}

	return true;
}

ProcessInfo::~ProcessInfo() {
	if (m_bInitialized && m_Handle!=NULL) {
		CloseHandle(m_Handle);
	}
}

bool IniSettings::Init(char v[]) {

	m_Version=v; //default value, if present oterwise "" and read from ini file.

	m_inifile.SetPath(m_inifilePath);
	if (m_inifile.ReadFile()) {
		m_WCPath = m_inifile.GetValue("wctitle","WCPath");
		m_WCPath += "\\Wincmd32.exe";
		m_TitleTemplate=m_inifile.GetValue("wctitle","Title_Template");
		m_Activeistances=atoi(m_inifile.GetValue("wctitle","WCLast_istance"));
		m_Version=m_inifile.GetValue("wctitle","WCVersion");
		m_RegName=m_inifile.GetValue("wctitle","WCRegName");
	}
	else {
		printf("Error wctitle: cannot find wctitle.ini\n");
		printf("I'm creating it for you with default vales, change them\n");
		m_inifile.SetValue("wctitle","Title_Template", m_TitleTemplate, 1);
		if (m_Version!="")
			m_inifile.SetValue("wctitle", "WCVersion", m_Version, 1);
		else
			m_inifile.SetValue("wctitle", "WCVersion", "5.11", 1);
		if (m_RegName!="")
			m_inifile.SetValue("wctitle", "CRegName", m_RegName, 1);
		else
			m_inifile.SetValue("wctitle", "CRegName", "Default Name", 1);
		m_inifile.SetValueI("wctitle","WCLast_istance", 1, 1);
		m_inifile.WriteFile();
		return (false);
	}
	return (true);
}

bool IniSettings::WriteIniFile()
{
	if (m_Version!="")
		m_inifile.SetValue("wctitle", "WCVersion", m_Version, 1);
	if (m_RegName!="")
		m_inifile.SetValue("wctitle", "CRegName", m_RegName, 1);
	m_inifile.SetValueI("wctitle","WCLast_istance", m_Activeistances, 1);
	m_inifile.WriteFile();

	return (false);
	
}




