// WcTitleApp.cpp : implementation file
//

#include "stdafx.h"
#include "WcTitleApp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWcTitleApp

ProcessInfo CWcTitleApp::m_Process;

CWcTitleApp::CWcTitleApp()
{
}

CWcTitleApp::~CWcTitleApp()
{
}


// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CWcTitleApp, CWinApp)
	//{{AFX_MSG_MAP(CWcTitleApp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CWcTitleApp member functions


int CWcTitleApp::Main(int argc, TCHAR* argv[], TCHAR* envp[]) {
	

	//Reads the ini file and fill some variables.
	m_Settings.Init(argv[1]);
	
	if(!InitialChecks(&m_Settings, argc, argv))
		exit(1);

	//Gets the calling process ID, that should be the Windows Commander' ID.
	m_Parent.Init();

	#ifdef _DEBUG
	CString tmpstr;
	tmpstr.Format("Process %d", m_Parent.m_ID);
	AfxMessageBox(tmpstr);
	#endif //_DEBUG

	//Now I have to find the handle the main window of the Parent.m_ID process!!
	EnumDesktopWindows(NULL, EnumWindowsProc, (LPARAM)m_Parent.m_ID);

	//WOW we found it!
	if(m_Parent.m_ID==m_Process.m_ID && m_Process.m_hWnd!=NULL) {
		LRESULT Res=0;
		char buff1[256]; //max title lenght 256 chars!!
		Res = ::SendMessage(m_Process.m_hWnd, WM_GETTEXT, 256, (LPARAM)buff1); 
		CString WCTitle;
		
		#ifdef _DEBUG
		CString tmpstr;
		tmpstr.Format("Process: %d, Handle: %X", m_Parent.m_ID, m_Process.m_hWnd);
		AfxMessageBox(tmpstr);
		#endif //_DEBUG
		
		WCTitle.Format("%s", buff1);
		WCTitle.TrimRight(" "); //leave spaces after title
		
		//	AfxMessageBox("WCTitle " + WCTitle);
				
		CString tStr=WCTitle;
		int squarepos=-1;
		squarepos=WCTitle.Find("[");
		if(squarepos!=-1) {
			CString str;
			str.Format("Posit. %d",squarepos);
			//	AfxMessageBox(str);
			//	AfxMessageBox("Prima: "+tStr);
			WCTitle=tStr.Left(squarepos-1);
			//	AfxMessageBox("Dopo: "+WCTitle);
		}
		
		tStr.Format("%s [%d]", WCTitle, m_Settings.m_Activeistances);
		
		#ifdef _DEBUG
		AfxMessageBox("tStr " + tStr);
		#endif //_DEBUG
		
		m_Settings.m_Activeistances++;
		m_Settings.WriteIniFile();
		LPTSTR buff2=tStr.GetBuffer(tStr.GetLength());
		Res = ::SendMessage(m_Process.m_hWnd, WM_SETTEXT,0,(LPARAM)buff2); 
		tStr.ReleaseBuffer();
		buff2=NULL;
		}

	return 0;
}

bool CWcTitleApp::InitialChecks(IniSettings *psets, int argc, TCHAR* argv[]) 
{

	if(!IsNT())
	{
		printf("This program can only be used on Windows NT/2000/XP!\n");
		return (false);
	}


	if(argc==2 && strcmp(argv[1],"/reset")==0) {
		m_Settings.m_Activeistances=1;
		m_Settings.WriteIniFile();
		return (true);
	}

	if (argc!=1 && argc<3) {
			printf("Error, syntax is: wctitle {/reset} version Registration name\n");
			printf("Ex. wctitle 5.11 John Smith Jr\n");
			printf("Ex. wctitle /reset, resets the counter for new istances!\n");
			exit(0);
	}

	if(argc!=1) {
		int i=2;
		psets->m_RegName="";
		while (i!=argc)
			psets->m_RegName = psets->m_RegName + argv[i++] + " ";
			(psets->m_RegName).TrimRight(" ");
	}


	return (true);
}

/*Function: BOOL IsNT()
 *Description:
 *Checks if the caller is running on WinNT
 *Parameters:
 *Return value:
 *TRUE if NT, false otherwise
 */
bool CWcTitleApp::IsNT ()
{
    OSVERSIONINFO       osviVerInfo;

    osviVerInfo.dwOSVersionInfoSize =   sizeof  (   OSVERSIONINFO);
    
    GetVersionEx    (   &osviVerInfo);

    return  (   VER_PLATFORM_WIN32_NT   ==  osviVerInfo.dwPlatformId);
}


BOOL CALLBACK CWcTitleApp::EnumWindowsProc(
	HWND hwnd,      // handle to parent window
	LPARAM lParam   // application-defined value 
) 
{
	DWORD ParentID=(DWORD)lParam;
	
	GetWindowThreadProcessId(hwnd, &(m_Process.m_ID));

	#ifdef _DEBUG
	CString tmpstr;
	tmpstr.Format("Process %d", m_Process.m_ID);
	AfxMessageBox(tmpstr);
	#endif //_DEBUG

	if(m_Process.m_ID==ParentID) {
		#ifdef _DEBUG
		AfxMessageBox("FOUND!");
		#endif //_DEBUG
		m_Process.m_hWnd=hwnd;
		return FALSE;
	}

	return TRUE;
}

