#include "wio.h"
#include "wmix.h"

size_t IOBufferSize = 0;
char *IOBuffer = NULL;

char *allocateIOBuffer()
{
  IOBufferSize = MAX_IOBUFFERSIZE;
  while ( ( IOBuffer = new char[IOBufferSize] ) == NULL )
    IOBufferSize /= 2;
  return IOBuffer;
}

void destroyIOBuffer()
{
  if ( IOBuffer )
    delete [] IOBuffer;
}

char *commas(long n)
{
  static char s[32], buf2[40];
  ltoa(n, s, 10);
  char *cp;
  strcpy(buf2, s)[32] = 0;
  if ( ( cp = strchr(buf2, '.') ) != NULL )
    strcpy(buf2+32, cp);
  else
    cp = strchr(buf2, 0);
  char *p = buf2+31;
  int i = -1;
  cp--;
  while ( cp >= buf2 )
  {
    if ( ++i == 3 )
    {
      i = 0;
      *p-- = ',';
    }
    *p-- = *cp--;
  }
  if ( !isdigit(p[1]) )
    *p-- = 0;
  return p+1;
}

int matched(const char *mask, const char *value, int extMask)
{
  char *cpp = (char*)mask;
  char *cpn = (char*)value;
  int match = 1;
  int ndone = 1;
  while ( ndone )
  {
    switch ( *cpp )
    {
      case '*':
        cpp++;
        while ( *cpn )
          if ( matched(cpp, cpn++, extMask) )
            return 1;
        break;
      case '?':
        cpp++;
        cpn++;
        break;
      case 0:
        if ( *cpn != 0 )
          match = 0;
        ndone = 0;
        break;
      default:
        if ( ( toupper(*cpp) == toupper(*cpn) ) || ( extMask && ( *cpp == '+' ) && ( isdigit(*cpn) ) ) )
        {
          cpp++;
          cpn++;
        }
        else
        {
          match = 0;
          ndone = 0;
        }
        break;
    }
  }
  return match;
}
