#ifndef __WIO_H
#define __WIO_H

#ifdef __WIN32__
  #include "coniow.h"
  #define TARGET_OS "W32"
#else
  #include <conio.h>
  #define TARGET_OS "DOS"
#endif

#ifdef __WIN32__
//  #define sleep(x) _sleep(x)
  #define ALLFILES "*"
  #include <windows.h>

  #define WILDCARDS 0x01
  #define EXTENSION 0x02
  #define FILENAME  0x04
  #define DIRECTORY 0x08
  #define DRIVE     0x10

  #define MAXDRIVE  3
  #define MAXPATH   260
  #define MAXDIR    256
  #define MAXFILE   256
  #define MAXEXT    256

  #define vsprintf wvsprintf
  #define sprintf  wsprintf

  #define FF_HANDLE HANDLE
  #define FIND_DATA WIN32_FIND_DATA
  #define IN_ATTR  FILE_ATTRIBUTE_NORMAL
  #define OUT_ATTR FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM | FILE_ATTRIBUTE_DIRECTORY
  #define DIR_ATTR FILE_ATTRIBUTE_DIRECTORY

  #ifdef __cplusplus
  extern "C" {
  #endif
    int  _RTLENTRY  _EXPFUNC printf(const char * __format, ...);
    int  _RTLENTRY  _EXPFUNC sscanf(const char * __buffer, const char * __format, ...);
    void _RTLENTRYF _EXPFUNC fnmerge( char _FAR *__path, const char _FAR *__drive, const char _FAR *__dir, const char _FAR *__name, const char _FAR *__ext);
    int  _RTLENTRYF _EXPFUNC fnsplit(const char _FAR *__path, char _FAR *__drive, char _FAR *__dir, char _FAR *__name, char _FAR *__ext);
  #ifdef __cplusplus
  }
  #endif
  extern int FPRINTF(HANDLE, const char*, ...);
  inline char    *ff_fname(FIND_DATA *ff) { return ff->cFileName; }
  inline unsigned ff_fsize(FIND_DATA *ff) { return ff->nFileSizeLow; }
  inline unsigned ff_attrib(FIND_DATA *ff) { return ff->dwFileAttributes; }

  inline unsigned ff_fdate(FIND_DATA *ff)
  {
    WORD d, t;
    FileTimeToDosDateTime(&ff->ftLastWriteTime, &d, &t);
    return d;
  }

  inline unsigned ff_ftime(FIND_DATA *ff)
  {
    WORD d, t;
    FileTimeToDosDateTime(&ff->ftLastWriteTime, &d, &t);
    return t;
  }

  inline int isSubDir(FIND_DATA *ff)
  {
    return ff->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY &&
           strcmp(ff->cFileName, ".") && strcmp(ff->cFileName, "..");
  }

  inline int isFile(FIND_DATA *ff)
  {
    return !(ff->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) &&
           strcmp(ff->cFileName, ".") && strcmp(ff->cFileName, "..");
  }

  inline FF_HANDLE findFirst(const char *path, FIND_DATA *ff, int)
  {
    return FindFirstFile(path, ff);
  }

  inline int findNext(FF_HANDLE h, FIND_DATA *ff)
  {
    return FindNextFile(h, ff);
  }

  inline int findClose(FF_HANDLE h, FIND_DATA*)
  {
    return FindClose(h);
  }

  inline int RenameFile(const char *s1, const char *s2)
  {
    return MoveFileEx(s1, s2, MOVEFILE_REPLACE_EXISTING);
  }

#else

  #define ALLFILES "*.*"
  #include <ctype.h>
  #include <stdlib.h>
  #include <fcntl.h>
  #include <io.h>
  #include <share.h>
  #include <stdio.h>
  #include <sys\stat.h>
  #include <time.h>
  #include <dir.h>
  #include <dos.h>
  #define INVALID_HANDLE_VALUE NULL
  #define CloseHandle(f) fclose(f)
  #define FlushFileBuffers(f) fflush(f)
  #define FPRINTF fprintf
  typedef FILE * HANDLE;
  typedef ftime FILETIME;
  #define FF_HANDLE int
  #define FIND_DATA ffblk
  #define IN_ATTR  FA_ARCH
  #define OUT_ATTR FA_HIDDEN | FA_SYSTEM | FA_DIREC
  #define DIR_ATTR FA_DIREC
  #define FILE_BEGIN   SEEK_SET
  #define FILE_CURRENT SEEK_CUR
  #define FILE_END     SEEK_END

static inline int GetFileTime(HANDLE h, FILETIME*, FILETIME*, FILETIME *t)
{
  return getftime(fileno(h), t) == 0;
}

static inline int SetFileTime(HANDLE h, const FILETIME*, const FILETIME*, const FILETIME *t)
{
  return setftime(fileno(h), (FILETIME*)t) == 0;
}

static inline long SetFilePointer(HANDLE h, long offset, long*, int whence)
{
  fseek(h, offset, whence);
  return ftell(h);
}

static inline int SetEndOfFile(HANDLE h)
{
  return chsize(fileno(h), ftell(h));
}

static inline int GetFileAttributes(const char *f)
{
  return _rtl_chmod(f, 0);
}

static inline int SetFileAttributes(const char *f, int attr)
{
  return _rtl_chmod(f, 1, attr);
}

static inline int RenameFile(const char *s1, const char *s2)
{
  unlink(s2);
  return rename(s1, s2) == 0;
}

static inline int DeleteFile(const char *s)
{
  return unlink(s) == 0;
}

inline char*ff_fname(FIND_DATA *ff) { return ff->ff_name; }
inline long ff_fsize(FIND_DATA *ff) { return ff->ff_fsize; }
inline int  ff_attrib(FIND_DATA *ff) { return ff->ff_attrib; }
inline unsigned ff_fdate(FIND_DATA *ff) { return ff->ff_fdate; }
inline unsigned ff_ftime(FIND_DATA *ff) { return ff->ff_ftime; }

inline int isSubDir(FIND_DATA *ff)
{
  return ff->ff_attrib & FA_DIREC && strcmp(ff->ff_name, ".") && strcmp(ff->ff_name, "..");
}

inline int isFile(FIND_DATA *ff)
{
  return !(ff->ff_attrib & FA_DIREC) && strcmp(ff->ff_name, ".") && strcmp(ff->ff_name, "..");
}

inline FF_HANDLE findFirst(const char *path, FIND_DATA *ff, int attr)
{
  return findfirst(path, ff, attr) == 0;
}

inline int findNext(FF_HANDLE, FIND_DATA *ff)
{
  return findnext(ff) == 0;
}

inline int findClose(FF_HANDLE, FIND_DATA*)
{
  return 1;
}

#endif

extern int existDir(const char*);
extern int existFile(const char*, FIND_DATA* = NULL);
extern char *fexpand(char*);
extern int createDir(const char *path);
extern size_t readBlock(HANDLE, void*, size_t);
extern size_t writeBlock(HANDLE, void*, size_t);
extern HANDLE openHandle(const char*, const char*);
extern size_t putString(HANDLE, const char*);
extern char *getString(HANDLE, char*, size_t);

inline char *addBackslash(char *s)
{
  if ( *s && ( *(strchr(s, 0)-1) != '\\' ) )
    strcat(s, "\\");
  return s;
}

extern int choiceYesNo(const char*, const char*);
extern HANDLE openFile(const char*, int, int, char*, const char* = NULL);

#endif