#include "wio.h"
#include "lang.h"

#include <dos.h>

#define CURRENT_FOLDER  "\\.\\"
#define PARENT_FOLDER   "\\..\\"

int createDir(const char *path)
{
  char dir[MAXPATH];
  static char Drv[MAXDRIVE], Dir[MAXDIR], File[MAXFILE], Ext[MAXEXT];
  fexpand(strcpy(dir, path));
  fnsplit(dir, Drv, Dir, File, Ext);
  strcat(strcpy(dir, Drv), Dir);
  dir[strlen(dir)-1] = 0;
  if ( strcmp(Dir, "\\") && !existDir(dir) )
  {
    if ( !createDir(dir) )
      return 0;
#ifdef __WIN32__
    return CreateDirectory(dir, NULL);
#else
    return mkdir(dir) ? 0 : 1;
#endif
  }
  return 1;
}

#ifdef __WIN32__
int existDir(const char *path)
{
  FIND_DATA ff;
  HANDLE f = FindFirstFile(path, &ff);
  int r = ( f != INVALID_HANDLE_VALUE ) && ( ff.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY);
  FindClose(f);
  return r;
}

int existFile(const char *path, FIND_DATA *ff1)
{
  FIND_DATA ff;
  HANDLE f = FindFirstFile(path, ff1 ? ff1 : &ff);
  int r = f != INVALID_HANDLE_VALUE;
  FindClose(f);
  return r;
}

size_t readBlock(HANDLE h, void *buff, size_t r)
{
  DWORD rb = 0;
  DWORD dwPos = SetFilePointer(h, 0, NULL, FILE_CURRENT);
  LockFile(h, dwPos, 0, dwPos+r, 0);
  if ( !ReadFile(h, buff, r, &rb, NULL) )
    rb = 0;
  UnlockFile(h, dwPos, 0, dwPos+r, 0);
  return rb;
}

size_t writeBlock(HANDLE h, void *buff, size_t r)
{
  DWORD rb = 0;
  DWORD dwPos = SetFilePointer(h, 0, NULL, FILE_CURRENT);
  LockFile(h, dwPos, 0, dwPos+r, 0);
  if ( !WriteFile(h, buff, r, &rb, NULL) )
    rb = 0;
  UnlockFile(h, dwPos, 0, dwPos+r, 0);
  return rb;
}

HANDLE openHandle(const char *file, const char * mode)
{
  bool append = false;
  DWORD oMode = 0, aMode = 0;
  for ( char *p = (char*)mode ; *p ; p++ )
    switch ( toupper(*p) )
    {
      case 'A': aMode = GENERIC_WRITE; oMode = OPEN_ALWAYS;   append = true;        break;
      case 'R': aMode = GENERIC_READ;  oMode = OPEN_EXISTING; break;
      case 'W': aMode = GENERIC_WRITE; oMode = CREATE_ALWAYS; break;
      case '+': aMode |= GENERIC_READ | GENERIC_WRITE;                            break;
    }
  HANDLE h = CreateFile(file, aMode, FILE_SHARE_READ, NULL, oMode, FILE_ATTRIBUTE_NORMAL, NULL);
  if ( append )
    SetFilePointer(h, 0, NULL, FILE_END);
  return h;
}

size_t putString(HANDLE f, const char *buffer)
{
  DWORD dwBytesRead = strlen(buffer), dwBytesWritten = 0;
  DWORD dwPos = SetFilePointer(f, 0, NULL, FILE_CURRENT);
  LockFile(f, dwPos, 0, dwPos+dwBytesRead, 0);
  WriteFile(f, buffer, dwBytesRead, &dwBytesWritten, NULL);
  UnlockFile(f, dwPos, 0, dwPos+dwBytesRead, 0);
  return dwBytesWritten;
}

char *getString(HANDLE f, char *buffer, size_t r)
{
  DWORD dwBytesRead = r-1, dwBytesWritten = 0;
  DWORD dwPos = SetFilePointer(f, 0, NULL, FILE_CURRENT);
  LockFile(f, dwPos, 0, dwPos+dwBytesRead, 0);
  bool res = ReadFile(f, buffer, dwBytesRead, &dwBytesWritten, NULL);
  UnlockFile(f, dwPos, 0, dwPos+dwBytesRead, 0);
  if ( !res || !dwBytesWritten )
    return NULL;
  buffer[dwBytesRead] = buffer[dwBytesWritten] = 0;
  const char *lf = "\r\n";
  char *p;
  if ( ( p = strpbrk(buffer, lf) ) != NULL )
  {
    while ( strchr(lf, *p) )
      p++;
    *p = 0;
  }
  SetFilePointer(f, dwPos+strlen(buffer), NULL, FILE_BEGIN);
  return buffer;
}

int FPRINTF(HANDLE f, const char *fmt, ...)
{
  char buffer[512];
  va_list v;
  va_start(v, fmt);
  int r = vsprintf(buffer, fmt, v);
  va_end(v);
  putString(f, buffer);
  return r;
}
#else
int existDir(const char *path)
{
  int ret = 0;
  FIND_DATA ff;
  if ( findFirst(path, &ff, OUT_ATTR) )
    ret = (ff.ff_attrib & FA_DIREC) != 0;
  findClose(NULL, &ff);
  return ret;
}

int existFile(const char *path, FIND_DATA *ff1)
{
  int ret = 0;
  FIND_DATA ff;
  if ( findFirst(path, ff1 ? ff1 : &ff, OUT_ATTR) )
    ret = 1;
  findClose(NULL, ff1 ? ff1 : &ff);
  return ret;
}

size_t readBlock(HANDLE h, void *buff, size_t r)
{
  return fread(buff, 1, r, h);
}

size_t writeBlock(HANDLE h, void *buff, size_t r)
{
  return fwrite(buff, 1, r, h);
}

static int getOpenMode(const char *mode)
{
  int oMode = 0;
  for ( char *p = (char*)mode ; *p ; p++ )
    switch ( toupper(*p) )
    {
      case 'A': oMode = O_CREAT | O_WRONLY | O_APPEND; break;
      case 'R': oMode = O_RDONLY;                      break;
      case 'W': oMode = O_CREAT | O_TRUNC | O_WRONLY;  break;
      case '+': oMode |= O_RDWR;                       break;
    }
  return oMode | O_BINARY;
}

HANDLE openHandle(const char *file, const char *mode)
{
  int handle = sopen(file, getOpenMode(mode), SH_DENYRW, S_IWRITE);
  return ( handle != -1 ) ? fdopen(handle, (char*)mode) : INVALID_HANDLE_VALUE;
}

size_t putString(HANDLE f, const char *buffer)
{
  return fputs(buffer, f);
}

char *getString(HANDLE f, char *buffer, size_t r)
{
  return fgets(buffer, r, f);
}
#endif

static void squeeze(char *path)
{
  char *dest = path;
  char *src = path;
  while ( *src != 0 )
  {
    if ( *src != '\\' )
      *dest++ = *src++;
    else
    {
      if ( !strncmp(src, CURRENT_FOLDER, 3) )
        src += 2;
      else if ( !strncmp(src, PARENT_FOLDER, 4) )
      {
        src += 3;
        while( *--dest != '\\' )
          ;
      }
      else
        *dest++ = *src++;
    }
  }
  *dest = 0;
}

char *fexpand(char *rpath)
{
  if ( strstr(rpath, "://") || !strncmp(rpath, "\\\\", 2) )
    return rpath;
  else
  {
    static char path[MAXPATH], curdir[MAXDIR];
    static char drive[MAXDRIVE], dir[MAXDIR], file[MAXFILE], ext[MAXEXT];
    int flags = fnsplit(rpath, drive, dir, file, ext);
    if ( (flags & DRIVE) == 0 )
    {
#ifdef __WIN32__
      GetCurrentDirectory(sizeof curdir, curdir);
      if ( curdir[1] == ':' )
      {
        *drive = *curdir;
        strcpy(drive+1, ":");
      }
#else
      *drive = (char)(getdisk() + 'A');
      strcpy(drive+1, ":");
#endif
    }
    if ( (flags & DIRECTORY) == 0 || (dir[0] != '\\' && dir[0] != '/') )
    {
#ifdef __WIN32__
      if ( *drive )
      {
        char *dummy;
        GetFullPathName(drive, sizeof curdir, curdir, &dummy);
        strcpy(curdir, curdir+2);
      }
      else
        *curdir = 0;
#else
      getcurdir(drive[0] - 'A' + 1, curdir);
#endif
      strcat(addBackslash(curdir), dir);
      if ( *curdir != '\\' && *curdir != '/' )
      {
        *dir = '\\';
        strcpy(dir+1, curdir);
      }
      else
        strcpy(dir, curdir);
    }
    squeeze(dir);
    char *p = dir;
    while ( (p = strchr(p, '/')) != 0 )
      *p = '\\';
    fnmerge(path, drive, dir, file, ext);
    return strcpy(rpath, path);
  }
}

int choiceYesNo(const char *fmt, const char *prompt)
{
  int skip = 0;
  text_info textInfo;
  gettextinfo(&textInfo);
  gotoxy(52, textInfo.cury);
  textattr(WHITE);
  char buff[64];
  sprintf(buff, fmt, prompt);
  cputs(strcat(buff, " [Y/N]?"));
  switch ( getch() )
  {
    case 'y':
    case 'Y':
      textattr(YELLOW);
      cputs(" Yes");
      sleep(skip = 1);
      break;
    case 0:
      getch();
    default:
      break;
  }
  gotoxy(52, textInfo.cury);
  textattr(textInfo.attribute);
  clreol();
  gotoxy(textInfo.curx, textInfo.cury);
  return skip;
}

static void wait(int noSoundMode)
{
  static int rotor = 0;
  cprintf("\r%s (%c)%s\r", noSoundMode ? "" : "\a", "-\\|/"[++rotor%=4], LNG_MODE_FIXLEN);
  sleep(1);
}

HANDLE openFile(const char * file, int maxTryes, int noSoundMode, char *mode, const char *prompt)
{
  HANDLE f = INVALID_HANDLE_VALUE;
  for ( int i = 0 ; maxTryes ? i < maxTryes : 1 ; i++ )
  {
    if ( ( f = openHandle(file, mode) ) != INVALID_HANDLE_VALUE )
      break;
    if ( prompt )
    {
      wait(noSoundMode);
      if ( kbhit() )
      {
        switch( getch() )
        {
          case 0x1B:
            if ( choiceYesNo(LNG_CHOICE_SKIP, prompt) )
              return f;
            break;
          case 0:
            getch();
            break;
          default:
            break;
        }
      }
    }
  }
  return f;
}
