#include "name.h"
#include "wio.h"

static char cvch[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
static char vch[sizeof cvch], svch[sizeof cvch];

char *nameFromMask(char * s, char* mask)
{
  char *cpp = (char*)mask;
  char *cpn = (char*)s;
  int ndone = 1;
  while ( ndone )
  {
    switch ( *cpp )
    {
      case '*':
        cpn = strchr(s, 0);
        cpp++;
        break;
      case '?':
        cpp++;
        cpn++;
        break;
      case 0:
        ndone = *cpn = 0;
        break;
      default:
        *cpn++ = *cpp++;
        break;
    }
  }
  return s;
}

void trim83(char *s)
{
  static char drv[MAXDRIVE], dir[MAXDIR], fil[MAXDIR], ext[MAXDIR];
  fnsplit(s, drv, dir, fil, ext);
  fil[8] = ext[4] = 0;
  fnmerge(s, drv, dir, fil, ext);
}

char *makeNewName(char * s, char* mask)
{
  if ( mask )
  {
    char drv[MAXDRIVE], dir[MAXDIR], fil[MAXDIR], ext[MAXDIR];
    fnsplit(s, drv, dir, fil, ext);
    char *p = strchr(mask, '.');
    if ( p )
    {
      *p = 0;
      nameFromMask(fil, mask);
      *p = '.';
      nameFromMask(ext, p);
      fnmerge(s, drv, dir, fil, ext);
    }
    else
    {
      char f[MAXPATH];
      fnsplit(f, "", "", fil, ext);
      nameFromMask(f, mask);
      fnmerge(s, drv, dir, f, "");
    }
  }
  return s;
}

int makeDiffName(int makeExt, int digitSet, char *s)
{
  static char drv[MAXDRIVE], dir[MAXDIR], fil[MAXFILE], ext[MAXEXT];
  fnsplit(s, drv, dir, fil, ext);
  if ( digitSet )
  {
    if ( makeExt )
      for ( int i = 0 ; i <= 99 ; i ++ )
      {
        sprintf(ext, ".#%02d", i);
        fnmerge(s, drv, dir, fil, ext);
        if ( !existFile(s) )
          return 1;
      }
    else
      for ( long i = 1 ; i <= 99999999l ; i ++ )
      {
        sprintf(fil, "%ld", i);
        fnmerge(s, drv, dir, fil, ext);
        if ( !existFile(s) )
          return 1;
      }
    return 0;
  }
  char *lastEChar, *lastVChar;
  strcpy(svch, cvch);
  if ( makeExt && ( !*ext || !stricmp(ext, ".") ) )
  {
    ext[0] = '.';
    ext[1] = ext[2] = 0;
    lastEChar = ext+1;
    lastVChar = NULL;
  }
  else
  {
    lastEChar = strchr(makeExt ? ext : fil, 0)-1;
    lastVChar = strchr(svch, toupper(*lastEChar));
  }
  if ( lastVChar )
  {
    strcpy(vch, lastVChar);
    *lastVChar = 0;
    strcat(vch, svch);
  }
  else
    strcpy(vch, svch);
  for ( int i = 0 ; i < sizeof vch ; i ++ )
  {
    fnmerge(s, drv, dir, fil, ext);
    if ( !existFile(s) )
      return 1;
    *lastEChar = vch[i];
  }
  return 0;
}
