#include "wio.h"
#include <dos.h>

enum opCode { ocNot, oc_LT, oc_LE, oc_EQ, oc_NE, oc_GE, oc_GT };
static opCode opSize, opDate, opTime;
static long argSize, argDate, argTime;
extern char *gl_ifSize, *gl_ifDate, *gl_ifTime;

static opCode getCode(const char* s)
{
  if ( !strnicmp(s, "LT.", 3) ) return oc_LT;
  if ( !strnicmp(s, "LE.", 3) ) return oc_LE;
  if ( !strnicmp(s, "EQ.", 3) ) return oc_EQ;
  if ( !strnicmp(s, "NE.", 3) ) return oc_NE;
  if ( !strnicmp(s, "GE.", 3) ) return oc_GE;
  if ( !strnicmp(s, "GT.", 3) ) return oc_GT;
  return ocNot;
}

static struct date fdate2date(unsigned short ff)
{
  struct Fd
  {
    unsigned ft_day: 5;       /* days */
    unsigned ft_month: 4;     /* months */
    unsigned ft_year: 7;      /* year - 1980*/
  } *fd = (Fd*)(&ff);
  date dd;
  dd.da_day  = (char)fd->ft_day;
  dd.da_mon  = (char)fd->ft_month;
  dd.da_year = (int)fd->ft_year+1980;
  return dd;
}

static struct time ftime2time(unsigned short ff)
{
  struct Ft
  {
    unsigned ft_tsec: 5;      /* two seconds */
    unsigned ft_min: 6;       /* minutes */
    unsigned ft_hour: 5;      /* hours */
  } *ft = (Ft*)(&ff);
  struct time tt;
  tt.ti_min  = (unsigned char)ft->ft_min;      /* minutes */
  tt.ti_hour = (unsigned char)ft->ft_hour;     /* hours */
  tt.ti_hund = (unsigned char)0;               /* hundredths of seconds */
  tt.ti_sec  = (unsigned char)(ft->ft_tsec*2); /* seconds */
  return tt;
}

#ifdef __WIN32__
static long getSize(const char *fn)
{
  FIND_DATA ff;
  long res = existFile(fn, &ff) ? ff.nFileSizeLow : 0;
  return res;
}

static long getDate(const char *fn)
{
  long res = 0;
  FIND_DATA ff;
  if ( existFile(fn, &ff) )
  {
    WORD d, t;
    FileTimeToDosDateTime(&ff.ftLastWriteTime, &d, &t);
    struct date dd;
    struct time tt = {10, 10, 10};
    dd = fdate2date(d);
    res = dostounix(&dd, &tt);
  }
  return res;
}

static long getTime(const char *fn)
{
  long res = 0;
  FIND_DATA ff;
  if ( existFile(fn, &ff) )
  {
    WORD d, t;
    FileTimeToDosDateTime(&ff.ftLastWriteTime, &d, &t);
    struct date dd;
    struct time tt;
    getdate(&dd);
    tt = ftime2time(t);
    res = dostounix(&dd, &tt);
  }
  return res;
}
#else
static long getFDate(FIND_DATA *ff)
{
  struct time nul = {10, 10, 10};
  struct date dd;
  dd = fdate2date(ff->ff_fdate);
  return dostounix(&dd, &nul);
}

static long getFTime(FIND_DATA *ff)
{
  struct time tt;
  struct date now;
  getdate(&now);
  tt = ftime2time(ff->ff_ftime);
  return dostounix(&now, &tt);
}

static long getSize(const char *fn)
{
  long res = 0;
  FIND_DATA ff;
  if ( !findfirst(fn, &ff, 0) )
    res = ff.ff_fsize;
  return res;
}

static long getDate(const char *fn)
{
  long res = 0;
  FIND_DATA ff;
  if ( !findfirst(fn, &ff, 0) )
    res = getFDate(&ff);
  return res;
}

static long getTime(const char *fn)
{
  long res = 0;
  FIND_DATA ff;
  if ( !findfirst(fn, &ff, 0) )
    res = getFTime(&ff);
  return res;
}
#endif

int parseSizeMacro(char *s, long &r)
{
  if ( isdigit(*s) )
  {
    r = atol(s);
    switch ( toupper(*(strchr(s, 0)-1)) )
    {
      case 'G':
        r *= 1024;
      case 'M':
        r *= 1024;
      case 'K':
        r *= 1024;
    }
  }
  else
    r = getSize(s);
  return 1;
}

static int parseSize(void)
{
  if ( ( opSize = getCode(gl_ifSize) ) == ocNot )
    return 0;
  return parseSizeMacro(gl_ifSize+3, argSize);
}

static const long SEC_IN_DAY = 86400l; // 60*60*24

static date incDate(date da, long days)
{
  struct date dc;
  struct time dummy1 = {10, 10, 10}, dummy2 = {10, 10, 10};
  unixtodos(dostounix(&da, &dummy1)+days*SEC_IN_DAY, &dc, &dummy2);
  return dc;
}

int parseDateMacro(char *s, long &r)
{
  long day, mon, year;
  struct date dd;
  struct time tt = {10, 10, 10};
  if ( strchr("+-", *s) )
  {
    getdate(&dd);
    dd = incDate(dd, atol(s));
    r = dostounix(&dd, &tt);
  }
  else if ( strchr(s, '/') )
  {
    sscanf(s, "%ld/%ld/%ld", &day, &mon, &year);
    if ( year < 50 )
      year += 2000;
    else if ( year < 100 )
      year += 1900;
    dd.da_day  = (char)day;
    dd.da_mon  = (char)mon;
    dd.da_year = (int)year;
    r = dostounix(&dd, &tt);
  }
  else
    r = getDate(s);
  return 1;
}

static int parseDate(void)
{
  if ( ( opDate = getCode(gl_ifDate) ) == ocNot )
    return 0;
  return parseDateMacro(gl_ifDate+3, argDate);
}

static int scanTime(char *s, struct time& tt)
{
  int ret = 0;
  long hour, min, sec;
  switch ( sscanf(s, "%ld:%ld:%ld", &hour, &min, &sec) )
  {
    case 0:
      ret = 0;
      break;
    case 1:
      min = 0;
    case 2:
      sec = 0;
  }
  tt.ti_hour = (unsigned char)hour;
  tt.ti_min  = (unsigned char)min;
  tt.ti_sec  = (unsigned char)sec;
  return ret;
}

int parseTimeMacro(char *s, long &r)
{
  struct date dd;
  struct time tt;
  getdate(&dd);
  if ( strchr("+-", *s) )
  {
    struct time now, nul = {0, 0, 0};
    gettime(&now);
    scanTime(s+1, tt);
    long tnow = dostounix(&dd, &now);
    long tsec = dostounix(&dd, &tt);
    long tnul = dostounix(&dd, &nul);
    if ( *s == '+' )
      tsec = tnow+(tsec-tnul);
    else
      tsec = tnow-(tsec-tnul);
    unixtodos(tsec, &dd, &tt);
    r = dostounix(&dd, &tt);
  }
  else if ( strchr(s, '.') == NULL && scanTime(s, tt) )
    r = dostounix(&dd, &tt);
  else
    r = getTime(s);
  return 1;
}

static int parseTime(void)
{
  if ( ( opTime = getCode(gl_ifTime) ) == ocNot )
    return 0;
  return parseTimeMacro(gl_ifTime+3, argTime);
}

int parseIf(void)
{
  if ( gl_ifSize && !parseSize() ) return 0;
  if ( gl_ifDate && !parseDate() ) return 0;
  if ( gl_ifTime && !parseTime() ) return 0;
  return 1;
}

static int checkFileNow(long n1, opCode op, long n2)
{
  switch ( op )
  {
    case oc_LT: return n1 <  n2;
    case oc_LE: return n1 <= n2;
    case oc_EQ: return n1 == n2;
    case oc_NE: return n1 != n2;
    case oc_GE: return n1 >= n2;
    case oc_GT: return n1 >  n2;
    default:    return 0;
  }
}

int checkFile(const char *fn)
{
  if ( gl_ifSize && !checkFileNow(getSize(fn), opSize, argSize) ) return 0;
  if ( gl_ifDate && !checkFileNow(getDate(fn), opDate, argDate) ) return 0;
  if ( gl_ifTime && !checkFileNow(getTime(fn), opTime, argTime) ) return 0;
  return 1;
}
