#include "ftn.h"

#include <ctype.h>
#include <string.h>

static int getNum(char*s, unsigned short &n)
{
  n = 0;
  if ( *s )
    while ( isdigit(*s) )
      n = (unsigned short)(n*10+(*s++-'0'));
  else
    n = 0xFFFF;
  return !*s;
}

int TFTNAddress::parse(char *aAddr, TFTNAddress *defAddress)
{
  unsigned short n;
  char addr[64];
  zone = net = node = point = 0;
  int pointSet = 0;
  char *p = strchr(strcpy(addr, aAddr), '.');
  if ( p )
  {
    *p++ = 0;
    if ( getNum(p, n) )
    {
      if ( n == 0xFFFF )
        return 0;
      point = n;
      pointSet = 1;
    }
    else
      return 0;
  }
  p = strchr(addr, '/');
  if ( p )
  {
    *p++ = 0;
    if ( getNum(p, n) )
    {
      if ( n == 0xFFFF )
        return 0;
      node = n;
      p = strchr(addr, ':');
      if ( p )
      {
        *p++ = 0;
        if ( getNum(p, n) )
        {
          if ( n == 0xFFFF )
            return 0;
          net = n;
        }
        else
          return 0;
        if ( getNum(addr, n) )
        {
          if ( n == 0xFFFF )
            return 0;
          zone = n;
        }
        else
          return 0;
      }
      else
      {
        if ( getNum(addr, n) )
        {
          if ( n == 0xFFFF )
            if ( defAddress )
              net = defAddress->net;
            else
              return 0;
          else
            net = n;
          zone = defAddress ? defAddress->zone : (unsigned short)2;
        }
        else
          return 0;
      }
    }
    else
      return 0;
  }
  else if ( defAddress )
  {
    if ( getNum(addr, n) )
      if ( n == 0xFFFF )
        if ( pointSet )
        {
          zone = defAddress->zone;
          net = defAddress->net;
          node = defAddress->node;
        }
        else
          return 0;
      else
      {
        node = n;
        zone = defAddress->zone;
        net = defAddress->net;
      }
    else
      return 0;
  }
  else
    return 0;
  return 1;
}
