// coniow.h
// Win32 API console input/output.
// Copyright (c) 2001 by Alexander Nazarenko, 2:464/991@fidonet
// Revision: 1.0

#if !defined(__CONIOW_H)
#define __CONIOW_H
#if !defined(___DEFS_H)
#include <_defs.h>
#endif
#if !defined(RC_INVOKED)
#if defined(__STDC__)
#pragma warn -nak
#endif
#pragma pack(push, 1)
#endif  /* !RC_INVOKED */

enum CURSORTYPE
{
  _NOCURSOR,
  _SOLIDCURSOR,
  _NORMALCURSOR
};

struct text_info
{
  unsigned short winleft, wintop, winright, winbottom;
  unsigned char  attribute, normattr;
  unsigned char  currmode;
  unsigned short screenheight, creenwidth;
  unsigned short curx, cury;
};

#if !defined(__COLORS)
#define __COLORS
enum COLORS
{
  BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, LIGHTGRAY,
  DARKGRAY, LIGHTBLUE, LIGHTGREEN, LIGHTCYAN, LIGHTRED, LIGHTMAGENTA, YELLOW, WHITE
};
#endif

#define BLINK 128

#if !defined(__FLAT__) || !defined(__WIN32__)
#error Must be Win32 FLAT mode
#else

enum text_modes
{
  LASTMODE = -1, BW40 = 0, C40, BW80, C80, MONO = 7, C4350 = 64,
  C40X14 = 8, C40X21,  C40X28,  C40X43,  C40X50,  C40X60,
  C80X14,     C80X21,  C80X28,  C80X43,  C80X50,  C80X60,
  BW40X14,    BW40X21, BW40X28, BW40X43, BW40X50, BW40X60,
  BW80X14,    BW80X21, BW80X28, BW80X43, BW80X50, BW80X60,
  MONO14,     MONO21,  MONO28,  MONO43,  MONO50,  MONO60,
  _ORIGMODE = 65
};

#define PASS_MAX    8   /* max. no. of chars returned by getpass */

#if !defined(__STDC__)  /*  NON-ANSI  */
#define directvideo  _directvideo
#define _getch       getch             /* for MSC compatibility */
#endif

extern int _directvideo;
extern int _wscroll;

#ifdef __cplusplus
extern "C" {
#endif

char *cgets(char*);
void  clreol(void);
void  clreolattr(int);
void  clrscr(void);
int   cprintf(const char*, ...);
int   cputs(const char*);
int   cscanf(const char*, ...);
void  delline(void);
int   getch(void);
int   getche(void);
char *getpass(const char*);
int   gettext(int, int, int, int, void*);
void  gettextinfo(struct text_info*);
int   getvch(void);
void  gotoxy(int, int);
void  highvideo(void);
void  insline(void);
int   kbhit(void);
void  lowvideo(void);
int   movetext(int, int, int, int, int, int);
void  normvideo(void);
int   putch(int);
int   puttext(int, int, int, int, void*);
void  textattr(int);
void  textbackground(int);
void  textcolor(int);
void  textmode(int);
int   ungetch(int);
int   wherex(void);
int   wherey(void);
void  window(int, int, int, int);
void  _setcursortype(CURSORTYPE);

#ifdef __cplusplus
}
#endif

#endif

#if !defined(RC_INVOKED)
#pragma pack(pop)
#if defined(__STDC__)
#pragma warn .nak
#endif
#endif  /* !RC_INVOKED */
#endif  /* __CONIOW_H */
