// coniow.cpp
// Win32 API console input/output.
// Copyright (c) 2001 by Alexander Nazarenko, 2:464/991@fidonet
// Revision: 1.0

#include <windows.h>
#include <stdarg.h>
#include "coniow.h"

// static CONSOLE_SCREEN_BUFFER_INFO infoI;
static CONSOLE_SCREEN_BUFFER_INFO infoO;
static HANDLE hI = GetStdHandle(STD_INPUT_HANDLE);
static HANDLE hO = GetStdHandle(STD_OUTPUT_HANDLE);

int _directvideo = 1;
int _wscroll = 1;

//static inline void getInfoI(void)
//{
//  GetConsoleScreenBufferInfo(hI, &infoI);
//}

static inline void getInfoO(void)
{
  GetConsoleScreenBufferInfo(hO, &infoO);
}

static unsigned char normattr = (GetConsoleScreenBufferInfo(hO, &infoO),(unsigned char)(infoO.wAttributes));

static void clreol_w(void)
{
  DWORD dummy;
  FillConsoleOutputCharacter(hO, ' ', infoO.srWindow.Right-infoO.dwCursorPosition.X, infoO.dwCursorPosition, &dummy);
  FillConsoleOutputAttribute(hO, infoO.wAttributes, infoO.dwSize.X-infoO.dwCursorPosition.X, infoO.dwCursorPosition, &dummy);
}

void clreol(void)
{
  getInfoO();
  clreol_w();
  SetConsoleCursorPosition(hO, infoO.dwCursorPosition);
}

void clreolattr(int attr)
{
  DWORD dummy;
  getInfoO();
  FillConsoleOutputAttribute(hO, (WORD)attr, infoO.dwSize.X-infoO.dwCursorPosition.X, infoO.dwCursorPosition, &dummy);
  SetConsoleCursorPosition(hO, infoO.dwCursorPosition);
}

void gotoxy(int x, int y)
{
  COORD C;
  getInfoO();
  C.X = (SHORT)(x-1);
  C.Y = (SHORT)(y-1);
  SetConsoleCursorPosition(hO, C);
}

void clrscr(void)
{
  COORD C;
  getInfoO();
  C.X = 0;
  for ( int Y = infoO.srWindow.Top ; Y < infoO.srWindow.Bottom ; Y++ )
  {
    C.Y = (SHORT)Y;
    clreol_w();
  }
  C.Y = 0;
  SetConsoleCursorPosition(hO, C);
}

static int getVch(INPUT_RECORD *r)
{
  DWORD i;
  if ( ReadConsoleInput(hI, r, 1, &i) && ( i == 1 ) )
    if ( ( r->EventType == KEY_EVENT ) && r->Event.KeyEvent.bKeyDown )
      return 1;
  FlushConsoleInputBuffer(hI);
  return 0;
}

int getvch(void)
{
  INPUT_RECORD r;
  for ( ; ; )
    if ( getVch(&r) )
      return r.Event.KeyEvent.wVirtualKeyCode;
}

int getch(void)
{
  INPUT_RECORD r;
  for ( ; ; )
    if ( getVch(&r) )
      return r.Event.KeyEvent.uChar.AsciiChar;
}

int getche(void)
{
  return putch(getch());
}

int kbhit(void)
{
  INPUT_RECORD r;
  DWORD i;
  if ( PeekConsoleInput(hI, &r, 1, &i) )
    if ( ( r.EventType == KEY_EVENT ) && r.Event.KeyEvent.bKeyDown )
      return 1;
    else
      FlushConsoleInputBuffer(hI);
  return 0;
}

int putch(int ch)
{
  DWORD dummy;
  char c = (char)ch;
  WriteConsole(hO, &c, 1, &dummy, NULL);
  return c;
}

int wherex(void)
{
  getInfoO();
  return infoO.dwCursorPosition.X-infoO.srWindow.Left+1;
}

int wherey(void)
{
  getInfoO();
  return infoO.dwCursorPosition.Y-infoO.srWindow.Top+1;
}

void gettextinfo(struct text_info *ti)
{
  getInfoO();
  ti->winleft      = (unsigned short)(infoO.srWindow.Left+1);
  ti->wintop       = (unsigned short)(infoO.srWindow.Top+1);
  ti->winright     = (unsigned short)(infoO.srWindow.Right+1);
  ti->winbottom    = (unsigned short)(infoO.srWindow.Bottom+1);
  ti->attribute    = infoO.wAttributes;
  ti->normattr     = normattr;
  ti->currmode     = C80;
  ti->screenheight = (unsigned short)infoO.dwSize.Y;
  ti->creenwidth   = (unsigned short)infoO.dwSize.X;
  ti->curx         = (unsigned short)(infoO.dwCursorPosition.Y+1);
  ti->cury         = (unsigned short)(infoO.dwCursorPosition.Y+1);
}

void textattr(int attr)
{
  getInfoO();
  SetConsoleTextAttribute(hO, (WORD)attr);
}

void textbackground(int attr)
{
  getInfoO();
  SetConsoleTextAttribute(hO, (WORD)((infoO.wAttributes & 0x000F) | ((WORD)(attr<<4) & 0x00F0)));
}

void textcolor(int attr)
{
  getInfoO();
  SetConsoleTextAttribute(hO, (WORD)((infoO.wAttributes & 0x00F0) | ((WORD)attr  & 0x000F)));
}

void highvideo(void)
{
  getInfoO();
  SetConsoleTextAttribute(hO, (WORD)(infoO.wAttributes | FOREGROUND_INTENSITY));
}

void lowvideo(void)
{
  getInfoO();
  SetConsoleTextAttribute(hO, (WORD)(infoO.wAttributes & ~FOREGROUND_INTENSITY));
}

void normvideo(void)
{
  getInfoO();
  SetConsoleTextAttribute(hO, (WORD)normattr);
}

void window(int x1, int y1, int x2, int y2)
{
  SMALL_RECT w = { (SHORT)(x1-1), (SHORT)(y1-1), (SHORT)(x2-1), (SHORT)(y2-1) };
  getInfoO();
  SetConsoleWindowInfo(hO, TRUE, &w);
}

void _setcursortype(CURSORTYPE c)
{
  CONSOLE_CURSOR_INFO ci;
  ci.bVisible = TRUE;
  switch ( c )
  {
    case _NOCURSOR:
      ci.bVisible = FALSE;
      break;
    case _SOLIDCURSOR:
      ci.dwSize = 100;
      break;
    default:
      ci.dwSize = 10;
      break;
  }
  SetConsoleCursorInfo(hO, &ci);
  ci.dwSize;
}

int cputs(const char *buff)
{
  DWORD dummy, len = strlen(buff);
  getInfoO();
  WriteConsole(hO, buff, len, &dummy, NULL);
  return buff[len-1];
}

char *getpass(const char *prompt)
{
  static char pass[PASS_MAX+1];
  char *p = pass;
  cputs(prompt);
  for ( int i = 0 ; i < PASS_MAX ; i++ )
  {
    if ( ( *p = (char)getch() ) == VK_RETURN)
      break;
    p++;
  }
  *p = 0;
  cputs("\r\n");
  return pass;
}

int movetext(int x1, int y1, int x2, int y2, int x3, int y3)
{
  getInfoO();
  SMALL_RECT R = { (SHORT)(x1-1), (SHORT)(y1-1), (SHORT)(x2-1), (SHORT)(y2-1) };
  COORD Dest = { (SHORT)(x3-1), (SHORT)(y3-1) };
  CHAR_INFO Fill;
  Fill.Char.AsciiChar = ' ';
  Fill.Attributes = infoO.wAttributes;
  return ScrollConsoleScreenBuffer(hO, &R, NULL, Dest, &Fill);
}

int gettext(int x1, int y1, int x2, int y2, void *buffer)
{
  getInfoO();
  SMALL_RECT R = { (SHORT)(x1-1), (SHORT)(y1-1), (SHORT)(x2-1), (SHORT)(y2-1) };
  COORD Size = { (SHORT)(x2-x1+1), (SHORT)(y2-y1+1) }, At = { 0, 0 };
  return ReadConsoleOutput(hO, (PCHAR_INFO)buffer, Size, At, &R);
}

int puttext(int x1, int y1, int x2, int y2, void *buffer)
{
  getInfoO();
  SMALL_RECT R = { (SHORT)(x1-1), (SHORT)(y1-1), (SHORT)(x2-1), (SHORT)(y2-1) };
  COORD Size = { (SHORT)(x2-x1+1), (SHORT)(y2-y1+1) }, At = { 0, 0 };
  return WriteConsoleOutput(hO, (PCHAR_INFO)buffer, Size, At, &R);
}

void insline(void)
{
  getInfoO();
  SMALL_RECT ScrollRectangle =
  {
    infoO.srWindow.Left,
    (SHORT)(infoO.srWindow.Top+1),
    infoO.srWindow.Right,
    infoO.dwCursorPosition.Y,
  };
  COORD Dest = { infoO.srWindow.Left, infoO.srWindow.Top };
  CHAR_INFO Fill;
  Fill.Char.AsciiChar = ' ';
  Fill.Attributes = infoO.wAttributes;
  ScrollConsoleScreenBuffer(hO, &ScrollRectangle, NULL, Dest, &Fill);
}

void delline(void)
{
  getInfoO();
  SMALL_RECT ScrollRectangle =
  {
    infoO.srWindow.Left,
    (SHORT)(infoO.dwCursorPosition.Y+1),
    infoO.srWindow.Right,
    infoO.srWindow.Bottom
  };
  COORD Dest = { infoO.srWindow.Left, infoO.dwCursorPosition.Y };
  CHAR_INFO Fill;
  Fill.Char.AsciiChar = ' ';
  Fill.Attributes = infoO.wAttributes;
  ScrollConsoleScreenBuffer(hO, &ScrollRectangle, NULL, Dest, &Fill);
}

static char buff[1024];

#ifdef __cplusplus
extern "C" {
#endif
extern int _RTLENTRY _EXPFUNC vsprintf(char _FAR *__buffer,
                                       const char _FAR *__format,
                                       void _FAR *__arglist);
extern int _RTLENTRY _EXPFUNC vsscanf( const char _FAR *__buffer,
                                       const char _FAR *__format,
                                       void _FAR *__arglist);
#ifdef  __cplusplus
}
#endif

int cprintf(const char *lpFmt, ...)
{
  va_list va;
  va_start(va, lpFmt);
  int r = vsprintf(buff, lpFmt, va);
  va_end(va);
  cputs(buff);
  return r;
}

int cscanf(const char *lpFmt, ...)
{
  va_list va;
  va_start(va, lpFmt);
  int r = vsscanf(cgets(buff), lpFmt, va);
  va_end(va);
  return r;
}

char *cgets(char *s)
{
  char *p = s+2;
  s[1] = 0;
  for ( int i = 0 ; i < *s ; i++ )
  {
    if ( ( *p = (char)getch() ) == VK_RETURN)
      break;
    p++;
    s[1]++;
  }
  *p = 0;
  return s+2;
}

void textmode(int)
{
}

int ungetch(int ch)
{
  return ch;
}
