#include "wio.h"
#include "wmix.h"

int findDescription(HANDLE src, const char *fn, char *buff, size_t size, long& pos)
{
  static char file[MAXFILE+MAXEXT];
  int found = 0;
  SetFilePointer(src, 0, NULL, FILE_BEGIN);
  for ( ; ; )
  {
    pos = SetFilePointer(src, 0, NULL, FILE_CURRENT);
    if ( getString(src, buff, size-1) )
    {
      if ( *buff && !isspace(*buff) )
      {
        char *p1 = buff, *p2 = file;
        while ( *p1 && !isspace(*p1) && ( p2 < file+(sizeof(file)-1) ) )
          *p2++ = *p1++;
        *p2 = 0;
        if ( matched(fn, addPoint(file), 0) )
        {
          found = 1;
          break;
        }
      }
    }
    else
      break;
  }
  return found;
}

void killDescription(HANDLE src, const char *fn, char *buff, size_t size)
{
  long pos, pos2;
  while ( findDescription(src, fn, buff, size, pos) )
  {
    SetFilePointer(src, pos, NULL, FILE_BEGIN);
    if ( getString(src, buff, size-1) )
    {
      pos2 = SetFilePointer(src, 0, NULL, FILE_CURRENT);
      while ( getString(src, buff, size-1) )
      {
        if ( isspace(*buff) )
          pos2 = SetFilePointer(src, 0, NULL, FILE_CURRENT);
        else
          break;
      }
      size_t r;
      do
      {
        SetFilePointer(src, pos2, NULL, FILE_BEGIN);
        r = readBlock(src, IOBuffer, IOBufferSize);
        pos2 = SetFilePointer(src, 0, NULL, FILE_CURRENT);
        SetFilePointer(src, pos, NULL, FILE_BEGIN);
        writeBlock(src, IOBuffer, r);
        pos = SetFilePointer(src, 0, NULL, FILE_CURRENT);
        FlushFileBuffers(src);
      } while ( r );
      SetEndOfFile(src);
      FlushFileBuffers(src);
    }
  }
}

void addDescription(HANDLE src, HANDLE dst, char *buff, size_t size)
{
  putString(dst, buff);
  while ( getString(src, buff, size-1) )
    if ( *buff && isspace(*buff) )
      putString(dst, buff);
    else
      break;
  FlushFileBuffers(dst);
}

void updateDescription(const char *srcDir, const char *dstDir, const char *descFile, const char *fn, int maxTryes, int noSoundMode)
{
  static char File[MAXPATH];
  fnmerge(File, "", srcDir, descFile, "");
  HANDLE src = openFile(File, maxTryes, noSoundMode, "r+", descFile);
  if ( src != INVALID_HANDLE_VALUE )
  {
    static char buff[128], buff2[128];
    long pos;
    if ( findDescription(src, fn, buff, sizeof(buff)-1, pos) )
    {
      fnmerge(File, "", dstDir, descFile, "");
      HANDLE dst = INVALID_HANDLE_VALUE;
      if ( existFile(File) )
      {
        dst = openFile(File, maxTryes, noSoundMode, "r+", descFile);
        if ( dst != INVALID_HANDLE_VALUE )
          killDescription(dst, fn, buff2, sizeof(buff2)-1);
        SetFilePointer(dst, 0, NULL, FILE_END);
      }
      if ( dst == INVALID_HANDLE_VALUE )
        dst = openFile(File, maxTryes, noSoundMode, "a", descFile);
      if ( dst != INVALID_HANDLE_VALUE )
        addDescription(src, dst, buff, sizeof(buff)-1);
      CloseHandle(dst);
    }
  }
  CloseHandle(src);
}
