{ About box }
unit VRename2;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs, ShellAPI;

type
  TAboutBox = class(TForm)
    Panel: TPanel;
    ProgIcon: TImage;
    ProgTitle: TLabel;
    ProgIdn: TLabel;
    ProgTarget: TLabel;
    Copyright: TLabel;
    OKButton: TButton;
    Email: TLabel;
    URL: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure EmailClick(Sender: TObject);
    procedure URLClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

implementation

Uses VRename0;

{$R *.DFM}

procedure TAboutBox.FormCreate(Sender: TObject);
begin
  ProgIcon.Picture.Icon := Application.Icon;
  ProgIdn.Caption       := GC_ProgIdn+' '+GC_ProgVers+' - '+GC_ProgDate;
  ProgTitle.Caption     := GC_ProgTitle;
  ProgTarget.Caption    := GC_ProgTarget;
  Copyright.Caption     := GC_Copyright;
  Email.Caption         := GC_AuthorEmail;
  URL.Caption           := GC_AuthorURL;
end;



procedure TAboutBox.EmailClick(Sender: TObject);
var cmd: string;
begin
  cmd:= 'mailto:'  + GC_AuthorEmail +
        '?subject=' + 'About '+GC_ProgIdn+' '+GC_ProgVers;
  if ShellExecute(GetDesktopWindow,nil,PChar(cmd),nil,nil,SW_NORMAL) <= 32
  then ShowMessage('failed to create e-mail');
end;

procedure TAboutBox.URLClick(Sender: TObject);
var cmd: string;
begin
  cmd:= GC_AuthorURL;
  if ShellExecute(GetDesktopWindow,nil,PChar(cmd),nil,nil,SW_NORMAL) <= 32
  then ShowMessage('failed to launch web browser');
end;

end.

