{ Main Window }
unit VRename1;

interface

uses
  StpLib, VRename0,
  ExtCtrls, Menus, Dialogs, StdCtrls, Controls, Buttons, Classes,
  Windows, Messages, SysUtils, Graphics, Forms, FileCtrl;

type
  TMainWindow = class(TForm)
    ToolBar: TPanel;
    FontDialog: TFontDialog;
    MainMenu: TMainMenu;
    MnuFile: TMenuItem;
    MnuFileExit: TMenuItem;
    MnuOptions: TMenuItem;
    MnuOptToolBar: TMenuItem;
    MnuOptHints: TMenuItem;
    MnuOptFont: TMenuItem;
    MnuHelp: TMenuItem;
    MnuHelpAbout: TMenuItem;
    BtnExit: TSpeedButton;
    BtnHints: TSpeedButton;
    BtnFont: TSpeedButton;
    BtnHelp: TSpeedButton;
    MnuOptIgnoreCase: TMenuItem;
    PopFileList: TPopupMenu;
    PopFileListCopy: TMenuItem;
    PopFileListSelectAll: TMenuItem;
    PopFileListUnselectAll: TMenuItem;
    N1: TMenuItem;
    PnlDialog: TPanel;
    LblFindMask: TLabel;
    TxtFindMask: TEdit;
    LblReplaceMask: TLabel;
    TxtReplaceMask: TEdit;
    GrpToCase: TRadioGroup;
    ChkIgnoreCase: TCheckBox;
    BtnRename: TBitBtn;
    BtnClose: TBitBtn;
    LblDirPath: TLabel;
    ClipBuf: TEdit;
    GrpDir: TGroupBox;
    DirectoryListBox: TDirectoryListBox;
    PnlDrive: TPanel;
    DriveComboBox: TDriveComboBox;
    LblDrive: TLabel;
    Splitter: TSplitter;
    GrpFile: TGroupBox;
    PnlFileMask: TPanel;
    PnlFileFilter: TPanel;
    TxtFileMask: TEdit;
    FilterComboBox: TFilterComboBox;
    FileListBox: TFileListBox;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MnuFileExitClick(Sender: TObject);
    procedure MnuOptionsClick(Sender: TObject);
    procedure MnuOptToolBarClick(Sender: TObject);
    procedure MnuOptHintsClick(Sender: TObject);
    procedure MnuOptFontClick(Sender: TObject);
    procedure MnuHelpAboutClick(Sender: TObject);
    procedure FontDialogApply(Sender: TObject; Wnd: Integer);
    procedure TxtFileMaskKeyPress(Sender: TObject; var Key: Char);
    procedure BtnRenameClick(Sender: TObject);
    procedure MnuOptIgnoreCaseClick(Sender: TObject);
    procedure PopFileListCopyClick(Sender: TObject);
    procedure PopFileListSelectAllClick(Sender: TObject);
    procedure PopFileListUnselectAllClick(Sender: TObject);
    procedure PopFileListPopup(Sender: TObject);
    procedure TxtFindMaskDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure TxtFindMaskDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure TxtReplaceMaskDragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure SplitterMoved(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    RenameAll : boolean;
    procedure WMGetMinMaxInfo(var V_Msg: Tmessage); message WM_GetMinMaxInfo;
    procedure AdjustPaneWidth;
  public
    procedure ApplyFont;
    procedure AdjustControls;
    function  Matches(const V_Filename,V_Prefix: String): boolean;
    procedure DoRename;
    function  DoRenameFile(const V_FileName: String): boolean;
  end;

var
  MainWindow: TMainWindow;

implementation

uses VRename2;

{$R *.DFM}


{ Private }

procedure TMainWindow.WMGetMinMaxInfo(var V_Msg: Tmessage);
begin
  with PMinMaxInfo(V_Msg.lparam)^.ptMinTrackSize do begin
    x:= GC_MinWinWidth;
    y:= GC_MinWinHeight;
  end;
  AdjustPaneWidth;
end;

procedure TMainWindow.AdjustPaneWidth;
begin if GV_FormReady then begin
  if GrpDir.Width < GC_MinDirWidth then
     GrpDir.Width := GC_MinDirWidth;
  if MainWindow.Width - GrpDir.Width - Splitter.Width < GC_MinFilWidth then
     GrpDir.Width := MainWindow.Width - Splitter.Width - GC_MinFilWidth;
end end;

{ Public }

procedure TMainWindow.ApplyFont;
begin
  DirectoryListBox.Font := FontDialog.Font;
  DriveComboBox.Font    := FontDialog.Font;
  TxtFileMask.Font      := FontDialog.Font;
  FileListBox.Font      := FontDialog.Font;
  FilterComboBox.Font   := FontDialog.Font;
  TxtFindMask.Font      := FontDialog.Font;
  FileListBox.Font      := FontDialog.Font;
  FilterComboBox.Font   := FontDialog.Font;
  TxtFindMask.Font      := FontDialog.Font;
  TxtReplaceMask.Font   := FontDialog.Font;
end;

procedure TMainWindow.AdjustControls;
begin
  BtnHints.Down:= ShowHint;
end;

function  TMainWindow.Matches(const V_Filename,V_Prefix: String): boolean;
begin
  if V_Prefix = '' then Result:= true
  else begin
    if ChkIgnoreCase.Checked
      then Result:= StpUppPos(V_FileName,V_Prefix) = 1
      else Result:= StpPos   (V_FileName,V_Prefix) = 1
  end;
end;

procedure TMainWindow.DoRename;
var i: integer; ok: boolean; MatchCount: integer;
begin
  RenameAll:= false;
  MatchCount:= 0;
  if      FileListBox.Items.Count = 0  then
    ShowMessage('There are no files to rename')
  else with FileListBox, Items do begin
    i:= 0; ok:= true;
    while ok and (i < Count) do begin
      if (Selected[i] or (SelCount=0)) and
         Matches(Items[i],TxtFindMask.Text)
      then begin
        Inc(MatchCount);
        ok:= DoRenameFile(Items[i]);
      end;
      Inc(i);
    end;
    if MatchCount=0 then
      ShowMessage('No matching files found')
    else
      FileListBox.Update;
  end;
end;

function TMainWindow.DoRenameFile(const V_FileName: String): boolean;
var OldName, NewName: String; ok: boolean;
begin
  ok:= true;
  OldName:= LblDirPath.Caption+'\'+V_FileName;
  if FileExists(OldName) then begin
    NewName:= TxtReplaceMask.Text +
              Copy(V_FileName,Length(TxtFindMask.Text)+1,Length(V_FileName));
    case GrpToCase.ItemIndex of
      0: NewName:= AnsiLowerCaseFileName(NewName);
      1: NewName:= AnsiUpperCaseFileName(NewName);
      else ;
    end;
    if not (RenameFile(OldName,NewName) or RenameAll) then
      case MessageDlg(
         'Cannot rename '#13+OldName+#13'to '+NewName+#13'Proceed?',
         mtError,[mbAll,mbYes,mbNo],0)
      of
        mrAll: RenameAll:= true;
        mrYes: {proceed};
        else   ok:= false;
      end;
  end;
  Result:= ok;
end;

{ Generated }

procedure TMainWindow.FormCreate(Sender: TObject);
begin
  Icon:= Application.Icon;
  ApplyFont;
end;

procedure TMainWindow.FormShow(Sender: TObject);
begin
  Application.Title  := GC_ProgTitle;
  MainWindow.Caption := GC_ProgTitle;
  GV_SettingFnm      := ChangeFileExt(Application.ExeName,GC_SettingExt);
  ReadOptions;
  GV_FormReady       := true;
end;

procedure TMainWindow.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose:= WriteOptions;
end;

procedure TMainWindow.MnuFileExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainWindow.MnuOptionsClick(Sender: TObject);
begin
  MnuOptToolbar.Checked    := Toolbar.Visible;
  MnuOptIgnoreCase.Checked := ChkIgnoreCase.Checked;
  MnuOptHints.Enabled      := Toolbar.Visible;
  if MnuOptHints.Enabled then
    MnuOptHints.Checked    := ShowHint
  else
    MnuOptHints.Checked    := false;
end;

procedure TMainWindow.MnuOptToolBarClick(Sender: TObject);
begin
  Toolbar.Visible:= not Toolbar.Visible;
end;

procedure TMainWindow.MnuOptHintsClick(Sender: TObject);
begin
  ShowHint:= not ShowHint;
  AdjustControls;
end;

procedure TMainWindow.MnuOptFontClick(Sender: TObject);
begin
  if FontDialog.Execute then ApplyFont;
end;

procedure TMainWindow.MnuOptIgnoreCaseClick(Sender: TObject);
begin
  with ChkIgnoreCase do Checked:= not Checked;
  AdjustControls;
end;

procedure TMainWindow.MnuHelpAboutClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainWindow.FontDialogApply(Sender: TObject; Wnd: Integer);
begin
  ApplyFont;
end;

procedure TMainWindow.TxtFileMaskKeyPress(Sender: TObject; var Key: Char);
begin if (Key = #13) and (TxtFileMask.Text <> '') then begin
  FileListBox.ApplyFilePath(TxtFileMask.Text);
end end;

procedure TMainWindow.BtnRenameClick(Sender: TObject);
begin
  DoRename;
end;

procedure TMainWindow.PopFileListCopyClick(Sender: TObject);
begin with FileListBox, Items do if SelCount = 1 then begin
  ClipBuf.Text:= Items[ItemIndex];
  ClipBuf.SelectAll;
  ClipBuf.CopyToClipboard;
end end;

procedure TMainWindow.PopFileListSelectAllClick(Sender: TObject);
var i: integer;
begin with FileListBox, Items do begin
  for i:= 0 to Count-1 do Selected[i]:= true;
end end;

procedure TMainWindow.PopFileListUnselectAllClick(Sender: TObject);
var i: integer;
begin with FileListBox, Items do begin
  for i:= 0 to Count-1 do Selected[i]:= false;
end end;

procedure TMainWindow.PopFileListPopup(Sender: TObject);
begin
  PopFileListCopy.Enabled:= FileListBox.SelCount = 1;
end;

procedure TMainWindow.TxtFindMaskDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept:= ((Source is TEdit) and ((Source as TEdit).Text <> '')) or
           ((Source is TFileListBox) and
            ((Source as TFileListBox).SelCount = 1));
end;

procedure TMainWindow.TxtFindMaskDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin with TxtFindMask do begin
  if (Source is TEdit) then
    Text:= (Source as TEdit).Text
  else if (Source is TFileListBox) then with (Source as TFileListBox) do
    Text:= Items[ItemIndex];
end end;

procedure TMainWindow.TxtReplaceMaskDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin with TxtReplaceMask do begin
  if (Source is TEdit) then
    Text:= (Source as TEdit).Text
  else if (Source is TFileListBox) then with (Source as TFileListBox) do
    Text:= Items[ItemIndex];
end end;















procedure TMainWindow.SplitterMoved(Sender: TObject);
begin
  AdjustPaneWidth;
end;

procedure TMainWindow.FormResize(Sender: TObject);
begin
  AdjustPaneWidth;
end;

end.
