{ General }
unit VRename0;

interface

uses
  SysUtils, WinProcs, Classes, Controls, Graphics, Forms, Dialogs,
  IniFiles;

const
  { global constants : general }
  GC_ProgIdn     = 'VRename';
  GC_ProgVers    = 'v1.4';
  GC_ProgDate    = 'Feb 14, 2000';
  GC_ProgTitle   = 'Visual Renamer';
  GC_ProgTarget  = 'Windows 95';
  GC_Copyright   = 'Copyright  1999-2000, J.R. Ferguson';
  GC_AuthorEmail = 'j.r.ferguson@iname.com';
  GC_AuthorURL   = 'http://hello.to/ferguson';
  GC_SettingExt  = '.ini';
  GC_MinWinWidth = 565;
  GC_MinWinHeight= 420;
  GC_MinDirWidth = 275;
  GC_MinFilWidth = 275;

var
  GV_SettingFnm  : String;

const
  GV_FormReady   : boolean = false;

procedure SetCursor(V_NewCursor: TCursor);
procedure RestoreCursor;
procedure ReadOptions;
function  WriteOptions: boolean;

implementation

Uses VRename1;

var
  OldCursor: TCursor;

procedure SetCursor(V_NewCursor: TCursor);
begin OldCursor:= Screen.Cursor; Screen.Cursor:= V_NewCursor; end;

procedure RestoreCursor;
begin Screen.Cursor:= OldCursor; end;

procedure ReadOptions;
var Bold, Italic: boolean; IniFile: TIniFile;
begin
  SetCursor(crHourglass); IniFile:= TIniFile.Create(GV_SettingFnm);
  if IniFile <> nil then with IniFile, MainWindow do try
    Left   := ReadInteger('Position','Left'  ,Left);
    Top    := ReadInteger('Position','Top'   ,Top);
    Width  := ReadInteger('Position','Width' ,Width);
    Height := ReadInteger('Position','Height',Height);
    with GrpDir do
      Width:= ReadInteger('Position','DirWidth',Width);
    with FontDialog.Font do begin
      Name    := ReadString ('Font' ,'Name'  ,Name);
      Size    := ReadInteger('Font' ,'Size'  ,Size);
      Color   := ReadInteger('Font' ,'Color' ,Color);
      Bold    := ReadBool   ('Font' ,'Bold'  ,fsBold   in Style);
      Italic  := ReadBool   ('Font' ,'Italic',fsItalic in Style);
      Style   := [];
      if Bold   then Style := Style + [fsBold];
      if Italic then Style := Style + [fsItalic];
      ApplyFont;
    end;
    with Toolbar       do Visible := ReadBool('Options','Toolbar'   ,Visible );
    with MainWindow    do ShowHint:= ReadBool('Options','Hints'     ,ShowHint);
    with ChkIgnoreCase do Checked := ReadBool('Options','IgnoreCase',Checked );
  finally IniFile.Free; AdjustControls; RestoreCursor; end;
end;

function  WriteOptions: boolean;
var IniFile: TIniFile;
begin
  Result:= true;
  SetCursor(crHourglass); IniFile:= TIniFile.Create(GV_SettingFnm);
  if IniFile <> nil then with IniFile, MainWindow do try try
    WriteInteger('Position','Left'  ,Left);
    WriteInteger('Position','Top'   ,Top);
    WriteInteger('Position','Width' ,Width);
    WriteInteger('Position','Height',Height);
    with GrpDir do
      WriteInteger('Position','DirWidth',Width);
    with FontDialog.Font do begin
      WriteString ('Font','Name'  ,Name);
      WriteInteger('Font','Size'  ,Size);
      WriteInteger('Font','Color' ,Color);
      WriteBool   ('Font','Bold'  ,fsBold   in Style);
      WriteBool   ('Font','Italic',fsItalic in Style);
    end;
    WriteBool('Options','Toolbar'   ,Toolbar.Visible);
    WriteBool('Options','Hints'     ,MainWindow.ShowHint);
    WriteBool('Options','IgnoreCase',ChkIgnoreCase.Checked);
  finally IniFile.Free; RestoreCursor; end;
  except on E: Exception do
    Result:= MessageDlg(E.Message,mtError,mbOKCancel,0) = mrOk;
  end;
end;

end.

