#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <direct.h>
#include "plugin.hpp"
#include "fmt.hpp"

#if defined(__BORLANDC__)
  #pragma option -a1
#elif defined(__GNUC__) || (defined(__WATCOMC__) && (__WATCOMC__ < 1100)) || defined(__LCC__)
  #pragma pack(1)
#else
  #pragma pack(push,1)
#endif

#define VP       0x50565056
#define ITEMSIZE 0x2C

struct VPHEADER {
  DWORD dwSignature;
  DWORD dwVer;
  DWORD dwDirOffset;
  DWORD dwNumOfItems;
};

struct DIRITEM {
  DWORD dwDataOffs;
  DWORD dwDataSize;
  char filename[32];
  char cTime0;
  char cTime1;
  char cTime2;
  char cTime3;
};

static VPHEADER hdr;
static DIRITEM *DItem;

static char  *szName, *szFName, *szIName;
static char  ModuleName[MAX_PATH];
static char  cVPath[MAX_PATH] = "", cVName[MAX_PATH] = "";
static char  szArcFileName[MAX_PATH] = "";

static DWORD dwNumOfItems, dwINum, dwDirOffset;
static int   iCurLevel = 0;

static FILE  *fArcFile, *fNewFile, *fTempFile;

DWORD GetItemNum (char * szIName);
int GetCurFile (DWORD dwNum);

DWORD WINAPI _export LoadFormatModule(const char *NewModuleName) {
  GetShortPathName (NewModuleName, ModuleName, sizeof(ModuleName));
  return 0;
}

BOOL WINAPI _export IsArchive(char *Name, const unsigned char *Data, int DataSize) {
  VPHEADER thdr;
  thdr = *((VPHEADER *)Data);
  dwNumOfItems = thdr.dwNumOfItems;
  dwDirOffset = thdr.dwDirOffset;
  return (thdr.dwSignature == VP);
}


BOOL WINAPI _export OpenArchive(char *Name,int *Type) {
  fArcFile = fopen (Name, "rb");
  lstrcpy (szArcFileName, Name);
  if (fArcFile == NULL)
    return (FALSE);
  *Type = 0;
  if ((DItem = new struct DIRITEM[dwNumOfItems]) == NULL) 
    return (FALSE);
  fseek (fArcFile, dwDirOffset, SEEK_SET);
  if (fread (DItem, ITEMSIZE, dwNumOfItems, fArcFile) < dwNumOfItems) 
    return (FALSE);
  dwINum = -1;
  fclose (fArcFile);
  return(TRUE);
}


int WINAPI _export GetArcItem(struct PluginPanelItem *Item,struct ArcItemInfo *Info) {
  while (1) {
    if (++dwINum == dwNumOfItems)
      return (GETARC_EOF);

    UINT strnewlen, i;
    if (DItem[dwINum].dwDataSize == 0) {
      if (strcmp((const char *) DItem[dwINum].filename, "..") != 0) {
        Item->FindData.dwFileAttributes = FILE_ATTRIBUTE_DIRECTORY;
        strcat((char *) cVPath, (const char *) DItem[dwINum].filename);
        strcat((char *) cVPath, "/");
      }
      else {
        strnewlen = strchr((const char *) cVPath, '/') - cVPath;
        if (++strnewlen == strlen(cVPath)) 
          for (i=0;i<128;i++) cVPath[i]=0x00;
        else 
          for (i=strnewlen;i<128;i++) cVPath[i]=0x00;
        break;
      }
    }
    else {
      Item->FindData.dwFileAttributes = FILE_ATTRIBUTE_NORMAL;
    } 
    if (Item->FindData.dwFileAttributes != FILE_ATTRIBUTE_DIRECTORY) {
      strcpy((char *)cVName, (const char *) cVPath);
      strcat((char *)cVName, (const char *) DItem[dwINum].filename);
    }
    else
      strcpy((char *)cVName, (const char *) cVPath);
    strcpy(Item->FindData.cFileName,(const char *)cVName);
    Item->PackSize=DItem[dwINum].dwDataSize;
    Item->FindData.nFileSizeLow=DItem[dwINum].dwDataSize;
    FILETIME lft;
    DosDateTimeToFileTime(DItem[dwINum].cTime3+DItem[dwINum].cTime2*256,
		                  DItem[dwINum].cTime1+DItem[dwINum].cTime0*256,
						  &lft);
    LocalFileTimeToFileTime(&lft,&Item->FindData.ftLastWriteTime);
    strcpy(Info->HostOS,"MS DOS");
    Info->Solid=0;
    Info->Comment=0;
    Info->Encrypted=0;
    Info->DictSize=0;
    Info->UnpVer=2;
    break;
  }
  return(GETARC_SUCCESS);
}


BOOL WINAPI _export CloseArchive(struct ArcInfo *Info) {
  unsigned int i;
  for (i=0;i<MAX_PATH;i++) {cVPath[i]=cVName[i]=0;}
  dwNumOfItems = dwINum = 0L;
  szName = szIName = NULL;
  delete (DItem);
  return (TRUE);
}


BOOL WINAPI _export GetFormatName(int Type,char *FormatName,char *DefaultExt) {
  if (Type==0) {
    strcpy(FormatName,"VP");
    strcpy(DefaultExt,"VP");
    return(TRUE);
  }
  return(FALSE);
}


BOOL WINAPI _export GetDefaultCommands(int Type,int Command,char *Dest) {
  if (Type==0) {
    switch (Command) {
      case 0: 
      case 1:
        wsprintf (Dest, "rundll32 %s,Xtract %s %%%%fW", 
                  ModuleName, szArcFileName);
        break;
//      case 4:
//        wsprintf (Dest, "rundll32 %s,Delete %s %%%%fW", 
//                  ModuleName, szArcFileName);
//        break;
//      case 10:
//        wsprintf (Dest, "rundll32 %s,AddReplace %s %%%%fW", 
//                  ModuleName, szArcFileName);
//        break;
      case 14:
        lstrcpy (Dest, "*.*");
        break;
      default:
        lstrcpy (Dest, "");
	}
  }
  return (FALSE);

}


extern "C" int WINAPI _export Xtract (HWND hwnd, HINSTANCE hinstance, 
                              /*LPCSTR*/ char * cCmdLine, DWORD dummy) {
  int Ret;
  char * szName = strrchr (cCmdLine, ' ');

  strncpy (szArcFileName, cCmdLine, (szName - cCmdLine));
  szName++;
  if ((fArcFile = fopen (szArcFileName, "rb")) == NULL)
    return -2;
  if (fread (&hdr, 0x10, 1, fArcFile) < 1) 
    return -2;
  dwNumOfItems = hdr.dwNumOfItems;
  dwDirOffset = hdr.dwDirOffset;
  if ((DItem = new struct DIRITEM[dwNumOfItems]) == NULL)
    return -1;
  fseek (fArcFile, dwDirOffset, SEEK_SET);
  if (fread (DItem, ITEMSIZE, dwNumOfItems, fArcFile) < dwNumOfItems) 
    return -2;
  if ((dwINum = GetItemNum (szName)) != -1) {
    if (DItem[dwINum].dwDataSize != 0) {
      if ((Ret = GetCurFile (dwINum)) != 0) 
        return Ret;
      fclose (fArcFile);
      delete DItem;
      return 0;
    }
    else {
      iCurLevel++;
      strcpy (cVPath, szName);
      while (iCurLevel > 0) {
        if ((Ret = GetCurFile (++dwINum)) != 0) 
          return Ret;
      }
      fclose (fArcFile);
      delete DItem;
      return 0;
    }
  }
  return -3;
}


extern "C" int WINAPI _export AddReplace (HWND hwnd, HINSTANCE hinstance, 
                              /*LPCSTR*/ char * cCmdLine, DWORD dummy) {

//cCmdLine: rundll32 ModuleName,AddReplace szArcFileName szFName", 

/*  BYTE * buffer;
  DWORD dwLen;
  char * szName = strrchr (cCmdLine, ' ');

  strncpy (szArcFileName, cCmdLine, (szName - cCmdLine));
  szName++;
  fArcFile = fopen (szArcFileName, "rb");
  if (fArcFile == NULL)
    return -2;
  if (fread (&hdr, ITEMSIZE, 1, fArcFile) < 1) 
    return -2;
  if ((szFName = new char[hdr.strs_used]) == NULL) 
    return -1;
  fseek (fArcFile, hdr.strs_offs, SEEK_SET);
  if (fread (szFName, hdr.strs_used, 1, fArcFile) < 1) 
    return -2;
  dwNumOfItems = hdr.tree_size / ITEMSIZE;
  if ((TItem = new struct TREEITEM[dwNumOfItems]) == NULL)
    return -1;
  fseek (fArcFile, hdr.tree_offs, SEEK_SET);
  if (fread (TItem, hdr.tree_size, 1, fArcFile) < 1) 
    return -2;
  if (dwINum = GetItemNum (szName)) {
    dwLen = TItem[dwINum].size1;
    if ((fNewFile = fopen (szName, "wb")) == NULL) 
      return -2;
    fseek (fArcFile, hdr.data_offs + TItem[dwINum].child_offset, SEEK_SET);
    if ((buffer = new BYTE [0x8000]) == NULL) 
      return -1;
    while (dwLen > 0x08000L) {
      if (fread (buffer, 0x8000, 1, fArcFile) < 1)
        return -2;
      if (fwrite (buffer, 0x8000, 1, fNewFile) < 1)
        return -3;
      dwLen -= 0x8000L;
    }
    if (fread (buffer, dwLen, 1, fArcFile) < 1)
	  return -2;
	if (fwrite (buffer, dwLen, 1, fNewFile) < 1)
	  return -3;
	fclose (fNewFile);
	fclose (fArcFile);
        delete szFName;
        delete TItem;
        delete buffer;
	return 0;
  }*/
  return -3;
}


DWORD GetItemNum (char * szIName) {
  UINT i;
  for (i = 0; i < dwNumOfItems; i++) {
    if (lstrcmp (szIName, DItem[i].filename) == 0) 
      return (DWORD) i;
  }
  return -1L;
}


int GetCurFile (DWORD dwNum) {
  BYTE * buffer;
  UINT strnewlen, i;
  DWORD dwLen = DItem[dwINum].dwDataSize;

//  if (!mkdir (cVPath))
//	return -2;
  mkdir (cVPath);
  strcpy (cVName, cVPath);
  strcat (cVName, "\\");
  if (DItem[dwINum].dwDataSize > 0) {
    strcat (cVName, DItem[dwINum].filename);
    if ((fNewFile = fopen (cVName, "wb")) == NULL) 
      return -2;
    fseek (fArcFile, DItem[dwNum].dwDataOffs, SEEK_SET);
    if ((buffer = new BYTE [0x8000]) == NULL) 
      return -1;
    while (dwLen > 0x08000L) {
      if (fread (buffer, 0x8000, 1, fArcFile) < 1)
        return -2;
      if (fwrite (buffer, 0x8000, 1, fNewFile) < 1)
        return -3;
      dwLen -= 0x8000L;
    }
    if (fread (buffer, dwLen, 1, fArcFile) < 1)
      return -2;
    if (fwrite (buffer, dwLen, 1, fNewFile) < 1)
      return -3;
    fclose (fNewFile);
    delete buffer;
  }
  else {
    if (lstrcmp(DItem[dwINum].filename, "..") == 0) {
      iCurLevel--;
      strnewlen = strchr((const char *) cVPath, '\\') - cVPath;
      if (++strnewlen == strlen(cVPath)) 
        for (i=0;i<128;i++) cVPath[i]=0x00;
      else 
        for (i=strnewlen;i<128;i++) cVPath[i]=0x00;
    }
    else {
      iCurLevel++;
      strcat (cVPath, "\\");
      strcat (cVPath, DItem[dwINum].filename);
    }
  }
  return 0;
}

