{&H+,Use32+,Z+,AlignRec+,X+,S-}

library VisEOL;

uses Windows, Plugin, FarColor;

var FARAPI: TPluginStartupInfo;

function GetMsg(MsgId: Integer): PChar;
begin
  Result:= FARAPI.GetMsg(FARAPI.ModuleNumber, MsgId);
end;

procedure SetStartupInfo(var Info: TPluginStartupInfo); stdcall;
begin
  FARAPI := Info;
end;

procedure GetPluginInfo(var Info: TPluginInfo); stdcall;
const PluginsTitle: array[0..0] of PChar = (nil);
begin
  Info.StructSize := SizeOf(Info);
  Info.Flags := PF_EDITOR + PF_DISABLEPANELS;
  PluginsTitle[0] := GetMsg(0);
  Info.PluginMenuStrings := @PluginsTitle;
  Info.PluginMenuStringsNumber := 1;
end;

{************************* ᭮  ணࠬ *************************}

// /  ᨬ
procedure ShowSymbols(Enable: Boolean);
var
  ei: TEditorInfo;
  esp: TEditorSetPosition;
  egs: TEditorGetString;
  ec: TEditorColor;
  I, X: Integer;
begin
//  砫쭮 ﭨ ।
  FARAPI.EditorControl(ECTL_GETINFO, @ei);

// ।⥫ ਣ⮢
  FillChar(esp, SizeOf(esp), $FF);
  esp.CurLine := ei.TopScreenLine;

//  ப 쬥 ...
  ec.StringNumber := -1;
  ec.StartPos := -1;
  ec.Color := 0;
  for I := 0 to ei.WindowSizeY - 1 do
  begin
    FARAPI.EditorControl(ECTL_SETPOSITION, @esp);
    FARAPI.EditorControl(ECTL_GETSTRING, @egs);
    ec.StartPos := egs.StringLength;
    ec.EndPos := egs.StringLength;
    FARAPI.EditorControl(ECTL_ADDCOLOR, @ec);
    Inc(esp.CurLine);
  end;

// ...  㥬
  if not Enable then
  begin
    esp.CurLine := ei.TopScreenLine;
    egs.StringNumber := -1;
    X := Integer(COL_EDITORTEXT) - Integer(COL_MENUTEXT);
    ec.Color := FARAPI.AdvControl(FARAPI.ModuleNumber, ACTL_GETCOLOR, @X);
    ec.Color := (ec.Color mod $10) * $10 + (ec.Color div $10);
    for I := 0 to ei.WindowSizeY - 1 do
    begin
      FARAPI.EditorControl(ECTL_SETPOSITION, @esp);
      FARAPI.EditorControl(ECTL_GETSTRING, @egs);
      ec.StartPos := egs.StringLength;
      ec.EndPos := egs.StringLength;
      FARAPI.EditorControl(ECTL_ADDCOLOR, @ec);
      Inc(esp.CurLine);
    end;
  end;

// ⠭ ० ﭨ ।
  esp.CurLine := ei.CurLine;
  esp.CurPos := ei.CurPos;
  esp.CurTabPos := -1;
  esp.TopScreenLine := ei.TopScreenLine;
  esp.LeftPos := ei.LeftPos;
  Integer(esp.OverType) := -1;
  FARAPI.EditorControl(ECTL_SETPOSITION, @esp);
end;

const InvisibleSymbolsAreHidden: Boolean = True;

function ProcessEditorEvent(Event: Integer; Param: Pointer): Integer; stdcall;
begin
  case Event of
    EE_REDRAW: ShowSymbols(InvisibleSymbolsAreHidden);
  end;
  Result := 0;
end;

function OpenPlugin(OpenFrom: integer; Item: integer): THandle; stdcall;
begin
  InvisibleSymbolsAreHidden := not InvisibleSymbolsAreHidden;
  FARAPI.EditorControl(ECTL_REDRAW, nil);
  Result := INVALID_HANDLE_VALUE;
end;

exports
  SetStartupInfo,
  GetPluginInfo,
  ProcessEditorEvent,
  OpenPlugin;

begin
end.
