#pragma inline

#ifndef __TINY__
#error Only in TINY model !
#endif

/* bcc -mt -lt -O1 -d vce.c */

#include     <dos.h>
#include      <io.h>
#include <process.h>
#include   <stdio.h>
#include  <stdlib.h>
#include  <string.h>

// ----------------------------------------------------------------------

char help[] =
  "\n"
  "VC Enchancer 4.[02-]05SW     Written by Sakharov N."
  "     Kiev      Apr 27 1994 \n"
  "Modified by Nick N. Mikhailenko                  "
  "     Moscow      " __DATE__ "\n\n"

  "Usage:  VCE ProgName Arguments\n"
  "Start it in *.mnu, *.ext and command line of VC.COM\n\n"

  "   You can use following combinations in \"Arguments\":\n\n"

  "   ^'Prompt' - show 'Prompt' and wait for string\n\n"

  "   ^:  - disk on current panel\n"
  "   ^\\  - path on current panel\n"
  "   ^%  - name of last directory in path\n"
  "   ^#  - name of last directory without extension\n"
  "   ^.^ - current filename\n"
  "   ^   - current filename without extension\n"
  "   ^^  - ^\n\n"

  "   $:, $\\, $%, $#, $.$, $, $$ - the same on other panel\n";

#define PANEL 267                       // ⨢  /ࠢ
                                               //  ᨨ 4.02 뫮 268
#define QUICK 0x104                    // ᬥ饭  ண ᪠
char far *global;                        // 㪠⥫  騥 ६

#define CURPATH 0x14              // ᬥ饭 ਢ易  砫 

#define CURNUM  0x58
#define NUMBASE 0x5A

#define FILEBEG 0x5E

char far  *left,                    // 㪠⥫    ࠢ 
     far *right;

// -----------------------------------------------------------------------

void movedat(
// 񪮥 ஢ ப
unsigned sseg,                                               // s - source
unsigned soff,

unsigned dseg,                                          // d - destination
unsigned doff,

unsigned  num)                               // ⢮ 㥬 
{
   asm push es;
   asm push ds;

   _ES = dseg;
   _DI = doff;

   _DS = sseg;
   _SI = soff;

   _CX =  num;

   asm rep movsb;

   asm pop ds;
   asm pop es;
}

// -----------------------------------------------------------------------

int find_vc(void)
{
   _CH = 'V';
   _CL = 'C';
   _DH = 'O';
   _DL = 'M';
   _AX = 0x2B00;

   geninterrupt(0x21);

   if (_AL != 0x00)                                    // VC  㦥
      return (1);

   left = MK_FP(_ES, _BX);                   // 㪠⥫   

   _CH = 'V';
   _CL = 'C';
   _DH = 'O';
   _DL = 'M';
   _AX = 0x2B01;

    geninterrupt(0x21);

    right = MK_FP(_ES, _BX);                // 㪠⥫  ࠢ 

    _CH = 'V';
    _CL = 'C';
    _DH = 'O';
    _DL = 'M';
    _AX = 0x2B02;

    geninterrupt(0x21);

    global = MK_FP(_ES, _BX);            // 㪠⥫  騥 ६

    return (0);
}

// -----------------------------------------------------------------------

char   prog_name[128];                        //  ᪠ ணࠬ
char    row_args[300];                // ப 㬥⮢  ᨬ
char args_string[300];                  // ⥫쭠 ப 㬥⮢

char       disk_1[] = " :",                                       // ᪨
           disk_2[] = " :";
char       path_dir_1[128],                      // ४ਨ  ⮬
           path_dir_2[128];
char       dir_name_1[128],                     // ४ਨ  
           dir_name_2[128];
char   short_dir_name_1[9],  // ४ਨ    ७ 
       short_dir_name_2[9];
char       file_name_1[13],                          //  ⥪饣 䠩
           file_name_2[13];
char short_file_name_1[13],              //  䠩  ࠧ७ 
     short_file_name_2[13];

char temp[128];                                        // ६ ப
char temp_w[2] = " ";

char *ch_point;                                     // 㪠⥫  ᨬ

// -----------------------------------------------------------------------

int main(
int    argc,
char **argv)
{
   int rt = 0, i = 0;
   unsigned int seg1, off1, seg2, off2;

   rt = find_vc();

   if (rt || argc < 2) {
      write(1, help, sizeof(help) - 1);
      if (rt)
         write(2, "\n\007"
               "Can't find Volkov Commander 4.00SW or compatible !\n", 53);
      return (1);
   }

   if (global[PANEL]) {                           // ⨢ ࠢ 
      seg1 = FP_SEG(right);
      off1 = FP_OFF(right);
      seg2 = FP_SEG(left);
      off2 = FP_OFF(left);
   }
   else {
      seg1 = FP_SEG(left);
      off1 = FP_OFF(left);
      seg2 = FP_SEG(right);
      off2 = FP_OFF(right);
   }
                                                           //  ᪮
   disk_1[0] = peekb(seg1, off1 + CURPATH);
   disk_2[0] = peekb(seg2, off2 + CURPATH);
                                          //  ४਩  ⠬
   movedat(seg1, off1 + CURPATH + 2, _DS, (unsigned)path_dir_1, 70);
   movedat(seg2, off2 + CURPATH + 2, _DS, (unsigned)path_dir_2, 70);

   file_name_1[12] = file_name_2[12] = '\0';       //  ⥪ 䠩

   i = ( peek(seg1, off1 + CURNUM) - peek(seg1, off1 + NUMBASE) ) / 24;
   movedat(seg1, off1 + i * 13 + FILEBEG, _DS, (unsigned)file_name_1, 12);

   i = ( peek(seg2, off2 + CURNUM) - peek(seg2, off2 + NUMBASE) ) / 24;
   movedat(seg2, off2 + i * 13 + FILEBEG, _DS, (unsigned)file_name_2, 12);

                                          //  ४਩  
   strcpy(dir_name_1, strrchr(path_dir_1, '\\') + 1);
   strcpy(dir_name_2, strrchr(path_dir_2, '\\') + 1);

   strcpy(temp, dir_name_1);            //  ४਩  ७
   if (strchr(temp, '.'))
      (*strchr(temp, '.')) = '\0';
   strcpy(short_dir_name_1, temp);

   strcpy(temp,dir_name_2);
   if (strchr(temp, '.'))
      (*strchr(temp, '.')) = '\0';
   strcpy(short_dir_name_2, temp);

   strcpy(short_file_name_1, file_name_1);  //  䠩  ७
   strcpy(short_file_name_2, file_name_2);
   if (strchr(short_file_name_1, '.'))
      (*strchr(short_file_name_1, '.')) = '\0';
   if (strchr(short_file_name_2, '.'))
      (*strchr(short_file_name_2, '.')) = '\0';
                                       //   祢  '\\'
   if (path_dir_1[strlen(path_dir_1) - 1] != '\\')
      strcat(path_dir_1, "\\");
   if (path_dir_2[strlen(path_dir_2) - 1] != '\\')
      strcat(path_dir_2, "\\");

   args_string[0] = '\0';
   i = 1;

   if (argv[i][0] == '\0')
      return (0);

   strcpy(prog_name, argv[i]);
   i++;

   row_args[0] = '\0';                                // ப 㬥⮢

   while (i < argc) {
      strcat(row_args, argv[i++]);
      strcat(row_args, " ");
   }

   for (ch_point = row_args; *ch_point; ch_point++) {

      if (*ch_point == '^') {                 // ஢뢠 樨 VCE

         switch (*(ch_point + 1)) {

            case '\'':
               ch_point += 2;
               {
                  char *ptr = ch_point;
                  while (*ch_point && *ch_point != '\'')
                     ch_point++;
                  if (*ch_point == '\0') {
                     write(2, "\n\007Bad switch ^\'Prompt\'\n\n", 23);
                     return (1);
                  }
                  *ch_point = '\0';
                  write(1, ptr, strlen(ptr));
                  gets(temp);
                  strcat(args_string,temp);
                  continue;
               }

            case ':':
               ch_point++;
               strcat(args_string, disk_1);
               continue;

            case '\\':
               ch_point++;
               strcat(args_string, path_dir_1);
               continue;

            case '%':
               ch_point++;
               strcat(args_string, dir_name_1);
               continue;

            case '#':
               ch_point++;
               strcat(args_string, short_dir_name_1);
               continue;

            case '.':
               if (*(ch_point + 2) == '^') {
                  ch_point += 2;
                  strcat(args_string, file_name_1);
                  continue;
               }
            break;

            case '^':
               ch_point++;
               strcat(args_string, "^");
               continue;
         }                                               //  switch()

         ch_point++;               //  ^ ᮥ塞   ७
         strcat(args_string, short_file_name_1);
         continue;
      }

      if (*ch_point == '$') {               // ஢뢠 樨 $ VCE

         switch (*(ch_point + 1)) {

            case ':':
               ch_point++;
               strcat(args_string, disk_2);
               continue;

            case '\\':
               ch_point++;
               strcat(args_string, path_dir_2);
               continue;

            case '%':
               ch_point++;
               strcat(args_string, dir_name_2);
               continue;

            case '#':
               ch_point++;
               strcat(args_string, short_dir_name_2);
               continue;

            case '.':
               if (*(ch_point + 2) == '$') {
                  ch_point += 2;
                  strcat(args_string, file_name_2);
                  continue;
               }
            break;

            case '$':
               ch_point++;
               strcat(args_string, "$");
               continue;
         }                                              //  switch()

         ch_point++;              //  $ ᮥ塞   ७
         strcat(args_string, short_file_name_2);
         continue;
      }
                                               // 㥬  ᨬ
      temp_w[0] = *ch_point;
      strcat(args_string, temp_w);

   }                            //  横  ன ப 㬥⮢

   return  // spawn - த; l - 㬥 ᯨ᪮; p - ᪠  PATH
      spawnlp( P_WAIT, prog_name, prog_name, args_string, NULL );
}
/************************************************************************/
